/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.text.Layout;
import android.text.Styled;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.FloatMath;

public class BoringLayout
extends Layout
implements TextUtils.EllipsizeCallback {
    public static final char FIRST_RIGHT_TO_LEFT = '\u0590';
    public String mDirect;
    public Paint mPaint;
    public int mBottom;
    public int mDesc;
    public int mTopPadding;
    public int mBottomPadding;
    public float mMax;
    public int mEllipsizedWidth;
    public int mEllipsizedStart;
    public int mEllipsizedCount;
    public static final TextPaint sTemp = new TextPaint();

    public static BoringLayout make(CharSequence source, TextPaint paint, int outerwidth, Layout.Alignment align, float spacingmult, float spacingadd, Metrics metrics, boolean includepad) {
        return new BoringLayout(source, paint, outerwidth, align, spacingmult, spacingadd, metrics, includepad);
    }

    public static BoringLayout make(CharSequence source, TextPaint paint, int outerwidth, Layout.Alignment align, float spacingmult, float spacingadd, Metrics metrics, boolean includepad, TextUtils.TruncateAt ellipsize, int ellipsizedWidth) {
        return new BoringLayout(source, paint, outerwidth, align, spacingmult, spacingadd, metrics, includepad, ellipsize, ellipsizedWidth);
    }

    public BoringLayout replaceOrMake(CharSequence source, TextPaint paint, int outerwidth, Layout.Alignment align, float spacingmult, float spacingadd, Metrics metrics, boolean includepad) {
        this.replaceWith(source, paint, outerwidth, align, spacingmult, spacingadd);
        this.mEllipsizedWidth = outerwidth;
        this.mEllipsizedStart = 0;
        this.mEllipsizedCount = 0;
        this.init(source, paint, outerwidth, align, spacingmult, spacingadd, metrics, includepad, true);
        return this;
    }

    public BoringLayout replaceOrMake(CharSequence source, TextPaint paint, int outerwidth, Layout.Alignment align, float spacingmult, float spacingadd, Metrics metrics, boolean includepad, TextUtils.TruncateAt ellipsize, int ellipsizedWidth) {
        boolean trust;
        if (ellipsize == null || ellipsize == TextUtils.TruncateAt.MARQUEE) {
            this.replaceWith(source, paint, outerwidth, align, spacingmult, spacingadd);
            this.mEllipsizedWidth = outerwidth;
            this.mEllipsizedStart = 0;
            this.mEllipsizedCount = 0;
            trust = true;
        } else {
            this.replaceWith(TextUtils.ellipsize(source, paint, ellipsizedWidth, ellipsize, true, this), paint, outerwidth, align, spacingmult, spacingadd);
            this.mEllipsizedWidth = ellipsizedWidth;
            trust = false;
        }
        this.init(this.getText(), paint, outerwidth, align, spacingmult, spacingadd, metrics, includepad, trust);
        return this;
    }

    public BoringLayout(CharSequence source, TextPaint paint, int outerwidth, Layout.Alignment align, float spacingmult, float spacingadd, Metrics metrics, boolean includepad) {
        super(source, paint, outerwidth, align, spacingmult, spacingadd);
        this.mEllipsizedWidth = outerwidth;
        this.mEllipsizedStart = 0;
        this.mEllipsizedCount = 0;
        this.init(source, paint, outerwidth, align, spacingmult, spacingadd, metrics, includepad, true);
    }

    public BoringLayout(CharSequence source, TextPaint paint, int outerwidth, Layout.Alignment align, float spacingmult, float spacingadd, Metrics metrics, boolean includepad, TextUtils.TruncateAt ellipsize, int ellipsizedWidth) {
        super(source, paint, outerwidth, align, spacingmult, spacingadd);
        boolean trust;
        if (ellipsize == null || ellipsize == TextUtils.TruncateAt.MARQUEE) {
            this.mEllipsizedWidth = outerwidth;
            this.mEllipsizedStart = 0;
            this.mEllipsizedCount = 0;
            trust = true;
        } else {
            this.replaceWith(TextUtils.ellipsize(source, paint, ellipsizedWidth, ellipsize, true, this), paint, outerwidth, align, spacingmult, spacingadd);
            this.mEllipsizedWidth = ellipsizedWidth;
            trust = false;
        }
        this.init(this.getText(), paint, outerwidth, align, spacingmult, spacingadd, metrics, includepad, trust);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(CharSequence source, TextPaint paint, int outerwidth, Layout.Alignment align, float spacingmult, float spacingadd, Metrics metrics, boolean includepad, boolean trustWidth) {
        this.mDirect = source instanceof String && align == Layout.Alignment.ALIGN_NORMAL ? ((Object)source).toString() : null;
        this.mPaint = paint;
        int spacing = includepad ? metrics.bottom - metrics.top : metrics.descent - metrics.ascent;
        if (spacingmult != 1.0f || spacingadd != 0.0f) {
            spacing = (int)((float)spacing * spacingmult + spacingadd + 0.5f);
        }
        this.mBottom = spacing;
        this.mDesc = includepad ? spacing + metrics.top : spacing + metrics.ascent;
        if (trustWidth) {
            this.mMax = metrics.width;
        } else {
            TextPaint textPaint = sTemp;
            synchronized (textPaint) {
                this.mMax = (int)FloatMath.ceil(Styled.measureText(paint, sTemp, source, 0, source.length(), null));
            }
        }
        if (includepad) {
            this.mTopPadding = metrics.top - metrics.ascent;
            this.mBottomPadding = metrics.bottom - metrics.descent;
        }
    }

    public static Metrics isBoring(CharSequence text, TextPaint paint) {
        return BoringLayout.isBoring(text, paint, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Metrics isBoring(CharSequence text, TextPaint paint, Metrics metrics) {
        char[] temp = TextUtils.obtain(500);
        int len = text.length();
        boolean boring = true;
        block3: for (int i = 0; i < len; i += 500) {
            int j = i + 500;
            if (j > len) {
                j = len;
            }
            TextUtils.getChars(text, i, j, temp, 0);
            int n = j - i;
            for (int a = 0; a < n; ++a) {
                char c = temp[a];
                if (c != '\n' && c != '\t' && c < '\u0590') continue;
                boring = false;
                break block3;
            }
        }
        TextUtils.recycle(temp);
        if (boring) {
            int wid;
            Metrics fm = metrics;
            if (fm == null) {
                fm = new Metrics();
            }
            TextPaint textPaint = sTemp;
            synchronized (textPaint) {
                wid = (int)FloatMath.ceil(Styled.measureText(paint, sTemp, text, 0, text.length(), fm));
            }
            fm.width = wid;
            return fm;
        }
        return null;
    }

    public int getHeight() {
        return this.mBottom;
    }

    public int getLineCount() {
        return 1;
    }

    public int getLineTop(int line) {
        if (line == 0) {
            return 0;
        }
        return this.mBottom;
    }

    public int getLineDescent(int line) {
        return this.mDesc;
    }

    public int getLineStart(int line) {
        if (line == 0) {
            return 0;
        }
        return this.getText().length();
    }

    public int getParagraphDirection(int line) {
        return 1;
    }

    public boolean getLineContainsTab(int line) {
        return false;
    }

    public float getLineMax(int line) {
        return this.mMax;
    }

    public Layout.Directions getLineDirections(int line) {
        return Layout.DIRS_ALL_LEFT_TO_RIGHT;
    }

    public int getTopPadding() {
        return this.mTopPadding;
    }

    public int getBottomPadding() {
        return this.mBottomPadding;
    }

    public int getEllipsisCount(int line) {
        return this.mEllipsizedCount;
    }

    public int getEllipsisStart(int line) {
        return this.mEllipsizedStart;
    }

    public int getEllipsizedWidth() {
        return this.mEllipsizedWidth;
    }

    public void draw(Canvas c, Path highlight, Paint highlightpaint, int cursorOffset) {
        if (this.mDirect != null && highlight == null) {
            c.drawText(this.mDirect, 0.0f, this.mBottom - this.mDesc, this.mPaint);
        } else {
            super.draw(c, highlight, highlightpaint, cursorOffset);
        }
    }

    public void ellipsized(int start, int end) {
        this.mEllipsizedStart = start;
        this.mEllipsizedCount = end - start;
    }

    public static class Metrics
    extends Paint.FontMetricsInt {
        public int width;

        public String toString() {
            return super.toString() + " width=" + this.width;
        }
    }
}

