/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.InputFilter;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;

public abstract class LoginFilter
implements InputFilter {
    public boolean mAppendInvalid;

    public LoginFilter(boolean appendInvalid) {
        this.mAppendInvalid = appendInvalid;
    }

    public LoginFilter() {
        this.mAppendInvalid = false;
    }

    public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
        char c;
        int i;
        char[] out = new char[end - start];
        int outidx = 0;
        boolean changed = false;
        this.onStart();
        for (i = 0; i < dstart; ++i) {
            c = dest.charAt(i);
            if (this.isAllowed(c)) continue;
            this.onInvalidCharacter(c);
        }
        for (i = start; i < end; ++i) {
            c = source.charAt(i);
            if (this.isAllowed(c)) {
                out[outidx++] = c;
                continue;
            }
            if (this.mAppendInvalid) {
                out[outidx++] = c;
            } else {
                changed = true;
            }
            this.onInvalidCharacter(c);
        }
        for (i = dend; i < dest.length(); ++i) {
            c = dest.charAt(i);
            if (this.isAllowed(c)) continue;
            this.onInvalidCharacter(c);
        }
        this.onStop();
        if (!changed) {
            return null;
        }
        String s = new String(out, 0, outidx);
        if (source instanceof Spanned) {
            SpannableString sp = new SpannableString(s);
            TextUtils.copySpansFrom((Spanned)source, start, end, null, sp, 0);
            return sp;
        }
        return s;
    }

    public void onStart() {
    }

    public void onInvalidCharacter(char c) {
    }

    public void onStop() {
    }

    public abstract boolean isAllowed(char var1);

    public static class PasswordFilterGMail
    extends LoginFilter {
        public PasswordFilterGMail() {
            super(false);
        }

        public PasswordFilterGMail(boolean appendInvalid) {
            super(appendInvalid);
        }

        public boolean isAllowed(char c) {
            if (' ' <= c && c <= '\u007f') {
                return true;
            }
            return '\u00a0' <= c && c <= '\u00ff';
        }
    }

    public static class UsernameFilterGeneric
    extends LoginFilter {
        public static final String mAllowed = "@_-.";

        public UsernameFilterGeneric() {
            super(false);
        }

        public UsernameFilterGeneric(boolean appendInvalid) {
            super(appendInvalid);
        }

        public boolean isAllowed(char c) {
            if ('0' <= c && c <= '9') {
                return true;
            }
            if ('a' <= c && c <= 'z') {
                return true;
            }
            if ('A' <= c && c <= 'Z') {
                return true;
            }
            return mAllowed.indexOf(c) != -1;
        }
    }

    public static class UsernameFilterGMail
    extends LoginFilter {
        public UsernameFilterGMail() {
            super(false);
        }

        public UsernameFilterGMail(boolean appendInvalid) {
            super(appendInvalid);
        }

        public boolean isAllowed(char c) {
            if ('0' <= c && c <= '9') {
                return true;
            }
            if ('a' <= c && c <= 'z') {
                return true;
            }
            if ('A' <= c && c <= 'Z') {
                return true;
            }
            return '.' == c;
        }
    }
}

