/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.util.Log;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.Date;
import java.util.TimeZone;
import org.apache.harmony.luni.internal.util.ZoneInfoDB;
import org.xmlpull.v1.XmlPullParserException;

public class TimeUtils {
    public static final String TAG = "TimeUtils";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeZone getTimeZone(int offset, boolean dst, long when, String country) {
        if (country == null) {
            return null;
        }
        TimeZone best = null;
        Resources r = Resources.getSystem();
        XmlResourceParser parser = r.getXml(17498115);
        Date d = new Date(when);
        TimeZone current = TimeZone.getDefault();
        String currentName = current.getID();
        int currentOffset = current.getOffset(when);
        boolean currentDst = current.inDaylightTime(d);
        try {
            XmlUtils.beginDocument(parser, "timezones");
            while (true) {
                TimeZone tz;
                XmlUtils.nextElement(parser);
                String element = parser.getName();
                if (element == null) break;
                if (!element.equals("timezone")) {
                    break;
                }
                String code = parser.getAttributeValue(null, "code");
                if (!country.equals(code) || parser.next() != 4) continue;
                String maybe = parser.getText();
                if (maybe.equals(currentName) && currentOffset == offset && currentDst == dst) {
                    TimeZone timeZone = current;
                    return timeZone;
                }
                if (best != null || (tz = TimeZone.getTimeZone(maybe)).getOffset(when) != offset || tz.inDaylightTime(d) != dst) continue;
                best = tz;
            }
        }
        catch (XmlPullParserException e) {
            Log.e(TAG, "Got exception while getting preferred time zone.", e);
        }
        catch (IOException e) {
            Log.e(TAG, "Got exception while getting preferred time zone.", e);
        }
        finally {
            parser.close();
        }
        return best;
    }

    public static String getTimeZoneDatabaseVersion() {
        return ZoneInfoDB.getVersion();
    }
}

