/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.animation.Interpolator;
import com.android.internal.R;

public class AccelerateInterpolator
implements Interpolator {
    public float mFactor = 1.0f;

    public AccelerateInterpolator() {
    }

    public AccelerateInterpolator(float factor) {
        this.mFactor = factor;
    }

    public AccelerateInterpolator(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AccelerateInterpolator);
        this.mFactor = a.getFloat(0, 1.0f);
        a.recycle();
    }

    public float getInterpolation(float input) {
        if (this.mFactor == 1.0f) {
            return input * input;
        }
        return (float)Math.pow(input, 2.0f * this.mFactor);
    }
}

