/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.net.Uri;
import android.net.http.Headers;
import android.webkit.LoadListener;
import android.webkit.StreamLoader;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ContentLoader
extends StreamLoader {
    public String mUrl;
    public Context mContext;
    public String mContentType;

    public ContentLoader(String rawUrl, LoadListener loadListener, Context context) {
        super(loadListener);
        this.mContext = context;
        int mimeIndex = rawUrl.lastIndexOf(63);
        if (mimeIndex != -1) {
            this.mUrl = rawUrl.substring(0, mimeIndex);
            this.mContentType = rawUrl.substring(mimeIndex + 1);
        } else {
            this.mUrl = rawUrl;
        }
    }

    public boolean setupStreamAndSendStatus() {
        Uri uri = Uri.parse(this.mUrl);
        if (uri == null) {
            this.mHandler.error(-14, this.mContext.getString(17039367) + " " + this.mUrl);
            return false;
        }
        try {
            this.mDataStream = this.mContext.getContentResolver().openInputStream(uri);
            this.mHandler.status(1, 1, 0, "OK");
        }
        catch (FileNotFoundException ex) {
            this.mHandler.error(-14, this.mContext.getString(17039446) + " " + ex.getMessage());
            return false;
        }
        catch (IOException ex) {
            this.mHandler.error(-13, this.mContext.getString(17039446) + " " + ex.getMessage());
            return false;
        }
        catch (RuntimeException ex) {
            this.mHandler.error(-13, this.mContext.getString(17039446) + " " + ex.getMessage());
            return false;
        }
        return true;
    }

    public void buildHeaders(Headers headers) {
        if (this.mContentType != null) {
            headers.setContentType("text/html");
        }
        headers.setCacheControl("no-store, no-cache");
    }

    public static void requestUrl(String url, LoadListener loadListener, Context context) {
        ContentLoader loader = new ContentLoader(url, loadListener, context);
        loader.load();
    }
}

