/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.net.ParseException;
import android.net.WebAddress;
import android.net.http.EventHandler;
import android.net.http.Headers;
import android.net.http.HttpAuthHeader;
import android.net.http.RequestHandle;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.webkit.BrowserFrame;
import android.webkit.ByteArrayBuilder;
import android.webkit.CacheLoader;
import android.webkit.CacheManager;
import android.webkit.CookieManager;
import android.webkit.MimeTypeMap;
import android.webkit.Network;
import android.webkit.PerfChecker;
import android.webkit.URLUtil;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadListener
extends Handler
implements EventHandler {
    public static final String LOGTAG = "webkit";
    public static final int MSG_CONTENT_HEADERS = 100;
    public static final int MSG_CONTENT_DATA = 110;
    public static final int MSG_CONTENT_FINISHED = 120;
    public static final int MSG_CONTENT_ERROR = 130;
    public static final int MSG_LOCATION_CHANGED = 140;
    public static final int MSG_LOCATION_CHANGED_REQUEST = 150;
    public static final int MSG_STATUS = 160;
    public static final int MSG_SSL_CERTIFICATE = 170;
    public static final int MSG_SSL_ERROR = 180;
    public static final int HTTP_OK = 200;
    public static final int HTTP_MOVED_PERMANENTLY = 301;
    public static final int HTTP_FOUND = 302;
    public static final int HTTP_SEE_OTHER = 303;
    public static final int HTTP_NOT_MODIFIED = 304;
    public static final int HTTP_TEMPORARY_REDIRECT = 307;
    public static final int HTTP_AUTH = 401;
    public static final int HTTP_NOT_FOUND = 404;
    public static final int HTTP_PROXY_AUTH = 407;
    public static int sNativeLoaderCount;
    public final ByteArrayBuilder mDataBuilder = new ByteArrayBuilder(8192);
    public String mUrl;
    public WebAddress mUri;
    public boolean mPermanent;
    public String mOriginalUrl;
    public Context mContext;
    public BrowserFrame mBrowserFrame;
    public int mNativeLoader;
    public String mMimeType;
    public String mEncoding;
    public String mTransferEncoding;
    public int mStatusCode;
    public String mStatusText;
    public long mContentLength;
    public boolean mCancelled;
    public boolean mAuthFailed;
    public CacheLoader mCacheLoader;
    public CacheManager.CacheResult mCacheResult;
    public HttpAuthHeader mAuthHeader;
    public int mErrorID = 0;
    public String mErrorDescription;
    public SslError mSslError;
    public RequestHandle mRequestHandle;
    public String mMethod;
    public Map<String, String> mRequestHeaders;
    public byte[] mPostData;
    public boolean mIsHighPriority;
    public boolean mSynchronous;
    public Vector<Message> mMessageQueue;
    public boolean mIsMainPageLoader;
    public Headers mHeaders;
    public int mCacheRedirectCount;
    public static final Pattern CONTENT_TYPE_PATTERN;

    public static LoadListener getLoadListener(Context context, BrowserFrame frame, String url, int nativeLoader, boolean synchronous, boolean isMainPageLoader) {
        ++sNativeLoaderCount;
        return new LoadListener(context, frame, url, nativeLoader, synchronous, isMainPageLoader);
    }

    public static int getNativeLoaderCount() {
        return sNativeLoaderCount;
    }

    public LoadListener(Context context, BrowserFrame frame, String url, int nativeLoader, boolean synchronous, boolean isMainPageLoader) {
        this.mContext = context;
        this.mBrowserFrame = frame;
        this.setUrl(url);
        this.mNativeLoader = nativeLoader;
        this.mMimeType = "";
        this.mEncoding = "";
        this.mSynchronous = synchronous;
        if (synchronous) {
            this.mMessageQueue = new Vector();
        }
        this.mIsMainPageLoader = isMainPageLoader;
    }

    public void clearNativeLoader() {
        --sNativeLoaderCount;
        this.mNativeLoader = 0;
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 100: {
                this.handleHeaders((Headers)msg.obj);
                break;
            }
            case 110: {
                if (this.mNativeLoader == 0 || this.ignoreCallbacks()) break;
                this.commitLoad();
                break;
            }
            case 120: {
                this.handleEndData();
                break;
            }
            case 130: {
                this.handleError(msg.arg1, (String)msg.obj);
                break;
            }
            case 140: {
                this.doRedirect();
                break;
            }
            case 150: {
                Message contMsg = this.obtainMessage(140);
                Message stopMsg = this.obtainMessage(120);
                this.mBrowserFrame.getCallbackProxy().onFormResubmission(stopMsg, contMsg);
                break;
            }
            case 160: {
                HashMap status = (HashMap)msg.obj;
                this.handleStatus((Integer)status.get("major"), (Integer)status.get("minor"), (Integer)status.get("code"), (String)status.get("reason"));
                break;
            }
            case 170: {
                this.handleCertificate((SslCertificate)msg.obj);
                break;
            }
            case 180: {
                this.handleSslError((SslError)msg.obj);
            }
        }
    }

    public BrowserFrame getFrame() {
        return this.mBrowserFrame;
    }

    public Context getContext() {
        return this.mContext;
    }

    public boolean isSynchronous() {
        return this.mSynchronous;
    }

    public boolean cancelled() {
        return this.mCancelled;
    }

    @Override
    public void headers(Headers headers) {
        this.sendMessageInternal(this.obtainMessage(100, headers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleHeaders(Headers headers) {
        if (this.mCancelled) {
            return;
        }
        this.mHeaders = headers;
        this.mMimeType = "";
        this.mEncoding = "";
        ArrayList<String> cookies = headers.getSetCookie();
        for (int i = 0; i < cookies.size(); ++i) {
            CookieManager.getInstance().setCookie(this.mUri, cookies.get(i));
        }
        long contentLength = headers.getContentLength();
        this.mContentLength = contentLength != -1L ? contentLength : 0L;
        String contentType = headers.getContentType();
        if (contentType != null) {
            this.parseContentTypeHeader(contentType);
            if (this.mMimeType.equalsIgnoreCase("text/plain") || this.mMimeType.equalsIgnoreCase("application/octet-stream")) {
                String newMimeType = this.guessMimeTypeFromExtension();
                if (newMimeType != null) {
                    this.mMimeType = newMimeType;
                }
            } else if (this.mMimeType.equalsIgnoreCase("text/vnd.wap.wml")) {
                this.mMimeType = "text/plain";
            } else if (this.mMimeType.equalsIgnoreCase("application/xhtml+xml") || this.mMimeType.equals("application/vnd.wap.xhtml+xml")) {
                this.mMimeType = "text/html";
            }
        } else {
            this.guessMimeType();
        }
        boolean mustAuthenticate = this.mStatusCode == 401 || this.mStatusCode == 407;
        boolean isProxyAuthRequest = this.mStatusCode == 407;
        this.mAuthFailed = false;
        if (this.mAuthHeader != null) {
            Network network;
            boolean bl = this.mAuthFailed = mustAuthenticate && isProxyAuthRequest == this.mAuthHeader.isProxy();
            if (!this.mAuthFailed && this.mAuthHeader.isProxy() && (network = Network.getInstance(this.mContext)).isValidProxySet()) {
                Network network2 = network;
                synchronized (network2) {
                    network.setProxyUsername(this.mAuthHeader.getUsername());
                    network.setProxyPassword(this.mAuthHeader.getPassword());
                }
            }
        }
        this.mAuthHeader = null;
        if (mustAuthenticate) {
            if (this.mStatusCode == 401) {
                this.mAuthHeader = this.parseAuthHeader(headers.getWwwAuthenticate());
            } else {
                this.mAuthHeader = this.parseAuthHeader(headers.getProxyAuthenticate());
                if (this.mAuthHeader != null) {
                    this.mAuthHeader.setProxy();
                }
            }
        }
        if ((this.mStatusCode == 200 || this.mStatusCode == 302 || this.mStatusCode == 301 || this.mStatusCode == 307) && this.mNativeLoader != 0) {
            this.mCacheResult = CacheManager.createCacheFile(this.mUrl, this.mStatusCode, headers, this.mMimeType, false);
            if (this.mCacheResult != null) {
                this.mCacheResult.encoding = this.mEncoding;
            }
        }
        this.commitHeadersCheckRedirect();
    }

    public boolean proxyAuthenticate() {
        if (this.mAuthHeader != null) {
            return this.mAuthHeader.isProxy();
        }
        return false;
    }

    @Override
    public void status(int majorVersion, int minorVersion, int code, String reasonPhrase) {
        HashMap<String, Object> status = new HashMap<String, Object>();
        status.put("major", majorVersion);
        status.put("minor", minorVersion);
        status.put("code", code);
        status.put("reason", reasonPhrase);
        this.mDataBuilder.clear();
        this.sendMessageInternal(this.obtainMessage(160, status));
    }

    public void handleStatus(int major, int minor, int code, String reason) {
        if (this.mCancelled) {
            return;
        }
        this.mStatusCode = code;
        this.mStatusText = reason;
        this.mPermanent = false;
    }

    @Override
    public void certificate(SslCertificate certificate) {
        this.sendMessageInternal(this.obtainMessage(170, certificate));
    }

    public void handleCertificate(SslCertificate certificate) {
        if (this.mIsMainPageLoader) {
            this.mBrowserFrame.certificate(certificate);
        }
    }

    @Override
    public void error(int id2, String description) {
        this.sendMessageInternal(this.obtainMessage(130, id2, 0, description));
    }

    public void handleError(int id2, String description) {
        this.mErrorID = id2;
        this.mErrorDescription = description;
        this.detachRequestHandle();
        this.notifyError();
        this.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void data(byte[] data, int length) {
        if ("base64".equalsIgnoreCase(this.mTransferEncoding)) {
            if (length < data.length) {
                byte[] trimmedData = new byte[length];
                System.arraycopy(data, 0, trimmedData, 0, length);
                data = trimmedData;
            }
            data = Base64.decodeBase64((byte[])data);
            length = data.length;
        }
        boolean sendMessage = false;
        ByteArrayBuilder byteArrayBuilder = this.mDataBuilder;
        synchronized (byteArrayBuilder) {
            sendMessage = this.mDataBuilder.isEmpty();
            this.mDataBuilder.append(data, 0, length);
        }
        if (sendMessage) {
            this.sendMessageInternal(this.obtainMessage(110));
        }
    }

    @Override
    public void endData() {
        this.sendMessageInternal(this.obtainMessage(120));
    }

    public void handleEndData() {
        if (this.mCancelled) {
            return;
        }
        switch (this.mStatusCode) {
            case 301: {
                this.mPermanent = true;
            }
            case 302: 
            case 303: 
            case 307: {
                if (this.mStatusCode == 307) {
                    if (this.mRequestHandle != null && this.mRequestHandle.getMethod().equals("POST")) {
                        this.sendMessageInternal(this.obtainMessage(150));
                    } else if (this.mMethod != null && this.mMethod.equals("POST")) {
                        this.sendMessageInternal(this.obtainMessage(150));
                    } else {
                        this.sendMessageInternal(this.obtainMessage(140));
                    }
                } else {
                    this.sendMessageInternal(this.obtainMessage(140));
                }
                return;
            }
            case 401: 
            case 407: {
                if (this.mAuthHeader == null || !Network.getInstance(this.mContext).isValidProxySet() && this.mAuthHeader.isProxy()) break;
                Network.getInstance(this.mContext).handleAuthRequest(this);
                return;
            }
            case 304: {
                if (this.mCacheLoader == null) break;
                this.mCacheLoader.load();
                return;
            }
        }
        this.detachRequestHandle();
        this.tearDown();
    }

    public void setCacheLoader(CacheLoader c) {
        this.mCacheLoader = c;
    }

    public boolean checkCache(Map<String, String> headers) {
        CacheManager.CacheResult result = CacheManager.getCacheFile(this.url(), headers);
        this.mCacheLoader = null;
        if (result != null) {
            this.mCacheLoader = new CacheLoader(this, result);
            if (!headers.containsKey("if-none-match") && !headers.containsKey("if-modified-since")) {
                this.mCacheLoader.load();
                return true;
            }
        }
        return false;
    }

    @Override
    public void handleSslErrorRequest(SslError error) {
        this.sendMessageInternal(this.obtainMessage(180, error));
    }

    public void handleSslError(SslError error) {
        if (!this.mCancelled) {
            this.mSslError = error;
            Network.getInstance(this.mContext).handleSslErrorRequest(this);
        }
    }

    public String realm() {
        if (this.mAuthHeader == null) {
            return null;
        }
        return this.mAuthHeader.getRealm();
    }

    public boolean authCredentialsInvalid() {
        return this.mAuthFailed && (!this.mAuthHeader.isDigest() || !this.mAuthHeader.getStale());
    }

    public SslError sslError() {
        return this.mSslError;
    }

    public void handleSslErrorResponse(boolean proceed) {
        if (this.mRequestHandle != null) {
            this.mRequestHandle.handleSslErrorResponse(proceed);
        }
        if (!proceed) {
            this.commitLoad();
            this.tearDown();
        }
    }

    public void handleAuthResponse(String username, String password) {
        if (username != null && password != null) {
            if (this.mAuthHeader != null && this.mRequestHandle != null) {
                this.mAuthHeader.setUsername(username);
                this.mAuthHeader.setPassword(password);
                int scheme = this.mAuthHeader.getScheme();
                if (scheme == 1) {
                    boolean isProxy = this.mAuthHeader.isProxy();
                    this.mRequestHandle.setupBasicAuthResponse(isProxy, username, password);
                } else if (scheme == 2) {
                    boolean isProxy = this.mAuthHeader.isProxy();
                    String realm = this.mAuthHeader.getRealm();
                    String nonce = this.mAuthHeader.getNonce();
                    String qop = this.mAuthHeader.getQop();
                    String algorithm = this.mAuthHeader.getAlgorithm();
                    String opaque = this.mAuthHeader.getOpaque();
                    this.mRequestHandle.setupDigestAuthResponse(isProxy, username, password, realm, nonce, qop, algorithm, opaque);
                }
            }
        } else {
            this.commitLoad();
            this.tearDown();
        }
    }

    public void setRequestData(String method, Map<String, String> headers, byte[] postData, boolean isHighPriority) {
        this.mMethod = method;
        this.mRequestHeaders = headers;
        this.mPostData = postData;
        this.mIsHighPriority = isHighPriority;
    }

    public String url() {
        return this.mUrl;
    }

    public WebAddress getWebAddress() {
        return this.mUri;
    }

    public String host() {
        if (this.mUri != null) {
            return this.mUri.mHost;
        }
        return null;
    }

    public String originalUrl() {
        if (this.mOriginalUrl != null) {
            return this.mOriginalUrl;
        }
        return this.mUrl;
    }

    public void attachRequestHandle(RequestHandle requestHandle) {
        this.mRequestHandle = requestHandle;
    }

    public void detachRequestHandle() {
        this.mRequestHandle = null;
    }

    public void downloadFile() {
        this.mCacheResult = null;
        this.mBrowserFrame.getCallbackProxy().onDownloadStart(this.url(), this.mBrowserFrame.getUserAgentString(), this.mHeaders.getContentDisposition(), this.mMimeType, this.mContentLength);
        this.cancel();
    }

    public static boolean willLoadFromCache(String url) {
        boolean inCache = CacheManager.getCacheFile(url, null) != null;
        return inCache;
    }

    public void resetCancel() {
        this.mCancelled = false;
    }

    public String mimeType() {
        return this.mMimeType;
    }

    public long contentLength() {
        return this.mContentLength;
    }

    public void commitHeadersCheckRedirect() {
        if (this.mCancelled) {
            return;
        }
        if (this.mStatusCode >= 301 && this.mStatusCode <= 303 || this.mStatusCode == 307) {
            return;
        }
        this.commitHeaders();
    }

    public void commitHeaders() {
        int nativeResponse = this.createNativeResponse();
        this.nativeReceivedResponse(nativeResponse);
    }

    public int createNativeResponse() {
        int statusCode = this.mStatusCode == 304 && this.mCacheLoader != null ? 200 : this.mStatusCode;
        final int nativeResponse = this.nativeCreateResponse(this.mUrl, statusCode, this.mStatusText, this.mMimeType, this.mContentLength, this.mEncoding, this.mCacheResult == null ? 0L : this.mCacheResult.expires / 1000L);
        if (this.mHeaders != null) {
            this.mHeaders.getHeaders(new Headers.HeaderCallback(){

                public void header(String name, String value) {
                    LoadListener.this.nativeSetResponseHeader(nativeResponse, name, value);
                }
            });
        }
        return nativeResponse;
    }

    public void commitLoad() {
        ByteArrayBuilder.Chunk c;
        if (this.mCancelled) {
            return;
        }
        PerfChecker checker = new PerfChecker();
        while ((c = this.mDataBuilder.getFirstChunk()) != null) {
            if (c.mLength != 0) {
                if (this.mCacheResult != null) {
                    try {
                        this.mCacheResult.outStream.write(c.mArray, 0, c.mLength);
                    }
                    catch (IOException e) {
                        this.mCacheResult = null;
                    }
                }
                this.nativeAddData(c.mArray, c.mLength);
            }
            this.mDataBuilder.releaseChunk(c);
            checker.responseAlert("res nativeAddData");
        }
    }

    public void tearDown() {
        if (this.mCacheResult != null) {
            if (this.getErrorID() == 0) {
                CacheManager.saveCacheFile(this.mUrl, this.mCacheResult);
            }
            this.mCacheResult = null;
        }
        if (this.mNativeLoader != 0) {
            PerfChecker checker = new PerfChecker();
            this.nativeFinished();
            checker.responseAlert("res nativeFinished");
            this.clearNativeLoader();
        }
    }

    public int getErrorID() {
        return this.mErrorID;
    }

    public String getErrorDescription() {
        return this.mErrorDescription;
    }

    public void notifyError() {
        if (this.mNativeLoader != 0) {
            String description = this.getErrorDescription();
            if (description == null) {
                description = "";
            }
            this.nativeError(this.getErrorID(), description, this.url());
            this.clearNativeLoader();
        }
    }

    public void cancel() {
        if (this.mRequestHandle != null) {
            this.mRequestHandle.cancel();
            this.mRequestHandle = null;
        }
        this.mCacheResult = null;
        this.mCancelled = true;
        this.clearNativeLoader();
    }

    public void doRedirect() {
        if (this.mCancelled) {
            return;
        }
        if (this.mCacheRedirectCount >= 16) {
            this.handleError(-9, this.mContext.getString(17039443));
            return;
        }
        String redirectTo = this.mHeaders.getLocation();
        if (redirectTo != null) {
            int nativeResponse = this.createNativeResponse();
            redirectTo = this.nativeRedirectedToUrl(this.mUrl, redirectTo, nativeResponse);
            if (this.mCancelled) {
                return;
            }
            if (redirectTo == null) {
                Log.d(LOGTAG, "Redirection failed for " + this.mHeaders.getLocation());
                this.cancel();
                return;
            }
            if (!URLUtil.isNetworkUrl(redirectTo)) {
                String text = this.mContext.getString(17039762) + "\n" + redirectTo;
                this.nativeAddData(text.getBytes(), text.length());
                this.nativeFinished();
                this.clearNativeLoader();
                return;
            }
            if (this.mOriginalUrl == null) {
                this.mOriginalUrl = this.mUrl;
            }
            if (this.mCacheResult != null) {
                if (this.getErrorID() == 0) {
                    CacheManager.saveCacheFile(this.mUrl, this.mCacheResult);
                }
                this.mCacheResult = null;
            }
            this.setUrl(redirectTo);
            if (this.mRequestHeaders == null) {
                this.mRequestHeaders = new HashMap<String, String>();
            }
            boolean fromCache = false;
            if (this.mCacheLoader != null) {
                ++this.mCacheRedirectCount;
                fromCache = true;
            }
            if (!this.checkCache(this.mRequestHeaders)) {
                if (this.mRequestHandle != null) {
                    this.mRequestHandle.setupRedirect(this.mUrl, this.mStatusCode, this.mRequestHeaders);
                } else {
                    Network network = Network.getInstance(this.getContext());
                    if (!network.requestURL(this.mMethod, this.mRequestHeaders, this.mPostData, this, this.mIsHighPriority)) {
                        this.handleError(-12, this.mContext.getString(17039367));
                        return;
                    }
                }
                if (fromCache) {
                    this.mRequestHandle.setRedirectCount(this.mCacheRedirectCount);
                }
            } else if (!fromCache) {
                this.mCacheRedirectCount = this.mRequestHandle.getRedirectCount() + 1;
            }
        } else {
            this.commitHeaders();
            this.commitLoad();
            this.tearDown();
        }
    }

    public void parseContentTypeHeader(String contentType) {
        if (contentType != null) {
            int i = contentType.indexOf(59);
            if (i >= 0) {
                this.mMimeType = contentType.substring(0, i);
                int j = contentType.indexOf(61, i);
                if (j > 0) {
                    i = contentType.indexOf(59, j);
                    if (i < j) {
                        i = contentType.length();
                    }
                    this.mEncoding = contentType.substring(j + 1, i);
                } else {
                    this.mEncoding = contentType.substring(i + 1);
                }
                this.mEncoding = this.mEncoding.trim();
                if (i < contentType.length() - 1) {
                    this.mTransferEncoding = contentType.substring(i + 1).trim();
                }
            } else {
                this.mMimeType = contentType;
            }
            this.mMimeType = this.mMimeType.trim();
            try {
                Matcher m = CONTENT_TYPE_PATTERN.matcher(this.mMimeType);
                if (m.find()) {
                    this.mMimeType = m.group(1);
                } else {
                    this.guessMimeType();
                }
            }
            catch (IllegalStateException ex) {
                this.guessMimeType();
            }
        }
    }

    public HttpAuthHeader parseAuthHeader(String header) {
        if (header != null) {
            int posMax = 256;
            int posLen = 0;
            int[] pos = new int[posMax];
            int headerLen = header.length();
            if (headerLen > 0) {
                boolean quoted = false;
                for (int i = 0; i < headerLen && posLen < posMax; ++i) {
                    if (header.charAt(i) == '\"') {
                        quoted = !quoted;
                        continue;
                    }
                    if (quoted) continue;
                    if (header.regionMatches(true, i, "Basic", 0, "Basic".length())) {
                        pos[posLen++] = i;
                        continue;
                    }
                    if (!header.regionMatches(true, i, "Digest", 0, "Digest".length())) continue;
                    pos[posLen++] = i;
                }
            }
            if (posLen > 0) {
                HttpAuthHeader rval;
                int i;
                for (i = 0; i < posLen; ++i) {
                    String sub;
                    if (!header.regionMatches(true, pos[i], "Digest", 0, "Digest".length()) || !(rval = new HttpAuthHeader(sub = header.substring(pos[i], i + 1 < posLen ? pos[i + 1] : headerLen))).isSupportedScheme()) continue;
                    return rval;
                }
                for (i = 0; i < posLen; ++i) {
                    String sub;
                    if (!header.regionMatches(true, pos[i], "Basic", 0, "Basic".length()) || !(rval = new HttpAuthHeader(sub = header.substring(pos[i], i + 1 < posLen ? pos[i + 1] : headerLen))).isSupportedScheme()) continue;
                    return rval;
                }
            }
        }
        return null;
    }

    public boolean ignoreCallbacks() {
        return this.mCancelled || this.mAuthHeader != null || this.mStatusCode > 300 && this.mStatusCode < 400;
    }

    public void setUrl(String url) {
        if (url != null) {
            this.mUri = null;
            if (URLUtil.isNetworkUrl(url)) {
                this.mUrl = URLUtil.stripAnchor(url);
                try {
                    this.mUri = new WebAddress(this.mUrl);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            } else {
                this.mUrl = url;
            }
        }
    }

    public void guessMimeType() {
        if (URLUtil.isDataUrl(this.mUrl) && this.mMimeType.length() != 0) {
            this.cancel();
            String text = this.mContext.getString(17039367);
            this.handleError(-12, text);
        } else {
            this.mMimeType = "text/html";
            String newMimeType = this.guessMimeTypeFromExtension();
            if (newMimeType != null) {
                this.mMimeType = newMimeType;
            }
        }
    }

    public String guessMimeTypeFromExtension() {
        String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(MimeTypeMap.getFileExtensionFromUrl(this.mUrl));
        if (mimeType != null && mimeType.equals("application/xhtml+xml")) {
            mimeType = "text/html";
        }
        return mimeType;
    }

    public void sendMessageInternal(Message msg) {
        if (this.mSynchronous) {
            this.mMessageQueue.add(msg);
        } else {
            this.sendMessage(msg);
        }
    }

    public void loadSynchronousMessages() {
        for (int size = this.mMessageQueue.size(); size > 0; --size) {
            this.handleMessage(this.mMessageQueue.remove(0));
        }
    }

    public int nativeCreateResponse(String string2, int n, String string3, String string4, long l, String string5, long l2) {
        return OverrideMethod.invokeI("android.webkit.LoadListener#nativeCreateResponse(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;JLjava/lang/String;J)I", true, this);
    }

    public void nativeSetResponseHeader(int n, String string2, String string3) {
        OverrideMethod.invokeV("android.webkit.LoadListener#nativeSetResponseHeader(ILjava/lang/String;Ljava/lang/String;)V", true, this);
    }

    public void nativeReceivedResponse(int n) {
        OverrideMethod.invokeV("android.webkit.LoadListener#nativeReceivedResponse(I)V", true, this);
    }

    public void nativeAddData(byte[] byArray, int n) {
        OverrideMethod.invokeV("android.webkit.LoadListener#nativeAddData([BI)V", true, this);
    }

    public void nativeFinished() {
        OverrideMethod.invokeV("android.webkit.LoadListener#nativeFinished()V", true, this);
    }

    public String nativeRedirectedToUrl(String string2, String string3, int n) {
        return (String)OverrideMethod.invokeA("android.webkit.LoadListener#nativeRedirectedToUrl(Ljava/lang/String;Ljava/lang/String;I)Ljava/lang/String;", true, this);
    }

    public void nativeError(int n, String string2, String string3) {
        OverrideMethod.invokeV("android.webkit.LoadListener#nativeError(ILjava/lang/String;Ljava/lang/String;)V", true, this);
    }

    static {
        CONTENT_TYPE_PATTERN = Pattern.compile("^((?:[xX]-)?[a-zA-Z\\*]+/[\\w\\+\\*-]+[\\.[\\w\\+-]+]*)$");
    }
}

