/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.net.http.SslError;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.webkit.CallbackProxy;
import android.webkit.LoadListener;
import android.webkit.Network;
import java.util.LinkedList;

public class SslErrorHandler
extends Handler {
    public static final String LOGTAG = "network";
    public Network mNetwork;
    public LinkedList<LoadListener> mLoaderQueue;
    public Bundle mSslPrefTable;
    public final int HANDLE_RESPONSE = 100;

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 100: {
                this.handleSslErrorResponse(msg.arg1 == 1);
                this.fastProcessQueuedSslErrors();
            }
        }
    }

    public SslErrorHandler(Network network) {
        this.mNetwork = network;
        this.mLoaderQueue = new LinkedList();
        this.mSslPrefTable = new Bundle();
    }

    public boolean saveState(Bundle outState) {
        boolean success;
        boolean bl = success = outState != null;
        if (success) {
            outState.putBundle("ssl-error-handler", this.mSslPrefTable);
        }
        return success;
    }

    public boolean restoreState(Bundle inState) {
        boolean success;
        boolean bl = success = inState != null;
        if (success && (success = inState.containsKey("ssl-error-handler"))) {
            this.mSslPrefTable = inState.getBundle("ssl-error-handler");
        }
        return success;
    }

    public synchronized void clear() {
        this.mSslPrefTable.clear();
    }

    public synchronized void handleSslErrorRequest(LoadListener loader) {
        if (!loader.cancelled()) {
            this.mLoaderQueue.offer(loader);
            if (loader == this.mLoaderQueue.peek()) {
                this.fastProcessQueuedSslErrors();
            }
        }
    }

    public void fastProcessQueuedSslErrors() {
        while (this.processNextLoader()) {
        }
    }

    public synchronized boolean processNextLoader() {
        LoadListener loader = this.mLoaderQueue.peek();
        if (loader != null) {
            if (loader.cancelled()) {
                return true;
            }
            SslError error = loader.sslError();
            int primary = error.getPrimaryError();
            String host = loader.host();
            if (this.mSslPrefTable.containsKey(host) && primary <= this.mSslPrefTable.getInt(host)) {
                this.handleSslErrorResponse(true);
                return true;
            }
            CallbackProxy proxy = loader.getFrame().getCallbackProxy();
            proxy.onReceivedSslError(this, error);
        }
        return false;
    }

    public void proceed() {
        this.sendMessage(this.obtainMessage(100, 1, 0));
    }

    public void cancel() {
        this.sendMessage(this.obtainMessage(100, 0, 0));
    }

    public synchronized void handleSslErrorResponse(boolean proceed) {
        LoadListener loader = this.mLoaderQueue.poll();
        if (!loader.cancelled()) {
            if (proceed) {
                int primary = loader.sslError().getPrimaryError();
                String host = loader.host();
                boolean hasKey = this.mSslPrefTable.containsKey(host);
                if (!hasKey || primary > this.mSslPrefTable.getInt(host)) {
                    this.mSslPrefTable.putInt(host, new Integer(primary));
                }
            }
            loader.handleSslErrorResponse(proceed);
        }
    }
}

