/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.net.http.Headers;
import android.os.Handler;
import android.os.Message;
import android.webkit.LoadListener;
import java.io.IOException;
import java.io.InputStream;

public abstract class StreamLoader
extends Handler {
    public static final String NO_STORE = "no-store";
    public static final int MSG_STATUS = 100;
    public static final int MSG_HEADERS = 101;
    public static final int MSG_DATA = 102;
    public static final int MSG_END = 103;
    public LoadListener mHandler;
    public InputStream mDataStream;
    public long mContentLength;
    public byte[] mData;

    public StreamLoader(LoadListener loadlistener) {
        this.mHandler = loadlistener;
    }

    public abstract boolean setupStreamAndSendStatus();

    public abstract void buildHeaders(Headers var1);

    public void load() {
        if (!this.mHandler.isSynchronous()) {
            this.sendMessage(this.obtainMessage(100));
        } else if (this.setupStreamAndSendStatus()) {
            this.mData = new byte[8192];
            this.sendHeaders();
            while (!this.sendData()) {
            }
            this.closeStreamAndSendEndData();
            this.mHandler.loadSynchronousMessages();
        }
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 100: {
                if (!this.setupStreamAndSendStatus()) break;
                this.mData = new byte[8192];
                this.sendMessage(this.obtainMessage(101));
                break;
            }
            case 101: {
                this.sendHeaders();
                this.sendMessage(this.obtainMessage(102));
                break;
            }
            case 102: {
                if (this.sendData()) {
                    this.sendMessage(this.obtainMessage(103));
                    break;
                }
                this.sendMessage(this.obtainMessage(102));
                break;
            }
            case 103: {
                this.closeStreamAndSendEndData();
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    public void sendHeaders() {
        Headers headers = new Headers();
        if (this.mContentLength > 0L) {
            headers.setContentLength(this.mContentLength);
        }
        headers.setCacheControl(NO_STORE);
        this.buildHeaders(headers);
        this.mHandler.headers(headers);
    }

    public boolean sendData() {
        if (this.mDataStream != null) {
            try {
                int amount = this.mDataStream.read(this.mData);
                if (amount > 0) {
                    this.mHandler.data(this.mData, amount);
                    return false;
                }
            }
            catch (IOException ex) {
                this.mHandler.error(-13, ex.getMessage());
            }
        }
        return true;
    }

    public void closeStreamAndSendEndData() {
        if (this.mDataStream != null) {
            try {
                this.mDataStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.mHandler.endData();
    }
}

