/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Selection;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebView;
import android.widget.AbsoluteLayout;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.TextView;
import java.util.ArrayList;

public class TextDialog
extends AutoCompleteTextView {
    public WebView mWebView;
    public boolean mSingle;
    public int mWidthSpec;
    public int mHeightSpec;
    public int mNodePointer;
    public boolean mGotEnterDown;
    public boolean mScrollToAccommodateCursor;
    public int mMaxLength;
    public String mPreChange;
    public char[] mCharacter = new char[1];
    public static final InputFilter[] NO_FILTERS = new InputFilter[0];

    public TextDialog(Context context, WebView webView) {
        super(context);
        this.mWebView = webView;
        ShapeDrawable background = new ShapeDrawable(new RectShape());
        Paint shapePaint = background.getPaint();
        shapePaint.setStyle(Paint.Style.STROKE);
        ColorDrawable color2 = new ColorDrawable(-1);
        Drawable[] array2 = new Drawable[]{color2, background};
        LayerDrawable layers = new LayerDrawable(array2);
        this.setBackgroundDrawable(layers);
        this.setPadding(3, 2, 0, 0);
        this.mMaxLength = -1;
        TextPaint paint = this.getPaint();
        int flags = paint.getFlags() | 0x80 | 1;
        paint.setFlags(flags);
        this.setTextColor(-16777216);
        this.setImeOptions(1);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.isSystem()) {
            return super.dispatchKeyEvent(event);
        }
        boolean down = event.getAction() != 1;
        int keyCode = event.getKeyCode();
        Editable text = this.getText();
        int oldLength = text.length();
        if (67 == keyCode && 0 == oldLength) {
            this.sendDomEvent(event);
            return true;
        }
        if (this.mSingle && 66 == keyCode) {
            if (this.isPopupShowing()) {
                return super.dispatchKeyEvent(event);
            }
            if (!down) {
                InputMethodManager.getInstance(this.mContext).hideSoftInputFromWindow(this.getWindowToken(), 0);
                this.sendDomEvent(new KeyEvent(0, keyCode));
                this.sendDomEvent(event);
            }
            return super.dispatchKeyEvent(event);
        }
        if (23 == keyCode) {
            if (this.isPopupShowing()) {
                return super.dispatchKeyEvent(event);
            }
            if (!down) {
                this.mWebView.shortPressOnTextField();
            }
            return super.dispatchKeyEvent(event);
        }
        if (this.getLayout() == null) {
            this.measure(this.mWidthSpec, this.mHeightSpec);
        }
        int oldStart = Selection.getSelectionStart(text);
        int oldEnd = Selection.getSelectionEnd(text);
        boolean maxedOut = this.mMaxLength != -1 && oldLength == this.mMaxLength;
        String oldText = maxedOut && oldEnd != oldStart ? text.toString() : "";
        if (super.dispatchKeyEvent(event)) {
            boolean isArrowKey;
            switch (keyCode) {
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    isArrowKey = true;
                    break;
                }
                case 66: {
                    this.mGotEnterDown = true;
                }
                default: {
                    isArrowKey = false;
                }
            }
            if (maxedOut && !isArrowKey && keyCode != 67) {
                if (oldEnd == oldStart) {
                    this.mScrollToAccommodateCursor = true;
                    return true;
                }
                if (!oldText.equals(this.getText().toString())) {
                    Editable span = this.getText();
                    int newStart = Selection.getSelectionStart(span);
                    int newEnd = Selection.getSelectionEnd(span);
                    this.mWebView.replaceTextfieldText(0, oldLength, span.toString(), newStart, newEnd);
                    this.mScrollToAccommodateCursor = true;
                    return true;
                }
            }
            if (isArrowKey) {
                this.sendDomEvent(event);
            }
            this.mScrollToAccommodateCursor = true;
            return true;
        }
        Selection.setSelection(text, oldStart, oldEnd);
        if (this.mGotEnterDown && !down) {
            return true;
        }
        if (keyCode == 21 || keyCode == 22 || keyCode == 19 || keyCode == 20) {
            this.mWebView.resetTrackballTime();
            return down ? this.mWebView.onKeyDown(keyCode, event) : this.mWebView.onKeyUp(keyCode, event);
        }
        return false;
    }

    public void fakeTouchEvent(float x, float y) {
        if (this.getLayout() == null) {
            this.measure(this.mWidthSpec, this.mHeightSpec);
        }
        MotionEvent ev = MotionEvent.obtain(0L, 0L, 1, x, y, 0);
        this.onTouchEvent(ev);
        ev.recycle();
    }

    public boolean isSameTextField(int ptr) {
        return ptr == this.mNodePointer;
    }

    public boolean onPreDraw() {
        if (this.getLayout() == null) {
            this.measure(this.mWidthSpec, this.mHeightSpec);
        }
        return super.onPreDraw();
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        int charactersFromKeyEvents;
        super.onTextChanged(s, start, before, count);
        String postChange = ((Object)s).toString();
        if (this.mPreChange == null || this.mPreChange.equals(postChange) || this.mMaxLength > -1 && this.mPreChange.length() > this.mMaxLength && this.mPreChange.substring(0, this.mMaxLength).equals(postChange)) {
            return;
        }
        this.mPreChange = postChange;
        if (before > 0 && 0 == count) {
            this.mWebView.deleteSelection(start, start + before);
            this.updateCachedTextfield();
            return;
        }
        TextUtils.getChars(s, start + count - 1, start + count, this.mCharacter, 0);
        KeyCharacterMap kmap = KeyCharacterMap.load(0);
        KeyEvent[] events = kmap.getEvents(this.mCharacter);
        boolean cannotUseKeyEvents = null == events;
        int n = charactersFromKeyEvents = cannotUseKeyEvents ? 0 : 1;
        if (count > 1 || cannotUseKeyEvents) {
            String replace = ((Object)s.subSequence(start, start + count - charactersFromKeyEvents)).toString();
            this.mWebView.replaceTextfieldText(start, start + before, replace, start + count - charactersFromKeyEvents, start + count - charactersFromKeyEvents);
        } else {
            this.mWebView.setSelection(start, start + before);
        }
        this.updateCachedTextfield();
        if (cannotUseKeyEvents) {
            return;
        }
        int length = events.length;
        for (int i = 0; i < length; ++i) {
            if (KeyEvent.isModifierKey(events[i].getKeyCode())) continue;
            this.sendDomEvent(events[i]);
        }
    }

    public boolean onTrackballEvent(MotionEvent event) {
        if (this.isPopupShowing()) {
            return super.onTrackballEvent(event);
        }
        if (event.getAction() != 2) {
            return false;
        }
        Editable text = this.getText();
        MovementMethod move = this.getMovementMethod();
        if (move != null && this.getLayout() != null && move.onTrackballEvent(this, text, event)) {
            return true;
        }
        this.mScrollToAccommodateCursor = false;
        return false;
    }

    public void remove() {
        InputMethodManager.getInstance(this.mContext).hideSoftInputFromWindow(this.getWindowToken(), 0);
        this.mWebView.removeView(this);
        this.mWebView.requestFocus();
        this.mScrollToAccommodateCursor = false;
    }

    public void enableScrollOnScreen(boolean enable) {
        this.mScrollToAccommodateCursor = enable;
    }

    public void bringIntoView() {
        if (this.getLayout() != null) {
            this.bringPointIntoView(Selection.getSelectionEnd(this.getText()));
        }
    }

    public boolean requestRectangleOnScreen(Rect rectangle) {
        if (this.mScrollToAccommodateCursor) {
            return super.requestRectangleOnScreen(rectangle);
        }
        return false;
    }

    public void sendDomEvent(KeyEvent event) {
        this.mWebView.passToJavaScript(this.getText().toString(), event);
    }

    public void setAdapterCustom(AutoCompleteAdapter adapter) {
        if (adapter != null) {
            this.setInputType(65536);
            adapter.setTextView(this);
        }
        super.setAdapter(adapter);
    }

    public void setInPassword(boolean inPassword) {
        if (inPassword) {
            this.setInputType(129);
        }
    }

    public void setMaxLength(int maxLength) {
        this.mMaxLength = maxLength;
        if (-1 == maxLength) {
            this.setFilters(NO_FILTERS);
        } else {
            this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxLength)});
        }
    }

    public void setNodePointer(int ptr) {
        this.mNodePointer = ptr;
    }

    public void setRect(int x, int y, int width, int height) {
        AbsoluteLayout.LayoutParams lp = (AbsoluteLayout.LayoutParams)this.getLayoutParams();
        if (null == lp) {
            lp = new AbsoluteLayout.LayoutParams(width, height, x, y);
        } else {
            lp.x = x;
            lp.y = y;
            lp.width = width;
            lp.height = height;
        }
        if (this.getParent() == null) {
            this.mWebView.addView(this, lp);
        } else {
            this.setLayoutParams(lp);
        }
        this.mWidthSpec = View.MeasureSpec.makeMeasureSpec(width, 0x40000000);
        this.mHeightSpec = View.MeasureSpec.makeMeasureSpec(height, 0x40000000);
        this.requestFocus();
    }

    public void setSingleLine(boolean single) {
        int inputType = 1;
        if (!single) {
            inputType |= 0x2C000;
        }
        this.mSingle = single;
        this.setHorizontallyScrolling(single);
        this.setInputType(inputType);
    }

    public void setText(CharSequence text, int start, int end) {
        this.mPreChange = ((Object)text).toString();
        this.setText(text);
        Editable span = this.getText();
        int length = span.length();
        if (end > length) {
            end = length;
        }
        if (start < 0) {
            start = 0;
        } else if (start > length) {
            start = length;
        }
        Selection.setSelection(span, start, end);
    }

    public void setTextAndKeepSelection(String text) {
        this.mPreChange = text.toString();
        Editable edit = this.getText();
        edit.replace(0, edit.length(), text);
        this.updateCachedTextfield();
    }

    public void updateCachedTextfield() {
        this.mWebView.updateCachedTextfield(this.getText().toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AutoCompleteAdapter
    extends ArrayAdapter<String> {
        public TextView mTextView;

        public AutoCompleteAdapter(Context context, ArrayList<String> entries) {
            super(context, 17367123, entries);
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            TextView tv = (TextView)super.getView(position, convertView, parent);
            if (tv != null && this.mTextView != null) {
                tv.setTextSize(this.mTextView.getTextSize());
            }
            return tv;
        }

        public void setTextView(TextView tv) {
            this.mTextView = tv;
        }
    }
}

