/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayAdapter<T>
extends BaseAdapter
implements Filterable {
    public List<T> mObjects;
    public final Object mLock = new Object();
    public int mResource;
    public int mDropDownResource;
    public int mFieldId = 0;
    public boolean mNotifyOnChange = true;
    public Context mContext;
    public ArrayList<T> mOriginalValues;
    public ArrayFilter mFilter;
    public LayoutInflater mInflater;

    public ArrayAdapter(Context context, int textViewResourceId) {
        this.init(context, textViewResourceId, 0, new ArrayList());
    }

    public ArrayAdapter(Context context, int resource, int textViewResourceId) {
        this.init(context, resource, textViewResourceId, new ArrayList());
    }

    public ArrayAdapter(Context context, int textViewResourceId, T[] objects) {
        this.init(context, textViewResourceId, 0, Arrays.asList(objects));
    }

    public ArrayAdapter(Context context, int resource, int textViewResourceId, T[] objects) {
        this.init(context, resource, textViewResourceId, Arrays.asList(objects));
    }

    public ArrayAdapter(Context context, int textViewResourceId, List<T> objects) {
        this.init(context, textViewResourceId, 0, objects);
    }

    public ArrayAdapter(Context context, int resource, int textViewResourceId, List<T> objects) {
        this.init(context, resource, textViewResourceId, objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T object) {
        if (this.mOriginalValues != null) {
            Object object2 = this.mLock;
            synchronized (object2) {
                this.mOriginalValues.add(object);
                if (this.mNotifyOnChange) {
                    this.notifyDataSetChanged();
                }
            }
        } else {
            this.mObjects.add(object);
            if (this.mNotifyOnChange) {
                this.notifyDataSetChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(T object, int index) {
        if (this.mOriginalValues != null) {
            Object object2 = this.mLock;
            synchronized (object2) {
                this.mOriginalValues.add(index, object);
                if (this.mNotifyOnChange) {
                    this.notifyDataSetChanged();
                }
            }
        } else {
            this.mObjects.add(index, object);
            if (this.mNotifyOnChange) {
                this.notifyDataSetChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(T object) {
        if (this.mOriginalValues != null) {
            Object object2 = this.mLock;
            synchronized (object2) {
                this.mOriginalValues.remove(object);
            }
        } else {
            this.mObjects.remove(object);
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.mOriginalValues != null) {
            Object object = this.mLock;
            synchronized (object) {
                this.mOriginalValues.clear();
            }
        } else {
            this.mObjects.clear();
        }
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    public void sort(Comparator<? super T> comparator) {
        Collections.sort(this.mObjects, comparator);
        if (this.mNotifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.mNotifyOnChange = true;
    }

    public void setNotifyOnChange(boolean notifyOnChange) {
        this.mNotifyOnChange = notifyOnChange;
    }

    public void init(Context context, int resource, int textViewResourceId, List<T> objects) {
        this.mContext = context;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mResource = this.mDropDownResource = resource;
        this.mObjects = objects;
        this.mFieldId = textViewResourceId;
    }

    public Context getContext() {
        return this.mContext;
    }

    @Override
    public int getCount() {
        return this.mObjects.size();
    }

    public T getItem(int position) {
        return this.mObjects.get(position);
    }

    public int getPosition(T item) {
        return this.mObjects.indexOf(item);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        return this.createViewFromResource(position, convertView, parent, this.mResource);
    }

    public View createViewFromResource(int position, View convertView, ViewGroup parent, int resource) {
        TextView text;
        View view = convertView == null ? this.mInflater.inflate(resource, parent, false) : convertView;
        try {
            text = this.mFieldId == 0 ? (TextView)view : (TextView)view.findViewById(this.mFieldId);
        }
        catch (ClassCastException e) {
            Log.e("ArrayAdapter", "You must supply a resource ID for a TextView");
            throw new IllegalStateException("ArrayAdapter requires the resource ID to be a TextView", e);
        }
        text.setText(this.getItem(position).toString());
        return view;
    }

    public void setDropDownViewResource(int resource) {
        this.mDropDownResource = resource;
    }

    @Override
    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        return this.createViewFromResource(position, convertView, parent, this.mDropDownResource);
    }

    public static ArrayAdapter<CharSequence> createFromResource(Context context, int textArrayResId, int textViewResId) {
        CharSequence[] strings = context.getResources().getTextArray(textArrayResId);
        return new ArrayAdapter<CharSequence>(context, textViewResId, strings);
    }

    @Override
    public Filter getFilter() {
        if (this.mFilter == null) {
            this.mFilter = new ArrayFilter(null);
        }
        return this.mFilter;
    }

    public static class 1 {
    }

    public class ArrayFilter
    extends Filter {
        public ArrayFilter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Filter.FilterResults performFiltering(CharSequence prefix) {
            Object object;
            Filter.FilterResults results = new Filter.FilterResults();
            if (ArrayAdapter.this.mOriginalValues == null) {
                object = ArrayAdapter.this.mLock;
                synchronized (object) {
                    ArrayAdapter.this.mOriginalValues = new ArrayList(ArrayAdapter.this.mObjects);
                }
            }
            if (prefix == null || prefix.length() == 0) {
                object = ArrayAdapter.this.mLock;
                synchronized (object) {
                    ArrayList list;
                    results.values = list = new ArrayList(ArrayAdapter.this.mOriginalValues);
                    results.count = list.size();
                }
            } else {
                String prefixString = ((Object)prefix).toString().toLowerCase();
                ArrayList values = ArrayAdapter.this.mOriginalValues;
                int count = values.size();
                ArrayList newValues = new ArrayList(count);
                block6: for (int i = 0; i < count; ++i) {
                    Object value = values.get(i);
                    String valueText = value.toString().toLowerCase();
                    if (valueText.startsWith(prefixString)) {
                        newValues.add(value);
                        continue;
                    }
                    String[] words = valueText.split(" ");
                    int wordCount = words.length;
                    for (int k = 0; k < wordCount; ++k) {
                        if (!words[k].startsWith(prefixString)) continue;
                        newValues.add(value);
                        continue block6;
                    }
                }
                results.values = newValues;
                results.count = newValues.size();
            }
            return results;
        }

        public void publishResults(CharSequence constraint, Filter.FilterResults results) {
            ArrayAdapter.this.mObjects = (List)results.values;
            if (results.count > 0) {
                ArrayAdapter.this.notifyDataSetChanged();
            } else {
                ArrayAdapter.this.notifyDataSetInvalidated();
            }
        }

        public /* synthetic */ ArrayFilter(1 x1) {
            this();
        }
    }
}

