/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.widget.RemoteViews;
import com.android.internal.R;

@RemoteViews.RemoteView
public class FrameLayout
extends ViewGroup {
    @ViewDebug.ExportedProperty
    public boolean mMeasureAllChildren = false;
    @ViewDebug.ExportedProperty
    public Drawable mForeground;
    @ViewDebug.ExportedProperty
    public int mForegroundPaddingLeft = 0;
    @ViewDebug.ExportedProperty
    public int mForegroundPaddingTop = 0;
    @ViewDebug.ExportedProperty
    public int mForegroundPaddingRight = 0;
    @ViewDebug.ExportedProperty
    public int mForegroundPaddingBottom = 0;
    public final Rect mSelfBounds = new Rect();
    public final Rect mOverlayBounds = new Rect();
    @ViewDebug.ExportedProperty
    public int mForegroundGravity = 119;
    @ViewDebug.ExportedProperty
    public boolean mForegroundInPadding = true;
    public boolean mForegroundBoundsChanged = false;

    public FrameLayout(Context context) {
        super(context);
    }

    public FrameLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FrameLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FrameLayout, defStyle, 0);
        this.mForegroundGravity = a.getInt(2, this.mForegroundGravity);
        Drawable d = a.getDrawable(0);
        if (d != null) {
            this.setForeground(d);
        }
        if (a.getBoolean(1, false)) {
            this.setMeasureAllChildren(true);
        }
        this.mForegroundInPadding = a.getBoolean(3, true);
        a.recycle();
    }

    @RemotableViewMethod
    public void setForegroundGravity(int foregroundGravity) {
        if (this.mForegroundGravity != foregroundGravity) {
            if ((foregroundGravity & 7) == 0) {
                foregroundGravity |= 3;
            }
            if ((foregroundGravity & 0x70) == 0) {
                foregroundGravity |= 0x30;
            }
            this.mForegroundGravity = foregroundGravity;
            if (this.mForegroundGravity == 119 && this.mForeground != null) {
                Rect padding = new Rect();
                if (this.mForeground.getPadding(padding)) {
                    this.mForegroundPaddingLeft = padding.left;
                    this.mForegroundPaddingTop = padding.top;
                    this.mForegroundPaddingRight = padding.right;
                    this.mForegroundPaddingBottom = padding.bottom;
                }
            } else {
                this.mForegroundPaddingLeft = 0;
                this.mForegroundPaddingTop = 0;
                this.mForegroundPaddingRight = 0;
                this.mForegroundPaddingBottom = 0;
            }
            this.requestLayout();
        }
    }

    public boolean verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || who == this.mForeground;
    }

    public void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mForeground != null && this.mForeground.isStateful()) {
            this.mForeground.setState(this.getDrawableState());
        }
    }

    public LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    public void setForeground(Drawable drawable2) {
        if (this.mForeground != drawable2) {
            if (this.mForeground != null) {
                this.mForeground.setCallback(null);
                this.unscheduleDrawable(this.mForeground);
            }
            this.mForeground = drawable2;
            this.mForegroundPaddingLeft = 0;
            this.mForegroundPaddingTop = 0;
            this.mForegroundPaddingRight = 0;
            this.mForegroundPaddingBottom = 0;
            if (drawable2 != null) {
                Rect padding;
                this.setWillNotDraw(false);
                drawable2.setCallback(this);
                if (drawable2.isStateful()) {
                    drawable2.setState(this.getDrawableState());
                }
                if (this.mForegroundGravity == 119 && drawable2.getPadding(padding = new Rect())) {
                    this.mForegroundPaddingLeft = padding.left;
                    this.mForegroundPaddingTop = padding.top;
                    this.mForegroundPaddingRight = padding.right;
                    this.mForegroundPaddingBottom = padding.bottom;
                }
            } else {
                this.setWillNotDraw(true);
            }
            this.requestLayout();
            this.invalidate();
        }
    }

    public Drawable getForeground() {
        return this.mForeground;
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        int maxHeight = 0;
        int maxWidth = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!this.mMeasureAllChildren && child.getVisibility() == 8) continue;
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth());
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight());
        }
        maxWidth += this.mPaddingLeft + this.mPaddingRight + this.mForegroundPaddingLeft + this.mForegroundPaddingRight;
        maxHeight += this.mPaddingTop + this.mPaddingBottom + this.mForegroundPaddingTop + this.mForegroundPaddingBottom;
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        Drawable drawable2 = this.getForeground();
        if (drawable2 != null) {
            maxHeight = Math.max(maxHeight, drawable2.getMinimumHeight());
            maxWidth = Math.max(maxWidth, drawable2.getMinimumWidth());
        }
        this.setMeasuredDimension(FrameLayout.resolveSize(maxWidth, widthMeasureSpec), FrameLayout.resolveSize(maxHeight, heightMeasureSpec));
    }

    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int count = this.getChildCount();
        int parentLeft = this.mPaddingLeft + this.mForegroundPaddingLeft;
        int parentRight = right - left - this.mPaddingRight - this.mForegroundPaddingRight;
        int parentTop = this.mPaddingTop + this.mForegroundPaddingTop;
        int parentBottom = bottom - top - this.mPaddingBottom - this.mForegroundPaddingBottom;
        this.mForegroundBoundsChanged = true;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            int childLeft = parentLeft;
            int childTop = parentTop;
            int gravity = lp.gravity;
            if (gravity != -1) {
                int horizontalGravity = gravity & 7;
                int verticalGravity = gravity & 0x70;
                switch (horizontalGravity) {
                    case 3: {
                        childLeft = parentLeft + lp.leftMargin;
                        break;
                    }
                    case 1: {
                        childLeft = parentLeft + (parentRight - parentLeft + lp.leftMargin + lp.rightMargin - width) / 2;
                        break;
                    }
                    case 5: {
                        childLeft = parentRight - width - lp.rightMargin;
                        break;
                    }
                    default: {
                        childLeft = parentLeft + lp.leftMargin;
                    }
                }
                switch (verticalGravity) {
                    case 48: {
                        childTop = parentTop + lp.topMargin;
                        break;
                    }
                    case 16: {
                        childTop = parentTop + (parentBottom - parentTop + lp.topMargin + lp.bottomMargin - height) / 2;
                        break;
                    }
                    case 80: {
                        childTop = parentBottom - height - lp.bottomMargin;
                        break;
                    }
                    default: {
                        childTop = parentTop + lp.topMargin;
                    }
                }
            }
            child.layout(childLeft, childTop, childLeft + width, childTop + height);
        }
    }

    public void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mForegroundBoundsChanged = true;
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mForeground != null) {
            Drawable foreground = this.mForeground;
            if (this.mForegroundBoundsChanged) {
                this.mForegroundBoundsChanged = false;
                if (foreground != null) {
                    Rect selfBounds = this.mSelfBounds;
                    Rect overlayBounds = this.mOverlayBounds;
                    int w = this.mRight - this.mLeft;
                    int h = this.mBottom - this.mTop;
                    if (this.mForegroundInPadding) {
                        selfBounds.set(0, 0, w, h);
                    } else {
                        selfBounds.set(this.mPaddingLeft, this.mPaddingTop, w - this.mPaddingRight, h - this.mPaddingBottom);
                    }
                    Gravity.apply(this.mForegroundGravity, foreground.getIntrinsicWidth(), foreground.getIntrinsicHeight(), selfBounds, overlayBounds);
                    foreground.setBounds(overlayBounds);
                }
            }
            foreground.draw(canvas);
        }
    }

    public boolean gatherTransparentRegion(Region region) {
        boolean opaque = super.gatherTransparentRegion(region);
        if (region != null && this.mForeground != null) {
            this.applyDrawableToTransparentRegion(this.mForeground, region);
        }
        return opaque;
    }

    @RemotableViewMethod
    public void setMeasureAllChildren(boolean measureAll) {
        this.mMeasureAllChildren = measureAll;
    }

    public boolean getConsiderGoneChildrenWhenMeasuring() {
        return this.mMeasureAllChildren;
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    public boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public int gravity = -1;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.FrameLayout_Layout);
            this.gravity = a.getInt(0, -1);
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(int width, int height, int gravity) {
            super(width, height);
            this.gravity = gravity;
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }
    }
}

