/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.widget.RemoteViews;
import com.android.internal.R;

@RemoteViews.RemoteView
public class RelativeLayout
extends ViewGroup {
    public static final int TRUE = -1;
    public static final int LEFT_OF = 0;
    public static final int RIGHT_OF = 1;
    public static final int ABOVE = 2;
    public static final int BELOW = 3;
    public static final int ALIGN_BASELINE = 4;
    public static final int ALIGN_LEFT = 5;
    public static final int ALIGN_TOP = 6;
    public static final int ALIGN_RIGHT = 7;
    public static final int ALIGN_BOTTOM = 8;
    public static final int ALIGN_PARENT_LEFT = 9;
    public static final int ALIGN_PARENT_TOP = 10;
    public static final int ALIGN_PARENT_RIGHT = 11;
    public static final int ALIGN_PARENT_BOTTOM = 12;
    public static final int CENTER_IN_PARENT = 13;
    public static final int CENTER_HORIZONTAL = 14;
    public static final int CENTER_VERTICAL = 15;
    public static final int VERB_COUNT = 16;
    public View mBaselineView = null;
    public boolean mHasBaselineAlignedChild;
    public int mGravity = 51;
    public final Rect mContentBounds = new Rect();
    public final Rect mSelfBounds = new Rect();
    public int mIgnoreGravity;

    public RelativeLayout(Context context) {
        super(context);
    }

    public RelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initFromAttributes(context, attrs);
    }

    public RelativeLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initFromAttributes(context, attrs);
    }

    public void initFromAttributes(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RelativeLayout);
        this.mIgnoreGravity = a.getResourceId(1, -1);
        this.mGravity = a.getInt(0, this.mGravity);
        a.recycle();
    }

    @RemotableViewMethod
    public void setIgnoreGravity(int viewId) {
        this.mIgnoreGravity = viewId;
    }

    @RemotableViewMethod
    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            if ((gravity & 7) == 0) {
                gravity |= 3;
            }
            if ((gravity & 0x70) == 0) {
                gravity |= 0x30;
            }
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    @RemotableViewMethod
    public void setHorizontalGravity(int horizontalGravity) {
        int gravity = horizontalGravity & 7;
        if ((this.mGravity & 7) != gravity) {
            this.mGravity = this.mGravity & 0xFFFFFFF8 | gravity;
            this.requestLayout();
        }
    }

    @RemotableViewMethod
    public void setVerticalGravity(int verticalGravity) {
        int gravity = verticalGravity & 0x70;
        if ((this.mGravity & 0x70) != gravity) {
            this.mGravity = this.mGravity & 0xFFFFFF8F | gravity;
            this.requestLayout();
        }
    }

    public int getBaseline() {
        return this.mBaselineView != null ? this.mBaselineView.getBaseline() : super.getBaseline();
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        LayoutParams params;
        View child;
        int i;
        int myWidth = -1;
        int myHeight = -1;
        int width = 0;
        int height = 0;
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        if (widthMode != 0) {
            myWidth = widthSize;
        }
        if (heightMode != 0) {
            myHeight = heightSize;
        }
        if (widthMode == 0x40000000) {
            width = myWidth;
        }
        if (heightMode == 0x40000000) {
            height = myHeight;
        }
        int len = this.getChildCount();
        this.mHasBaselineAlignedChild = false;
        View ignore = null;
        int gravity = this.mGravity & 7;
        boolean horizontalGravity = gravity != 3 && gravity != 0;
        gravity = this.mGravity & 0x70;
        boolean verticalGravity = gravity != 48 && gravity != 0;
        int left = Integer.MAX_VALUE;
        int top = Integer.MAX_VALUE;
        int right = Integer.MIN_VALUE;
        int bottom = Integer.MIN_VALUE;
        if ((horizontalGravity || verticalGravity) && this.mIgnoreGravity != -1) {
            ignore = this.findViewById(this.mIgnoreGravity);
        }
        for (i = 0; i < len; ++i) {
            child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            params = (LayoutParams)child.getLayoutParams();
            this.applySizeRules(params, myWidth, myHeight);
            this.measureChild(child, params, myWidth, myHeight);
            this.positionChild(child, params, myWidth, myHeight);
            if (widthMode != 0x40000000) {
                width = Math.max(width, params.mRight);
            }
            if (heightMode != 0x40000000) {
                height = Math.max(height, params.mBottom);
            }
            if (child != ignore || verticalGravity) {
                left = Math.min(left, params.mLeft - params.leftMargin);
                top = Math.min(top, params.mTop - params.topMargin);
            }
            if (child == ignore && !horizontalGravity) continue;
            right = Math.max(right, params.mRight + params.rightMargin);
            bottom = Math.max(bottom, params.mBottom + params.bottomMargin);
        }
        if (this.mHasBaselineAlignedChild) {
            for (i = 0; i < len; ++i) {
                child = this.getChildAt(i);
                if (child.getVisibility() == 8) continue;
                params = (LayoutParams)child.getLayoutParams();
                this.alignBaseline(child, params);
                if (child != ignore || verticalGravity) {
                    left = Math.min(left, params.mLeft - params.leftMargin);
                    top = Math.min(top, params.mTop - params.topMargin);
                }
                if (child == ignore && !horizontalGravity) continue;
                right = Math.max(right, params.mRight + params.rightMargin);
                bottom = Math.max(bottom, params.mBottom + params.bottomMargin);
            }
        }
        if (widthMode != 0x40000000) {
            width += this.mPaddingRight;
            if (this.mLayoutParams.width >= 0) {
                width = Math.max(width, this.mLayoutParams.width);
            }
            width = Math.max(width, this.getSuggestedMinimumWidth());
            width = RelativeLayout.resolveSize(width, widthMeasureSpec);
        }
        if (heightMode != 0x40000000) {
            height += this.mPaddingBottom;
            if (this.mLayoutParams.height >= 0) {
                height = Math.max(height, this.mLayoutParams.height);
            }
            height = Math.max(height, this.getSuggestedMinimumHeight());
            height = RelativeLayout.resolveSize(height, heightMeasureSpec);
        }
        if (horizontalGravity || verticalGravity) {
            Rect selfBounds = this.mSelfBounds;
            selfBounds.set(this.mPaddingLeft, this.mPaddingTop, width - this.mPaddingRight, height - this.mPaddingBottom);
            Rect contentBounds = this.mContentBounds;
            Gravity.apply(this.mGravity, right - left, bottom - top, selfBounds, contentBounds);
            int horizontalOffset = contentBounds.left - left;
            int verticalOffset = contentBounds.top - top;
            if (horizontalOffset != 0 || verticalOffset != 0) {
                for (int i2 = 0; i2 < len; ++i2) {
                    View child2 = this.getChildAt(i2);
                    if (child2.getVisibility() == 8 || child2 == ignore) continue;
                    LayoutParams params2 = (LayoutParams)child2.getLayoutParams();
                    params2.mLeft += horizontalOffset;
                    params2.mRight += horizontalOffset;
                    params2.mTop += verticalOffset;
                    params2.mBottom += verticalOffset;
                }
            }
        }
        this.setMeasuredDimension(width, height);
    }

    public void alignBaseline(View child, LayoutParams params) {
        LayoutParams anchorParams;
        int[] rules = params.getRules();
        int anchorBaseline = this.getRelatedViewBaseline(rules, 4);
        if (anchorBaseline != -1 && (anchorParams = this.getRelatedViewParams(rules, 4)) != null) {
            int offset = anchorParams.mTop + anchorBaseline;
            int baseline = child.getBaseline();
            if (baseline != -1) {
                offset -= baseline;
            }
            int height = params.mBottom - params.mTop;
            params.mTop = offset;
            params.mBottom = params.mTop + height;
        }
        if (this.mBaselineView == null) {
            this.mBaselineView = child;
        } else {
            LayoutParams lp = (LayoutParams)this.mBaselineView.getLayoutParams();
            if (params.mTop < lp.mTop || params.mTop == lp.mTop && params.mLeft < lp.mLeft) {
                this.mBaselineView = child;
            }
        }
    }

    public void measureChild(View child, LayoutParams params, int myWidth, int myHeight) {
        int childWidthMeasureSpec = this.getChildMeasureSpec(params.mLeft, params.mRight, params.width, params.leftMargin, params.rightMargin, this.mPaddingLeft, this.mPaddingRight, myWidth);
        int childHeightMeasureSpec = this.getChildMeasureSpec(params.mTop, params.mBottom, params.height, params.topMargin, params.bottomMargin, this.mPaddingTop, this.mPaddingBottom, myHeight);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    public int getChildMeasureSpec(int childStart, int childEnd, int childSize, int startMargin, int endMargin, int startPadding, int endPadding, int mySize) {
        int childSpecMode = 0;
        int childSpecSize = 0;
        int tempStart = childStart;
        int tempEnd = childEnd;
        if (tempStart < 0) {
            tempStart = startPadding + startMargin;
        }
        if (tempEnd < 0) {
            tempEnd = mySize - endPadding - endMargin;
        }
        int maxAvailable = tempEnd - tempStart;
        if (childStart >= 0 && childEnd >= 0) {
            childSpecMode = 0x40000000;
            childSpecSize = maxAvailable;
        } else if (childSize >= 0) {
            childSpecMode = 0x40000000;
            childSpecSize = maxAvailable >= 0 ? Math.min(maxAvailable, childSize) : childSize;
        } else if (childSize == -1) {
            childSpecMode = 0x40000000;
            childSpecSize = maxAvailable;
        } else if (childSize == -2) {
            if (maxAvailable >= 0) {
                childSpecMode = Integer.MIN_VALUE;
                childSpecSize = maxAvailable;
            } else {
                childSpecMode = 0;
                childSpecSize = 0;
            }
        }
        return View.MeasureSpec.makeMeasureSpec(childSpecSize, childSpecMode);
    }

    public void positionChild(View child, LayoutParams params, int myWidth, int myHeight) {
        int[] rules = params.getRules();
        if (params.mLeft < 0 && params.mRight >= 0) {
            params.mLeft = params.mRight - child.getMeasuredWidth();
        } else if (params.mLeft >= 0 && params.mRight < 0) {
            params.mRight = params.mLeft + child.getMeasuredWidth();
        } else if (params.mLeft < 0 && params.mRight < 0) {
            if (0 != rules[13] || 0 != rules[14]) {
                this.centerHorizontal(child, params, myWidth);
            } else {
                params.mLeft = this.mPaddingLeft + params.leftMargin;
                params.mRight = params.mLeft + child.getMeasuredWidth();
            }
        }
        if (params.mTop < 0 && params.mBottom >= 0) {
            params.mTop = params.mBottom - child.getMeasuredHeight();
        } else if (params.mTop >= 0 && params.mBottom < 0) {
            params.mBottom = params.mTop + child.getMeasuredHeight();
        } else if (params.mTop < 0 && params.mBottom < 0) {
            if (0 != rules[13] || 0 != rules[15]) {
                this.centerVertical(child, params, myHeight);
            } else {
                params.mTop = this.mPaddingTop + params.topMargin;
                params.mBottom = params.mTop + child.getMeasuredHeight();
            }
        }
    }

    public void applySizeRules(LayoutParams childParams, int myWidth, int myHeight) {
        int[] rules = childParams.getRules();
        childParams.mLeft = -1;
        childParams.mRight = -1;
        LayoutParams anchorParams = this.getRelatedViewParams(rules, 0);
        if (anchorParams != null) {
            childParams.mRight = anchorParams.mLeft - (anchorParams.leftMargin + childParams.rightMargin);
        } else if (childParams.alignWithParent && rules[0] != 0 && myWidth >= 0) {
            childParams.mRight = myWidth - this.mPaddingRight - childParams.rightMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 1);
        if (anchorParams != null) {
            childParams.mLeft = anchorParams.mRight + (anchorParams.rightMargin + childParams.leftMargin);
        } else if (childParams.alignWithParent && rules[1] != 0) {
            childParams.mLeft = this.mPaddingLeft + childParams.leftMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 5);
        if (anchorParams != null) {
            childParams.mLeft = anchorParams.mLeft + childParams.leftMargin;
        } else if (childParams.alignWithParent && rules[5] != 0) {
            childParams.mLeft = this.mPaddingLeft + childParams.leftMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 7);
        if (anchorParams != null) {
            childParams.mRight = anchorParams.mRight - childParams.rightMargin;
        } else if (childParams.alignWithParent && rules[7] != 0 && myWidth >= 0) {
            childParams.mRight = myWidth - this.mPaddingRight - childParams.rightMargin;
        }
        if (0 != rules[9]) {
            childParams.mLeft = this.mPaddingLeft + childParams.leftMargin;
        }
        if (0 != rules[11] && myWidth >= 0) {
            childParams.mRight = myWidth - this.mPaddingRight - childParams.rightMargin;
        }
        childParams.mTop = -1;
        childParams.mBottom = -1;
        anchorParams = this.getRelatedViewParams(rules, 2);
        if (anchorParams != null) {
            childParams.mBottom = anchorParams.mTop - (anchorParams.topMargin + childParams.bottomMargin);
        } else if (childParams.alignWithParent && rules[2] != 0 && myHeight >= 0) {
            childParams.mBottom = myHeight - this.mPaddingBottom - childParams.bottomMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 3);
        if (anchorParams != null) {
            childParams.mTop = anchorParams.mBottom + (anchorParams.bottomMargin + childParams.topMargin);
        } else if (childParams.alignWithParent && rules[3] != 0) {
            childParams.mTop = this.mPaddingTop + childParams.topMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 6);
        if (anchorParams != null) {
            childParams.mTop = anchorParams.mTop + childParams.topMargin;
        } else if (childParams.alignWithParent && rules[6] != 0) {
            childParams.mTop = this.mPaddingTop + childParams.topMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 8);
        if (anchorParams != null) {
            childParams.mBottom = anchorParams.mBottom - childParams.bottomMargin;
        } else if (childParams.alignWithParent && rules[8] != 0 && myHeight >= 0) {
            childParams.mBottom = myHeight - this.mPaddingBottom - childParams.bottomMargin;
        }
        if (0 != rules[10]) {
            childParams.mTop = this.mPaddingTop + childParams.topMargin;
        }
        if (0 != rules[12] && myHeight >= 0) {
            childParams.mBottom = myHeight - this.mPaddingBottom - childParams.bottomMargin;
        }
        if (rules[4] != 0) {
            this.mHasBaselineAlignedChild = true;
        }
    }

    public View getRelatedView(int[] rules, int relation) {
        int id2 = rules[relation];
        if (id2 != 0) {
            View v = this.findViewById(id2);
            if (v == null) {
                return null;
            }
            while (v.getVisibility() == 8) {
                rules = ((LayoutParams)v.getLayoutParams()).getRules();
                if ((v = v.findViewById(rules[relation])) != null) continue;
                return null;
            }
            return v;
        }
        return null;
    }

    public LayoutParams getRelatedViewParams(int[] rules, int relation) {
        ViewGroup.LayoutParams params;
        View v = this.getRelatedView(rules, relation);
        if (v != null && (params = v.getLayoutParams()) instanceof LayoutParams) {
            return (LayoutParams)v.getLayoutParams();
        }
        return null;
    }

    public int getRelatedViewBaseline(int[] rules, int relation) {
        View v = this.getRelatedView(rules, relation);
        if (v != null) {
            return v.getBaseline();
        }
        return -1;
    }

    public void centerHorizontal(View child, LayoutParams params, int myWidth) {
        int childWidth = child.getMeasuredWidth();
        int left = (myWidth - childWidth) / 2;
        params.mLeft = left;
        params.mRight = left + childWidth;
    }

    public void centerVertical(View child, LayoutParams params, int myHeight) {
        int childHeight = child.getMeasuredHeight();
        int top = (myHeight - childHeight) / 2;
        params.mTop = top;
        params.mBottom = top + childHeight;
    }

    public void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams st = (LayoutParams)child.getLayoutParams();
            child.layout(st.mLeft, st.mTop, st.mRight, st.mBottom);
        }
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    public ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    public boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        @ViewDebug.ExportedProperty(resolveId=true, indexMapping={@ViewDebug.IntToString(from=2, to="above"), @ViewDebug.IntToString(from=4, to="alignBaseline"), @ViewDebug.IntToString(from=8, to="alignBottom"), @ViewDebug.IntToString(from=5, to="alignLeft"), @ViewDebug.IntToString(from=12, to="alignParentBottom"), @ViewDebug.IntToString(from=9, to="alignParentLeft"), @ViewDebug.IntToString(from=11, to="alignParentRight"), @ViewDebug.IntToString(from=10, to="alignParentTop"), @ViewDebug.IntToString(from=7, to="alignRight"), @ViewDebug.IntToString(from=6, to="alignTop"), @ViewDebug.IntToString(from=3, to="below"), @ViewDebug.IntToString(from=14, to="centerHorizontal"), @ViewDebug.IntToString(from=13, to="center"), @ViewDebug.IntToString(from=15, to="centerVertical"), @ViewDebug.IntToString(from=0, to="leftOf"), @ViewDebug.IntToString(from=1, to="rightOf")}, mapping={@ViewDebug.IntToString(from=-1, to="true"), @ViewDebug.IntToString(from=0, to="NO_ID")})
        public int[] mRules = new int[16];
        public int mLeft;
        public int mTop;
        public int mRight;
        public int mBottom;
        @ViewDebug.ExportedProperty
        public boolean alignWithParent;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.RelativeLayout_Layout);
            int[] rules = this.mRules;
            int N = a.getIndexCount();
            block19: for (int i = 0; i < N; ++i) {
                int attr2 = a.getIndex(i);
                switch (attr2) {
                    case 16: {
                        this.alignWithParent = a.getBoolean(attr2, false);
                        continue block19;
                    }
                    case 0: {
                        rules[0] = a.getResourceId(attr2, 0);
                        continue block19;
                    }
                    case 1: {
                        rules[1] = a.getResourceId(attr2, 0);
                        continue block19;
                    }
                    case 2: {
                        rules[2] = a.getResourceId(attr2, 0);
                        continue block19;
                    }
                    case 3: {
                        rules[3] = a.getResourceId(attr2, 0);
                        continue block19;
                    }
                    case 4: {
                        rules[4] = a.getResourceId(attr2, 0);
                        continue block19;
                    }
                    case 5: {
                        rules[5] = a.getResourceId(attr2, 0);
                        continue block19;
                    }
                    case 6: {
                        rules[6] = a.getResourceId(attr2, 0);
                        continue block19;
                    }
                    case 7: {
                        rules[7] = a.getResourceId(attr2, 0);
                        continue block19;
                    }
                    case 8: {
                        rules[8] = a.getResourceId(attr2, 0);
                        continue block19;
                    }
                    case 9: {
                        rules[9] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block19;
                    }
                    case 10: {
                        rules[10] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block19;
                    }
                    case 11: {
                        rules[11] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block19;
                    }
                    case 12: {
                        rules[12] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block19;
                    }
                    case 13: {
                        rules[13] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block19;
                    }
                    case 14: {
                        rules[14] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block19;
                    }
                    case 15: {
                        rules[15] = a.getBoolean(attr2, false) ? -1 : 0;
                    }
                }
            }
            a.recycle();
        }

        public LayoutParams(int w, int h) {
            super(w, h);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public String debug(String output) {
            return output + "ViewGroup.LayoutParams={ width=" + LayoutParams.sizeToString(this.width) + ", height=" + LayoutParams.sizeToString(this.height) + " }";
        }

        public void addRule(int verb) {
            this.mRules[verb] = -1;
        }

        public void addRule(int verb, int anchor) {
            this.mRules[verb] = anchor;
        }

        public int[] getRules() {
            return this.mRules;
        }
    }
}

