/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.media.MediaPlayer;
import android.net.Uri;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.MediaController;
import java.io.IOException;

public class VideoView
extends SurfaceView
implements MediaController.MediaPlayerControl {
    public String TAG = "VideoView";
    public Uri mUri;
    public int mDuration;
    public SurfaceHolder mSurfaceHolder = null;
    public MediaPlayer mMediaPlayer = null;
    public boolean mIsPrepared;
    public int mVideoWidth;
    public int mVideoHeight;
    public int mSurfaceWidth;
    public int mSurfaceHeight;
    public MediaController mMediaController;
    public MediaPlayer.OnCompletionListener mOnCompletionListener;
    public MediaPlayer.OnPreparedListener mOnPreparedListener;
    public int mCurrentBufferPercentage;
    public MediaPlayer.OnErrorListener mOnErrorListener;
    public boolean mStartWhenPrepared;
    public int mSeekWhenPrepared;
    public MediaPlayer.OnVideoSizeChangedListener mSizeChangedListener = new MediaPlayer.OnVideoSizeChangedListener(){

        public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
            VideoView.this.mVideoWidth = mp.getVideoWidth();
            VideoView.this.mVideoHeight = mp.getVideoHeight();
            if (VideoView.this.mVideoWidth != 0 && VideoView.this.mVideoHeight != 0) {
                VideoView.this.getHolder().setFixedSize(VideoView.this.mVideoWidth, VideoView.this.mVideoHeight);
            }
        }
    };
    public MediaPlayer.OnPreparedListener mPreparedListener = new MediaPlayer.OnPreparedListener(){

        public void onPrepared(MediaPlayer mp) {
            VideoView.this.mIsPrepared = true;
            if (VideoView.this.mOnPreparedListener != null) {
                VideoView.this.mOnPreparedListener.onPrepared(VideoView.this.mMediaPlayer);
            }
            if (VideoView.this.mMediaController != null) {
                VideoView.this.mMediaController.setEnabled(true);
            }
            VideoView.this.mVideoWidth = mp.getVideoWidth();
            VideoView.this.mVideoHeight = mp.getVideoHeight();
            if (VideoView.this.mVideoWidth != 0 && VideoView.this.mVideoHeight != 0) {
                VideoView.this.getHolder().setFixedSize(VideoView.this.mVideoWidth, VideoView.this.mVideoHeight);
                if (VideoView.this.mSurfaceWidth == VideoView.this.mVideoWidth && VideoView.this.mSurfaceHeight == VideoView.this.mVideoHeight) {
                    if (VideoView.this.mSeekWhenPrepared != 0) {
                        VideoView.this.mMediaPlayer.seekTo(VideoView.this.mSeekWhenPrepared);
                        VideoView.this.mSeekWhenPrepared = 0;
                    }
                    if (VideoView.this.mStartWhenPrepared) {
                        VideoView.this.mMediaPlayer.start();
                        VideoView.this.mStartWhenPrepared = false;
                        if (VideoView.this.mMediaController != null) {
                            VideoView.this.mMediaController.show();
                        }
                    } else if (!(VideoView.this.isPlaying() || VideoView.this.mSeekWhenPrepared == 0 && VideoView.this.getCurrentPosition() <= 0 || VideoView.this.mMediaController == null)) {
                        VideoView.this.mMediaController.show(0);
                    }
                }
            } else {
                if (VideoView.this.mSeekWhenPrepared != 0) {
                    VideoView.this.mMediaPlayer.seekTo(VideoView.this.mSeekWhenPrepared);
                    VideoView.this.mSeekWhenPrepared = 0;
                }
                if (VideoView.this.mStartWhenPrepared) {
                    VideoView.this.mMediaPlayer.start();
                    VideoView.this.mStartWhenPrepared = false;
                }
            }
        }
    };
    public MediaPlayer.OnCompletionListener mCompletionListener = new MediaPlayer.OnCompletionListener(){

        public void onCompletion(MediaPlayer mp) {
            if (VideoView.this.mMediaController != null) {
                VideoView.this.mMediaController.hide();
            }
            if (VideoView.this.mOnCompletionListener != null) {
                VideoView.this.mOnCompletionListener.onCompletion(VideoView.this.mMediaPlayer);
            }
        }
    };
    public MediaPlayer.OnErrorListener mErrorListener = new MediaPlayer.OnErrorListener(){

        public boolean onError(MediaPlayer mp, int framework_err, int impl_err) {
            Log.d(VideoView.this.TAG, "Error: " + framework_err + "," + impl_err);
            if (VideoView.this.mMediaController != null) {
                VideoView.this.mMediaController.hide();
            }
            if (VideoView.this.mOnErrorListener != null && VideoView.this.mOnErrorListener.onError(VideoView.this.mMediaPlayer, framework_err, impl_err)) {
                return true;
            }
            if (VideoView.this.getWindowToken() != null) {
                Resources r = VideoView.this.mContext.getResources();
                int messageId = framework_err == 200 ? 17039381 : 0x1040011;
                new AlertDialog.Builder(VideoView.this.mContext).setTitle(17039378).setMessage(messageId).setPositiveButton(0x1040010, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        if (VideoView.this.mOnCompletionListener != null) {
                            VideoView.this.mOnCompletionListener.onCompletion(VideoView.this.mMediaPlayer);
                        }
                    }
                }).setCancelable(false).show();
            }
            return true;
        }
    };
    public MediaPlayer.OnBufferingUpdateListener mBufferingUpdateListener = new MediaPlayer.OnBufferingUpdateListener(){

        public void onBufferingUpdate(MediaPlayer mp, int percent) {
            VideoView.this.mCurrentBufferPercentage = percent;
        }
    };
    public SurfaceHolder.Callback mSHCallback = new SurfaceHolder.Callback(){

        public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
            VideoView.this.mSurfaceWidth = w;
            VideoView.this.mSurfaceHeight = h;
            if (VideoView.this.mMediaPlayer != null && VideoView.this.mIsPrepared && VideoView.this.mVideoWidth == w && VideoView.this.mVideoHeight == h) {
                if (VideoView.this.mSeekWhenPrepared != 0) {
                    VideoView.this.mMediaPlayer.seekTo(VideoView.this.mSeekWhenPrepared);
                    VideoView.this.mSeekWhenPrepared = 0;
                }
                VideoView.this.mMediaPlayer.start();
                if (VideoView.this.mMediaController != null) {
                    VideoView.this.mMediaController.show();
                }
            }
        }

        public void surfaceCreated(SurfaceHolder holder) {
            VideoView.this.mSurfaceHolder = holder;
            VideoView.this.openVideo();
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            VideoView.this.mSurfaceHolder = null;
            if (VideoView.this.mMediaController != null) {
                VideoView.this.mMediaController.hide();
            }
            if (VideoView.this.mMediaPlayer != null) {
                VideoView.this.mMediaPlayer.reset();
                VideoView.this.mMediaPlayer.release();
                VideoView.this.mMediaPlayer = null;
            }
        }
    };

    public VideoView(Context context) {
        super(context);
        this.initVideoView();
    }

    public VideoView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
        this.initVideoView();
    }

    public VideoView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initVideoView();
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = VideoView.getDefaultSize(this.mVideoWidth, widthMeasureSpec);
        int height = VideoView.getDefaultSize(this.mVideoHeight, heightMeasureSpec);
        if (this.mVideoWidth > 0 && this.mVideoHeight > 0) {
            if (this.mVideoWidth * height > width * this.mVideoHeight) {
                height = width * this.mVideoHeight / this.mVideoWidth;
            } else if (this.mVideoWidth * height < width * this.mVideoHeight) {
                width = height * this.mVideoWidth / this.mVideoHeight;
            }
        }
        this.setMeasuredDimension(width, height);
    }

    public int resolveAdjustedSize(int desiredSize, int measureSpec) {
        int result = desiredSize;
        int specMode = View.MeasureSpec.getMode(measureSpec);
        int specSize = View.MeasureSpec.getSize(measureSpec);
        switch (specMode) {
            case 0: {
                result = desiredSize;
                break;
            }
            case -2147483648: {
                result = Math.min(desiredSize, specSize);
                break;
            }
            case 0x40000000: {
                result = specSize;
            }
        }
        return result;
    }

    public void initVideoView() {
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        this.getHolder().addCallback(this.mSHCallback);
        this.getHolder().setType(3);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestFocus();
    }

    public void setVideoPath(String path) {
        this.setVideoURI(Uri.parse(path));
    }

    public void setVideoURI(Uri uri) {
        this.mUri = uri;
        this.mStartWhenPrepared = false;
        this.mSeekWhenPrepared = 0;
        this.openVideo();
        this.requestLayout();
        this.invalidate();
    }

    public void stopPlayback() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
    }

    public void openVideo() {
        if (this.mUri == null || this.mSurfaceHolder == null) {
            return;
        }
        Intent i = new Intent("com.android.music.musicservicecommand");
        i.putExtra("command", "pause");
        this.mContext.sendBroadcast(i);
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.reset();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
        try {
            this.mMediaPlayer = new MediaPlayer();
            this.mMediaPlayer.setOnPreparedListener(this.mPreparedListener);
            this.mMediaPlayer.setOnVideoSizeChangedListener(this.mSizeChangedListener);
            this.mIsPrepared = false;
            Log.v(this.TAG, "reset duration to -1 in openVideo");
            this.mDuration = -1;
            this.mMediaPlayer.setOnCompletionListener(this.mCompletionListener);
            this.mMediaPlayer.setOnErrorListener(this.mErrorListener);
            this.mMediaPlayer.setOnBufferingUpdateListener(this.mBufferingUpdateListener);
            this.mCurrentBufferPercentage = 0;
            this.mMediaPlayer.setDataSource(this.mContext, this.mUri);
            this.mMediaPlayer.setDisplay(this.mSurfaceHolder);
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setScreenOnWhilePlaying(true);
            this.mMediaPlayer.prepareAsync();
            this.attachMediaController();
        }
        catch (IOException ex) {
            Log.w(this.TAG, "Unable to open content: " + this.mUri, ex);
            return;
        }
        catch (IllegalArgumentException ex) {
            Log.w(this.TAG, "Unable to open content: " + this.mUri, ex);
            return;
        }
    }

    public void setMediaController(MediaController controller) {
        if (this.mMediaController != null) {
            this.mMediaController.hide();
        }
        this.mMediaController = controller;
        this.attachMediaController();
    }

    public void attachMediaController() {
        if (this.mMediaPlayer != null && this.mMediaController != null) {
            this.mMediaController.setMediaPlayer(this);
            VideoView anchorView = this.getParent() instanceof View ? (View)((Object)this.getParent()) : this;
            this.mMediaController.setAnchorView(anchorView);
            this.mMediaController.setEnabled(this.mIsPrepared);
        }
    }

    public void setOnPreparedListener(MediaPlayer.OnPreparedListener l) {
        this.mOnPreparedListener = l;
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener l) {
        this.mOnCompletionListener = l;
    }

    public void setOnErrorListener(MediaPlayer.OnErrorListener l) {
        this.mOnErrorListener = l;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mIsPrepared && this.mMediaPlayer != null && this.mMediaController != null) {
            this.toggleMediaControlsVisiblity();
        }
        return false;
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        if (this.mIsPrepared && this.mMediaPlayer != null && this.mMediaController != null) {
            this.toggleMediaControlsVisiblity();
        }
        return false;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.mIsPrepared && keyCode != 4 && keyCode != 24 && keyCode != 25 && keyCode != 82 && keyCode != 5 && keyCode != 6 && this.mMediaPlayer != null && this.mMediaController != null) {
            if (keyCode == 79 || keyCode == 85) {
                if (this.mMediaPlayer.isPlaying()) {
                    this.pause();
                    this.mMediaController.show();
                } else {
                    this.start();
                    this.mMediaController.hide();
                }
                return true;
            }
            if (keyCode == 86 && this.mMediaPlayer.isPlaying()) {
                this.pause();
                this.mMediaController.show();
            } else {
                this.toggleMediaControlsVisiblity();
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public void toggleMediaControlsVisiblity() {
        if (this.mMediaController.isShowing()) {
            this.mMediaController.hide();
        } else {
            this.mMediaController.show();
        }
    }

    public void start() {
        if (this.mMediaPlayer != null && this.mIsPrepared) {
            this.mMediaPlayer.start();
            this.mStartWhenPrepared = false;
        } else {
            this.mStartWhenPrepared = true;
        }
    }

    public void pause() {
        if (this.mMediaPlayer != null && this.mIsPrepared && this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.pause();
        }
        this.mStartWhenPrepared = false;
    }

    public int getDuration() {
        if (this.mMediaPlayer != null && this.mIsPrepared) {
            if (this.mDuration > 0) {
                return this.mDuration;
            }
            this.mDuration = this.mMediaPlayer.getDuration();
            return this.mDuration;
        }
        this.mDuration = -1;
        return this.mDuration;
    }

    public int getCurrentPosition() {
        if (this.mMediaPlayer != null && this.mIsPrepared) {
            return this.mMediaPlayer.getCurrentPosition();
        }
        return 0;
    }

    public void seekTo(int msec) {
        if (this.mMediaPlayer != null && this.mIsPrepared) {
            this.mMediaPlayer.seekTo(msec);
        } else {
            this.mSeekWhenPrepared = msec;
        }
    }

    public boolean isPlaying() {
        if (this.mMediaPlayer != null && this.mIsPrepared) {
            return this.mMediaPlayer.isPlaying();
        }
        return false;
    }

    public int getBufferPercentage() {
        if (this.mMediaPlayer != null) {
            return this.mCurrentBufferPercentage;
        }
        return 0;
    }
}

