/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;

public class ListMenuItemView
extends LinearLayout
implements MenuView.ItemView {
    public MenuItemImpl mItemData;
    public ImageView mIconView;
    public RadioButton mRadioButton;
    public TextView mTitleView;
    public CheckBox mCheckBox;
    public TextView mShortcutView;
    public Drawable mBackground;
    public int mTextAppearance;
    public Context mTextAppearanceContext;
    public int mMenuType;

    public ListMenuItemView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MenuView, defStyle, 0);
        this.mBackground = a.getDrawable(5);
        this.mTextAppearance = a.getResourceId(1, -1);
        this.mTextAppearanceContext = context;
        a.recycle();
    }

    public ListMenuItemView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public void onFinishInflate() {
        super.onFinishInflate();
        this.setBackgroundDrawable(this.mBackground);
        this.mTitleView = (TextView)this.findViewById(16908310);
        if (this.mTextAppearance != -1) {
            this.mTitleView.setTextAppearance(this.mTextAppearanceContext, this.mTextAppearance);
        }
        this.mShortcutView = (TextView)this.findViewById(16908713);
    }

    public void initialize(MenuItemImpl itemData, int menuType) {
        this.mItemData = itemData;
        this.mMenuType = menuType;
        this.setVisibility(itemData.isVisible() ? 0 : 8);
        this.setTitle(itemData.getTitleForItemView(this));
        this.setCheckable(itemData.isCheckable());
        this.setShortcut(itemData.shouldShowShortcut(), itemData.getShortcut());
        this.setIcon(itemData.getIcon());
        this.setEnabled(itemData.isEnabled());
    }

    public void setTitle(CharSequence title) {
        if (title != null) {
            this.mTitleView.setText(title);
            if (this.mTitleView.getVisibility() != 0) {
                this.mTitleView.setVisibility(0);
            }
        } else if (this.mTitleView.getVisibility() != 8) {
            this.mTitleView.setVisibility(8);
        }
    }

    public MenuItemImpl getItemData() {
        return this.mItemData;
    }

    public void setCheckable(boolean checkable) {
        CompoundButton otherCompoundButton;
        CompoundButton compoundButton;
        if (!checkable && this.mRadioButton == null && this.mCheckBox == null) {
            return;
        }
        if (this.mRadioButton == null) {
            this.insertRadioButton();
        }
        if (this.mCheckBox == null) {
            this.insertCheckBox();
        }
        if (this.mItemData.isExclusiveCheckable()) {
            compoundButton = this.mRadioButton;
            otherCompoundButton = this.mCheckBox;
        } else {
            compoundButton = this.mCheckBox;
            otherCompoundButton = this.mRadioButton;
        }
        if (checkable) {
            int newVisibility;
            compoundButton.setChecked(this.mItemData.isChecked());
            int n = newVisibility = checkable ? 0 : 8;
            if (compoundButton.getVisibility() != newVisibility) {
                compoundButton.setVisibility(newVisibility);
            }
            if (otherCompoundButton.getVisibility() != 8) {
                otherCompoundButton.setVisibility(8);
            }
        } else {
            this.mCheckBox.setVisibility(8);
            this.mRadioButton.setVisibility(8);
        }
    }

    public void setChecked(boolean checked) {
        CompoundButton compoundButton;
        if (this.mItemData.isExclusiveCheckable()) {
            if (this.mRadioButton == null) {
                this.insertRadioButton();
            }
            compoundButton = this.mRadioButton;
        } else {
            if (this.mCheckBox == null) {
                this.insertCheckBox();
            }
            compoundButton = this.mCheckBox;
        }
        compoundButton.setChecked(checked);
    }

    public void setShortcut(boolean showShortcut, char shortcutKey) {
        int newVisibility;
        int n = newVisibility = showShortcut && this.mItemData.shouldShowShortcut() ? 0 : 8;
        if (newVisibility == 0) {
            this.mShortcutView.setText(this.mItemData.getShortcutLabel());
        }
        if (this.mShortcutView.getVisibility() != newVisibility) {
            this.mShortcutView.setVisibility(newVisibility);
        }
    }

    public void setIcon(Drawable icon) {
        if (!this.mItemData.shouldShowIcon(this.mMenuType)) {
            return;
        }
        if (this.mIconView == null && icon == null) {
            return;
        }
        if (this.mIconView == null) {
            this.insertIconView();
        }
        if (icon != null) {
            this.mIconView.setImageDrawable(icon);
            if (this.mIconView.getVisibility() != 0) {
                this.mIconView.setVisibility(0);
            }
        } else {
            this.mIconView.setVisibility(8);
        }
    }

    public void insertIconView() {
        LayoutInflater inflater = this.mItemData.getLayoutInflater(this.mMenuType);
        this.mIconView = (ImageView)inflater.inflate(17367096, (ViewGroup)this, false);
        this.addView((View)this.mIconView, 0);
    }

    public void insertRadioButton() {
        LayoutInflater inflater = this.mItemData.getLayoutInflater(this.mMenuType);
        this.mRadioButton = (RadioButton)inflater.inflate(17367098, (ViewGroup)this, false);
        this.addView(this.mRadioButton);
    }

    public void insertCheckBox() {
        LayoutInflater inflater = this.mItemData.getLayoutInflater(this.mMenuType);
        this.mCheckBox = (CheckBox)inflater.inflate(17367095, (ViewGroup)this, false);
        this.addView(this.mCheckBox);
    }

    public boolean prefersCondensedTitle() {
        return false;
    }

    public boolean showsIcon() {
        return false;
    }
}

