/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.BridgeInflater;
import android.view.IWindow;
import android.view.IWindowSession;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.android.internal.R;
import com.android.internal.util.XmlUtils;
import com.android.layoutlib.api.ILayoutBridge;
import com.android.layoutlib.api.ILayoutLog;
import com.android.layoutlib.api.ILayoutResult;
import com.android.layoutlib.api.IProjectCallback;
import com.android.layoutlib.api.IResourceValue;
import com.android.layoutlib.api.IStyleResourceValue;
import com.android.layoutlib.api.IXmlPullParser;
import com.android.layoutlib.bridge.BridgeAssetManager;
import com.android.layoutlib.bridge.BridgeCanvas;
import com.android.layoutlib.bridge.BridgeContext;
import com.android.layoutlib.bridge.BridgeResources;
import com.android.layoutlib.bridge.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.FontLoader;
import com.android.layoutlib.bridge.LayoutResult;
import com.android.layoutlib.bridge.ResourceHelper;
import com.android.ninepatch.NinePatch;
import com.android.tools.layoutlib.create.MethodAdapter;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Bridge
implements ILayoutBridge {
    private static final int DEFAULT_TITLE_BAR_HEIGHT = 25;
    private static final int DEFAULT_STATUS_BAR_HEIGHT = 25;
    private static final Map<Integer, String[]> sRMap = new HashMap<Integer, String[]>();
    private static final Map<int[], String> sRArrayMap = new HashMap<int[], String>();
    private static final Map<String, Map<String, Integer>> sRFullMap = new HashMap<String, Map<String, Integer>>();
    private static final Map<Object, Map<String, SoftReference<Bitmap>>> sProjectBitmapCache = new HashMap<Object, Map<String, SoftReference<Bitmap>>>();
    private static final Map<Object, Map<String, SoftReference<NinePatch>>> sProject9PatchCache = new HashMap<Object, Map<String, SoftReference<NinePatch>>>();
    private static final Map<String, SoftReference<Bitmap>> sFrameworkBitmapCache = new HashMap<String, SoftReference<Bitmap>>();
    private static final Map<String, SoftReference<NinePatch>> sFramework9PatchCache = new HashMap<String, SoftReference<NinePatch>>();
    private static Map<String, Map<String, Integer>> sEnumValueMap;
    private static final ILayoutLog sDefaultLogger;
    private static ILayoutLog sLogger;

    public int getApiLevel() {
        return 3;
    }

    public boolean init(String fontOsLocation, Map<String, Map<String, Integer>> enumValueMap) {
        return Bridge.sinit(fontOsLocation, enumValueMap);
    }

    private static synchronized boolean sinit(String fontOsLocation, Map<String, Map<String, Integer>> enumValueMap) {
        final String debug = System.getenv("DEBUG_LAYOUT");
        if (debug != null && !debug.equals("0") && !debug.equals("false")) {
            OverrideMethod.setDefaultListener(new MethodAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onInvokeV(String signature, boolean isNative, Object caller) {
                    if (sLogger != null) {
                        ILayoutLog iLayoutLog = sDefaultLogger;
                        synchronized (iLayoutLog) {
                            sLogger.error("Missing Stub: " + signature + (isNative ? " (native)" : ""));
                        }
                    }
                    if (debug.equalsIgnoreCase("throw")) {
                        throw new StaticMethodNotImplementedException(signature);
                    }
                }
            });
        }
        OverrideMethod.setMethodListener("android.view.View#isInEditMode()Z", new MethodAdapter(){

            public int onInvokeI(String signature, boolean isNative, Object caller) {
                return 1;
            }
        });
        FontLoader fontLoader = FontLoader.create(fontOsLocation);
        if (fontLoader == null) {
            return false;
        }
        Typeface.init(fontLoader);
        sEnumValueMap = enumValueMap;
        try {
            Class<R> r = R.class;
            for (Class<?> inner : r.getDeclaredClasses()) {
                String resType = inner.getSimpleName();
                HashMap<String, Integer> fullMap = new HashMap<String, Integer>();
                sRFullMap.put(resType, fullMap);
                for (Field f : inner.getDeclaredFields()) {
                    int modifiers = f.getModifiers();
                    if (!Modifier.isStatic(modifiers)) continue;
                    Class<?> type = f.getType();
                    if (type.isArray() && type.getComponentType() == Integer.TYPE) {
                        sRArrayMap.put((int[])f.get(null), f.getName());
                        continue;
                    }
                    if (type == Integer.TYPE) {
                        Integer value = (Integer)f.get(null);
                        sRMap.put(value, new String[]{f.getName(), resType});
                        fullMap.put(f.getName(), value);
                        continue;
                    }
                    assert (false);
                }
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return false;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Deprecated
    public ILayoutResult computeLayout(IXmlPullParser layoutDescription, Object projectKey, int screenWidth, int screenHeight, String themeName, Map<String, Map<String, IResourceValue>> projectResources, Map<String, Map<String, IResourceValue>> frameworkResources, IProjectCallback customViewLoader, ILayoutLog logger) {
        boolean isProjectTheme = false;
        if (themeName.charAt(0) == '*') {
            themeName = themeName.substring(1);
            isProjectTheme = true;
        }
        return this.computeLayout(layoutDescription, projectKey, screenWidth, screenHeight, 160, 160.0f, 160.0f, themeName, isProjectTheme, projectResources, frameworkResources, customViewLoader, logger);
    }

    public ILayoutResult computeLayout(IXmlPullParser layoutDescription, Object projectKey, int screenWidth, int screenHeight, String themeName, boolean isProjectTheme, Map<String, Map<String, IResourceValue>> projectResources, Map<String, Map<String, IResourceValue>> frameworkResources, IProjectCallback customViewLoader, ILayoutLog logger) {
        return this.computeLayout(layoutDescription, projectKey, screenWidth, screenHeight, 160, 160.0f, 160.0f, themeName, isProjectTheme, projectResources, frameworkResources, customViewLoader, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILayoutResult computeLayout(IXmlPullParser layoutDescription, Object projectKey, int screenWidth, int screenHeight, int density, float xdpi, float ydpi, String themeName, boolean isProjectTheme, Map<String, Map<String, IResourceValue>> projectResources, Map<String, Map<String, IResourceValue>> frameworkResources, IProjectCallback customViewLoader, ILayoutLog logger) {
        if (logger == null) {
            logger = sDefaultLogger;
        }
        ILayoutLog iLayoutLog = sDefaultLogger;
        synchronized (iLayoutLog) {
            sLogger = logger;
        }
        HashMap<IStyleResourceValue, IStyleResourceValue> styleParentMap = new HashMap<IStyleResourceValue, IStyleResourceValue>();
        IStyleResourceValue currentTheme = this.computeStyleMaps(themeName, isProjectTheme, projectResources.get("style"), frameworkResources.get("style"), styleParentMap);
        BridgeContext context = null;
        try {
            DisplayMetrics metrics = new DisplayMetrics();
            metrics.scaledDensity = metrics.density = (float)density / 160.0f;
            metrics.widthPixels = screenWidth;
            metrics.heightPixels = screenHeight;
            metrics.xdpi = xdpi;
            metrics.ydpi = ydpi;
            context = new BridgeContext(projectKey, metrics, currentTheme, projectResources, frameworkResources, styleParentMap, customViewLoader, logger);
            BridgeInflater inflater = new BridgeInflater(context, customViewLoader);
            context.setBridgeInflater(inflater);
            IResourceValue windowBackground = null;
            int screenOffset = 0;
            if (currentTheme != null) {
                windowBackground = context.findItemInStyle(currentTheme, "windowBackground");
                windowBackground = context.resolveResValue(windowBackground);
                screenOffset = this.getScreenOffset(currentTheme, context);
            }
            if (Looper.myLooper() == null) {
                Looper.prepare();
            }
            BridgeXmlBlockParser parser = new BridgeXmlBlockParser((XmlPullParser)layoutDescription, context, false);
            FrameLayout root = new FrameLayout(context);
            View view = inflater.inflate(parser, (ViewGroup)root);
            View.AttachInfo info = new View.AttachInfo(new WindowSession(), new Window(), new Handler(), null);
            info.mHasWindowFocus = true;
            info.mWindowVisibility = 0;
            info.mInTouchMode = false;
            root.dispatchAttachedToWindow(info, 0);
            if (windowBackground != null) {
                Drawable d = ResourceHelper.getDrawable(windowBackground.getValue(), context, true);
                root.setBackgroundDrawable(d);
            }
            int w_spec = View.MeasureSpec.makeMeasureSpec(screenWidth, 0x40000000);
            int h_spec = View.MeasureSpec.makeMeasureSpec(screenHeight - screenOffset, 0x40000000);
            view.measure(w_spec, h_spec);
            view.layout(0, screenOffset, screenWidth, screenHeight);
            BridgeCanvas canvas = new BridgeCanvas(screenWidth, screenHeight - screenOffset, logger);
            ((View)root).draw(canvas);
            canvas.dispose();
            LayoutResult layoutResult = new LayoutResult(this.visit(((ViewGroup)view).getChildAt(0), context), canvas.getImage());
            return layoutResult;
        }
        catch (Throwable e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            logger.error(t);
            LayoutResult layoutResult = new LayoutResult(1, t.getClass().getSimpleName() + ": " + t.getMessage());
            return layoutResult;
        }
        finally {
            BridgeResources.clearSystem();
            BridgeAssetManager.clearSystem();
            ILayoutLog iLayoutLog2 = sDefaultLogger;
            synchronized (iLayoutLog2) {
                sLogger = sDefaultLogger;
            }
        }
    }

    public void clearCaches(Object projectKey) {
        if (projectKey != null) {
            sProjectBitmapCache.remove(projectKey);
            sProject9PatchCache.remove(projectKey);
        }
    }

    public static String[] resolveResourceValue(int value) {
        return sRMap.get(value);
    }

    public static String resolveResourceValue(int[] array2) {
        return sRArrayMap.get(array2);
    }

    public static Integer getResourceValue(String type, String name) {
        Map<String, Integer> map = sRFullMap.get(type);
        if (map != null) {
            return map.get(name);
        }
        return null;
    }

    static Map<String, Integer> getEnumValues(String attributeName) {
        if (sEnumValueMap != null) {
            return sEnumValueMap.get(attributeName);
        }
        return null;
    }

    private ILayoutResult.ILayoutViewInfo visit(View view, BridgeContext context) {
        if (view == null) {
            return null;
        }
        LayoutResult.LayoutViewInfo result = new LayoutResult.LayoutViewInfo(view.getClass().getName(), context.getViewKey(view), view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            int n = group.getChildCount();
            ILayoutResult.ILayoutViewInfo[] children = new ILayoutResult.ILayoutViewInfo[n];
            for (int i = 0; i < group.getChildCount(); ++i) {
                children[i] = this.visit(group.getChildAt(i), context);
            }
            result.setChildren(children);
        }
        return result;
    }

    private IStyleResourceValue computeStyleMaps(String themeName, boolean isProjectTheme, Map<String, IResourceValue> inProjectStyleMap, Map<String, IResourceValue> inFrameworkStyleMap, Map<IStyleResourceValue, IStyleResourceValue> outInheritanceMap) {
        if (inProjectStyleMap != null && inFrameworkStyleMap != null) {
            IResourceValue theme = null;
            theme = isProjectTheme ? inProjectStyleMap.get(themeName) : inFrameworkStyleMap.get(themeName);
            if (theme instanceof IStyleResourceValue) {
                this.computeStyleInheritance(inProjectStyleMap.values(), inProjectStyleMap, inFrameworkStyleMap, outInheritanceMap);
                this.computeStyleInheritance(inFrameworkStyleMap.values(), null, inFrameworkStyleMap, outInheritanceMap);
                return (IStyleResourceValue)theme;
            }
        }
        return null;
    }

    private void computeStyleInheritance(Collection<IResourceValue> styles, Map<String, IResourceValue> inProjectStyleMap, Map<String, IResourceValue> inFrameworkStyleMap, Map<IStyleResourceValue, IStyleResourceValue> outInheritanceMap) {
        for (IResourceValue value : styles) {
            if (!(value instanceof IStyleResourceValue)) continue;
            IStyleResourceValue style2 = (IStyleResourceValue)value;
            IStyleResourceValue parentStyle = null;
            String parentName = style2.getParentStyle();
            if (parentName == null) {
                parentName = this.getParentName(value.getName());
            }
            if (parentName == null || (parentStyle = this.getStyle(parentName, inProjectStyleMap, inFrameworkStyleMap)) == null) continue;
            outInheritanceMap.put(style2, parentStyle);
        }
    }

    private IStyleResourceValue getStyle(String parentName, Map<String, IResourceValue> inProjectStyleMap, Map<String, IResourceValue> inFrameworkStyleMap) {
        boolean frameworkOnly = false;
        String name = parentName;
        if (name.startsWith("@")) {
            name = name.substring("@".length());
        }
        if (name.startsWith("android:")) {
            frameworkOnly = true;
            name = name.substring("android:".length());
        }
        if (name.startsWith("style/")) {
            name = name.substring("style/".length());
        }
        IResourceValue parent = null;
        if (!frameworkOnly && inProjectStyleMap != null) {
            parent = inProjectStyleMap.get(name);
        }
        if (parent == null) {
            parent = inFrameworkStyleMap.get(name);
        }
        if (parent instanceof IStyleResourceValue) {
            return (IStyleResourceValue)parent;
        }
        sLogger.error(String.format("Unable to resolve parent style name: ", parentName));
        return null;
    }

    private String getParentName(String styleName) {
        int index = styleName.lastIndexOf(46);
        if (index != -1) {
            return styleName.substring(0, index);
        }
        return null;
    }

    private int getScreenOffset(IStyleResourceValue currentTheme, BridgeContext context) {
        int offset = 0;
        IResourceValue value = context.findItemInStyle(currentTheme, "windowNoTitle");
        if ((value = context.resolveResValue(value)) == null || value.getValue() == null || !XmlUtils.convertValueToBoolean(value.getValue(), false)) {
            TypedValue typedValue;
            value = context.findItemInStyle(currentTheme, "windowTitleSize");
            value = context.resolveResValue(value);
            offset = 25;
            if (value != null && (typedValue = ResourceHelper.getValue(value.getValue())) != null) {
                offset = (int)typedValue.getDimension(context.getResources().mMetrics);
            }
        }
        value = context.findItemInStyle(currentTheme, "windowFullscreen");
        if ((value = context.resolveResValue(value)) == null || value.getValue() == null || !XmlUtils.convertValueToBoolean(value.getValue(), false)) {
            offset += 25;
        }
        return offset;
    }

    static Bitmap getCachedBitmap(String value, Object projectKey) {
        if (projectKey != null) {
            SoftReference<Bitmap> ref;
            Map<String, SoftReference<Bitmap>> map = sProjectBitmapCache.get(projectKey);
            if (map != null && (ref = map.get(value)) != null) {
                return ref.get();
            }
        } else {
            SoftReference<Bitmap> ref = sFrameworkBitmapCache.get(value);
            if (ref != null) {
                return ref.get();
            }
        }
        return null;
    }

    static void setCachedBitmap(String value, Bitmap bmp, Object projectKey) {
        if (projectKey != null) {
            Map<String, SoftReference<Bitmap>> map = sProjectBitmapCache.get(projectKey);
            if (map == null) {
                map = new HashMap<String, SoftReference<Bitmap>>();
                sProjectBitmapCache.put(projectKey, map);
            }
            map.put(value, new SoftReference<Bitmap>(bmp));
        } else {
            sFrameworkBitmapCache.put(value, new SoftReference<Bitmap>(bmp));
        }
    }

    static NinePatch getCached9Patch(String value, Object projectKey) {
        if (projectKey != null) {
            SoftReference<NinePatch> ref;
            Map<String, SoftReference<NinePatch>> map = sProject9PatchCache.get(projectKey);
            if (map != null && (ref = map.get(value)) != null) {
                return ref.get();
            }
        } else {
            SoftReference<NinePatch> ref = sFramework9PatchCache.get(value);
            if (ref != null) {
                return ref.get();
            }
        }
        return null;
    }

    static void setCached9Patch(String value, NinePatch ninePatch, Object projectKey) {
        if (projectKey != null) {
            Map<String, SoftReference<NinePatch>> map = sProject9PatchCache.get(projectKey);
            if (map == null) {
                map = new HashMap<String, SoftReference<NinePatch>>();
                sProject9PatchCache.put(projectKey, map);
            }
            map.put(value, new SoftReference<NinePatch>(ninePatch));
        } else {
            sFramework9PatchCache.put(value, new SoftReference<NinePatch>(ninePatch));
        }
    }

    static {
        sLogger = sDefaultLogger = new ILayoutLog(){

            public void error(String message) {
                System.err.println(message);
            }

            public void error(Throwable t) {
                String message = t.getMessage();
                if (message == null) {
                    message = t.getClass().getName();
                }
                System.err.println(message);
            }

            public void warning(String message) {
                System.out.println(message);
            }
        };
    }

    private static final class Window
    implements IWindow {
        private Window() {
        }

        public void dispatchAppVisibility(boolean arg0) throws RemoteException {
        }

        public void dispatchGetNewSurface() throws RemoteException {
        }

        public void dispatchKey(KeyEvent arg0) throws RemoteException {
        }

        public void dispatchPointer(MotionEvent arg0, long arg1) throws RemoteException {
        }

        public void dispatchTrackball(MotionEvent arg0, long arg1) throws RemoteException {
        }

        public void executeCommand(String arg0, String arg1, ParcelFileDescriptor arg2) throws RemoteException {
        }

        public void resized(int arg0, int arg1, Rect arg2, Rect arg3, boolean arg4) throws RemoteException {
        }

        public void windowFocusChanged(boolean arg0, boolean arg1) throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }

    private static final class WindowSession
    implements IWindowSession {
        private WindowSession() {
        }

        public int add(IWindow arg0, WindowManager.LayoutParams arg1, int arg2, Rect arg3) throws RemoteException {
            return 0;
        }

        public void finishDrawing(IWindow arg0) throws RemoteException {
        }

        public void finishKey(IWindow arg0) throws RemoteException {
        }

        public boolean getInTouchMode() throws RemoteException {
            return false;
        }

        public boolean performHapticFeedback(IWindow window, int effectId, boolean always) {
            return false;
        }

        public MotionEvent getPendingPointerMove(IWindow arg0) throws RemoteException {
            return null;
        }

        public MotionEvent getPendingTrackballMove(IWindow arg0) throws RemoteException {
            return null;
        }

        public int relayout(IWindow arg0, WindowManager.LayoutParams arg1, int arg2, int arg3, int arg4, boolean arg4_5, Rect arg5, Rect arg6, Rect arg7, Surface arg8) throws RemoteException {
            return 0;
        }

        public void getDisplayFrame(IWindow window, Rect outDisplayFrame) {
        }

        public void remove(IWindow arg0) throws RemoteException {
        }

        public void setInTouchMode(boolean arg0) throws RemoteException {
        }

        public void setTransparentRegion(IWindow arg0, Region arg1) throws RemoteException {
        }

        public void setInsets(IWindow window, int touchable, Rect contentInsets, Rect visibleInsets) {
        }

        public IBinder asBinder() {
            return null;
        }
    }

    public static class StaticMethodNotImplementedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public StaticMethodNotImplementedException(String msg) {
            super(msg);
        }
    }
}

