/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge;

import android.util.XmlPullAttributes;
import com.android.layoutlib.api.IResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.BridgeContext;
import org.xmlpull.v1.XmlPullParser;

public class BridgeXmlPullAttributes
extends XmlPullAttributes {
    private final BridgeContext mContext;
    private final boolean mPlatformFile;

    public BridgeXmlPullAttributes(XmlPullParser parser, BridgeContext context, boolean platformFile) {
        super(parser);
        this.mContext = context;
        this.mPlatformFile = platformFile;
    }

    public int getAttributeNameResource(int index) {
        Integer v;
        String name = this.getAttributeName(index);
        String ns = this.mParser.getAttributeNamespace(index);
        if ("http://schemas.android.com/apk/res/android".equals(ns)) {
            Integer v2 = Bridge.getResourceValue("attr", name);
            if (v2 != null) {
                return v2;
            }
            return 0;
        }
        if (this.mContext.getProjectCallback().getNamespace().equals(ns) && (v = this.mContext.getProjectCallback().getResourceValue("attr", name)) != null) {
            return v;
        }
        return 0;
    }

    public int getAttributeResourceValue(int index, int defaultValue) {
        String value = this.getAttributeValue(index);
        return this.resolveResourceValue(value, defaultValue);
    }

    public int getAttributeResourceValue(String namespace, String attribute, int defaultValue) {
        String value = this.getAttributeValue(namespace, attribute);
        return this.resolveResourceValue(value, defaultValue);
    }

    private int resolveResourceValue(String value, int defaultValue) {
        IResourceValue resource = this.mContext.resolveResValue(this.mContext.findResValue(value));
        if (resource != null) {
            Integer id2 = null;
            id2 = this.mPlatformFile || resource.isFramework() ? Bridge.getResourceValue(resource.getType(), resource.getName()) : this.mContext.getProjectCallback().getResourceValue(resource.getType(), resource.getName());
            if (id2 != null) {
                return id2;
            }
        }
        return defaultValue;
    }
}

