/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.utils;

import java.util.Arrays;
import org.apache.harmony.security.internal.nls.Messages;

public class ObjectIdentifier {
    public final int[] oid;
    public int hash = -1;
    public String soid;
    public String sOID;
    public String name;
    public Object group;

    public ObjectIdentifier(int[] oid) {
        ObjectIdentifier.validateOid(oid);
        this.oid = oid;
    }

    public ObjectIdentifier(int[] oid, String name, Object oidGroup) {
        this(oid);
        if (oidGroup == null) {
            throw new NullPointerException(Messages.getString("security.172"));
        }
        this.group = oidGroup;
        this.name = name;
        this.toOIDString();
    }

    public int[] getOid() {
        return this.oid;
    }

    public String getName() {
        return this.name;
    }

    public Object getGroup() {
        return this.group;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(this.oid, ((ObjectIdentifier)o).oid);
    }

    public String toOIDString() {
        if (this.sOID == null) {
            this.sOID = "OID." + this.toString();
        }
        return this.sOID;
    }

    public String toString() {
        if (this.soid == null) {
            StringBuffer sb = new StringBuffer(4 * this.oid.length);
            for (int i = 0; i < this.oid.length - 1; ++i) {
                sb.append(this.oid[i]);
                sb.append('.');
            }
            sb.append(this.oid[this.oid.length - 1]);
            this.soid = sb.toString();
        }
        return this.soid;
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = ObjectIdentifier.hashIntArray(this.oid);
        }
        return this.hash;
    }

    public static void validateOid(int[] oid) {
        if (oid == null) {
            throw new NullPointerException(Messages.getString("security.98"));
        }
        if (oid.length < 2) {
            throw new IllegalArgumentException(Messages.getString("security.99"));
        }
        if (oid[0] > 2) {
            throw new IllegalArgumentException(Messages.getString("security.9A"));
        }
        if (oid[0] != 2 && oid[1] > 39) {
            throw new IllegalArgumentException(Messages.getString("security.9B"));
        }
    }

    public static int hashIntArray(int[] array2) {
        int intHash = 0;
        for (int i = 0; i < array2.length && i < 4; ++i) {
            intHash += array2[i] << 8 * i;
        }
        return intHash & Integer.MAX_VALUE;
    }
}

