/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.net.ssl.SSLException;
import org.apache.harmony.xnet.provider.jsse.AlertException;
import org.apache.harmony.xnet.provider.jsse.CipherSuite;

public class DigitalSignature {
    public MessageDigest md5 = null;
    public MessageDigest sha = null;
    public Signature signature = null;
    public Cipher cipher = null;
    public byte[] md5_hash;
    public byte[] sha_hash;

    public DigitalSignature(int keyExchange) {
        try {
            if (keyExchange == CipherSuite.KeyExchange_RSA_EXPORT || keyExchange == CipherSuite.KeyExchange_RSA || keyExchange == CipherSuite.KeyExchange_DHE_RSA || keyExchange == CipherSuite.KeyExchange_DHE_RSA_EXPORT) {
                this.md5 = MessageDigest.getInstance("MD5");
                this.sha = MessageDigest.getInstance("SHA-1");
                this.cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            } else if (keyExchange == CipherSuite.KeyExchange_DHE_DSS || keyExchange == CipherSuite.KeyExchange_DHE_DSS_EXPORT) {
                this.sha = MessageDigest.getInstance("SHA-1");
                this.signature = Signature.getInstance("NONEwithDSA");
            }
        }
        catch (Exception e) {
            throw new AlertException(80, new SSLException("INTERNAL ERROR: Unexpected exception on digital signature", e));
        }
    }

    public void init(PrivateKey key) {
        try {
            if (this.signature != null) {
                this.signature.initSign(key);
            } else if (this.cipher != null) {
                this.cipher.init(1, key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init(Certificate cert) {
        try {
            if (this.signature != null) {
                this.signature.initVerify(cert);
            } else if (this.cipher != null) {
                this.cipher.init(2, cert);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update(byte[] data) {
        try {
            if (this.sha != null) {
                this.sha.update(data);
            }
            if (this.md5 != null) {
                this.md5.update(data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setMD5(byte[] data) {
        this.md5_hash = data;
    }

    public void setSHA(byte[] data) {
        this.sha_hash = data;
    }

    public byte[] sign() {
        try {
            if (this.md5 != null && this.md5_hash == null) {
                this.md5_hash = new byte[16];
                this.md5.digest(this.md5_hash, 0, this.md5_hash.length);
            }
            if (this.md5_hash != null) {
                if (this.signature != null) {
                    this.signature.update(this.md5_hash);
                } else if (this.cipher != null) {
                    this.cipher.update(this.md5_hash);
                }
            }
            if (this.sha != null && this.sha_hash == null) {
                this.sha_hash = new byte[20];
                this.sha.digest(this.sha_hash, 0, this.sha_hash.length);
            }
            if (this.sha_hash != null) {
                if (this.signature != null) {
                    this.signature.update(this.sha_hash);
                } else if (this.cipher != null) {
                    this.cipher.update(this.sha_hash);
                }
            }
            if (this.signature != null) {
                return this.signature.sign();
            }
            if (this.cipher != null) {
                return this.cipher.doFinal();
            }
            return new byte[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public boolean verifySignature(byte[] data) {
        try {
            if (this.signature != null) {
                return this.signature.verify(data);
            }
            if (this.cipher != null) {
                byte[] md5_sha;
                byte[] decrypt = this.cipher.doFinal(data);
                if (this.md5_hash != null && this.sha_hash != null) {
                    md5_sha = new byte[this.md5_hash.length + this.sha_hash.length];
                    System.arraycopy(this.md5_hash, 0, md5_sha, 0, this.md5_hash.length);
                    System.arraycopy(this.sha_hash, 0, md5_sha, this.md5_hash.length, this.sha_hash.length);
                } else {
                    md5_sha = this.md5_hash != null ? this.md5_hash : this.sha_hash;
                }
                return Arrays.equals(decrypt, md5_sha);
            }
            return data == null || data.length == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

