/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.DERObjectIdentifier;

public class X509NameElementList {
    public DERObjectIdentifier key0;
    public DERObjectIdentifier key1;
    public DERObjectIdentifier key2;
    public DERObjectIdentifier key3;
    public String value0;
    public String value1;
    public String value2;
    public String value3;
    public Object[] rest;
    public int added;
    public int size;

    public void add(DERObjectIdentifier key, String value) {
        this.add(key, value, false);
    }

    public void add(DERObjectIdentifier key, String value, boolean added) {
        if (this.size >= 32) {
            throw new UnsupportedOperationException("no more than 32 elements");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        int sz = this.size;
        switch (sz) {
            case 0: {
                this.key0 = key;
                this.value0 = value;
                break;
            }
            case 1: {
                this.key1 = key;
                this.value1 = value;
                break;
            }
            case 2: {
                this.key2 = key;
                this.value2 = value;
                break;
            }
            case 3: {
                this.key3 = key;
                this.value3 = value;
                break;
            }
            case 4: {
                this.rest = new Object[10];
                this.rest[0] = key;
                this.rest[1] = value;
                break;
            }
            case 9: {
                Object[] newRest = new Object[56];
                System.arraycopy(this.rest, 0, newRest, 0, 10);
                this.rest = newRest;
            }
            default: {
                int index = (sz - 4) * 2;
                this.rest[index] = key;
                this.rest[index + 1] = value;
                break;
            }
        }
        if (added) {
            this.added |= 1 << sz;
        }
        this.size = sz + 1;
    }

    public void setLastAddedFlag() {
        this.added |= 1 << this.size - 1;
    }

    public int size() {
        return this.size;
    }

    public DERObjectIdentifier getKey(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        switch (n) {
            case 0: {
                return this.key0;
            }
            case 1: {
                return this.key1;
            }
            case 2: {
                return this.key2;
            }
            case 3: {
                return this.key3;
            }
        }
        return (DERObjectIdentifier)this.rest[(n - 4) * 2];
    }

    public String getValue(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        switch (n) {
            case 0: {
                return this.value0;
            }
            case 1: {
                return this.value1;
            }
            case 2: {
                return this.value2;
            }
            case 3: {
                return this.value3;
            }
        }
        return (String)this.rest[(n - 4) * 2 + 1];
    }

    public boolean getAdded(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        return (this.added & 1 << n) != 0;
    }

    public X509NameElementList reverse() {
        X509NameElementList result = new X509NameElementList();
        for (int i = this.size - 1; i >= 0; --i) {
            result.add(this.getKey(i), this.getValue(i), this.getAdded(i));
        }
        return result;
    }
}

