/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.SearchDialog;
import android.app.SearchManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.server.search.SearchableInfo;
import android.text.Html;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.ImageView;
import android.widget.ResourceCursorAdapter;
import android.widget.TextView;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestionsAdapter
extends ResourceCursorAdapter {
    public static final boolean DBG = false;
    public static final String LOG_TAG = "SuggestionsAdapter";
    public SearchManager mSearchManager = (SearchManager)this.mContext.getSystemService("search");
    public SearchDialog mSearchDialog;
    public SearchableInfo mSearchable;
    public Context mProviderContext;
    public WeakHashMap<String, Drawable.ConstantState> mOutsideDrawablesCache;
    public SparseArray<Drawable.ConstantState> mBackgroundsCache;
    public boolean mGlobalSearchMode;
    public boolean mClosed = false;
    public int mFormatCol;
    public int mText1Col;
    public int mText2Col;
    public int mIconName1Col;
    public int mIconName2Col;
    public int mBackgroundColorCol;
    public static final String EXTRA_CURSOR_RESPOND_CLOSE_CURSOR = "cursor_respond_close_cursor";
    public final Bundle mCursorRespondCloseCursorBundle;
    public int mListItemToSelect = -1;
    public static final int NONE = -1;
    public int mMaxDisplayed = -1;
    public int mDisplayNotifyPos = -1;
    public final Runnable mStartSpinnerRunnable;
    public final Runnable mStopSpinnerRunnable;
    public static final long DELETE_KEY_POST_DELAY = 500L;

    public SuggestionsAdapter(Context context, SearchDialog searchDialog, SearchableInfo searchable, WeakHashMap<String, Drawable.ConstantState> outsideDrawablesCache, boolean globalSearchMode) {
        super(context, 17367124, null, true);
        this.mSearchDialog = searchDialog;
        this.mSearchable = searchable;
        Context activityContext = this.mSearchable.getActivityContext(this.mContext);
        this.mProviderContext = this.mSearchable.getProviderContext(this.mContext, activityContext);
        this.mOutsideDrawablesCache = outsideDrawablesCache;
        this.mBackgroundsCache = new SparseArray();
        this.mGlobalSearchMode = globalSearchMode;
        this.mStartSpinnerRunnable = new Runnable(){

            public void run() {
                SuggestionsAdapter.this.mSearchDialog.setWorking(true);
            }
        };
        this.mStopSpinnerRunnable = new Runnable(){

            public void run() {
                SuggestionsAdapter.this.mSearchDialog.setWorking(false);
            }
        };
        this.mCursorRespondCloseCursorBundle = new Bundle();
        this.mCursorRespondCloseCursorBundle.putBoolean(EXTRA_CURSOR_RESPOND_CLOSE_CURSOR, true);
        this.getFilter().setDelayer(new Filter.Delayer(){
            public int mPreviousLength = 0;

            public long getPostingDelay(CharSequence constraint) {
                if (constraint == null) {
                    return 0L;
                }
                long delay = constraint.length() < this.mPreviousLength ? 500L : 0L;
                this.mPreviousLength = constraint.length();
                return delay;
            }
        });
    }

    @Override
    public boolean hasStableIds() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cursor runQueryOnBackgroundThread(CharSequence constraint) {
        String query;
        String string2 = query = constraint == null ? "" : ((Object)constraint).toString();
        if (!this.mGlobalSearchMode) {
            this.mSearchDialog.getWindow().getDecorView().post(this.mStartSpinnerRunnable);
        }
        try {
            Cursor cursor = this.mSearchManager.getSuggestions(this.mSearchable, query);
            if (!this.mGlobalSearchMode && cursor != null) {
                cursor.getCount();
            }
            Cursor cursor2 = cursor;
            return cursor2;
        }
        catch (RuntimeException e) {
            Log.w(LOG_TAG, "Search suggestions query threw an exception.", e);
            Cursor cursor = null;
            return cursor;
        }
        finally {
            if (!this.mGlobalSearchMode) {
                this.mSearchDialog.getWindow().getDecorView().post(this.mStopSpinnerRunnable);
            }
        }
    }

    public void close() {
        this.changeCursor(null);
        this.mClosed = true;
    }

    @Override
    public void changeCursor(Cursor c) {
        if (this.mClosed) {
            Log.w(LOG_TAG, "Tried to change cursor after adapter was closed.");
            if (c != null) {
                c.close();
            }
            return;
        }
        try {
            Cursor oldCursor = this.getCursor();
            super.changeCursor(c);
            if (oldCursor != null && oldCursor != c) {
                oldCursor.respond(this.mCursorRespondCloseCursorBundle);
            }
            if (c != null) {
                this.mFormatCol = c.getColumnIndex("suggest_format");
                this.mText1Col = c.getColumnIndex("suggest_text_1");
                this.mText2Col = c.getColumnIndex("suggest_text_2");
                this.mIconName1Col = c.getColumnIndex("suggest_icon_1");
                this.mIconName2Col = c.getColumnIndex("suggest_icon_2");
                this.mBackgroundColorCol = c.getColumnIndex("suggest_background_color");
            }
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "error changing cursor and caching columns", e);
        }
    }

    @Override
    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.callCursorPostRefresh(this.mCursor);
        if (this.mListItemToSelect != -1) {
            this.mSearchDialog.setListSelection(this.mListItemToSelect);
            this.mListItemToSelect = -1;
        }
    }

    public void callCursorPostRefresh(Cursor cursor) {
        if (!this.mGlobalSearchMode) {
            return;
        }
        Bundle request = new Bundle();
        request.putInt("DialogCursorProtocol.method", 0);
        Bundle response = cursor.respond(request);
        this.mSearchDialog.setWorking(response.getBoolean("DialogCursorProtocol.POST_REFRESH.isPending", false));
        this.mDisplayNotifyPos = response.getInt("DialogCursorProtocol.POST_REFRESH.displayNotify", -1);
    }

    public void callCursorOnClick(Cursor cursor, int position) {
        if (!this.mGlobalSearchMode) {
            return;
        }
        Bundle request = new Bundle(1);
        request.putInt("DialogCursorProtocol.method", 2);
        request.putInt("DialogCursorProtocol.CLICK.sendPosition", position);
        request.putInt("DialogCursorProtocol.CLICK.sendDisplayPosition", this.mMaxDisplayed);
        Bundle response = cursor.respond(request);
        this.mMaxDisplayed = -1;
        this.mListItemToSelect = response.getInt("DialogCursorProtocol.CLICK.receiveSelectedPosition", -1);
    }

    @Override
    public View newView(Context context, Cursor cursor, ViewGroup parent) {
        View v = super.newView(context, cursor, parent);
        v.setTag(new ChildViewCache(v));
        return v;
    }

    @Override
    public void bindView(View view, Context context, Cursor cursor) {
        ChildViewCache views = (ChildViewCache)view.getTag();
        int pos = cursor.getPosition();
        if (pos > this.mMaxDisplayed) {
            this.mMaxDisplayed = pos;
        }
        if (this.mGlobalSearchMode && this.mDisplayNotifyPos != -1 && pos == this.mDisplayNotifyPos) {
            Bundle request = new Bundle();
            request.putInt("DialogCursorProtocol.method", 3);
            this.mCursor.respond(request);
            this.mDisplayNotifyPos = -1;
        }
        int backgroundColor = 0;
        if (this.mBackgroundColorCol != -1) {
            backgroundColor = cursor.getInt(this.mBackgroundColorCol);
        }
        Drawable background = this.getItemBackground(backgroundColor);
        view.setBackgroundDrawable(background);
        boolean isHtml = this.mFormatCol > 0 && "html".equals(cursor.getString(this.mFormatCol));
        this.setViewText(cursor, views.mText1, this.mText1Col, isHtml);
        this.setViewText(cursor, views.mText2, this.mText2Col, isHtml);
        if (views.mIcon1 != null) {
            this.setViewDrawable(views.mIcon1, this.getIcon1(cursor));
        }
        if (views.mIcon2 != null) {
            this.setViewDrawable(views.mIcon2, this.getIcon2(cursor));
        }
    }

    public Drawable getItemBackground(int backgroundColor) {
        if (backgroundColor == 0) {
            return null;
        }
        Drawable.ConstantState cachedBg = this.mBackgroundsCache.get(backgroundColor);
        if (cachedBg != null) {
            return cachedBg.newDrawable();
        }
        ColorDrawable transparent = new ColorDrawable(0);
        ColorDrawable background = new ColorDrawable(backgroundColor);
        StateListDrawable newBg = new StateListDrawable();
        newBg.addState(new int[]{0x10100A1}, transparent);
        newBg.addState(new int[]{16842919}, transparent);
        newBg.addState(new int[0], background);
        this.mBackgroundsCache.put(backgroundColor, newBg.getConstantState());
        return newBg;
    }

    public void setViewText(Cursor cursor, TextView v, int textCol, boolean isHtml) {
        if (v == null) {
            return;
        }
        CharSequence text = null;
        if (textCol >= 0) {
            String str = cursor.getString(textCol);
            text = isHtml && SuggestionsAdapter.looksLikeHtml(str) ? Html.fromHtml(str) : str;
        }
        v.setText(text);
        if (TextUtils.isEmpty(text)) {
            v.setVisibility(8);
        } else {
            v.setVisibility(0);
        }
    }

    public static boolean looksLikeHtml(String str) {
        if (TextUtils.isEmpty(str)) {
            return false;
        }
        for (int i = str.length() - 1; i >= 0; --i) {
            char c = str.charAt(i);
            if (c != '<' && c != '&') continue;
            return true;
        }
        return false;
    }

    public Drawable getIcon1(Cursor cursor) {
        if (this.mIconName1Col < 0) {
            return null;
        }
        String value = cursor.getString(this.mIconName1Col);
        Drawable drawable2 = this.getDrawableFromResourceValue(value);
        if (drawable2 != null) {
            return drawable2;
        }
        return this.getDefaultIcon1(cursor);
    }

    public Drawable getIcon2(Cursor cursor) {
        if (this.mIconName2Col < 0) {
            return null;
        }
        String value = cursor.getString(this.mIconName2Col);
        return this.getDrawableFromResourceValue(value);
    }

    public void setViewDrawable(ImageView v, Drawable drawable2) {
        v.setImageDrawable(drawable2);
        if (drawable2 == null) {
            v.setVisibility(8);
        } else {
            v.setVisibility(0);
            drawable2.setVisible(false, false);
            drawable2.setVisible(true, false);
        }
    }

    @Override
    public CharSequence convertToString(Cursor cursor) {
        String text1;
        String data;
        if (cursor == null) {
            return null;
        }
        String query = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_query");
        if (query != null) {
            return query;
        }
        if (this.mSearchable.shouldRewriteQueryFromData() && (data = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_data")) != null) {
            return data;
        }
        if (this.mSearchable.shouldRewriteQueryFromText() && (text1 = SuggestionsAdapter.getColumnString(cursor, "suggest_text_1")) != null) {
            return text1;
        }
        return null;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        try {
            return super.getView(position, convertView, parent);
        }
        catch (RuntimeException e) {
            Log.w(LOG_TAG, "Search suggestions cursor threw exception.", e);
            View v = this.newView(this.mContext, this.mCursor, parent);
            if (v != null) {
                ChildViewCache views = (ChildViewCache)v.getTag();
                TextView tv = views.mText1;
                tv.setText(e.toString());
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Drawable getDrawableFromResourceValue(String drawableId) {
        if (drawableId == null || drawableId.length() == 0 || "0".equals(drawableId)) {
            return null;
        }
        Drawable.ConstantState cached = this.mOutsideDrawablesCache.get(drawableId);
        if (cached != null) {
            return cached.newDrawable();
        }
        Drawable drawable2 = null;
        try {
            int resourceId = Integer.parseInt(drawableId);
            drawable2 = this.mProviderContext.getResources().getDrawable(resourceId);
        }
        catch (NumberFormatException nfe) {
            block15: {
                try {
                    Uri uri = Uri.parse(drawableId);
                    InputStream stream = this.mProviderContext.getContentResolver().openInputStream(uri);
                    if (stream == null) break block15;
                    try {
                        drawable2 = Drawable.createFromStream(stream, null);
                    }
                    finally {
                        try {
                            stream.close();
                        }
                        catch (IOException ex) {
                            Log.e(LOG_TAG, "Error closing icon stream for " + uri, ex);
                        }
                    }
                }
                catch (FileNotFoundException fnfe) {
                    // empty catch block
                }
            }
            if (drawable2 != null) {
                this.mOutsideDrawablesCache.put(drawableId, drawable2.getConstantState());
            }
        }
        catch (Resources.NotFoundException nfe) {
            // empty catch block
        }
        return drawable2;
    }

    public Drawable getDefaultIcon1(Cursor cursor) {
        Drawable drawable2;
        String c = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_component");
        if (c != null) {
            ComponentName component = ComponentName.unflattenFromString(c);
            if (component != null) {
                Drawable drawable3 = this.getActivityIconWithCache(component);
                if (drawable3 != null) {
                    return drawable3;
                }
            } else {
                Log.w(LOG_TAG, "Bad component name: " + c);
            }
        }
        if ((drawable2 = this.getActivityIconWithCache(this.mSearchable.getSearchActivity())) != null) {
            return drawable2;
        }
        return this.mContext.getPackageManager().getDefaultActivityIcon();
    }

    public Drawable getActivityIconWithCache(ComponentName component) {
        String componentIconKey = component.flattenToShortString();
        if (this.mOutsideDrawablesCache.containsKey(componentIconKey)) {
            Drawable.ConstantState cached = this.mOutsideDrawablesCache.get(componentIconKey);
            return cached == null ? null : cached.newDrawable();
        }
        Drawable drawable2 = this.getActivityIcon(component);
        Drawable.ConstantState toCache = drawable2 == null ? null : drawable2.getConstantState();
        this.mOutsideDrawablesCache.put(componentIconKey, toCache);
        return drawable2;
    }

    public Drawable getActivityIcon(ComponentName component) {
        ActivityInfo activityInfo;
        PackageManager pm = this.mContext.getPackageManager();
        try {
            activityInfo = pm.getActivityInfo(component, 128);
        }
        catch (PackageManager.NameNotFoundException ex) {
            Log.w(LOG_TAG, ex.toString());
            return null;
        }
        int iconId = activityInfo.getIconResource();
        if (iconId == 0) {
            return null;
        }
        String pkg = component.getPackageName();
        Drawable drawable2 = pm.getDrawable(pkg, iconId, activityInfo.applicationInfo);
        if (drawable2 == null) {
            Log.w(LOG_TAG, "Invalid icon resource " + iconId + " for " + component.flattenToShortString());
            return null;
        }
        return drawable2;
    }

    public static String getColumnString(Cursor cursor, String columnName) {
        int col = cursor.getColumnIndex(columnName);
        if (col == -1) {
            return null;
        }
        try {
            return cursor.getString(col);
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "unexpected error retrieving valid column from cursor, did the remote process die?", e);
            return null;
        }
    }

    public static class ChildViewCache {
        public final TextView mText1;
        public final TextView mText2;
        public final ImageView mIcon1;
        public final ImageView mIcon2;

        public ChildViewCache(View v) {
            this.mText1 = (TextView)v.findViewById(16908308);
            this.mText2 = (TextView)v.findViewById(16908309);
            this.mIcon1 = (ImageView)v.findViewById(16908295);
            this.mIcon2 = (ImageView)v.findViewById(16908296);
        }
    }
}

