/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Annotation;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.BulletSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.LineHeightSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import android.util.SparseArray;
import com.android.internal.util.XmlUtils;
import com.android.tools.layoutlib.create.OverrideMethod;

public class StringBlock {
    public static final String TAG = "AssetManager";
    public static final boolean localLOGV = false;
    public final int mNative;
    public final boolean mUseSparse;
    public final boolean mOwnsNative;
    public CharSequence[] mStrings;
    public SparseArray<CharSequence> mSparseStrings;
    public StyleIDs mStyleIDs = null;

    public StringBlock(byte[] data, boolean useSparse) {
        this.mNative = StringBlock.nativeCreate(data, 0, data.length);
        this.mUseSparse = useSparse;
        this.mOwnsNative = true;
    }

    public StringBlock(byte[] data, int offset, int size, boolean useSparse) {
        this.mNative = StringBlock.nativeCreate(data, offset, size);
        this.mUseSparse = useSparse;
        this.mOwnsNative = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharSequence get(int idx) {
        StringBlock stringBlock = this;
        synchronized (stringBlock) {
            String str;
            if (this.mStrings != null) {
                CharSequence res = this.mStrings[idx];
                if (res != null) {
                    return res;
                }
            } else if (this.mSparseStrings != null) {
                CharSequence res = this.mSparseStrings.get(idx);
                if (res != null) {
                    return res;
                }
            } else {
                int num = StringBlock.nativeGetSize(this.mNative);
                if (this.mUseSparse && num > 250) {
                    this.mSparseStrings = new SparseArray();
                } else {
                    this.mStrings = new CharSequence[num];
                }
            }
            CharSequence res = str = StringBlock.nativeGetString(this.mNative, idx);
            int[] style2 = StringBlock.nativeGetStyle(this.mNative, idx);
            if (style2 != null) {
                if (this.mStyleIDs == null) {
                    this.mStyleIDs = new StyleIDs();
                    this.mStyleIDs.boldId = StringBlock.nativeIndexOfString(this.mNative, "b");
                    this.mStyleIDs.italicId = StringBlock.nativeIndexOfString(this.mNative, "i");
                    this.mStyleIDs.underlineId = StringBlock.nativeIndexOfString(this.mNative, "u");
                    this.mStyleIDs.ttId = StringBlock.nativeIndexOfString(this.mNative, "tt");
                    this.mStyleIDs.bigId = StringBlock.nativeIndexOfString(this.mNative, "big");
                    this.mStyleIDs.smallId = StringBlock.nativeIndexOfString(this.mNative, "small");
                    this.mStyleIDs.supId = StringBlock.nativeIndexOfString(this.mNative, "sup");
                    this.mStyleIDs.subId = StringBlock.nativeIndexOfString(this.mNative, "sub");
                    this.mStyleIDs.strikeId = StringBlock.nativeIndexOfString(this.mNative, "strike");
                    this.mStyleIDs.listItemId = StringBlock.nativeIndexOfString(this.mNative, "li");
                    this.mStyleIDs.marqueeId = StringBlock.nativeIndexOfString(this.mNative, "marquee");
                }
                res = this.applyStyles(str, style2, this.mStyleIDs);
            }
            if (this.mStrings != null) {
                this.mStrings[idx] = res;
            } else {
                this.mSparseStrings.put(idx, res);
            }
            return res;
        }
    }

    public void finalize() throws Throwable {
        if (this.mOwnsNative) {
            StringBlock.nativeDestroy(this.mNative);
        }
    }

    public CharSequence applyStyles(String str, int[] style2, StyleIDs ids) {
        if (style2.length == 0) {
            return str;
        }
        SpannableString buffer = new SpannableString(str);
        for (int i = 0; i < style2.length; i += 3) {
            int eq;
            int type = style2[i];
            if (type == ids.boldId) {
                buffer.setSpan(new StyleSpan(1), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.italicId) {
                buffer.setSpan(new StyleSpan(2), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.underlineId) {
                buffer.setSpan(new UnderlineSpan(), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.ttId) {
                buffer.setSpan(new TypefaceSpan("monospace"), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.bigId) {
                buffer.setSpan(new RelativeSizeSpan(1.25f), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.smallId) {
                buffer.setSpan(new RelativeSizeSpan(0.8f), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.subId) {
                buffer.setSpan(new SubscriptSpan(), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.supId) {
                buffer.setSpan(new SuperscriptSpan(), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.strikeId) {
                buffer.setSpan(new StrikethroughSpan(), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (type == ids.listItemId) {
                StringBlock.addParagraphSpan(buffer, new BulletSpan(10), style2[i + 1], style2[i + 2] + 1);
                continue;
            }
            if (type == ids.marqueeId) {
                buffer.setSpan((Object)TextUtils.TruncateAt.MARQUEE, style2[i + 1], style2[i + 2] + 1, 18);
                continue;
            }
            String tag = StringBlock.nativeGetString(this.mNative, type);
            if (tag.startsWith("font;")) {
                int color2;
                int size;
                String sub = StringBlock.subtag(tag, ";height=");
                if (sub != null) {
                    size = Integer.parseInt(sub);
                    StringBlock.addParagraphSpan(buffer, new Height(size), style2[i + 1], style2[i + 2] + 1);
                }
                if ((sub = StringBlock.subtag(tag, ";size=")) != null) {
                    size = Integer.parseInt(sub);
                    buffer.setSpan(new AbsoluteSizeSpan(size, true), style2[i + 1], style2[i + 2] + 1, 33);
                }
                if ((sub = StringBlock.subtag(tag, ";fgcolor=")) != null) {
                    color2 = XmlUtils.convertValueToUnsignedInt(sub, -1);
                    buffer.setSpan(new ForegroundColorSpan(color2), style2[i + 1], style2[i + 2] + 1, 33);
                }
                if ((sub = StringBlock.subtag(tag, ";bgcolor=")) == null) continue;
                color2 = XmlUtils.convertValueToUnsignedInt(sub, -1);
                buffer.setSpan(new BackgroundColorSpan(color2), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (tag.startsWith("a;")) {
                String sub = StringBlock.subtag(tag, ";href=");
                if (sub == null) continue;
                buffer.setSpan(new URLSpan(sub), style2[i + 1], style2[i + 2] + 1, 33);
                continue;
            }
            if (!tag.startsWith("annotation;")) continue;
            int len = tag.length();
            int t = tag.indexOf(59);
            while (t < len && (eq = tag.indexOf(61, t)) >= 0) {
                int next = tag.indexOf(59, eq);
                if (next < 0) {
                    next = len;
                }
                String key = tag.substring(t + 1, eq);
                String value = tag.substring(eq + 1, next);
                buffer.setSpan(new Annotation(key, value), style2[i + 1], style2[i + 2] + 1, 33);
                t = next;
            }
        }
        return new SpannedString(buffer);
    }

    public static void addParagraphSpan(Spannable buffer, Object what, int start, int end) {
        int len = buffer.length();
        if (start != 0 && start != len && buffer.charAt(start - 1) != '\n') {
            --start;
            while (start > 0 && buffer.charAt(start - 1) != '\n') {
                --start;
            }
        }
        if (end != 0 && end != len && buffer.charAt(end - 1) != '\n') {
            ++end;
            while (end < len && buffer.charAt(end - 1) != '\n') {
                ++end;
            }
        }
        buffer.setSpan(what, start, end, 51);
    }

    public static String subtag(String full, String attribute) {
        int start = full.indexOf(attribute);
        if (start < 0) {
            return null;
        }
        int end = full.indexOf(59, start += attribute.length());
        if (end < 0) {
            return full.substring(start);
        }
        return full.substring(start, end);
    }

    public StringBlock(int obj, boolean useSparse) {
        this.mNative = obj;
        this.mUseSparse = useSparse;
        this.mOwnsNative = false;
    }

    public static int nativeCreate(byte[] byArray, int n, int n2) {
        return OverrideMethod.invokeI("android.content.res.StringBlock#nativeCreate([BII)I", true, null);
    }

    public static int nativeGetSize(int n) {
        return OverrideMethod.invokeI("android.content.res.StringBlock#nativeGetSize(I)I", true, null);
    }

    public static String nativeGetString(int n, int n2) {
        return (String)OverrideMethod.invokeA("android.content.res.StringBlock#nativeGetString(II)Ljava/lang/String;", true, null);
    }

    public static int[] nativeGetStyle(int n, int n2) {
        return (int[])OverrideMethod.invokeA("android.content.res.StringBlock#nativeGetStyle(II)[I", true, null);
    }

    public static int nativeIndexOfString(int n, String string2) {
        return OverrideMethod.invokeI("android.content.res.StringBlock#nativeIndexOfString(ILjava/lang/String;)I", true, null);
    }

    public static void nativeDestroy(int n) {
        OverrideMethod.invokeV("android.content.res.StringBlock#nativeDestroy(I)V", true, null);
    }

    public static class Height
    implements LineHeightSpan.WithDensity {
        public int mSize;
        public static float sProportion = 0.0f;

        public Height(int size) {
            this.mSize = size;
        }

        public void chooseHeight(CharSequence text, int start, int end, int spanstartv, int v, Paint.FontMetricsInt fm) {
            this.chooseHeight(text, start, end, spanstartv, v, fm, null);
        }

        public void chooseHeight(CharSequence text, int start, int end, int spanstartv, int v, Paint.FontMetricsInt fm, TextPaint paint) {
            int size = this.mSize;
            if (paint != null) {
                size = (int)((float)size * paint.density);
            }
            if (fm.bottom - fm.top < size) {
                fm.top = fm.bottom - size;
                fm.ascent -= size;
            } else {
                int need;
                if (sProportion == 0.0f) {
                    Paint p = new Paint();
                    p.setTextSize(100.0f);
                    Rect r = new Rect();
                    p.getTextBounds("ABCDEFG", 0, 7, r);
                    sProportion = (float)r.top / p.ascent();
                }
                if (size - fm.descent >= (need = (int)Math.ceil((float)(-fm.top) * sProportion))) {
                    fm.top = fm.bottom - size;
                    fm.ascent = fm.descent - size;
                } else if (size >= need) {
                    fm.top = fm.ascent = -need;
                    fm.bottom = fm.descent = fm.top + size;
                } else {
                    fm.top = fm.ascent = -size;
                    fm.descent = 0;
                    fm.bottom = 0;
                }
            }
        }
    }

    public static class StyleIDs {
        public int boldId;
        public int italicId;
        public int underlineId;
        public int ttId;
        public int bigId;
        public int smallId;
        public int subId;
        public int supId;
        public int strikeId;
        public int listItemId;
        public int marqueeId;
    }
}

