/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

public abstract class SQLiteClosable {
    public int mReferenceCount = 1;
    public Object mLock = new Object();

    public abstract void onAllReferencesReleased();

    public void onAllReferencesReleasedFromContainer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireReference() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mReferenceCount <= 0) {
                throw new IllegalStateException("attempt to acquire a reference on a close SQLiteClosable");
            }
            ++this.mReferenceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseReference() {
        Object object = this.mLock;
        synchronized (object) {
            --this.mReferenceCount;
            if (this.mReferenceCount == 0) {
                this.onAllReferencesReleased();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseReferenceFromContainer() {
        Object object = this.mLock;
        synchronized (object) {
            --this.mReferenceCount;
            if (this.mReferenceCount == 0) {
                this.onAllReferencesReleasedFromContainer();
            }
        }
    }
}

