/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteProgram;
import android.os.SystemClock;
import com.android.tools.layoutlib.create.OverrideMethod;

public class SQLiteStatement
extends SQLiteProgram {
    public static final String TAG = "SQLiteStatement";
    public final String mSql;

    public SQLiteStatement(SQLiteDatabase db, String sql) {
        super(db, sql);
        this.mSql = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        this.mDatabase.lock();
        boolean logStats = this.mDatabase.mLogStats;
        long startTime = logStats ? SystemClock.elapsedRealtime() : 0L;
        this.acquireReference();
        try {
            this.native_execute();
            if (logStats) {
                this.mDatabase.logTimeStat(false, startTime, SystemClock.elapsedRealtime());
            }
        }
        finally {
            this.releaseReference();
            this.mDatabase.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeInsert() {
        this.mDatabase.lock();
        boolean logStats = this.mDatabase.mLogStats;
        long startTime = logStats ? SystemClock.elapsedRealtime() : 0L;
        this.acquireReference();
        try {
            this.native_execute();
            if (logStats) {
                this.mDatabase.logTimeStat(false, startTime, SystemClock.elapsedRealtime());
            }
            long l = this.mDatabase.lastInsertRow();
            return l;
        }
        finally {
            this.releaseReference();
            this.mDatabase.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long simpleQueryForLong() {
        this.mDatabase.lock();
        boolean logStats = this.mDatabase.mLogStats;
        long startTime = logStats ? SystemClock.elapsedRealtime() : 0L;
        this.acquireReference();
        try {
            long retValue = this.native_1x1_long();
            if (logStats) {
                this.mDatabase.logTimeStat(false, startTime, SystemClock.elapsedRealtime());
            }
            long l = retValue;
            return l;
        }
        finally {
            this.releaseReference();
            this.mDatabase.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String simpleQueryForString() {
        this.mDatabase.lock();
        boolean logStats = this.mDatabase.mLogStats;
        long startTime = logStats ? SystemClock.elapsedRealtime() : 0L;
        this.acquireReference();
        try {
            String retValue = this.native_1x1_string();
            if (logStats) {
                this.mDatabase.logTimeStat(false, startTime, SystemClock.elapsedRealtime());
            }
            String string2 = retValue;
            return string2;
        }
        finally {
            this.releaseReference();
            this.mDatabase.unlock();
        }
    }

    public void native_execute() {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteStatement#native_execute()V", true, this);
    }

    public long native_1x1_long() {
        return OverrideMethod.invokeL("android.database.sqlite.SQLiteStatement#native_1x1_long()J", true, this);
    }

    public String native_1x1_string() {
        return (String)OverrideMethod.invokeA("android.database.sqlite.SQLiteStatement#native_1x1_string()Ljava/lang/String;", true, this);
    }
}

