/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import com.android.tools.layoutlib.create.OverrideMethod;

public class NinePatch {
    public final Bitmap mBitmap;
    public final byte[] mChunk;
    public Paint mPaint;
    public String mSrcName;

    public NinePatch(Bitmap bitmap, byte[] chunk, String srcName) {
        this.mBitmap = bitmap;
        this.mChunk = chunk;
        this.mSrcName = srcName;
        NinePatch.validateNinePatchChunk(this.mBitmap.ni(), chunk);
    }

    public NinePatch(NinePatch patch) {
        this.mBitmap = patch.mBitmap;
        this.mChunk = patch.mChunk;
        this.mSrcName = patch.mSrcName;
        if (patch.mPaint != null) {
            this.mPaint = new Paint(patch.mPaint);
        }
        NinePatch.validateNinePatchChunk(this.mBitmap.ni(), this.mChunk);
    }

    public void setPaint(Paint p) {
        this.mPaint = p;
    }

    public void draw(Canvas canvas, RectF location) {
        NinePatch.nativeDraw(canvas.mNativeCanvas, location, this.mBitmap.ni(), this.mChunk, this.mPaint != null ? this.mPaint.mNativePaint : 0, canvas.mDensity, this.mBitmap.mDensity);
    }

    public void draw(Canvas canvas, Rect location) {
        NinePatch.nativeDraw(canvas.mNativeCanvas, location, this.mBitmap.ni(), this.mChunk, this.mPaint != null ? this.mPaint.mNativePaint : 0, canvas.mDensity, this.mBitmap.mDensity);
    }

    public void draw(Canvas canvas, Rect location, Paint paint) {
        NinePatch.nativeDraw(canvas.mNativeCanvas, location, this.mBitmap.ni(), this.mChunk, paint != null ? paint.mNativePaint : 0, canvas.mDensity, this.mBitmap.mDensity);
    }

    public int getDensity() {
        return this.mBitmap.mDensity;
    }

    public int getWidth() {
        return this.mBitmap.getWidth();
    }

    public int getHeight() {
        return this.mBitmap.getHeight();
    }

    public boolean hasAlpha() {
        return this.mBitmap.hasAlpha();
    }

    public Region getTransparentRegion(Rect location) {
        int r = NinePatch.nativeGetTransparentRegion(this.mBitmap.ni(), this.mChunk, location);
        return r != 0 ? new Region(r) : null;
    }

    public static boolean isNinePatchChunk(byte[] byArray) {
        return OverrideMethod.invokeI("android.graphics.NinePatch#isNinePatchChunk([B)Z", true, null) != 0;
    }

    public static void validateNinePatchChunk(int n, byte[] byArray) {
        OverrideMethod.invokeV("android.graphics.NinePatch#validateNinePatchChunk(I[B)V", true, null);
    }

    public static void nativeDraw(int n, RectF rectF, int n2, byte[] byArray, int n3, int n4, int n5) {
        OverrideMethod.invokeV("android.graphics.NinePatch#nativeDraw(ILandroid/graphics/RectF;I[BIII)V", true, null);
    }

    public static void nativeDraw(int n, Rect rect, int n2, byte[] byArray, int n3, int n4, int n5) {
        OverrideMethod.invokeV("android.graphics.NinePatch#nativeDraw(ILandroid/graphics/Rect;I[BIII)V", true, null);
    }

    public static int nativeGetTransparentRegion(int n, byte[] byArray, Rect rect) {
        return OverrideMethod.invokeI("android.graphics.NinePatch#nativeGetTransparentRegion(I[BLandroid/graphics/Rect;)I", true, null);
    }
}

