/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.Context;
import android.media.IAudioService;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.util.Log;

public class AudioManager {
    public final Context mContext;
    public final Handler mHandler;
    public static String TAG = "AudioManager";
    public static boolean DEBUG = false;
    public static boolean localLOGV = DEBUG;
    public static final String ACTION_AUDIO_BECOMING_NOISY = "android.media.AUDIO_BECOMING_NOISY";
    public static final String RINGER_MODE_CHANGED_ACTION = "android.media.RINGER_MODE_CHANGED";
    public static final String EXTRA_RINGER_MODE = "android.media.EXTRA_RINGER_MODE";
    public static final String VIBRATE_SETTING_CHANGED_ACTION = "android.media.VIBRATE_SETTING_CHANGED";
    public static final String VOLUME_CHANGED_ACTION = "android.media.VOLUME_CHANGED_ACTION";
    public static final String EXTRA_VIBRATE_SETTING = "android.media.EXTRA_VIBRATE_SETTING";
    public static final String EXTRA_VIBRATE_TYPE = "android.media.EXTRA_VIBRATE_TYPE";
    public static final String EXTRA_VOLUME_STREAM_TYPE = "android.media.EXTRA_VOLUME_STREAM_TYPE";
    public static final String EXTRA_VOLUME_STREAM_VALUE = "android.media.EXTRA_VOLUME_STREAM_VALUE";
    public static final int STREAM_VOICE_CALL = 0;
    public static final int STREAM_SYSTEM = 1;
    public static final int STREAM_RING = 2;
    public static final int STREAM_MUSIC = 3;
    public static final int STREAM_ALARM = 4;
    public static final int STREAM_NOTIFICATION = 5;
    public static final int STREAM_BLUETOOTH_SCO = 6;
    public static final int NUM_STREAMS = 5;
    public static final int[] MAX_STREAM_VOLUME = new int[]{6, 8, 8, 16, 8, 8, 16};
    public static final int[] DEFAULT_STREAM_VOLUME = new int[]{4, 5, 5, 11, 6, 5, 7};
    public static final int ADJUST_RAISE = 1;
    public static final int ADJUST_LOWER = -1;
    public static final int ADJUST_SAME = 0;
    public static final int FLAG_SHOW_UI = 1;
    public static final int FLAG_ALLOW_RINGER_MODES = 2;
    public static final int FLAG_PLAY_SOUND = 4;
    public static final int FLAG_REMOVE_SOUND_AND_VIBRATE = 8;
    public static final int FLAG_VIBRATE = 16;
    public static final int RINGER_MODE_SILENT = 0;
    public static final int RINGER_MODE_VIBRATE = 1;
    public static final int RINGER_MODE_NORMAL = 2;
    public static final int VIBRATE_TYPE_RINGER = 0;
    public static final int VIBRATE_TYPE_NOTIFICATION = 1;
    public static final int VIBRATE_SETTING_OFF = 0;
    public static final int VIBRATE_SETTING_ON = 1;
    public static final int VIBRATE_SETTING_ONLY_SILENT = 2;
    public static final int USE_DEFAULT_STREAM_TYPE = Integer.MIN_VALUE;
    public static IAudioService sService;
    public static final int MODE_INVALID = -2;
    public static final int MODE_CURRENT = -1;
    public static final int MODE_NORMAL = 0;
    public static final int MODE_RINGTONE = 1;
    public static final int MODE_IN_CALL = 2;
    public static final int ROUTE_EARPIECE = 1;
    public static final int ROUTE_SPEAKER = 2;
    @Deprecated
    public static final int ROUTE_BLUETOOTH = 4;
    public static final int ROUTE_BLUETOOTH_SCO = 4;
    public static final int ROUTE_HEADSET = 8;
    public static final int ROUTE_BLUETOOTH_A2DP = 16;
    public static final int ROUTE_ALL = -1;
    public static final int FX_KEY_CLICK = 0;
    public static final int FX_FOCUS_NAVIGATION_UP = 1;
    public static final int FX_FOCUS_NAVIGATION_DOWN = 2;
    public static final int FX_FOCUS_NAVIGATION_LEFT = 3;
    public static final int FX_FOCUS_NAVIGATION_RIGHT = 4;
    public static final int FX_KEYPRESS_STANDARD = 5;
    public static final int FX_KEYPRESS_SPACEBAR = 6;
    public static final int FX_KEYPRESS_DELETE = 7;
    public static final int FX_KEYPRESS_RETURN = 8;
    public static final int NUM_SOUND_EFFECTS = 9;
    public IBinder mICallBack = new Binder();

    public AudioManager(Context context) {
        this.mContext = context;
        this.mHandler = new Handler(context.getMainLooper());
    }

    public static IAudioService getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("audio");
        sService = IAudioService.Stub.asInterface(b);
        return sService;
    }

    public void adjustStreamVolume(int streamType, int direction, int flags) {
        IAudioService service = AudioManager.getService();
        try {
            service.adjustStreamVolume(streamType, direction, flags);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in adjustStreamVolume", e);
        }
    }

    public void adjustVolume(int direction, int flags) {
        IAudioService service = AudioManager.getService();
        try {
            service.adjustVolume(direction, flags);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in adjustVolume", e);
        }
    }

    public void adjustSuggestedStreamVolume(int direction, int suggestedStreamType, int flags) {
        IAudioService service = AudioManager.getService();
        try {
            service.adjustSuggestedStreamVolume(direction, suggestedStreamType, flags);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in adjustVolume", e);
        }
    }

    public int getRingerMode() {
        IAudioService service = AudioManager.getService();
        try {
            return service.getRingerMode();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in getRingerMode", e);
            return 2;
        }
    }

    public int getStreamMaxVolume(int streamType) {
        IAudioService service = AudioManager.getService();
        try {
            return service.getStreamMaxVolume(streamType);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in getStreamMaxVolume", e);
            return 0;
        }
    }

    public int getStreamVolume(int streamType) {
        IAudioService service = AudioManager.getService();
        try {
            return service.getStreamVolume(streamType);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in getStreamVolume", e);
            return 0;
        }
    }

    public void setRingerMode(int ringerMode) {
        IAudioService service = AudioManager.getService();
        try {
            service.setRingerMode(ringerMode);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setRingerMode", e);
        }
    }

    public void setStreamVolume(int streamType, int index, int flags) {
        IAudioService service = AudioManager.getService();
        try {
            service.setStreamVolume(streamType, index, flags);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setStreamVolume", e);
        }
    }

    public void setStreamSolo(int streamType, boolean state) {
        IAudioService service = AudioManager.getService();
        try {
            service.setStreamSolo(streamType, state, this.mICallBack);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setStreamSolo", e);
        }
    }

    public void setStreamMute(int streamType, boolean state) {
        IAudioService service = AudioManager.getService();
        try {
            service.setStreamMute(streamType, state, this.mICallBack);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setStreamMute", e);
        }
    }

    public boolean shouldVibrate(int vibrateType) {
        IAudioService service = AudioManager.getService();
        try {
            return service.shouldVibrate(vibrateType);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in shouldVibrate", e);
            return false;
        }
    }

    public int getVibrateSetting(int vibrateType) {
        IAudioService service = AudioManager.getService();
        try {
            return service.getVibrateSetting(vibrateType);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in getVibrateSetting", e);
            return 0;
        }
    }

    public void setVibrateSetting(int vibrateType, int vibrateSetting) {
        IAudioService service = AudioManager.getService();
        try {
            service.setVibrateSetting(vibrateType, vibrateSetting);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setVibrateSetting", e);
        }
    }

    public void setSpeakerphoneOn(boolean on) {
        this.setRoutingP(-2, on ? 2 : 0, 2);
    }

    public boolean isSpeakerphoneOn() {
        return (this.getRoutingP(2) & 2) != 0;
    }

    public void setBluetoothScoOn(boolean on) {
        this.setRoutingP(-2, on ? 4 : 0, 4);
    }

    public boolean isBluetoothScoOn() {
        return (this.getRoutingP(2) & 4) != 0;
    }

    public void setBluetoothA2dpOn(boolean on) {
        this.setRoutingP(-2, on ? 16 : 0, 16);
    }

    public boolean isBluetoothA2dpOn() {
        return (this.getRoutingP(0) & 0x10) != 0;
    }

    public void setWiredHeadsetOn(boolean on) {
        this.setRoutingP(-2, on ? 8 : 0, 8);
    }

    public boolean isWiredHeadsetOn() {
        return (this.getRoutingP(0) & 8) != 0;
    }

    public void setMicrophoneMute(boolean on) {
        IAudioService service = AudioManager.getService();
        try {
            service.setMicrophoneMute(on);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setMicrophoneMute", e);
        }
    }

    public boolean isMicrophoneMute() {
        IAudioService service = AudioManager.getService();
        try {
            return service.isMicrophoneMute();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in isMicrophoneMute", e);
            return false;
        }
    }

    public void setMode(int mode) {
        IAudioService service = AudioManager.getService();
        try {
            service.setMode(mode);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setMode", e);
        }
    }

    public int getMode() {
        IAudioService service = AudioManager.getService();
        try {
            return service.getMode();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in getMode", e);
            return -2;
        }
    }

    public void setRouting(int mode, int routes, int mask) {
        IAudioService service = AudioManager.getService();
        try {
            service.setRouting(mode, routes, mask);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setRouting", e);
        }
    }

    @Deprecated
    public int getRouting(int mode) {
        IAudioService service = AudioManager.getService();
        try {
            return service.getRouting(mode);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in getRouting", e);
            return -1;
        }
    }

    public boolean isMusicActive() {
        IAudioService service = AudioManager.getService();
        try {
            return service.isMusicActive();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in isMusicActive", e);
            return false;
        }
    }

    public void setParameter(String key, String value) {
        IAudioService service = AudioManager.getService();
        try {
            service.setParameter(key, value);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setParameter", e);
        }
    }

    public void playSoundEffect(int effectType) {
        if (effectType < 0 || effectType >= 9) {
            return;
        }
        if (!this.querySoundEffectsEnabled()) {
            return;
        }
        IAudioService service = AudioManager.getService();
        try {
            service.playSoundEffect(effectType);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in playSoundEffect" + e);
        }
    }

    public void playSoundEffect(int effectType, float volume) {
        if (effectType < 0 || effectType >= 9) {
            return;
        }
        IAudioService service = AudioManager.getService();
        try {
            service.playSoundEffectVolume(effectType, volume);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in playSoundEffect" + e);
        }
    }

    public boolean querySoundEffectsEnabled() {
        return Settings.System.getInt(this.mContext.getContentResolver(), "sound_effects_enabled", 0) != 0;
    }

    public void loadSoundEffects() {
        IAudioService service = AudioManager.getService();
        try {
            service.loadSoundEffects();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in loadSoundEffects" + e);
        }
    }

    public void unloadSoundEffects() {
        IAudioService service = AudioManager.getService();
        try {
            service.unloadSoundEffects();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in unloadSoundEffects" + e);
        }
    }

    public void reloadAudioSettings() {
        IAudioService service = AudioManager.getService();
        try {
            service.reloadAudioSettings();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in reloadAudioSettings" + e);
        }
    }

    public void setRoutingP(int mode, int routes, int mask) {
        IAudioService service = AudioManager.getService();
        try {
            service.setRouting(mode, routes, mask);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in setRouting", e);
        }
    }

    public int getRoutingP(int mode) {
        IAudioService service = AudioManager.getService();
        try {
            return service.getRouting(mode);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Dead object in getRouting", e);
            return -1;
        }
    }
}

