/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityManagerNative;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.media.AudioManager;
import android.media.AudioSystem;
import android.media.IAudioService;
import android.media.MediaPlayer;
import android.media.SoundPool;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.util.Log;
import android.view.VolumePanel;
import com.android.internal.telephony.ITelephony;
import java.io.IOException;
import java.util.ArrayList;

public class AudioService
extends IAudioService.Stub {
    public static final String TAG = "AudioService";
    public static final int PERSIST_DELAY = 3000;
    public Context mContext;
    public ContentResolver mContentResolver;
    public VolumePanel mVolumePanel;
    public static final int SHARED_MSG = -1;
    public static final int SENDMSG_REPLACE = 0;
    public static final int SENDMSG_NOOP = 1;
    public static final int SENDMSG_QUEUE = 2;
    public static final int MSG_SET_SYSTEM_VOLUME = 0;
    public static final int MSG_PERSIST_VOLUME = 1;
    public static final int MSG_PERSIST_RINGER_MODE = 3;
    public static final int MSG_PERSIST_VIBRATE_SETTING = 4;
    public static final int MSG_MEDIA_SERVER_DIED = 5;
    public static final int MSG_MEDIA_SERVER_STARTED = 6;
    public static final int MSG_PLAY_SOUND_EFFECT = 7;
    public AudioSystemThread mAudioSystemThread;
    public AudioHandler mAudioHandler;
    public VolumeStreamState[] mStreamStates;
    public SettingsObserver mSettingsObserver;
    public boolean mMicMute;
    public int mMode;
    public int[] mRoutes = new int[3];
    public Object mSettingsLock = new Object();
    public boolean mMediaServerOk;
    public boolean mSpeakerIsOn;
    public boolean mBluetoothScoIsConnected;
    public boolean mHeadsetIsConnected;
    public boolean mBluetoothA2dpIsConnected;
    public SoundPool mSoundPool;
    public Object mSoundEffectsLock = new Object();
    public static final int NUM_SOUNDPOOL_CHANNELS = 4;
    public static final int SOUND_EFFECT_VOLUME = 1000;
    public static final String SOUND_EFFECTS_PATH = "/media/audio/ui/";
    public static final String[] SOUND_EFFECT_FILES = new String[]{"Effect_Tick.ogg", "KeypressStandard.ogg", "KeypressSpacebar.ogg", "KeypressDelete.ogg", "KeypressReturn.ogg"};
    public int[][] SOUND_EFFECT_FILES_MAP = new int[][]{{0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {1, -1}, {2, -1}, {3, -1}, {4, -1}};
    public AudioSystem.ErrorCallback mAudioSystemCallback = new AudioSystem.ErrorCallback(){

        public void onError(int error) {
            switch (error) {
                case 100: {
                    if (!AudioService.this.mMediaServerOk) break;
                    AudioService.sendMsg(AudioService.this.mAudioHandler, 5, -1, 1, 0, 0, null, 1500);
                    break;
                }
                case 0: {
                    if (AudioService.this.mMediaServerOk) break;
                    AudioService.sendMsg(AudioService.this.mAudioHandler, 6, -1, 1, 0, 0, null, 0);
                    break;
                }
            }
        }
    };
    public int mRingerMode;
    public int mRingerModeAffectedStreams;
    public int mMuteAffectedStreams;
    public int mVibrateSetting;

    public AudioService(Context context) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.mVolumePanel = new VolumePanel(context, this);
        this.mSettingsObserver = new SettingsObserver();
        this.createAudioSystemThread();
        this.createStreamStates();
        this.readPersistedSettings();
        this.readAudioSettings();
        this.mMediaServerOk = true;
        AudioSystem.setErrorCallback(this.mAudioSystemCallback);
        this.loadSoundEffects();
        this.mSpeakerIsOn = false;
        this.mBluetoothScoIsConnected = false;
        this.mHeadsetIsConnected = false;
        this.mBluetoothA2dpIsConnected = false;
    }

    public void createAudioSystemThread() {
        this.mAudioSystemThread = new AudioSystemThread();
        this.mAudioSystemThread.start();
        this.waitForAudioHandlerCreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAudioHandlerCreation() {
        AudioService audioService = this;
        synchronized (audioService) {
            while (this.mAudioHandler == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Log.e(TAG, "Interrupted while waiting on volume handler.");
                }
            }
        }
    }

    public void createStreamStates() {
        int[] volumeLevelsPhone = AudioService.createVolumeLevels(0, AudioManager.MAX_STREAM_VOLUME[0]);
        int[] volumeLevelsCoarse = AudioService.createVolumeLevels(0, AudioManager.MAX_STREAM_VOLUME[1]);
        int[] volumeLevelsFine = AudioService.createVolumeLevels(0, AudioManager.MAX_STREAM_VOLUME[3]);
        int[] volumeLevelsBtPhone = AudioService.createVolumeLevels(0, AudioManager.MAX_STREAM_VOLUME[6]);
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        this.mStreamStates = new VolumeStreamState[numStreamTypes];
        VolumeStreamState[] streams = this.mStreamStates;
        for (int i = 0; i < numStreamTypes; ++i) {
            int[] levels;
            switch (i) {
                case 3: {
                    levels = volumeLevelsFine;
                    break;
                }
                case 0: {
                    levels = volumeLevelsPhone;
                    break;
                }
                case 6: {
                    levels = volumeLevelsBtPhone;
                    break;
                }
                default: {
                    levels = volumeLevelsCoarse;
                }
            }
            streams[i] = i == 6 ? new VolumeStreamState(AudioManager.DEFAULT_STREAM_VOLUME[i], i, levels, null) : new VolumeStreamState(Settings.System.VOLUME_SETTINGS[i], i, levels, null);
        }
    }

    public static int[] createVolumeLevels(int offset, int numlevels) {
        double curve = 1.0;
        int[] volumes = new int[numlevels + offset];
        for (int i = 0; i < offset; ++i) {
            volumes[i] = 0;
        }
        double val = 0.0;
        double max = Math.pow(numlevels - 1, curve);
        for (int i = 0; i < numlevels; ++i) {
            val = Math.pow(i, curve) / max;
            volumes[offset + i] = (int)(val * 100.0);
        }
        return volumes;
    }

    public void readPersistedSettings() {
        ContentResolver cr = this.mContentResolver;
        this.mRingerMode = Settings.System.getInt(cr, "mode_ringer", 2);
        this.mVibrateSetting = Settings.System.getInt(cr, "vibrate_on", 0);
        this.mRingerModeAffectedStreams = Settings.System.getInt(cr, "mode_ringer_streams_affected", 38);
        this.mMuteAffectedStreams = Settings.System.getInt(cr, "mute_streams_affected", 14);
        this.broadcastRingerMode();
        this.broadcastVibrateSetting(0);
        this.broadcastVibrateSetting(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAudioSettings() {
        Object object = this.mSettingsLock;
        synchronized (object) {
            this.mMicMute = AudioSystem.isMicrophoneMuted();
            this.mMode = AudioSystem.getMode();
            for (int mode = 0; mode < 3; ++mode) {
                this.mRoutes[mode] = AudioSystem.getRouting(mode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyAudioSettings() {
        Object object = this.mSettingsLock;
        synchronized (object) {
            AudioSystem.muteMicrophone(this.mMicMute);
            AudioSystem.setMode(this.mMode);
            for (int mode = 0; mode < 3; ++mode) {
                AudioSystem.setRouting(mode, this.mRoutes[mode], -1);
            }
        }
    }

    public void adjustVolume(int direction, int flags) {
        this.adjustSuggestedStreamVolume(direction, Integer.MIN_VALUE, flags);
    }

    public void adjustSuggestedStreamVolume(int direction, int suggestedStreamType, int flags) {
        int streamType = this.getActiveStreamType(suggestedStreamType);
        if (streamType != 2 && (flags & 4) != 0) {
            flags &= 0xFFFFFFFB;
        }
        this.adjustStreamVolume(streamType, direction, flags);
    }

    public void adjustStreamVolume(int streamType, int direction, int flags) {
        boolean notificationsUseRingVolume;
        this.ensureValidDirection(direction);
        this.ensureValidStreamType(streamType);
        boolean bl = notificationsUseRingVolume = Settings.System.getInt(this.mContentResolver, "notifications_use_ring_volume", 1) == 1;
        if (notificationsUseRingVolume && streamType == 5) {
            streamType = 2;
        }
        VolumeStreamState streamState = this.mStreamStates[streamType];
        int oldIndex = streamState.mIndex;
        boolean adjustVolume = true;
        if ((flags & 2) != 0 || streamType == 2) {
            adjustVolume = this.checkForRingerModeChange(oldIndex, direction);
        }
        if (adjustVolume && streamState.adjustIndex(direction)) {
            boolean alsoUpdateNotificationVolume;
            boolean bl2 = alsoUpdateNotificationVolume = notificationsUseRingVolume && streamType == 2;
            if (alsoUpdateNotificationVolume) {
                this.mStreamStates[5].adjustIndex(direction);
            }
            if (streamState.muteCount() == 0) {
                AudioService.sendMsg(this.mAudioHandler, 0, streamType, 1, 0, 0, streamState, 0);
                if (alsoUpdateNotificationVolume) {
                    AudioService.sendMsg(this.mAudioHandler, 0, 5, 1, 0, 0, this.mStreamStates[5], 0);
                }
            }
        }
        this.mVolumePanel.postVolumeChanged(streamType, flags);
        this.sendVolumeUpdate(streamType);
    }

    public void setStreamVolume(int streamType, int index, int flags) {
        this.ensureValidStreamType(streamType);
        this.syncRingerAndNotificationStreamVolume(streamType, index, false);
        this.setStreamVolumeInt(streamType, index, false, true);
        this.mVolumePanel.postVolumeChanged(streamType, flags);
        this.sendVolumeUpdate(streamType);
    }

    public void sendVolumeUpdate(int streamType) {
        Intent intent = new Intent("android.media.VOLUME_CHANGED_ACTION");
        intent.putExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", streamType);
        intent.putExtra("android.media.EXTRA_VOLUME_STREAM_VALUE", this.getStreamVolume(streamType));
        if (streamType == 6) {
            this.mContext.sendBroadcast(intent);
        }
    }

    public void syncRingerAndNotificationStreamVolume(int streamType, int index, boolean force) {
        boolean notificationsUseRingVolume;
        boolean bl = notificationsUseRingVolume = Settings.System.getInt(this.mContentResolver, "notifications_use_ring_volume", 1) == 1;
        if (notificationsUseRingVolume) {
            if (streamType == 5) {
                streamType = 2;
            }
            if (streamType == 2) {
                this.setStreamVolumeInt(5, index, force, true);
            }
        }
    }

    public void setStreamVolumeInt(int streamType, int index, boolean force, boolean lastAudible) {
        VolumeStreamState streamState = this.mStreamStates[streamType];
        if ((streamState.setIndex(index, lastAudible) || force) && streamState.muteCount() == 0) {
            AudioService.sendMsg(this.mAudioHandler, 0, streamType, 1, 0, 0, streamState, 0);
        }
    }

    public void setStreamSolo(int streamType, boolean state, IBinder cb) {
        for (int stream = 0; stream < this.mStreamStates.length; ++stream) {
            if (!this.isStreamAffectedByMute(stream) || stream == streamType) continue;
            this.mStreamStates[stream].mute(cb, state);
        }
    }

    public void setStreamMute(int streamType, boolean state, IBinder cb) {
        if (this.isStreamAffectedByMute(streamType)) {
            this.mStreamStates[streamType].mute(cb, state);
        }
    }

    public int getStreamVolume(int streamType) {
        this.ensureValidStreamType(streamType);
        return this.mStreamStates[streamType].mIndex;
    }

    public int getStreamMaxVolume(int streamType) {
        this.ensureValidStreamType(streamType);
        return this.mStreamStates[streamType].getMaxIndex();
    }

    public int getRingerMode() {
        return this.mRingerMode;
    }

    public void setRingerMode(int ringerMode) {
        if (ringerMode != this.mRingerMode) {
            this.setRingerModeInt(ringerMode, true);
            this.broadcastRingerMode();
        }
    }

    public void setRingerModeInt(int ringerMode, boolean persist) {
        this.mRingerMode = ringerMode;
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        if (this.mRingerMode == 2) {
            for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                if (!this.isStreamAffectedByRingerMode(streamType)) continue;
                this.setStreamVolumeInt(streamType, this.mStreamStates[streamType].mLastAudibleIndex, false, false);
            }
        } else {
            for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                if (this.isStreamAffectedByRingerMode(streamType)) {
                    this.setStreamVolumeInt(streamType, 0, false, false);
                    continue;
                }
                this.setStreamVolumeInt(streamType, this.mStreamStates[streamType].mLastAudibleIndex, false, false);
            }
        }
        if (persist) {
            AudioService.sendMsg(this.mAudioHandler, 3, -1, 0, 0, 0, null, 3000);
        }
    }

    public boolean shouldVibrate(int vibrateType) {
        switch (this.getVibrateSetting(vibrateType)) {
            case 1: {
                return this.mRingerMode != 0;
            }
            case 2: {
                return this.mRingerMode == 1;
            }
            case 0: {
                if (vibrateType != 0) break;
                return this.mRingerMode == 1;
            }
        }
        return false;
    }

    public int getVibrateSetting(int vibrateType) {
        return this.mVibrateSetting >> vibrateType * 2 & 3;
    }

    public void setVibrateSetting(int vibrateType, int vibrateSetting) {
        this.mVibrateSetting = AudioService.getValueForVibrateSetting(this.mVibrateSetting, vibrateType, vibrateSetting);
        this.broadcastVibrateSetting(vibrateType);
        AudioService.sendMsg(this.mAudioHandler, 4, -1, 1, 0, 0, null, 0);
    }

    public static int getValueForVibrateSetting(int existingValue, int vibrateType, int vibrateSetting) {
        existingValue &= ~(3 << vibrateType * 2);
        return existingValue |= (vibrateSetting & 3) << vibrateType * 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMicrophoneMute(boolean on) {
        if (!this.checkAudioSettingsPermission("setMicrophoneMute()")) {
            return;
        }
        Object object = this.mSettingsLock;
        synchronized (object) {
            if (on != this.mMicMute) {
                AudioSystem.muteMicrophone(on);
                this.mMicMute = on;
            }
        }
    }

    public boolean isMicrophoneMute() {
        return this.mMicMute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(int mode) {
        if (!this.checkAudioSettingsPermission("setMode()")) {
            return;
        }
        Object object = this.mSettingsLock;
        synchronized (object) {
            if (mode != this.mMode && AudioSystem.setMode(mode) == 0) {
                this.mMode = mode;
            }
            int streamType = this.getActiveStreamType(Integer.MIN_VALUE);
            int index = this.mStreamStates[streamType].mIndex;
            this.syncRingerAndNotificationStreamVolume(streamType, index, true);
            this.setStreamVolumeInt(streamType, index, true, true);
        }
    }

    public int getMode() {
        return this.mMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRouting(int mode, int routes, int mask) {
        int incallMask = 0;
        int ringtoneMask = 0;
        int normalMask = 0;
        if (!this.checkAudioSettingsPermission("setRouting()")) {
            return;
        }
        Object object = this.mSettingsLock;
        synchronized (object) {
            if (mode == -2) {
                switch (mask) {
                    case 2: {
                        if (routes != 0 && !this.mSpeakerIsOn) {
                            this.mSpeakerIsOn = true;
                            this.mRoutes[2] = 2;
                            incallMask = -1;
                            break;
                        }
                        if (routes != 0 || !this.mSpeakerIsOn) break;
                        this.mSpeakerIsOn = false;
                        this.mRoutes[2] = this.mBluetoothScoIsConnected ? 4 : (this.mHeadsetIsConnected ? 8 : 1);
                        incallMask = -1;
                        break;
                    }
                    case 4: {
                        if (routes != 0 && !this.mBluetoothScoIsConnected) {
                            this.mBluetoothScoIsConnected = true;
                            this.mRoutes[2] = 4;
                            this.mRoutes[1] = this.mRoutes[1] & 0x10 | 4;
                            this.mRoutes[0] = this.mRoutes[0] & 0x10 | 4;
                            incallMask = -1;
                            ringtoneMask = -17;
                            normalMask = -17;
                            break;
                        }
                        if (routes != 0 || !this.mBluetoothScoIsConnected) break;
                        this.mBluetoothScoIsConnected = false;
                        if (this.mHeadsetIsConnected) {
                            this.mRoutes[2] = 8;
                            this.mRoutes[1] = this.mRoutes[1] & 0x10 | 0xA;
                            this.mRoutes[0] = this.mRoutes[0] & 0x10 | 8;
                        } else {
                            this.mRoutes[2] = this.mSpeakerIsOn ? 2 : 1;
                            this.mRoutes[1] = this.mRoutes[1] & 0x10 | 2;
                            this.mRoutes[0] = this.mRoutes[0] & 0x10 | 2;
                        }
                        incallMask = -1;
                        ringtoneMask = -17;
                        normalMask = -17;
                        break;
                    }
                    case 8: {
                        if (routes != 0 && !this.mHeadsetIsConnected) {
                            this.mHeadsetIsConnected = true;
                            if (this.mBluetoothScoIsConnected) break;
                            this.mRoutes[2] = 8;
                            this.mRoutes[1] = this.mRoutes[1] & 0x10 | 0xA;
                            this.mRoutes[0] = this.mRoutes[0] & 0x10 | 8;
                            incallMask = -1;
                            ringtoneMask = -17;
                            normalMask = -17;
                            break;
                        }
                        if (routes != 0 || !this.mHeadsetIsConnected) break;
                        this.mHeadsetIsConnected = false;
                        if (this.mBluetoothScoIsConnected) break;
                        this.mRoutes[2] = this.mSpeakerIsOn ? 2 : 1;
                        this.mRoutes[1] = this.mRoutes[1] & 0x10 | 2;
                        this.mRoutes[0] = this.mRoutes[0] & 0x10 | 2;
                        incallMask = -1;
                        ringtoneMask = -17;
                        normalMask = -17;
                        break;
                    }
                    case 16: {
                        if (routes != 0 && !this.mBluetoothA2dpIsConnected) {
                            this.mBluetoothA2dpIsConnected = true;
                            this.mRoutes[1] = this.mRoutes[1] | 0x10;
                            this.mRoutes[0] = this.mRoutes[0] | 0x10;
                            ringtoneMask = 16;
                            normalMask = 16;
                            break;
                        }
                        if (routes != 0 || !this.mBluetoothA2dpIsConnected) break;
                        this.mBluetoothA2dpIsConnected = false;
                        this.mRoutes[1] = this.mRoutes[1] & 0xFFFFFFEF;
                        this.mRoutes[0] = this.mRoutes[0] & 0xFFFFFFEF;
                        ringtoneMask = 16;
                        normalMask = 16;
                    }
                }
                if (incallMask != 0) {
                    AudioSystem.setRouting(2, this.mRoutes[2], incallMask);
                }
                if (ringtoneMask != 0) {
                    AudioSystem.setRouting(1, this.mRoutes[1], ringtoneMask);
                }
                if (normalMask != 0) {
                    AudioSystem.setRouting(0, this.mRoutes[0], normalMask);
                }
                int streamType = this.getActiveStreamType(Integer.MIN_VALUE);
                int index = this.mStreamStates[streamType].mIndex;
                this.syncRingerAndNotificationStreamVolume(streamType, index, true);
                this.setStreamVolumeInt(streamType, index, true, true);
            }
        }
    }

    public int getRouting(int mode) {
        return this.mRoutes[mode];
    }

    public boolean isMusicActive() {
        return AudioSystem.isMusicActive();
    }

    public void setParameter(String key, String value) {
        AudioSystem.setParameter(key, value);
    }

    public void playSoundEffect(int effectType) {
        AudioService.sendMsg(this.mAudioHandler, 7, -1, 1, effectType, 1000, null, 0);
    }

    public void playSoundEffectVolume(int effectType, float volume) {
        AudioService.sendMsg(this.mAudioHandler, 7, -1, 1, effectType, (int)(volume * 1000.0f), null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSoundEffects() {
        Object object = this.mSoundEffectsLock;
        synchronized (object) {
            this.mSoundPool = new SoundPool(4, 1, 0);
            if (this.mSoundPool == null) {
                return false;
            }
            int[] poolId = new int[SOUND_EFFECT_FILES.length];
            for (int fileIdx = 0; fileIdx < SOUND_EFFECT_FILES.length; ++fileIdx) {
                poolId[fileIdx] = -1;
            }
            for (int effect = 0; effect < 9; ++effect) {
                if (this.SOUND_EFFECT_FILES_MAP[effect][1] == 0) continue;
                if (poolId[this.SOUND_EFFECT_FILES_MAP[effect][0]] == -1) {
                    int sampleId;
                    String filePath = Environment.getRootDirectory() + SOUND_EFFECTS_PATH + SOUND_EFFECT_FILES[this.SOUND_EFFECT_FILES_MAP[effect][0]];
                    this.SOUND_EFFECT_FILES_MAP[effect][1] = sampleId = this.mSoundPool.load(filePath, 0);
                    poolId[this.SOUND_EFFECT_FILES_MAP[effect][0]] = sampleId;
                    if (sampleId > 0) continue;
                    Log.w(TAG, "Soundpool could not load file: " + filePath);
                    continue;
                }
                this.SOUND_EFFECT_FILES_MAP[effect][1] = poolId[this.SOUND_EFFECT_FILES_MAP[effect][0]];
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadSoundEffects() {
        Object object = this.mSoundEffectsLock;
        synchronized (object) {
            if (this.mSoundPool == null) {
                return;
            }
            int[] poolId = new int[SOUND_EFFECT_FILES.length];
            for (int fileIdx = 0; fileIdx < SOUND_EFFECT_FILES.length; ++fileIdx) {
                poolId[fileIdx] = 0;
            }
            for (int effect = 0; effect < 9; ++effect) {
                if (this.SOUND_EFFECT_FILES_MAP[effect][1] <= 0 || poolId[this.SOUND_EFFECT_FILES_MAP[effect][0]] != 0) continue;
                this.mSoundPool.unload(this.SOUND_EFFECT_FILES_MAP[effect][1]);
                this.SOUND_EFFECT_FILES_MAP[effect][1] = -1;
                poolId[this.SOUND_EFFECT_FILES_MAP[effect][0]] = -1;
            }
            this.mSoundPool = null;
        }
    }

    public void reloadAudioSettings() {
        this.readPersistedSettings();
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int streamType = 0; streamType < numStreamTypes; ++streamType) {
            VolumeStreamState streamState = this.mStreamStates[streamType];
            if (streamType != 6) {
                String settingName = Settings.System.VOLUME_SETTINGS[streamType];
                String lastAudibleSettingName = settingName + "_last_audible";
                streamState.mIndex = streamState.getValidIndex(Settings.System.getInt(this.mContentResolver, settingName, AudioManager.DEFAULT_STREAM_VOLUME[streamType]));
                streamState.mLastAudibleIndex = streamState.getValidIndex(Settings.System.getInt(this.mContentResolver, lastAudibleSettingName, streamState.mIndex > 0 ? streamState.mIndex : AudioManager.DEFAULT_STREAM_VOLUME[streamType]));
            }
            if (streamState.muteCount() != 0 && !this.isStreamAffectedByMute(streamType)) {
                int size = streamState.mDeathHandlers.size();
                for (int i = 0; i < size; ++i) {
                    ((VolumeStreamState.VolumeDeathHandler)streamState.mDeathHandlers.get(i)).mMuteCount = 1;
                    ((VolumeStreamState.VolumeDeathHandler)streamState.mDeathHandlers.get(i)).mute(false);
                }
            }
            if (streamState.muteCount() != 0) continue;
            AudioSystem.setVolume(streamType, streamState.mVolumes[streamState.mIndex]);
        }
        this.setRingerModeInt(this.getRingerMode(), false);
    }

    public boolean checkForRingerModeChange(int oldIndex, int direction) {
        boolean adjustVolumeIndex = true;
        int newRingerMode = this.mRingerMode;
        if (this.mRingerMode == 2 && oldIndex == 1 && direction == -1) {
            newRingerMode = 1;
        } else if (this.mRingerMode == 1) {
            if (direction == 1) {
                newRingerMode = 2;
            } else if (direction == -1) {
                newRingerMode = 0;
            }
        } else if (direction == 1 && this.mRingerMode == 0) {
            newRingerMode = 1;
        }
        if (newRingerMode != this.mRingerMode) {
            this.setRingerMode(newRingerMode);
            adjustVolumeIndex = false;
        }
        return adjustVolumeIndex;
    }

    public boolean isStreamAffectedByRingerMode(int streamType) {
        return (this.mRingerModeAffectedStreams & 1 << streamType) != 0;
    }

    public boolean isStreamAffectedByMute(int streamType) {
        return (this.mMuteAffectedStreams & 1 << streamType) != 0;
    }

    public void ensureValidDirection(int direction) {
        if (direction < -1 || direction > 1) {
            throw new IllegalArgumentException("Bad direction " + direction);
        }
    }

    public void ensureValidStreamType(int streamType) {
        if (streamType < 0 || streamType >= this.mStreamStates.length) {
            throw new IllegalArgumentException("Bad stream type " + streamType);
        }
    }

    public int getActiveStreamType(int suggestedStreamType) {
        boolean isOffhook = false;
        try {
            ITelephony phone = ITelephony.Stub.asInterface(ServiceManager.checkService("phone"));
            if (phone != null) {
                isOffhook = phone.isOffhook();
            }
        }
        catch (RemoteException e) {
            Log.w(TAG, "Couldn't connect to phone service", e);
        }
        if ((this.getRouting(2) & 4) != 0) {
            return 6;
        }
        if (isOffhook) {
            return 0;
        }
        if (AudioSystem.isMusicActive()) {
            return 3;
        }
        if (suggestedStreamType == Integer.MIN_VALUE) {
            return 2;
        }
        return suggestedStreamType;
    }

    public void broadcastRingerMode() {
        if (ActivityManagerNative.isSystemReady()) {
            Intent broadcast = new Intent("android.media.RINGER_MODE_CHANGED");
            broadcast.putExtra("android.media.EXTRA_RINGER_MODE", this.mRingerMode);
            long origCallerIdentityToken = Binder.clearCallingIdentity();
            this.mContext.sendStickyBroadcast(broadcast);
            Binder.restoreCallingIdentity(origCallerIdentityToken);
        }
    }

    public void broadcastVibrateSetting(int vibrateType) {
        if (ActivityManagerNative.isSystemReady()) {
            Intent broadcast = new Intent("android.media.VIBRATE_SETTING_CHANGED");
            broadcast.putExtra("android.media.EXTRA_VIBRATE_TYPE", vibrateType);
            broadcast.putExtra("android.media.EXTRA_VIBRATE_SETTING", this.getVibrateSetting(vibrateType));
            this.mContext.sendBroadcast(broadcast);
        }
    }

    public static int getMsg(int baseMsg, int streamType) {
        return baseMsg & 0xFFFF | streamType << 16;
    }

    public static int getMsgBase(int msg) {
        return msg & 0xFFFF;
    }

    public static void sendMsg(Handler handler, int baseMsg, int streamType, int existingMsgPolicy, int arg1, int arg2, Object obj, int delay) {
        int msg;
        int n = msg = streamType == -1 ? baseMsg : AudioService.getMsg(baseMsg, streamType);
        if (existingMsgPolicy == 0) {
            handler.removeMessages(msg);
        } else if (existingMsgPolicy == 1 && handler.hasMessages(msg)) {
            return;
        }
        handler.sendMessageDelayed(handler.obtainMessage(msg, arg1, arg2, obj), delay);
    }

    public boolean checkAudioSettingsPermission(String method) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_AUDIO_SETTINGS") == 0) {
            return true;
        }
        String msg = "Audio Settings Permission Denial: " + method + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid();
        Log.w(TAG, msg);
        return false;
    }

    public class SettingsObserver
    extends ContentObserver {
        public SettingsObserver() {
            super(new Handler());
            AudioService.this.mContentResolver.registerContentObserver(Settings.System.getUriFor("mode_ringer_streams_affected"), false, this);
        }

        public void onChange(boolean selfChange) {
            super.onChange(selfChange);
            AudioService.this.mRingerModeAffectedStreams = Settings.System.getInt(AudioService.this.mContentResolver, "mode_ringer_streams_affected", 0);
            AudioService.this.setRingerModeInt(AudioService.this.getRingerMode(), false);
        }
    }

    public class AudioHandler
    extends Handler {
        public AudioHandler() {
        }

        public void setSystemVolume(VolumeStreamState streamState) {
            AudioSystem.setVolume(streamState.mStreamType, streamState.mVolumes[streamState.mIndex]);
            AudioService.sendMsg(AudioService.this.mAudioHandler, 1, streamState.mStreamType, 0, 0, 0, streamState, 3000);
        }

        public void persistVolume(VolumeStreamState streamState) {
            if (streamState.mStreamType != 6) {
                Settings.System.putInt(AudioService.this.mContentResolver, streamState.mVolumeIndexSettingName, streamState.mIndex);
                Settings.System.putInt(AudioService.this.mContentResolver, streamState.mLastAudibleVolumeIndexSettingName, streamState.mLastAudibleIndex);
            }
        }

        public void persistRingerMode() {
            Settings.System.putInt(AudioService.this.mContentResolver, "mode_ringer", AudioService.this.mRingerMode);
        }

        public void persistVibrateSetting() {
            Settings.System.putInt(AudioService.this.mContentResolver, "vibrate_on", AudioService.this.mVibrateSetting);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void playSoundEffect(int effectType, int volume) {
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                if (AudioService.this.mSoundPool == null) {
                    return;
                }
                if (AudioService.this.SOUND_EFFECT_FILES_MAP[effectType][1] > 0) {
                    float v = (float)volume / 1000.0f;
                    AudioService.this.mSoundPool.play(AudioService.this.SOUND_EFFECT_FILES_MAP[effectType][1], v, v, 0, 0, 1.0f);
                } else {
                    MediaPlayer mediaPlayer = new MediaPlayer();
                    if (mediaPlayer != null) {
                        try {
                            String filePath = Environment.getRootDirectory() + AudioService.SOUND_EFFECTS_PATH + SOUND_EFFECT_FILES[AudioService.this.SOUND_EFFECT_FILES_MAP[effectType][0]];
                            mediaPlayer.setDataSource(filePath);
                            mediaPlayer.setAudioStreamType(1);
                            mediaPlayer.prepare();
                            mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                                public void onCompletion(MediaPlayer mp) {
                                    AudioHandler.this.cleanupPlayer(mp);
                                }
                            });
                            mediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                                public boolean onError(MediaPlayer mp, int what, int extra) {
                                    AudioHandler.this.cleanupPlayer(mp);
                                    return true;
                                }
                            });
                            mediaPlayer.start();
                        }
                        catch (IOException ex) {
                            Log.w(AudioService.TAG, "MediaPlayer IOException: " + ex);
                        }
                        catch (IllegalArgumentException ex) {
                            Log.w(AudioService.TAG, "MediaPlayer IllegalArgumentException: " + ex);
                        }
                        catch (IllegalStateException ex) {
                            Log.w(AudioService.TAG, "MediaPlayer IllegalStateException: " + ex);
                        }
                    }
                }
            }
        }

        public void cleanupPlayer(MediaPlayer mp) {
            if (mp != null) {
                try {
                    mp.stop();
                    mp.release();
                }
                catch (IllegalStateException ex) {
                    Log.w(AudioService.TAG, "MediaPlayer IllegalStateException: " + ex);
                }
            }
        }

        public void handleMessage(Message msg) {
            int baseMsgWhat = AudioService.getMsgBase(msg.what);
            switch (baseMsgWhat) {
                case 0: {
                    this.setSystemVolume((VolumeStreamState)msg.obj);
                    break;
                }
                case 1: {
                    this.persistVolume((VolumeStreamState)msg.obj);
                    break;
                }
                case 3: {
                    this.persistRingerMode();
                    break;
                }
                case 4: {
                    this.persistVibrateSetting();
                    break;
                }
                case 5: {
                    Log.e(AudioService.TAG, "Media server died.");
                    AudioService.this.mMediaServerOk = false;
                    AudioSystem.getMode();
                    break;
                }
                case 6: {
                    Log.e(AudioService.TAG, "Media server started.");
                    AudioService.this.applyAudioSettings();
                    int numStreamTypes = AudioSystem.getNumStreamTypes();
                    for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                        VolumeStreamState streamState = AudioService.this.mStreamStates[streamType];
                        int volume = streamState.muteCount() == 0 ? streamState.mVolumes[streamState.mIndex] : streamState.mVolumes[0];
                        AudioSystem.setVolume(streamType, volume);
                    }
                    AudioService.this.setRingerMode(AudioService.this.mRingerMode);
                    AudioService.this.mMediaServerOk = true;
                    break;
                }
                case 7: {
                    this.playSoundEffect(msg.arg1, msg.arg2);
                }
            }
        }

        public /* synthetic */ AudioHandler(1 x1) {
            this();
        }
    }

    public class AudioSystemThread
    extends Thread {
        public AudioSystemThread() {
            super(AudioService.TAG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Looper.prepare();
            AudioService audioService = AudioService.this;
            synchronized (audioService) {
                AudioService.this.mAudioHandler = new AudioHandler(null);
                AudioService.this.notify();
            }
            Looper.loop();
        }
    }

    public class VolumeStreamState {
        public final String mVolumeIndexSettingName;
        public final String mLastAudibleVolumeIndexSettingName;
        public final int mStreamType;
        public final int[] mVolumes;
        public int mIndex;
        public int mLastAudibleIndex;
        public ArrayList<VolumeDeathHandler> mDeathHandlers;

        public VolumeStreamState(String settingName, int streamType, int[] volumes) {
            this.mVolumeIndexSettingName = settingName;
            this.mLastAudibleVolumeIndexSettingName = settingName + "_last_audible";
            this.mStreamType = streamType;
            this.mVolumes = volumes;
            ContentResolver cr = AudioService.this.mContentResolver;
            this.mIndex = this.getValidIndex(Settings.System.getInt(cr, this.mVolumeIndexSettingName, AudioManager.DEFAULT_STREAM_VOLUME[streamType]));
            this.mLastAudibleIndex = this.getValidIndex(Settings.System.getInt(cr, this.mLastAudibleVolumeIndexSettingName, this.mIndex > 0 ? this.mIndex : AudioManager.DEFAULT_STREAM_VOLUME[streamType]));
            AudioSystem.setVolume(streamType, volumes[this.mIndex]);
            this.mDeathHandlers = new ArrayList();
        }

        public VolumeStreamState(int defaultVolume, int streamType, int[] volumes) {
            this.mVolumeIndexSettingName = null;
            this.mLastAudibleVolumeIndexSettingName = null;
            this.mIndex = this.mLastAudibleIndex = defaultVolume;
            this.mStreamType = streamType;
            this.mVolumes = volumes;
            AudioSystem.setVolume(this.mStreamType, defaultVolume);
            this.mDeathHandlers = new ArrayList();
        }

        public boolean adjustIndex(int deltaIndex) {
            return this.setIndex(this.mIndex + deltaIndex, true);
        }

        public boolean setIndex(int index, boolean lastAudible) {
            int oldIndex = this.mIndex;
            this.mIndex = this.getValidIndex(index);
            if (oldIndex != this.mIndex) {
                if (lastAudible) {
                    this.mLastAudibleIndex = this.mIndex;
                }
                return true;
            }
            return false;
        }

        public int getMaxIndex() {
            return this.mVolumes.length - 1;
        }

        public void mute(IBinder cb, boolean state) {
            VolumeDeathHandler handler = this.getDeathHandler(cb, state);
            if (handler == null) {
                Log.e(AudioService.TAG, "Could not get client death handler for stream: " + this.mStreamType);
                return;
            }
            handler.mute(state);
        }

        public int getValidIndex(int index) {
            if (index < 0) {
                return 0;
            }
            if (index >= this.mVolumes.length) {
                return this.mVolumes.length - 1;
            }
            return index;
        }

        public int muteCount() {
            int count = 0;
            int size = this.mDeathHandlers.size();
            for (int i = 0; i < size; ++i) {
                count += this.mDeathHandlers.get(i).mMuteCount;
            }
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VolumeDeathHandler getDeathHandler(IBinder cb, boolean state) {
            ArrayList<VolumeDeathHandler> arrayList = this.mDeathHandlers;
            synchronized (arrayList) {
                VolumeDeathHandler handler;
                int size = this.mDeathHandlers.size();
                for (int i = 0; i < size; ++i) {
                    handler = this.mDeathHandlers.get(i);
                    if (!cb.equals(handler.mICallback)) continue;
                    return handler;
                }
                if (state) {
                    handler = new VolumeDeathHandler(cb);
                } else {
                    Log.w(AudioService.TAG, "stream was not muted by this client");
                    handler = null;
                }
                return handler;
            }
        }

        public /* synthetic */ VolumeStreamState(int x1, int x2, int[] x3, 1 x4) {
            this(x1, x2, x3);
        }

        public /* synthetic */ VolumeStreamState(String x1, int x2, int[] x3, 1 x4) {
            this(x1, x2, x3);
        }

        public class VolumeDeathHandler
        implements IBinder.DeathRecipient {
            public IBinder mICallback;
            public int mMuteCount;

            public VolumeDeathHandler(IBinder cb) {
                this.mICallback = cb;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void mute(boolean state) {
                var2_2 = VolumeStreamState.access$900(VolumeStreamState.this);
                synchronized (var2_2) {
                    if (state) {
                        if (this.mMuteCount == 0) {
                            try {
                                this.mICallback.linkToDeath(this, 0);
                                VolumeStreamState.access$900(VolumeStreamState.this).add(this);
                                if (VolumeStreamState.access$600(VolumeStreamState.this) != 0) ** GOTO lbl21
                                VolumeStreamState.this.setIndex(0, false);
                                AudioService.access$200(AudioService.access$100(AudioService.this), 0, VolumeStreamState.access$1300(VolumeStreamState.this), 1, 0, 0, VolumeStreamState.this, 0);
                            }
                            catch (RemoteException e) {
                                this.binderDied();
                                VolumeStreamState.access$900(VolumeStreamState.this).notify();
                                return;
                            }
                        } else {
                            Log.w("AudioService", "stream: " + VolumeStreamState.access$1300(VolumeStreamState.this) + " was already muted by this client");
                        }
lbl21:
                        // 3 sources

                        ++this.mMuteCount;
                    } else if (this.mMuteCount == 0) {
                        Log.e("AudioService", "unexpected unmute for stream: " + VolumeStreamState.access$1300(VolumeStreamState.this));
                    } else {
                        --this.mMuteCount;
                        if (this.mMuteCount == 0) {
                            VolumeStreamState.access$900(VolumeStreamState.this).remove(this);
                            this.mICallback.unlinkToDeath(this, 0);
                            if (!(VolumeStreamState.access$600(VolumeStreamState.this) != 0 || AudioService.this.isStreamAffectedByRingerMode(VolumeStreamState.access$1300(VolumeStreamState.this)) && AudioService.access$1400(AudioService.this) != 2)) {
                                VolumeStreamState.this.setIndex(VolumeStreamState.access$700(VolumeStreamState.this), false);
                                AudioService.access$200(AudioService.access$100(AudioService.this), 0, VolumeStreamState.access$1300(VolumeStreamState.this), 1, 0, 0, VolumeStreamState.this, 0);
                            }
                        }
                    }
                    VolumeStreamState.access$900(VolumeStreamState.this).notify();
                }
            }

            public void binderDied() {
                Log.w(AudioService.TAG, "Volume service client died for stream: " + VolumeStreamState.this.mStreamType);
                if (this.mMuteCount != 0) {
                    this.mMuteCount = 1;
                    this.mute(false);
                }
            }
        }
    }
}

