/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.AndroidHttpClientConnection;
import android.net.http.Connection;
import android.net.http.EventHandler;
import android.net.http.Headers;
import android.net.http.HttpLog;
import android.net.http.HttpsConnection;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.RequestContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Request {
    public EventHandler mEventHandler;
    public Connection mConnection;
    public BasicHttpRequest mHttpRequest;
    public String mPath;
    public HttpHost mHost;
    public HttpHost mProxyHost;
    public boolean mHighPriority;
    public volatile boolean mCancelled = false;
    public int mFailCount = 0;
    public InputStream mBodyProvider;
    public int mBodyLength;
    public static final String HOST_HEADER = "Host";
    public static final String ACCEPT_ENCODING_HEADER = "Accept-Encoding";
    public static final String CONTENT_LENGTH_HEADER = "content-length";
    public final Object mClientResource = new Object();
    public static RequestContent requestContentProcessor = new RequestContent();

    public Request(String method, HttpHost host, HttpHost proxyHost, String path, InputStream bodyProvider, int bodyLength, EventHandler eventHandler, Map<String, String> headers, boolean highPriority) {
        this.mEventHandler = eventHandler;
        this.mHost = host;
        this.mProxyHost = proxyHost;
        this.mPath = path;
        this.mHighPriority = highPriority;
        this.mBodyProvider = bodyProvider;
        this.mBodyLength = bodyLength;
        if (bodyProvider == null) {
            this.mHttpRequest = new BasicHttpRequest(method, this.getUri());
        } else {
            this.mHttpRequest = new BasicHttpEntityEnclosingRequest(method, this.getUri());
            this.setBodyProvider(bodyProvider, bodyLength);
        }
        this.addHeader(HOST_HEADER, this.getHostPort());
        this.addHeader(ACCEPT_ENCODING_HEADER, "gzip");
        this.addHeaders(headers);
    }

    public void setConnection(Connection connection) {
        this.mConnection = connection;
    }

    public EventHandler getEventHandler() {
        return this.mEventHandler;
    }

    public void addHeader(String name, String value) {
        if (name == null) {
            String damage = "Null http header name";
            HttpLog.e(damage);
            throw new NullPointerException(damage);
        }
        if (value == null || value.length() == 0) {
            String damage = "Null or empty value for header \"" + name + "\"";
            HttpLog.e(damage);
            throw new RuntimeException(damage);
        }
        this.mHttpRequest.addHeader(name, value);
    }

    public void addHeaders(Map<String, String> headers) {
        if (headers == null) {
            return;
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.addHeader(entry.getKey(), entry.getValue());
        }
    }

    public void sendRequest(AndroidHttpClientConnection httpClientConnection) throws HttpException, IOException {
        if (this.mCancelled) {
            return;
        }
        requestContentProcessor.process((HttpRequest)this.mHttpRequest, this.mConnection.getHttpContext());
        httpClientConnection.sendRequestHeader((HttpRequest)this.mHttpRequest);
        if (this.mHttpRequest instanceof HttpEntityEnclosingRequest) {
            httpClientConnection.sendRequestEntity((HttpEntityEnclosingRequest)this.mHttpRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readResponse(AndroidHttpClientConnection httpClientConnection) throws IOException, ParseException {
        HttpEntity entity;
        Headers header;
        StatusLine statusLine;
        block15: {
            if (this.mCancelled) {
                return;
            }
            statusLine = null;
            boolean hasBody = false;
            boolean reuse = false;
            httpClientConnection.flush();
            int statusCode = 0;
            header = new Headers();
            while ((statusCode = (statusLine = httpClientConnection.parseResponseHeader(header)).getStatusCode()) < 200) {
            }
            ProtocolVersion v = statusLine.getProtocolVersion();
            this.mEventHandler.status(v.getMajor(), v.getMinor(), statusCode, statusLine.getReasonPhrase());
            this.mEventHandler.headers(header);
            entity = null;
            hasBody = Request.canResponseHaveBody((HttpRequest)this.mHttpRequest, statusCode);
            if (hasBody) {
                entity = httpClientConnection.receiveResponseEntity(header);
            }
            if (entity != null) {
                InputStream is = entity.getContent();
                Header contentEncoding = entity.getContentEncoding();
                InputStream nis = null;
                try {
                    try {
                        nis = contentEncoding != null && contentEncoding.getValue().equals("gzip") ? new GZIPInputStream(is) : is;
                        byte[] buf = this.mConnection.getBuf();
                        int len = 0;
                        int count = 0;
                        int lowWater = buf.length / 2;
                        while (len != -1) {
                            len = nis.read(buf, count, buf.length - count);
                            if (len != -1) {
                                count += len;
                            }
                            if (len != -1 && count < lowWater) continue;
                            this.mEventHandler.data(buf, count);
                            count = 0;
                        }
                        Object var17_18 = null;
                        if (nis == null) break block15;
                    }
                    catch (EOFException e) {
                        Object var17_19 = null;
                        if (nis != null) {
                            nis.close();
                        }
                        break block15;
                    }
                    catch (IOException e) {
                        if (statusCode == 200) {
                            throw e;
                        }
                        Object var17_20 = null;
                        if (nis != null) {
                            nis.close();
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    Object var17_21 = null;
                    if (nis != null) {
                        nis.close();
                    }
                    throw throwable;
                }
                nis.close();
            }
        }
        this.mConnection.setCanPersist(entity, statusLine.getProtocolVersion(), header.getConnectionType());
        this.mEventHandler.endData();
        this.complete();
    }

    public void cancel() {
        this.mCancelled = true;
        if (this.mConnection != null) {
            this.mConnection.cancel();
        }
    }

    public String getHostPort() {
        String myScheme = this.mHost.getSchemeName();
        int myPort = this.mHost.getPort();
        if (myPort != 80 && myScheme.equals("http") || myPort != 443 && myScheme.equals("https")) {
            return this.mHost.toHostString();
        }
        return this.mHost.getHostName();
    }

    public String getUri() {
        if (this.mProxyHost == null || this.mHost.getSchemeName().equals("https")) {
            return this.mPath;
        }
        return this.mHost.getSchemeName() + "://" + this.getHostPort() + this.mPath;
    }

    public String toString() {
        return (this.mHighPriority ? "P*" : "") + this.mPath;
    }

    public void reset() {
        this.mHttpRequest.removeHeaders(CONTENT_LENGTH_HEADER);
        if (this.mBodyProvider != null) {
            try {
                this.mBodyProvider.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.setBodyProvider(this.mBodyProvider, this.mBodyLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilComplete() {
        Object object = this.mClientResource;
        synchronized (object) {
            try {
                this.mClientResource.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        Object object = this.mClientResource;
        synchronized (object) {
            this.mClientResource.notifyAll();
        }
    }

    public static boolean canResponseHaveBody(HttpRequest request, int status) {
        if ("HEAD".equalsIgnoreCase(request.getRequestLine().getMethod())) {
            return false;
        }
        return status >= 200 && status != 204 && status != 304 && status != 205;
    }

    public void setBodyProvider(InputStream bodyProvider, int bodyLength) {
        if (!bodyProvider.markSupported()) {
            throw new IllegalArgumentException("bodyProvider must support mark()");
        }
        bodyProvider.mark(Integer.MAX_VALUE);
        ((BasicHttpEntityEnclosingRequest)this.mHttpRequest).setEntity((HttpEntity)new InputStreamEntity(bodyProvider, (long)bodyLength));
    }

    public void handleSslErrorResponse(boolean proceed) {
        HttpsConnection connection = (HttpsConnection)this.mConnection;
        if (connection != null) {
            connection.restartConnection(proceed);
        }
    }

    public void error(int errorId, int resourceId) {
        this.mEventHandler.error(errorId, ((Object)this.mConnection.mContext.getText(resourceId)).toString());
    }
}

