/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.ParcelFileDescriptor;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MemoryFile {
    public static String TAG = "MemoryFile";
    public static final int PROT_READ = 1;
    public static final int PROT_WRITE = 2;
    public FileDescriptor mFD;
    public int mAddress;
    public int mLength;
    public boolean mAllowPurging = false;
    public final boolean mOwnsRegion;

    public static FileDescriptor native_open(String string2, int n) throws IOException {
        return (FileDescriptor)OverrideMethod.invokeA("android.os.MemoryFile#native_open(Ljava/lang/String;I)Ljava/io/FileDescriptor;", true, null);
    }

    public static int native_mmap(FileDescriptor fileDescriptor, int n, int n2) throws IOException {
        return OverrideMethod.invokeI("android.os.MemoryFile#native_mmap(Ljava/io/FileDescriptor;II)I", true, null);
    }

    public static void native_munmap(int n, int n2) throws IOException {
        OverrideMethod.invokeV("android.os.MemoryFile#native_munmap(II)V", true, null);
    }

    public static void native_close(FileDescriptor fileDescriptor) {
        OverrideMethod.invokeV("android.os.MemoryFile#native_close(Ljava/io/FileDescriptor;)V", true, null);
    }

    public static int native_read(FileDescriptor fileDescriptor, int n, byte[] byArray, int n2, int n3, int n4, boolean bl) throws IOException {
        return OverrideMethod.invokeI("android.os.MemoryFile#native_read(Ljava/io/FileDescriptor;I[BIIIZ)I", true, null);
    }

    public static void native_write(FileDescriptor fileDescriptor, int n, byte[] byArray, int n2, int n3, int n4, boolean bl) throws IOException {
        OverrideMethod.invokeV("android.os.MemoryFile#native_write(Ljava/io/FileDescriptor;I[BIIIZ)V", true, null);
    }

    public static void native_pin(FileDescriptor fileDescriptor, boolean bl) throws IOException {
        OverrideMethod.invokeV("android.os.MemoryFile#native_pin(Ljava/io/FileDescriptor;Z)V", true, null);
    }

    public static boolean native_is_ashmem_region(FileDescriptor fileDescriptor) throws IOException {
        return OverrideMethod.invokeI("android.os.MemoryFile#native_is_ashmem_region(Ljava/io/FileDescriptor;)Z", true, null) != 0;
    }

    public MemoryFile(String name, int length) throws IOException {
        this.mLength = length;
        this.mFD = MemoryFile.native_open(name, length);
        this.mAddress = MemoryFile.native_mmap(this.mFD, length, 3);
        this.mOwnsRegion = true;
    }

    public MemoryFile(FileDescriptor fd, int length, String mode) throws IOException {
        if (fd == null) {
            throw new NullPointerException("File descriptor is null.");
        }
        if (!MemoryFile.isMemoryFile(fd)) {
            throw new IllegalArgumentException("Not a memory file.");
        }
        this.mLength = length;
        this.mFD = fd;
        this.mAddress = MemoryFile.native_mmap(this.mFD, length, MemoryFile.modeToProt(mode));
        this.mOwnsRegion = false;
    }

    public void close() {
        this.deactivate();
        if (!this.isClosed()) {
            MemoryFile.native_close(this.mFD);
        }
    }

    public void deactivate() {
        if (!this.isDeactivated()) {
            try {
                MemoryFile.native_munmap(this.mAddress, this.mLength);
                this.mAddress = 0;
            }
            catch (IOException ex) {
                Log.e(TAG, ex.toString());
            }
        }
    }

    public boolean isDeactivated() {
        return this.mAddress == 0;
    }

    public boolean isClosed() {
        return !this.mFD.valid();
    }

    public void finalize() {
        if (!this.isClosed()) {
            Log.e(TAG, "MemoryFile.finalize() called while ashmem still open");
            this.close();
        }
    }

    public int length() {
        return this.mLength;
    }

    public boolean isPurgingAllowed() {
        return this.mAllowPurging;
    }

    public synchronized boolean allowPurging(boolean allowPurging) throws IOException {
        if (!this.mOwnsRegion) {
            throw new IOException("Only the owner can make ashmem regions purgable.");
        }
        boolean oldValue = this.mAllowPurging;
        if (oldValue != allowPurging) {
            MemoryFile.native_pin(this.mFD, !allowPurging);
            this.mAllowPurging = allowPurging;
        }
        return oldValue;
    }

    public InputStream getInputStream() {
        return new MemoryInputStream(null);
    }

    public OutputStream getOutputStream() {
        return new MemoryOutputStream(null);
    }

    public int readBytes(byte[] buffer, int srcOffset, int destOffset, int count) throws IOException {
        if (this.isDeactivated()) {
            throw new IOException("Can't read from deactivated memory file.");
        }
        if (destOffset < 0 || destOffset > buffer.length || count < 0 || count > buffer.length - destOffset || srcOffset < 0 || srcOffset > this.mLength || count > this.mLength - srcOffset) {
            throw new IndexOutOfBoundsException();
        }
        return MemoryFile.native_read(this.mFD, this.mAddress, buffer, srcOffset, destOffset, count, this.mAllowPurging);
    }

    public void writeBytes(byte[] buffer, int srcOffset, int destOffset, int count) throws IOException {
        if (this.isDeactivated()) {
            throw new IOException("Can't write to deactivated memory file.");
        }
        if (srcOffset < 0 || srcOffset > buffer.length || count < 0 || count > buffer.length - srcOffset || destOffset < 0 || destOffset > this.mLength || count > this.mLength - destOffset) {
            throw new IndexOutOfBoundsException();
        }
        MemoryFile.native_write(this.mFD, this.mAddress, buffer, srcOffset, destOffset, count, this.mAllowPurging);
    }

    public ParcelFileDescriptor getParcelFileDescriptor() throws IOException {
        return new ParcelFileDescriptor(this.getFileDescriptor());
    }

    public FileDescriptor getFileDescriptor() throws IOException {
        return this.mFD;
    }

    public static boolean isMemoryFile(FileDescriptor fd) throws IOException {
        return MemoryFile.native_is_ashmem_region(fd);
    }

    public static int modeToProt(String mode) {
        if ("r".equals(mode)) {
            return 1;
        }
        throw new IllegalArgumentException("Unsupported file mode: '" + mode + "'");
    }

    public static class 1 {
    }

    public class MemoryOutputStream
    extends OutputStream {
        public int mOffset = 0;
        public byte[] mSingleByte;

        public MemoryOutputStream() {
        }

        public void write(byte[] buffer, int offset, int count) throws IOException {
            MemoryFile.this.writeBytes(buffer, offset, this.mOffset, count);
        }

        public void write(int oneByte) throws IOException {
            if (this.mSingleByte == null) {
                this.mSingleByte = new byte[1];
            }
            this.mSingleByte[0] = (byte)oneByte;
            this.write(this.mSingleByte, 0, 1);
        }

        public /* synthetic */ MemoryOutputStream(1 x1) {
            this();
        }
    }

    public class MemoryInputStream
    extends InputStream {
        public int mMark = 0;
        public int mOffset = 0;
        public byte[] mSingleByte;

        public MemoryInputStream() {
        }

        public int available() throws IOException {
            if (this.mOffset >= MemoryFile.this.mLength) {
                return 0;
            }
            return MemoryFile.this.mLength - this.mOffset;
        }

        public boolean markSupported() {
            return true;
        }

        public void mark(int readlimit) {
            this.mMark = this.mOffset;
        }

        public void reset() throws IOException {
            this.mOffset = this.mMark;
        }

        public int read() throws IOException {
            int result;
            if (this.mSingleByte == null) {
                this.mSingleByte = new byte[1];
            }
            if ((result = this.read(this.mSingleByte, 0, 1)) != 1) {
                return -1;
            }
            return this.mSingleByte[0];
        }

        public int read(byte[] buffer, int offset, int count) throws IOException {
            if (offset < 0 || count < 0 || offset + count > buffer.length) {
                throw new IndexOutOfBoundsException();
            }
            if ((count = Math.min(count, this.available())) < 1) {
                return -1;
            }
            int result = MemoryFile.this.readBytes(buffer, this.mOffset, offset, count);
            if (result > 0) {
                this.mOffset += result;
            }
            return result;
        }

        public long skip(long n) throws IOException {
            if ((long)this.mOffset + n > (long)MemoryFile.this.mLength) {
                n = MemoryFile.this.mLength - this.mOffset;
            }
            this.mOffset = (int)((long)this.mOffset + n);
            return n;
        }

        public /* synthetic */ MemoryInputStream(1 x1) {
            this();
        }
    }
}

