/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.Preference;
import android.preference.PreferenceGroup;
import android.preference.PreferenceGroupAdapter;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;

public class PreferenceScreen
extends PreferenceGroup
implements AdapterView.OnItemClickListener,
DialogInterface.OnDismissListener {
    public ListAdapter mRootAdapter;
    public Dialog mDialog;

    public PreferenceScreen(Context context, AttributeSet attrs) {
        super(context, attrs, 16842891);
    }

    public ListAdapter getRootAdapter() {
        if (this.mRootAdapter == null) {
            this.mRootAdapter = this.onCreateRootAdapter();
        }
        return this.mRootAdapter;
    }

    public ListAdapter onCreateRootAdapter() {
        return new PreferenceGroupAdapter(this);
    }

    public void bind(ListView listView) {
        listView.setOnItemClickListener(this);
        listView.setAdapter(this.getRootAdapter());
        this.onAttachedToActivity();
    }

    public void onClick() {
        if (this.getIntent() != null || this.getPreferenceCount() == 0) {
            return;
        }
        this.showDialog(null);
    }

    public void showDialog(Bundle state) {
        Context context = this.getContext();
        ListView listView = new ListView(context);
        this.bind(listView);
        CharSequence title = this.getTitle();
        Dialog dialog = this.mDialog = new Dialog(context, TextUtils.isEmpty(title) ? 16973830 : 16973829);
        dialog.setContentView(listView);
        if (!TextUtils.isEmpty(title)) {
            dialog.setTitle(title);
        }
        dialog.setOnDismissListener(this);
        if (state != null) {
            dialog.onRestoreInstanceState(state);
        }
        this.getPreferenceManager().addPreferencesScreen(dialog);
        dialog.show();
    }

    public void onDismiss(DialogInterface dialog) {
        this.mDialog = null;
        this.getPreferenceManager().removePreferencesScreen(dialog);
    }

    public Dialog getDialog() {
        return this.mDialog;
    }

    public void onItemClick(AdapterView parent, View view, int position, long id2) {
        Object item = this.getRootAdapter().getItem(position);
        if (!(item instanceof Preference)) {
            return;
        }
        Preference preference = (Preference)item;
        preference.performClick(this);
    }

    public boolean isOnSameScreenAsChildren() {
        return false;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Dialog dialog = this.mDialog;
        if (dialog == null || !dialog.isShowing()) {
            return superState;
        }
        SavedState myState = new SavedState(superState);
        myState.isDialogShowing = true;
        myState.dialogBundle = dialog.onSaveInstanceState();
        return myState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state == null || !state.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState myState = (SavedState)state;
        super.onRestoreInstanceState(myState.getSuperState());
        if (myState.isDialogShowing) {
            this.showDialog(myState.dialogBundle);
        }
    }

    public static class SavedState
    extends Preference.BaseSavedState {
        public boolean isDialogShowing;
        public Bundle dialogBundle;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source) {
            super(source);
            this.isDialogShowing = source.readInt() == 1;
            this.dialogBundle = source.readBundle();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.isDialogShowing ? 1 : 0);
            dest.writeBundle(this.dialogBundle);
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }
    }
}

