/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.security.Reply;
import android.security.ServiceCommand;

public abstract class Keystore {
    public static final String TAG = "Keystore";
    public static final String[] NOTFOUND = new String[0];
    public static final int BOOTUP = 0;
    public static final int UNINITIALIZED = 1;
    public static final int LOCKED = 2;
    public static final int UNLOCKED = 3;

    public static Keystore getInstance() {
        return new FileKeystore(null);
    }

    public abstract int lock();

    public abstract int unlock(String var1);

    public abstract int getState();

    public abstract int changePassword(String var1, String var2);

    public abstract int setPassword(String var1);

    public abstract String[] listKeys(String var1);

    public abstract int put(String var1, String var2, String var3);

    public abstract String get(String var1, String var2);

    public abstract int remove(String var1, String var2);

    public abstract int reset();

    public static class 1 {
    }

    public static class FileKeystore
    extends Keystore {
        public static final String SERVICE_NAME = "keystore";
        public static final String CA_CERTIFICATE = "CaCertificate";
        public static final String USER_CERTIFICATE = "UserCertificate";
        public static final String USER_KEY = "UserPrivateKey";
        public static final String COMMAND_DELIMITER = " ";
        public static final ServiceCommand mServiceCommand = new ServiceCommand("keystore");

        public FileKeystore() {
        }

        public int lock() {
            Reply result = mServiceCommand.execute(0, null);
            return result != null ? result.returnCode : -1;
        }

        public int unlock(String password) {
            Reply result = mServiceCommand.execute(1, password);
            return result != null ? result.returnCode : -1;
        }

        public int getState() {
            Reply result = mServiceCommand.execute(3, null);
            return result != null ? result.returnCode : -1;
        }

        public int changePassword(String oldPassword, String newPassword) {
            Reply result = mServiceCommand.execute(2, oldPassword + COMMAND_DELIMITER + newPassword);
            return result != null ? result.returnCode : -1;
        }

        public int setPassword(String firstPassword) {
            Reply result = mServiceCommand.execute(2, firstPassword);
            return result != null ? result.returnCode : -1;
        }

        public String[] listKeys(String namespace) {
            Reply result = mServiceCommand.execute(4, namespace);
            if (result == null || result.returnCode != 0 || result.len == 0) {
                return NOTFOUND;
            }
            return new String(result.data, 0, result.len).split("\\s+");
        }

        public int put(String namespace, String keyname, String value) {
            Reply result = mServiceCommand.execute(6, namespace + COMMAND_DELIMITER + keyname + COMMAND_DELIMITER + value);
            return result != null ? result.returnCode : -1;
        }

        public String get(String namespace, String keyname) {
            Reply result = mServiceCommand.execute(5, namespace + COMMAND_DELIMITER + keyname);
            return result != null ? (result.returnCode != 0 ? null : new String(result.data, 0, result.len)) : null;
        }

        public int remove(String namespace, String keyname) {
            Reply result = mServiceCommand.execute(7, namespace + COMMAND_DELIMITER + keyname);
            return result != null ? result.returnCode : -1;
        }

        public int reset() {
            Reply result = mServiceCommand.execute(8, null);
            return result != null ? result.returnCode : -1;
        }

        public /* synthetic */ FileKeystore(1 x0) {
            this();
        }
    }
}

