/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.security.Reply;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ServiceCommand {
    public static final String SUCCESS = "0";
    public static final String FAILED = "-1";
    public static final int LOCK = 0;
    public static final int UNLOCK = 1;
    public static final int PASSWD = 2;
    public static final int GET_STATE = 3;
    public static final int LIST_KEYS = 4;
    public static final int GET_KEY = 5;
    public static final int PUT_KEY = 6;
    public static final int REMOVE_KEY = 7;
    public static final int RESET = 8;
    public static final int MAX_CMD_INDEX = 9;
    public static final int BUFFER_LENGTH = 4096;
    public static final boolean DBG = true;
    public String mServiceName;
    public String mTag;
    public InputStream mIn;
    public OutputStream mOut;
    public LocalSocket mSocket;

    public boolean connect() {
        if (this.mSocket != null) {
            return true;
        }
        Log.d(this.mTag, "connecting...");
        try {
            this.mSocket = new LocalSocket();
            LocalSocketAddress address = new LocalSocketAddress(this.mServiceName, LocalSocketAddress.Namespace.RESERVED);
            this.mSocket.connect(address);
            this.mIn = this.mSocket.getInputStream();
            this.mOut = this.mSocket.getOutputStream();
        }
        catch (IOException ex) {
            this.disconnect();
            return false;
        }
        return true;
    }

    public void disconnect() {
        Log.d(this.mTag, "disconnecting...");
        try {
            if (this.mSocket != null) {
                this.mSocket.close();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            if (this.mIn != null) {
                this.mIn.close();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            if (this.mOut != null) {
                this.mOut.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mSocket = null;
        this.mIn = null;
        this.mOut = null;
    }

    public boolean readBytes(byte[] buffer, int len) {
        int off;
        int count;
        if (len < 0) {
            return false;
        }
        for (off = 0; off != len; off += count) {
            try {
                count = this.mIn.read(buffer, off, len - off);
                if (count > 0) continue;
                Log.e(this.mTag, "read error " + count);
                break;
            }
            catch (IOException ex) {
                Log.e(this.mTag, "read exception", ex);
                break;
            }
        }
        if (off == len) {
            return true;
        }
        this.disconnect();
        return false;
    }

    public Reply readReply() {
        byte[] buf = new byte[4];
        Reply reply = new Reply();
        if (!this.readBytes(buf, 4)) {
            return null;
        }
        reply.len = buf[0] & 0xFF | (buf[1] & 0xFF) << 8 | (buf[2] & 0xFF) << 16 | (buf[3] & 0xFF) << 24;
        if (!this.readBytes(buf, 4)) {
            return null;
        }
        reply.returnCode = buf[0] & 0xFF | (buf[1] & 0xFF) << 8 | (buf[2] & 0xFF) << 16 | (buf[3] & 0xFF) << 24;
        if (reply.len > 4096) {
            Log.e(this.mTag, "invalid reply length (" + reply.len + ")");
            this.disconnect();
            return null;
        }
        if (!this.readBytes(reply.data, reply.len)) {
            return null;
        }
        return reply;
    }

    public boolean writeCommand(int cmd, String _data) {
        byte[] buf = new byte[8];
        byte[] data = _data == null ? new byte[]{} : _data.getBytes();
        int len = data.length;
        buf[0] = (byte)(len & 0xFF);
        buf[1] = (byte)(len >> 8 & 0xFF);
        buf[2] = (byte)(len >> 16 & 0xFF);
        buf[3] = (byte)(len >> 24 & 0xFF);
        buf[4] = (byte)(cmd & 0xFF);
        buf[5] = (byte)(cmd >> 8 & 0xFF);
        buf[6] = (byte)(cmd >> 16 & 0xFF);
        buf[7] = (byte)(cmd >> 24 & 0xFF);
        try {
            this.mOut.write(buf, 0, 8);
            this.mOut.write(data, 0, len);
        }
        catch (IOException ex) {
            Log.e(this.mTag, "write error", ex);
            this.disconnect();
            return false;
        }
        return true;
    }

    public Reply executeCommand(int cmd, String data) {
        if (!this.writeCommand(cmd, data)) {
            Log.e(this.mTag, "write command failed? reconnect!");
            if (!this.connect() || !this.writeCommand(cmd, data)) {
                return null;
            }
        }
        return this.readReply();
    }

    public synchronized Reply execute(int cmd, String data) {
        if (!this.connect()) {
            Log.e(this.mTag, "connection failed");
            return null;
        }
        Reply result = this.executeCommand(cmd, data);
        this.disconnect();
        return result;
    }

    public ServiceCommand(String service) {
        this.mServiceName = service;
        this.mTag = service;
    }
}

