/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.util.Pool;
import android.util.Poolable;
import android.util.PoolableManager;
import android.util.Pools;
import android.view.MotionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VelocityTracker
implements Poolable<VelocityTracker> {
    public static final String TAG = "VelocityTracker";
    public static final boolean DEBUG = false;
    public static final boolean localLOGV = false;
    public static final int NUM_PAST = 10;
    public static final int LONGEST_PAST_TIME = 200;
    public static final VelocityTracker[] mPool = new VelocityTracker[1];
    public static final Pool<VelocityTracker> sPool = Pools.synchronizedPool(Pools.finitePool(new PoolableManager<VelocityTracker>(){

        @Override
        public VelocityTracker newInstance() {
            return new VelocityTracker(null);
        }

        @Override
        public void onAcquired(VelocityTracker element) {
            element.clear();
        }

        @Override
        public void onReleased(VelocityTracker element) {
        }
    }, 2));
    public final float[] mPastX = new float[10];
    public final float[] mPastY = new float[10];
    public final long[] mPastTime = new long[10];
    public float mYVelocity;
    public float mXVelocity;
    public VelocityTracker mNext;

    public static VelocityTracker obtain() {
        return sPool.acquire();
    }

    public void recycle() {
        sPool.release(this);
    }

    @Override
    public void setNextPoolable(VelocityTracker element) {
        this.mNext = element;
    }

    @Override
    public VelocityTracker getNextPoolable() {
        return this.mNext;
    }

    public VelocityTracker() {
    }

    public void clear() {
        this.mPastTime[0] = 0L;
    }

    public void addMovement(MotionEvent ev) {
        long time = ev.getEventTime();
        int N = ev.getHistorySize();
        for (int i = 0; i < N; ++i) {
            this.addPoint(ev.getHistoricalX(i), ev.getHistoricalY(i), ev.getHistoricalEventTime(i));
        }
        this.addPoint(ev.getX(), ev.getY(), time);
    }

    public void addPoint(float x, float y, long time) {
        int i;
        int drop = -1;
        long[] pastTime = this.mPastTime;
        for (i = 0; i < 10 && pastTime[i] != 0L; ++i) {
            if (pastTime[i] >= time - 200L) continue;
            drop = i;
        }
        if (i == 10 && drop < 0) {
            drop = 0;
        }
        if (drop == i) {
            --drop;
        }
        float[] pastX = this.mPastX;
        float[] pastY = this.mPastY;
        if (drop >= 0) {
            int start = drop + 1;
            int count = 10 - drop - 1;
            System.arraycopy(pastX, start, pastX, 0, count);
            System.arraycopy(pastY, start, pastY, 0, count);
            System.arraycopy(pastTime, start, pastTime, 0, count);
            i -= drop + 1;
        }
        pastX[i] = x;
        pastY[i] = y;
        pastTime[i] = time;
        if (++i < 10) {
            pastTime[i] = 0L;
        }
    }

    public void computeCurrentVelocity(int units) {
        this.computeCurrentVelocity(units, Float.MAX_VALUE);
    }

    public void computeCurrentVelocity(int units, float maxVelocity) {
        int N;
        float[] pastX = this.mPastX;
        float[] pastY = this.mPastY;
        long[] pastTime = this.mPastTime;
        float oldestX = pastX[0];
        float oldestY = pastY[0];
        long oldestTime = pastTime[0];
        float accumX = 0.0f;
        float accumY = 0.0f;
        for (N = 0; N < 10 && pastTime[N] != 0L; ++N) {
        }
        if (N > 3) {
            --N;
        }
        for (int i = 1; i < N; ++i) {
            int dur = (int)(pastTime[i] - oldestTime);
            if (dur == 0) continue;
            float dist = pastX[i] - oldestX;
            float vel = dist / (float)dur * (float)units;
            accumX = accumX == 0.0f ? vel : (accumX + vel) * 0.5f;
            dist = pastY[i] - oldestY;
            vel = dist / (float)dur * (float)units;
            accumY = accumY == 0.0f ? vel : (accumY + vel) * 0.5f;
        }
        this.mXVelocity = accumX < 0.0f ? Math.max(accumX, -maxVelocity) : Math.min(accumX, maxVelocity);
        this.mYVelocity = accumY < 0.0f ? Math.max(accumY, -maxVelocity) : Math.min(accumY, maxVelocity);
    }

    public float getXVelocity() {
        return this.mXVelocity;
    }

    public float getYVelocity() {
        return this.mYVelocity;
    }

    public /* synthetic */ VelocityTracker(1 x0) {
        this();
    }
}

