/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.Resources;
import android.media.AudioManager;
import android.media.AudioService;
import android.media.AudioSystem;
import android.media.ToneGenerator;
import android.os.Handler;
import android.os.Message;
import android.os.Vibrator;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

public class VolumePanel
extends Handler {
    public static final String TAG = "VolumePanel";
    public static boolean LOGD = true;
    public static final int PLAY_SOUND_DELAY = 300;
    public static final int VIBRATE_DELAY = 300;
    public static final int VIBRATE_DURATION = 300;
    public static final int BEEP_DURATION = 150;
    public static final int MAX_VOLUME = 100;
    public static final int FREE_DELAY = 10000;
    public static final int MSG_VOLUME_CHANGED = 0;
    public static final int MSG_FREE_RESOURCES = 1;
    public static final int MSG_PLAY_SOUND = 2;
    public static final int MSG_STOP_SOUNDS = 3;
    public static final int MSG_VIBRATE = 4;
    public static final int RINGTONE_VOLUME_TEXT = 17039997;
    public static final int MUSIC_VOLUME_TEXT = 17039998;
    public static final int INCALL_VOLUME_TEXT = 17040000;
    public static final int ALARM_VOLUME_TEXT = 17040002;
    public static final int UNKNOWN_VOLUME_TEXT = 17040004;
    public static final int NOTIFICATION_VOLUME_TEXT = 17040003;
    public static final int BLUETOOTH_INCALL_VOLUME_TEXT = 17040001;
    public Context mContext;
    public AudioManager mAudioManager;
    public AudioService mAudioService;
    public final Toast mToast;
    public final View mView;
    public final TextView mMessage;
    public final TextView mAdditionalMessage;
    public final ImageView mSmallStreamIcon;
    public final ImageView mLargeStreamIcon;
    public final ProgressBar mLevel;
    public ToneGenerator[] mToneGenerators;
    public Vibrator mVibrator;

    public VolumePanel(Context context, AudioService volumeService) {
        this.mContext = context;
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mAudioService = volumeService;
        this.mToast = new Toast(context);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View view = this.mView = inflater.inflate(17367142, null);
        this.mMessage = (TextView)view.findViewById(16908299);
        this.mAdditionalMessage = (TextView)view.findViewById(16908774);
        this.mSmallStreamIcon = (ImageView)view.findViewById(16908773);
        this.mLargeStreamIcon = (ImageView)view.findViewById(16908775);
        this.mLevel = (ProgressBar)view.findViewById(16908653);
        this.mToneGenerators = new ToneGenerator[AudioSystem.getNumStreamTypes()];
        this.mVibrator = new Vibrator();
    }

    public void postVolumeChanged(int streamType, int flags) {
        if (this.hasMessages(0)) {
            return;
        }
        this.removeMessages(1);
        this.obtainMessage(0, streamType, flags).sendToTarget();
    }

    public void onVolumeChanged(int streamType, int flags) {
        if (LOGD) {
            Log.d(TAG, "onVolumeChanged(streamType: " + streamType + ", flags: " + flags + ")");
        }
        if ((flags & 1) != 0) {
            this.onShowVolumeChanged(streamType, flags);
        }
        if ((flags & 4) != 0) {
            this.removeMessages(2);
            this.sendMessageDelayed(this.obtainMessage(2, streamType, flags), 300L);
        }
        if ((flags & 8) != 0) {
            this.removeMessages(2);
            this.removeMessages(4);
            this.onStopSounds();
        }
        this.removeMessages(1);
        this.sendMessageDelayed(this.obtainMessage(1), 10000L);
    }

    public void onShowVolumeChanged(int streamType, int flags) {
        int index = this.mAudioService.getStreamVolume(streamType);
        int message = 17040004;
        int additionalMessage = 0;
        if (LOGD) {
            Log.d(TAG, "onShowVolumeChanged(streamType: " + streamType + ", flags: " + flags + "), index: " + index);
        }
        int max = this.mAudioService.getStreamMaxVolume(streamType);
        switch (streamType) {
            case 2: {
                message = 17039997;
                this.setRingerIcon(index);
                break;
            }
            case 3: {
                message = 17039998;
                if (this.mAudioManager.isBluetoothA2dpOn()) {
                    additionalMessage = 17039999;
                    this.setLargeIcon(17301920);
                    break;
                }
                this.setSmallIcon(index);
                break;
            }
            case 0: {
                ++max;
                message = 17040000;
                this.setSmallIcon(++index);
                break;
            }
            case 4: {
                message = 17040002;
                this.setSmallIcon(index);
                break;
            }
            case 5: {
                message = 17040003;
                this.setSmallIcon(index);
                break;
            }
            case 6: {
                ++index;
                ++max;
                message = 17040001;
                this.setLargeIcon(17301921);
            }
        }
        String messageString = Resources.getSystem().getString(message);
        if (!this.mMessage.getText().equals(messageString)) {
            this.mMessage.setText(messageString);
        }
        if (additionalMessage == 0) {
            this.mAdditionalMessage.setVisibility(8);
        } else {
            this.mAdditionalMessage.setVisibility(0);
            this.mAdditionalMessage.setText(Resources.getSystem().getString(additionalMessage));
        }
        if (max != this.mLevel.getMax()) {
            this.mLevel.setMax(max);
        }
        this.mLevel.setProgress(index);
        this.mToast.setView(this.mView);
        this.mToast.setDuration(0);
        this.mToast.setGravity(48, 0, 0);
        this.mToast.show();
        if ((flags & 0x10) != 0 && this.mAudioService.isStreamAffectedByRingerMode(streamType) && this.mAudioService.getRingerMode() == 1 && this.mAudioService.shouldVibrate(0)) {
            this.sendMessageDelayed(this.obtainMessage(4), 300L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPlaySound(int streamType, int flags) {
        if (this.hasMessages(3)) {
            this.removeMessages(3);
            this.onStopSounds();
        }
        VolumePanel volumePanel = this;
        synchronized (volumePanel) {
            ToneGenerator toneGen = this.getOrCreateToneGenerator(streamType);
            toneGen.startTone(24);
        }
        this.sendMessageDelayed(this.obtainMessage(3), 150L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStopSounds() {
        VolumePanel volumePanel = this;
        synchronized (volumePanel) {
            int numStreamTypes = AudioSystem.getNumStreamTypes();
            for (int i = numStreamTypes - 1; i >= 0; --i) {
                ToneGenerator toneGen = this.mToneGenerators[i];
                if (toneGen == null) continue;
                toneGen.stopTone();
            }
        }
    }

    public void onVibrate() {
        if (this.mAudioService.getRingerMode() != 1) {
            return;
        }
        this.mVibrator.vibrate(300L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ToneGenerator getOrCreateToneGenerator(int streamType) {
        VolumePanel volumePanel = this;
        synchronized (volumePanel) {
            if (this.mToneGenerators[streamType] == null) {
                this.mToneGenerators[streamType] = new ToneGenerator(streamType, 100);
                return this.mToneGenerators[streamType];
            }
            return this.mToneGenerators[streamType];
        }
    }

    public void setSmallIcon(int index) {
        this.mLargeStreamIcon.setVisibility(8);
        this.mSmallStreamIcon.setVisibility(0);
        this.mSmallStreamIcon.setImageResource(index == 0 ? 17301923 : 17301924);
    }

    public void setLargeIcon(int resId) {
        this.mSmallStreamIcon.setVisibility(8);
        this.mLargeStreamIcon.setVisibility(0);
        this.mLargeStreamIcon.setImageResource(resId);
    }

    public void setRingerIcon(int index) {
        this.mSmallStreamIcon.setVisibility(8);
        this.mLargeStreamIcon.setVisibility(0);
        int ringerMode = this.mAudioService.getRingerMode();
        if (LOGD) {
            Log.d(TAG, "setRingerIcon(index: " + index + "), ringerMode: " + ringerMode);
        }
        int icon = ringerMode == 0 ? 17301922 : (ringerMode == 1 ? 17301918 : 17301919);
        this.mLargeStreamIcon.setImageResource(icon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFreeResources() {
        this.mSmallStreamIcon.setImageDrawable(null);
        this.mLargeStreamIcon.setImageDrawable(null);
        VolumePanel volumePanel = this;
        synchronized (volumePanel) {
            for (int i = this.mToneGenerators.length - 1; i >= 0; --i) {
                if (this.mToneGenerators[i] != null) {
                    this.mToneGenerators[i].release();
                }
                this.mToneGenerators[i] = null;
            }
        }
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                this.onVolumeChanged(msg.arg1, msg.arg2);
                break;
            }
            case 1: {
                this.onFreeResources();
                break;
            }
            case 3: {
                this.onStopSounds();
                break;
            }
            case 2: {
                this.onPlaySound(msg.arg1, msg.arg2);
                break;
            }
            case 4: {
                this.onVibrate();
            }
        }
    }
}

