/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.AnticipateOvershootInterpolator;
import android.view.animation.BounceInterpolator;
import android.view.animation.CycleInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.GridLayoutAnimationController;
import android.view.animation.Interpolator;
import android.view.animation.LayoutAnimationController;
import android.view.animation.LinearInterpolator;
import android.view.animation.OvershootInterpolator;
import android.view.animation.RotateAnimation;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimationUtils {
    public static long currentAnimationTimeMillis() {
        return SystemClock.uptimeMillis();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Animation loadAnimation(Context context, int id2) throws Resources.NotFoundException {
        XmlResourceParser parser = null;
        try {
            try {
                parser = context.getResources().getAnimation(id2);
                Animation animation = AnimationUtils.createAnimationFromXml(context, parser);
                Object var6_6 = null;
                if (parser == null) return animation;
                parser.close();
                return animation;
            }
            catch (XmlPullParserException ex) {
                Resources.NotFoundException rnf = new Resources.NotFoundException("Can't load animation resource ID #0x" + Integer.toHexString(id2));
                rnf.initCause(ex);
                throw rnf;
            }
            catch (IOException ex) {
                Resources.NotFoundException rnf = new Resources.NotFoundException("Can't load animation resource ID #0x" + Integer.toHexString(id2));
                rnf.initCause(ex);
                throw rnf;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (parser == null) throw throwable;
            parser.close();
            throw throwable;
        }
    }

    public static Animation createAnimationFromXml(Context c, XmlPullParser parser) throws XmlPullParserException, IOException {
        return AnimationUtils.createAnimationFromXml(c, parser, null, Xml.asAttributeSet(parser));
    }

    public static Animation createAnimationFromXml(Context c, XmlPullParser parser, AnimationSet parent, AttributeSet attrs) throws XmlPullParserException, IOException {
        int type;
        Animation anim2 = null;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if (name.equals("set")) {
                anim2 = new AnimationSet(c, attrs);
                AnimationUtils.createAnimationFromXml(c, parser, anim2, attrs);
            } else if (name.equals("alpha")) {
                anim2 = new AlphaAnimation(c, attrs);
            } else if (name.equals("scale")) {
                anim2 = new ScaleAnimation(c, attrs);
            } else if (name.equals("rotate")) {
                anim2 = new RotateAnimation(c, attrs);
            } else if (name.equals("translate")) {
                anim2 = new TranslateAnimation(c, attrs);
            } else {
                throw new RuntimeException("Unknown animation name: " + parser.getName());
            }
            if (parent == null) continue;
            parent.addAnimation(anim2);
        }
        return anim2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LayoutAnimationController loadLayoutAnimation(Context context, int id2) throws Resources.NotFoundException {
        XmlResourceParser parser = null;
        try {
            try {
                parser = context.getResources().getAnimation(id2);
                LayoutAnimationController layoutAnimationController = AnimationUtils.createLayoutAnimationFromXml(context, parser);
                Object var6_6 = null;
                if (parser == null) return layoutAnimationController;
                parser.close();
                return layoutAnimationController;
            }
            catch (XmlPullParserException ex) {
                Resources.NotFoundException rnf = new Resources.NotFoundException("Can't load animation resource ID #0x" + Integer.toHexString(id2));
                rnf.initCause(ex);
                throw rnf;
            }
            catch (IOException ex) {
                Resources.NotFoundException rnf = new Resources.NotFoundException("Can't load animation resource ID #0x" + Integer.toHexString(id2));
                rnf.initCause(ex);
                throw rnf;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (parser == null) throw throwable;
            parser.close();
            throw throwable;
        }
    }

    public static LayoutAnimationController createLayoutAnimationFromXml(Context c, XmlPullParser parser) throws XmlPullParserException, IOException {
        return AnimationUtils.createLayoutAnimationFromXml(c, parser, Xml.asAttributeSet(parser));
    }

    public static LayoutAnimationController createLayoutAnimationFromXml(Context c, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        int type;
        LayoutAnimationController controller = null;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if ("layoutAnimation".equals(name)) {
                controller = new LayoutAnimationController(c, attrs);
                continue;
            }
            if ("gridLayoutAnimation".equals(name)) {
                controller = new GridLayoutAnimationController(c, attrs);
                continue;
            }
            throw new RuntimeException("Unknown layout animation name: " + name);
        }
        return controller;
    }

    public static Animation makeInAnimation(Context c, boolean fromLeft) {
        Animation a = fromLeft ? AnimationUtils.loadAnimation(c, 17432578) : AnimationUtils.loadAnimation(c, 17432613);
        a.setInterpolator(new DecelerateInterpolator());
        a.setStartTime(AnimationUtils.currentAnimationTimeMillis());
        return a;
    }

    public static Animation makeOutAnimation(Context c, boolean toRight) {
        Animation a = toRight ? AnimationUtils.loadAnimation(c, 17432579) : AnimationUtils.loadAnimation(c, 17432616);
        a.setInterpolator(new AccelerateInterpolator());
        a.setStartTime(AnimationUtils.currentAnimationTimeMillis());
        return a;
    }

    public static Animation makeInChildBottomAnimation(Context c) {
        Animation a = AnimationUtils.loadAnimation(c, 17432612);
        a.setInterpolator(new AccelerateInterpolator());
        a.setStartTime(AnimationUtils.currentAnimationTimeMillis());
        return a;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Interpolator loadInterpolator(Context context, int id2) throws Resources.NotFoundException {
        XmlResourceParser parser = null;
        try {
            try {
                parser = context.getResources().getAnimation(id2);
                Interpolator interpolator = AnimationUtils.createInterpolatorFromXml(context, parser);
                Object var6_6 = null;
                if (parser == null) return interpolator;
                parser.close();
                return interpolator;
            }
            catch (XmlPullParserException ex) {
                Resources.NotFoundException rnf = new Resources.NotFoundException("Can't load animation resource ID #0x" + Integer.toHexString(id2));
                rnf.initCause(ex);
                throw rnf;
            }
            catch (IOException ex) {
                Resources.NotFoundException rnf = new Resources.NotFoundException("Can't load animation resource ID #0x" + Integer.toHexString(id2));
                rnf.initCause(ex);
                throw rnf;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (parser == null) throw throwable;
            parser.close();
            throw throwable;
        }
    }

    public static Interpolator createInterpolatorFromXml(Context c, XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        Interpolator interpolator = null;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            AttributeSet attrs = Xml.asAttributeSet(parser);
            String name = parser.getName();
            if (name.equals("linearInterpolator")) {
                interpolator = new LinearInterpolator(c, attrs);
                continue;
            }
            if (name.equals("accelerateInterpolator")) {
                interpolator = new AccelerateInterpolator(c, attrs);
                continue;
            }
            if (name.equals("decelerateInterpolator")) {
                interpolator = new DecelerateInterpolator(c, attrs);
                continue;
            }
            if (name.equals("accelerateDecelerateInterpolator")) {
                interpolator = new AccelerateDecelerateInterpolator(c, attrs);
                continue;
            }
            if (name.equals("cycleInterpolator")) {
                interpolator = new CycleInterpolator(c, attrs);
                continue;
            }
            if (name.equals("anticipateInterpolator")) {
                interpolator = new AnticipateInterpolator(c, attrs);
                continue;
            }
            if (name.equals("overshootInterpolator")) {
                interpolator = new OvershootInterpolator(c, attrs);
                continue;
            }
            if (name.equals("anticipateOvershootInterpolator")) {
                interpolator = new AnticipateOvershootInterpolator(c, attrs);
                continue;
            }
            if (name.equals("bounceInterpolator")) {
                interpolator = new BounceInterpolator(c, attrs);
                continue;
            }
            throw new RuntimeException("Unknown interpolator name: " + parser.getName());
        }
        return interpolator;
    }
}

