/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.webkit.DownloadListener;
import android.webkit.HttpAuthHandler;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.SslErrorHandler;
import android.webkit.URLUtil;
import android.webkit.WebBackForwardList;
import android.webkit.WebChromeClient;
import android.webkit.WebHistoryItem;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.EditText;
import android.widget.TextView;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;

public class CallbackProxy
extends Handler {
    public static final String LOGTAG = "CallbackProxy";
    public volatile WebViewClient mWebViewClient;
    public volatile WebChromeClient mWebChromeClient;
    public final WebView mWebView;
    public volatile DownloadListener mDownloadListener;
    public boolean mProgressUpdatePending;
    public volatile int mLatestProgress;
    public final WebBackForwardList mBackForwardList;
    public final Context mContext;
    public static final int PAGE_STARTED = 100;
    public static final int RECEIVED_ICON = 101;
    public static final int RECEIVED_TITLE = 102;
    public static final int OVERRIDE_URL = 103;
    public static final int AUTH_REQUEST = 104;
    public static final int SSL_ERROR = 105;
    public static final int PROGRESS = 106;
    public static final int UPDATE_VISITED = 107;
    public static final int LOAD_RESOURCE = 108;
    public static final int CREATE_WINDOW = 109;
    public static final int CLOSE_WINDOW = 110;
    public static final int SAVE_PASSWORD = 111;
    public static final int JS_ALERT = 112;
    public static final int JS_CONFIRM = 113;
    public static final int JS_PROMPT = 114;
    public static final int JS_UNLOAD = 115;
    public static final int ASYNC_KEYEVENTS = 116;
    public static final int TOO_MANY_REDIRECTS = 117;
    public static final int DOWNLOAD_FILE = 118;
    public static final int REPORT_ERROR = 119;
    public static final int RESEND_POST_DATA = 120;
    public static final int PAGE_FINISHED = 121;
    public static final int REQUEST_FOCUS = 122;
    public static final int SCALE_CHANGED = 123;
    public static final int RECEIVED_CERTIFICATE = 124;
    public static final int SWITCH_OUT_HISTORY = 125;
    public static final int JS_TIMEOUT = 126;
    public static final int NOTIFY = 200;
    public long mWebCoreThreadTime;

    public CallbackProxy(Context context, WebView w) {
        this.mContext = context;
        this.mWebView = w;
        this.mBackForwardList = new WebBackForwardList();
    }

    public void setWebViewClient(WebViewClient client) {
        this.mWebViewClient = client;
    }

    public void setWebChromeClient(WebChromeClient client) {
        this.mWebChromeClient = client;
    }

    public void setDownloadListener(DownloadListener client) {
        this.mDownloadListener = client;
    }

    public WebBackForwardList getBackForwardList() {
        return this.mBackForwardList;
    }

    public boolean uiOverrideUrlLoading(String overrideUrl) {
        if (overrideUrl == null || overrideUrl.length() == 0) {
            return false;
        }
        boolean override = false;
        if (this.mWebViewClient != null) {
            override = this.mWebViewClient.shouldOverrideUrlLoading(this.mWebView, overrideUrl);
        } else {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse(overrideUrl));
            intent.addCategory("android.intent.category.BROWSABLE");
            intent.putExtra("com.android.browser.application_id", this.mContext.getPackageName());
            try {
                this.mContext.startActivity(intent);
                override = true;
            }
            catch (ActivityNotFoundException ex) {
                // empty catch block
            }
        }
        return override;
    }

    public boolean uiOverrideKeyEvent(KeyEvent event) {
        if (this.mWebViewClient != null) {
            return this.mWebViewClient.shouldOverrideKeyEvent(this.mWebView, event);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 100: {
                if (this.mWebViewClient == null) break;
                this.mWebViewClient.onPageStarted(this.mWebView, msg.getData().getString("url"), (Bitmap)msg.obj);
                break;
            }
            case 121: {
                if (this.mWebViewClient == null) break;
                this.mWebViewClient.onPageFinished(this.mWebView, (String)msg.obj);
                break;
            }
            case 101: {
                if (this.mWebChromeClient == null) break;
                this.mWebChromeClient.onReceivedIcon(this.mWebView, (Bitmap)msg.obj);
                break;
            }
            case 102: {
                if (this.mWebChromeClient == null) break;
                this.mWebChromeClient.onReceivedTitle(this.mWebView, (String)msg.obj);
                break;
            }
            case 117: {
                Message cancelMsg = (Message)msg.getData().getParcelable("cancelMsg");
                Message continueMsg = (Message)msg.getData().getParcelable("continueMsg");
                if (this.mWebViewClient != null) {
                    this.mWebViewClient.onTooManyRedirects(this.mWebView, cancelMsg, continueMsg);
                    break;
                }
                cancelMsg.sendToTarget();
                break;
            }
            case 119: {
                if (this.mWebViewClient == null) break;
                int reasonCode = msg.arg1;
                String description = msg.getData().getString("description");
                String failUrl = msg.getData().getString("failingUrl");
                this.mWebViewClient.onReceivedError(this.mWebView, reasonCode, description, failUrl);
                break;
            }
            case 120: {
                Message resend = (Message)msg.getData().getParcelable("resend");
                Message dontResend = (Message)msg.getData().getParcelable("dontResend");
                if (this.mWebViewClient != null) {
                    this.mWebViewClient.onFormResubmission(this.mWebView, dontResend, resend);
                    break;
                }
                dontResend.sendToTarget();
                break;
            }
            case 103: {
                String overrideUrl = msg.getData().getString("url");
                boolean override = this.uiOverrideUrlLoading(overrideUrl);
                ResultTransport result = (ResultTransport)msg.obj;
                CallbackProxy callbackProxy = this;
                synchronized (callbackProxy) {
                    result.setResult(override);
                    this.notify();
                    break;
                }
            }
            case 104: {
                if (this.mWebViewClient == null) break;
                HttpAuthHandler handler = (HttpAuthHandler)msg.obj;
                String host = msg.getData().getString("host");
                String realm = msg.getData().getString("realm");
                this.mWebViewClient.onReceivedHttpAuthRequest(this.mWebView, handler, host, realm);
                break;
            }
            case 105: {
                if (this.mWebViewClient == null) break;
                HashMap map = (HashMap)msg.obj;
                this.mWebViewClient.onReceivedSslError(this.mWebView, (SslErrorHandler)map.get("handler"), (SslError)map.get("error"));
                break;
            }
            case 106: {
                CallbackProxy map = this;
                synchronized (map) {
                    if (this.mWebChromeClient != null) {
                        this.mWebChromeClient.onProgressChanged(this.mWebView, this.mLatestProgress);
                    }
                    this.mProgressUpdatePending = false;
                    break;
                }
            }
            case 107: {
                if (this.mWebViewClient == null) break;
                this.mWebViewClient.doUpdateVisitedHistory(this.mWebView, (String)msg.obj, msg.arg1 != 0);
                break;
            }
            case 108: {
                if (this.mWebViewClient == null) break;
                this.mWebViewClient.onLoadResource(this.mWebView, (String)msg.obj);
                break;
            }
            case 118: {
                if (this.mDownloadListener == null) break;
                String url = msg.getData().getString("url");
                String userAgent = msg.getData().getString("userAgent");
                String contentDisposition = msg.getData().getString("contentDisposition");
                String mimetype = msg.getData().getString("mimetype");
                Long contentLength = msg.getData().getLong("contentLength");
                this.mDownloadListener.onDownloadStart(url, userAgent, contentDisposition, mimetype, contentLength);
                break;
            }
            case 109: {
                if (this.mWebChromeClient == null || this.mWebChromeClient.onCreateWindow(this.mWebView, msg.arg1 == 1, msg.arg2 == 1, (Message)msg.obj)) break;
                CallbackProxy url = this;
                synchronized (url) {
                    this.notify();
                    break;
                }
            }
            case 122: {
                if (this.mWebChromeClient == null) break;
                this.mWebChromeClient.onRequestFocus(this.mWebView);
                break;
            }
            case 110: {
                if (this.mWebChromeClient == null) break;
                this.mWebChromeClient.onCloseWindow((WebView)msg.obj);
                break;
            }
            case 111: {
                Bundle bundle = msg.getData();
                String schemePlusHost = bundle.getString("host");
                String username = bundle.getString("username");
                String password = bundle.getString("password");
                if (this.mWebView.onSavePassword(schemePlusHost, username, password, (Message)msg.obj)) break;
                CallbackProxy contentLength = this;
                synchronized (contentLength) {
                    this.notify();
                    break;
                }
            }
            case 116: {
                if (this.mWebViewClient == null) break;
                this.mWebViewClient.onUnhandledKeyEvent(this.mWebView, (KeyEvent)msg.obj);
                break;
            }
            case 112: {
                if (this.mWebChromeClient == null) break;
                final JsResult res = (JsResult)msg.obj;
                String message = msg.getData().getString("message");
                String url = msg.getData().getString("url");
                if (!this.mWebChromeClient.onJsAlert(this.mWebView, url, message, res)) {
                    new AlertDialog.Builder(this.mContext).setTitle(this.getJsDialogTitle(url)).setMessage(message).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            res.confirm();
                        }
                    }).setCancelable(false).show();
                }
                res.setReady();
                break;
            }
            case 113: {
                if (this.mWebChromeClient == null) break;
                final JsResult res = (JsResult)msg.obj;
                String message = msg.getData().getString("message");
                String url = msg.getData().getString("url");
                if (!this.mWebChromeClient.onJsConfirm(this.mWebView, url, message, res)) {
                    new AlertDialog.Builder(this.mContext).setTitle(this.getJsDialogTitle(url)).setMessage(message).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            res.confirm();
                        }
                    }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            res.cancel();
                        }
                    }).show();
                }
                res.setReady();
                break;
            }
            case 114: {
                if (this.mWebChromeClient == null) break;
                final JsPromptResult res = (JsPromptResult)msg.obj;
                String message = msg.getData().getString("message");
                String defaultVal = msg.getData().getString("default");
                String url = msg.getData().getString("url");
                if (!this.mWebChromeClient.onJsPrompt(this.mWebView, url, message, defaultVal, res)) {
                    LayoutInflater factory = LayoutInflater.from(this.mContext);
                    View view = factory.inflate(17367084, null);
                    final EditText v = (EditText)view.findViewById(16908668);
                    v.setText(defaultVal);
                    ((TextView)view.findViewById(16908299)).setText(message);
                    new AlertDialog.Builder(this.mContext).setTitle(this.getJsDialogTitle(url)).setView(view).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int whichButton) {
                            res.confirm(v.getText().toString());
                        }
                    }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int whichButton) {
                            res.cancel();
                        }
                    }).setOnCancelListener(new DialogInterface.OnCancelListener(){

                        public void onCancel(DialogInterface dialog) {
                            res.cancel();
                        }
                    }).show();
                }
                res.setReady();
                break;
            }
            case 115: {
                if (this.mWebChromeClient == null) break;
                final JsResult res = (JsResult)msg.obj;
                String message = msg.getData().getString("message");
                String url = msg.getData().getString("url");
                if (!this.mWebChromeClient.onJsBeforeUnload(this.mWebView, url, message, res)) {
                    String m = this.mContext.getString(17039922, message);
                    new AlertDialog.Builder(this.mContext).setMessage(m).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            res.confirm();
                        }
                    }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            res.cancel();
                        }
                    }).show();
                }
                res.setReady();
                break;
            }
            case 126: {
                if (this.mWebChromeClient == null) break;
                JsResult res = (JsResult)msg.obj;
                if (this.mWebChromeClient.onJsTimeout()) {
                    res.confirm();
                } else {
                    res.cancel();
                }
                res.setReady();
                break;
            }
            case 124: {
                this.mWebView.setCertificate((SslCertificate)msg.obj);
                break;
            }
            case 200: {
                CallbackProxy callbackProxy = this;
                synchronized (callbackProxy) {
                    this.notify();
                    break;
                }
            }
            case 123: {
                if (this.mWebViewClient == null) break;
                this.mWebViewClient.onScaleChanged(this.mWebView, msg.getData().getFloat("old"), msg.getData().getFloat("new"));
                break;
            }
            case 125: {
                this.mWebView.switchOutDrawHistory();
            }
        }
    }

    public int getProgress() {
        return this.mLatestProgress;
    }

    public void switchOutDrawHistory() {
        this.sendMessage(this.obtainMessage(125));
    }

    public String getJsDialogTitle(String url) {
        String title = url;
        if (URLUtil.isDataUrl(url)) {
            title = this.mContext.getString(17039921);
        } else {
            try {
                URL aUrl = new URL(url);
                title = this.mContext.getString(17039920, aUrl.getProtocol() + "://" + aUrl.getHost());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return title;
    }

    public void onPageStarted(String url, Bitmap favicon) {
        if (this.mWebViewClient == null) {
            return;
        }
        Message msg = this.obtainMessage(100);
        msg.obj = favicon;
        msg.getData().putString("url", url);
        this.sendMessage(msg);
    }

    public void onPageFinished(String url) {
        if (this.mWebViewClient == null) {
            return;
        }
        Message msg = this.obtainMessage(121, url);
        this.sendMessage(msg);
    }

    public void onTooManyRedirects(Message cancelMsg, Message continueMsg) {
        if (this.mWebViewClient == null) {
            cancelMsg.sendToTarget();
            return;
        }
        Message msg = this.obtainMessage(117);
        Bundle bundle = msg.getData();
        bundle.putParcelable("cancelMsg", cancelMsg);
        bundle.putParcelable("continueMsg", continueMsg);
        this.sendMessage(msg);
    }

    public void onReceivedError(int errorCode, String description, String failingUrl) {
        if (this.mWebViewClient == null) {
            return;
        }
        Message msg = this.obtainMessage(119);
        msg.arg1 = errorCode;
        msg.getData().putString("description", description);
        msg.getData().putString("failingUrl", failingUrl);
        this.sendMessage(msg);
    }

    public void onFormResubmission(Message dontResend, Message resend) {
        if (this.mWebViewClient == null) {
            dontResend.sendToTarget();
            return;
        }
        Message msg = this.obtainMessage(120);
        Bundle bundle = msg.getData();
        bundle.putParcelable("resend", resend);
        bundle.putParcelable("dontResend", dontResend);
        this.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldOverrideUrlLoading(String url) {
        ResultTransport res = new ResultTransport(null);
        Message msg = this.obtainMessage(103);
        msg.getData().putString("url", url);
        msg.obj = res;
        CallbackProxy callbackProxy = this;
        synchronized (callbackProxy) {
            this.sendMessage(msg);
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Log.e(LOGTAG, "Caught exception while waiting for overrideUrl");
                Log.e(LOGTAG, Log.getStackTraceString(e));
            }
        }
        return (Boolean)res.getResult();
    }

    public void onReceivedHttpAuthRequest(HttpAuthHandler handler, String hostName, String realmName) {
        if (this.mWebViewClient == null) {
            handler.cancel();
            return;
        }
        Message msg = this.obtainMessage(104, handler);
        msg.getData().putString("host", hostName);
        msg.getData().putString("realm", realmName);
        this.sendMessage(msg);
    }

    public void onReceivedSslError(SslErrorHandler handler, SslError error) {
        if (this.mWebViewClient == null) {
            handler.cancel();
            return;
        }
        Message msg = this.obtainMessage(105);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("handler", handler);
        map.put("error", error);
        msg.obj = map;
        this.sendMessage(msg);
    }

    public void onReceivedCertificate(SslCertificate certificate) {
        if (this.mWebViewClient == null) {
            return;
        }
        this.sendMessage(this.obtainMessage(124, certificate));
    }

    public void doUpdateVisitedHistory(String url, boolean isReload) {
        if (this.mWebViewClient == null) {
            return;
        }
        this.sendMessage(this.obtainMessage(107, isReload ? 1 : 0, 0, url));
    }

    public void onLoadResource(String url) {
        if (this.mWebViewClient == null) {
            return;
        }
        this.sendMessage(this.obtainMessage(108, url));
    }

    public void onUnhandledKeyEvent(KeyEvent event) {
        if (this.mWebViewClient == null) {
            return;
        }
        this.sendMessage(this.obtainMessage(116, event));
    }

    public void onScaleChanged(float oldScale, float newScale) {
        if (this.mWebViewClient == null) {
            return;
        }
        Message msg = this.obtainMessage(123);
        Bundle bundle = msg.getData();
        bundle.putFloat("old", oldScale);
        bundle.putFloat("new", newScale);
        this.sendMessage(msg);
    }

    public boolean onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
        if (this.mDownloadListener == null) {
            return false;
        }
        Message msg = this.obtainMessage(118);
        Bundle bundle = msg.getData();
        bundle.putString("url", url);
        bundle.putString("userAgent", userAgent);
        bundle.putString("mimetype", mimetype);
        bundle.putLong("contentLength", contentLength);
        bundle.putString("contentDisposition", contentDisposition);
        this.sendMessage(msg);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onSavePassword(String schemePlusHost, String username, String password, Message resumeMsg) {
        resumeMsg = this.obtainMessage(200);
        Message msg = this.obtainMessage(111, resumeMsg);
        Bundle bundle = msg.getData();
        bundle.putString("host", schemePlusHost);
        bundle.putString("username", username);
        bundle.putString("password", password);
        CallbackProxy callbackProxy = this;
        synchronized (callbackProxy) {
            this.sendMessage(msg);
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Log.e(LOGTAG, "Caught exception while waiting for onSavePassword");
                Log.e(LOGTAG, Log.getStackTraceString(e));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onProgressChanged(int newProgress) {
        CallbackProxy callbackProxy = this;
        synchronized (callbackProxy) {
            this.mLatestProgress = newProgress;
            if (this.mWebChromeClient == null) {
                return;
            }
            if (!this.mProgressUpdatePending) {
                this.sendEmptyMessage(106);
                this.mProgressUpdatePending = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebView createWindow(boolean dialog, boolean userGesture) {
        if (this.mWebChromeClient == null) {
            return null;
        }
        WebView.WebViewTransport transport = new WebView.WebViewTransport(this.mWebView);
        Message msg = this.obtainMessage(200);
        msg.obj = transport;
        CallbackProxy callbackProxy = this;
        synchronized (callbackProxy) {
            this.sendMessage(this.obtainMessage(109, dialog ? 1 : 0, userGesture ? 1 : 0, msg));
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Log.e(LOGTAG, "Caught exception while waiting for createWindow");
                Log.e(LOGTAG, Log.getStackTraceString(e));
            }
        }
        WebView w = transport.getWebView();
        if (w != null) {
            w.getWebViewCore().initializeSubwindow();
        }
        return w;
    }

    public void onRequestFocus() {
        if (this.mWebChromeClient == null) {
            return;
        }
        this.sendEmptyMessage(122);
    }

    public void onCloseWindow(WebView window) {
        if (this.mWebChromeClient == null) {
            return;
        }
        this.sendMessage(this.obtainMessage(110, window));
    }

    public void onReceivedIcon(Bitmap icon) {
        WebHistoryItem i = this.mBackForwardList.getCurrentItem();
        if (i != null) {
            i.setFavicon(icon);
        }
        if (this.mWebChromeClient == null) {
            return;
        }
        this.sendMessage(this.obtainMessage(101, icon));
    }

    public void onReceivedTitle(String title) {
        if (this.mWebChromeClient == null) {
            return;
        }
        this.sendMessage(this.obtainMessage(102, title));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onJsAlert(String url, String message) {
        if (this.mWebChromeClient == null) {
            return;
        }
        JsResult result = new JsResult(this, false);
        Message alert = this.obtainMessage(112, result);
        alert.getData().putString("message", message);
        alert.getData().putString("url", url);
        CallbackProxy callbackProxy = this;
        synchronized (callbackProxy) {
            this.sendMessage(alert);
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Log.e(LOGTAG, "Caught exception while waiting for jsAlert");
                Log.e(LOGTAG, Log.getStackTraceString(e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onJsConfirm(String url, String message) {
        if (this.mWebChromeClient == null) {
            return false;
        }
        JsResult result = new JsResult(this, false);
        Message confirm = this.obtainMessage(113, result);
        confirm.getData().putString("message", message);
        confirm.getData().putString("url", url);
        CallbackProxy callbackProxy = this;
        synchronized (callbackProxy) {
            this.sendMessage(confirm);
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Log.e(LOGTAG, "Caught exception while waiting for jsConfirm");
                Log.e(LOGTAG, Log.getStackTraceString(e));
            }
        }
        return result.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String onJsPrompt(String url, String message, String defaultValue) {
        if (this.mWebChromeClient == null) {
            return null;
        }
        JsPromptResult result = new JsPromptResult(this);
        Message prompt = this.obtainMessage(114, result);
        prompt.getData().putString("message", message);
        prompt.getData().putString("default", defaultValue);
        prompt.getData().putString("url", url);
        CallbackProxy callbackProxy = this;
        synchronized (callbackProxy) {
            this.sendMessage(prompt);
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Log.e(LOGTAG, "Caught exception while waiting for jsPrompt");
                Log.e(LOGTAG, Log.getStackTraceString(e));
            }
        }
        return result.getStringResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onJsBeforeUnload(String url, String message) {
        if (this.mWebChromeClient == null) {
            return true;
        }
        JsResult result = new JsResult(this, true);
        Message confirm = this.obtainMessage(115, result);
        confirm.getData().putString("message", message);
        confirm.getData().putString("url", url);
        CallbackProxy callbackProxy = this;
        synchronized (callbackProxy) {
            this.sendMessage(confirm);
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Log.e(LOGTAG, "Caught exception while waiting for jsUnload");
                Log.e(LOGTAG, Log.getStackTraceString(e));
            }
        }
        return result.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onJsTimeout() {
        if (this.mWebChromeClient == null) {
            return true;
        }
        JsResult result = new JsResult(this, true);
        Message timeout = this.obtainMessage(126, result);
        CallbackProxy callbackProxy = this;
        synchronized (callbackProxy) {
            this.sendMessage(timeout);
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Log.e(LOGTAG, "Caught exception while waiting for jsUnload");
                Log.e(LOGTAG, Log.getStackTraceString(e));
            }
        }
        return result.getResult();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ResultTransport<E> {
        public E mResult;

        public ResultTransport() {
        }

        public synchronized void setResult(E result) {
            this.mResult = result;
        }

        public synchronized E getResult() {
            return this.mResult;
        }

        public /* synthetic */ ResultTransport(1 x1) {
            this();
        }
    }
}

