/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.net.http.Headers;
import android.webkit.LoadListener;
import android.webkit.StreamLoader;
import android.webkit.URLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FileLoader
extends StreamLoader {
    public String mPath;
    public Context mContext;
    public boolean mIsAsset;
    public boolean mAllowFileAccess;

    public FileLoader(String url, LoadListener loadListener, Context context, boolean asset, boolean allowFileAccess) {
        super(loadListener);
        this.mIsAsset = asset;
        this.mContext = context;
        this.mAllowFileAccess = allowFileAccess;
        int index = url.indexOf(63);
        this.mPath = this.mIsAsset ? (index > 0 ? URLUtil.stripAnchor(url.substring("file:///android_asset/".length(), index)) : URLUtil.stripAnchor(url.substring("file:///android_asset/".length()))) : (index > 0 ? URLUtil.stripAnchor(url.substring("file://".length(), index)) : URLUtil.stripAnchor(url.substring("file://".length())));
    }

    public boolean setupStreamAndSendStatus() {
        try {
            if (this.mIsAsset) {
                try {
                    this.mDataStream = this.mContext.getAssets().open(this.mPath);
                }
                catch (FileNotFoundException ex) {
                    this.mDataStream = this.mContext.getAssets().openNonAsset(this.mPath);
                }
            } else {
                if (!this.mAllowFileAccess) {
                    this.mHandler.error(-13, this.mContext.getString(17039604));
                    return false;
                }
                this.mDataStream = new FileInputStream(this.mPath);
                this.mContentLength = new File(this.mPath).length();
            }
            this.mHandler.status(1, 1, 0, "OK");
        }
        catch (FileNotFoundException ex) {
            this.mHandler.error(-14, this.mContext.getString(17039604) + " " + ex.getMessage());
            return false;
        }
        catch (IOException ex) {
            this.mHandler.error(-13, this.mContext.getString(17039604) + " " + ex.getMessage());
            return false;
        }
        return true;
    }

    public void buildHeaders(Headers headers) {
    }

    public static void requestUrl(String url, LoadListener loadListener, Context context, boolean asset, boolean allowFileAccess) {
        FileLoader loader = new FileLoader(url, loadListener, context, asset, allowFileAccess);
        loader.load();
    }
}

