/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.util.Log;
import android.view.RemotableViewMethod;
import android.view.View;
import android.widget.RemoteViews;
import com.android.internal.R;

@RemoteViews.RemoteView
public class ImageView
extends View {
    public Uri mUri;
    public int mResource = 0;
    public Matrix mMatrix;
    public ScaleType mScaleType;
    public boolean mHaveFrame = false;
    public boolean mAdjustViewBounds = false;
    public int mMaxWidth = Integer.MAX_VALUE;
    public int mMaxHeight = Integer.MAX_VALUE;
    public ColorFilter mColorFilter;
    public int mAlpha = 255;
    public int mViewAlphaScale = 256;
    public Drawable mDrawable = null;
    public int[] mState = null;
    public boolean mMergeState = false;
    public int mLevel = 0;
    public int mDrawableWidth;
    public int mDrawableHeight;
    public Matrix mDrawMatrix = null;
    public RectF mTempSrc = new RectF();
    public RectF mTempDst = new RectF();
    public boolean mCropToPadding;
    public boolean mBaselineAligned = false;
    public static final ScaleType[] sScaleTypeArray = new ScaleType[]{ScaleType.MATRIX, ScaleType.FIT_XY, ScaleType.FIT_START, ScaleType.FIT_CENTER, ScaleType.FIT_END, ScaleType.CENTER, ScaleType.CENTER_CROP, ScaleType.CENTER_INSIDE};
    public static final Matrix.ScaleToFit[] sS2FArray = new Matrix.ScaleToFit[]{Matrix.ScaleToFit.FILL, Matrix.ScaleToFit.START, Matrix.ScaleToFit.CENTER, Matrix.ScaleToFit.END};

    public ImageView(Context context) {
        super(context);
        this.initImageView();
    }

    public ImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        int tint;
        this.initImageView();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ImageView, defStyle, 0);
        Drawable d = a.getDrawable(0);
        if (d != null) {
            this.setImageDrawable(d);
        }
        this.mBaselineAligned = a.getBoolean(6, false);
        this.setAdjustViewBounds(a.getBoolean(2, false));
        this.setMaxWidth(a.getDimensionPixelSize(3, Integer.MAX_VALUE));
        this.setMaxHeight(a.getDimensionPixelSize(4, Integer.MAX_VALUE));
        int index = a.getInt(1, -1);
        if (index >= 0) {
            this.setScaleType(sScaleTypeArray[index]);
        }
        if ((tint = a.getInt(5, 0)) != 0) {
            this.setColorFilter(tint, PorterDuff.Mode.SRC_ATOP);
        }
        this.mCropToPadding = a.getBoolean(7, false);
        a.recycle();
    }

    public void initImageView() {
        this.mMatrix = new Matrix();
        this.mScaleType = ScaleType.FIT_CENTER;
    }

    public boolean verifyDrawable(Drawable dr) {
        return this.mDrawable == dr || super.verifyDrawable(dr);
    }

    public void invalidateDrawable(Drawable dr) {
        if (dr == this.mDrawable) {
            this.invalidate();
        } else {
            super.invalidateDrawable(dr);
        }
    }

    public boolean onSetAlpha(int alpha) {
        if (this.getBackground() == null) {
            int scale = alpha + (alpha >> 7);
            if (this.mViewAlphaScale != scale) {
                this.mViewAlphaScale = scale;
                this.applyColorMod();
            }
            return true;
        }
        return false;
    }

    @RemotableViewMethod
    public void setAdjustViewBounds(boolean adjustViewBounds) {
        this.mAdjustViewBounds = adjustViewBounds;
        if (adjustViewBounds) {
            this.setScaleType(ScaleType.FIT_CENTER);
        }
    }

    @RemotableViewMethod
    public void setMaxWidth(int maxWidth) {
        this.mMaxWidth = maxWidth;
    }

    @RemotableViewMethod
    public void setMaxHeight(int maxHeight) {
        this.mMaxHeight = maxHeight;
    }

    public Drawable getDrawable() {
        return this.mDrawable;
    }

    @RemotableViewMethod
    public void setImageResource(int resId) {
        if (this.mUri != null || this.mResource != resId) {
            this.updateDrawable(null);
            this.mResource = resId;
            this.mUri = null;
            this.resolveUri();
            this.requestLayout();
            this.invalidate();
        }
    }

    @RemotableViewMethod
    public void setImageURI(Uri uri) {
        if (this.mResource != 0 || this.mUri != uri && (uri == null || this.mUri == null || !uri.equals(this.mUri))) {
            this.updateDrawable(null);
            this.mResource = 0;
            this.mUri = uri;
            this.resolveUri();
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setImageDrawable(Drawable drawable2) {
        if (this.mDrawable != drawable2) {
            this.mResource = 0;
            this.mUri = null;
            this.updateDrawable(drawable2);
            this.requestLayout();
            this.invalidate();
        }
    }

    @RemotableViewMethod
    public void setImageBitmap(Bitmap bm) {
        this.setImageDrawable(new BitmapDrawable(this.mContext.getResources(), bm));
    }

    public void setImageState(int[] state, boolean merge) {
        this.mState = state;
        this.mMergeState = merge;
        if (this.mDrawable != null) {
            this.refreshDrawableState();
            this.resizeFromDrawable();
        }
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.resizeFromDrawable();
    }

    @RemotableViewMethod
    public void setImageLevel(int level) {
        this.mLevel = level;
        if (this.mDrawable != null) {
            this.mDrawable.setLevel(level);
            this.resizeFromDrawable();
        }
    }

    public void setScaleType(ScaleType scaleType) {
        if (scaleType == null) {
            throw new NullPointerException();
        }
        if (this.mScaleType != scaleType) {
            this.mScaleType = scaleType;
            this.setWillNotCacheDrawing(this.mScaleType == ScaleType.CENTER);
            this.requestLayout();
            this.invalidate();
        }
    }

    public ScaleType getScaleType() {
        return this.mScaleType;
    }

    public Matrix getImageMatrix() {
        return this.mMatrix;
    }

    public void setImageMatrix(Matrix matrix) {
        if (matrix != null && matrix.isIdentity()) {
            matrix = null;
        }
        if (matrix == null && !this.mMatrix.isIdentity() || matrix != null && !this.mMatrix.equals(matrix)) {
            this.mMatrix.set(matrix);
            this.configureBounds();
            this.invalidate();
        }
    }

    public void resolveUri() {
        if (this.mDrawable != null) {
            return;
        }
        Resources rsrc = this.getResources();
        if (rsrc == null) {
            return;
        }
        Drawable d = null;
        if (this.mResource != 0) {
            try {
                d = rsrc.getDrawable(this.mResource);
            }
            catch (Exception e) {
                Log.w("ImageView", "Unable to find resource: " + this.mResource, e);
                this.mUri = null;
            }
        } else if (this.mUri != null) {
            if ("content".equals(this.mUri.getScheme())) {
                try {
                    d = Drawable.createFromStream(this.mContext.getContentResolver().openInputStream(this.mUri), null);
                }
                catch (Exception e) {
                    Log.w("ImageView", "Unable to open content: " + this.mUri, e);
                }
            } else {
                d = Drawable.createFromPath(this.mUri.toString());
            }
            if (d == null) {
                System.out.println("resolveUri failed on bad bitmap uri: " + this.mUri);
                this.mUri = null;
            }
        } else {
            return;
        }
        this.updateDrawable(d);
    }

    public int[] onCreateDrawableState(int extraSpace) {
        if (this.mState == null) {
            return super.onCreateDrawableState(extraSpace);
        }
        if (!this.mMergeState) {
            return this.mState;
        }
        return ImageView.mergeDrawableStates(super.onCreateDrawableState(extraSpace + this.mState.length), this.mState);
    }

    public void updateDrawable(Drawable d) {
        if (this.mDrawable != null) {
            this.mDrawable.setCallback(null);
            this.unscheduleDrawable(this.mDrawable);
        }
        this.mDrawable = d;
        if (d != null) {
            d.setCallback(this);
            if (d.isStateful()) {
                d.setState(this.getDrawableState());
            }
            d.setLevel(this.mLevel);
            this.mDrawableWidth = d.getIntrinsicWidth();
            this.mDrawableHeight = d.getIntrinsicHeight();
            this.applyColorMod();
            this.configureBounds();
        }
    }

    public void resizeFromDrawable() {
        Drawable d = this.mDrawable;
        if (d != null) {
            int h;
            int w = d.getIntrinsicWidth();
            if (w < 0) {
                w = this.mDrawableWidth;
            }
            if ((h = d.getIntrinsicHeight()) < 0) {
                h = this.mDrawableHeight;
            }
            if (w != this.mDrawableWidth || h != this.mDrawableHeight) {
                this.mDrawableWidth = w;
                this.mDrawableHeight = h;
                this.requestLayout();
            }
        }
    }

    public static Matrix.ScaleToFit scaleTypeToScaleToFit(ScaleType st) {
        return sS2FArray[st.nativeInt - 1];
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightSize;
        int widthSize;
        int w;
        int h;
        this.resolveUri();
        float desiredAspect = 0.0f;
        boolean resizeWidth = false;
        boolean resizeHeight = false;
        if (this.mDrawable == null) {
            this.mDrawableWidth = -1;
            this.mDrawableHeight = -1;
            h = 0;
            w = 0;
        } else {
            w = this.mDrawableWidth;
            h = this.mDrawableHeight;
            if (w <= 0) {
                w = 1;
            }
            if (h <= 0) {
                h = 1;
            }
            if (this.mAdjustViewBounds) {
                int widthSpecMode = View.MeasureSpec.getMode(widthMeasureSpec);
                int heightSpecMode = View.MeasureSpec.getMode(heightMeasureSpec);
                resizeWidth = widthSpecMode != 0x40000000;
                resizeHeight = heightSpecMode != 0x40000000;
                desiredAspect = (float)w / (float)h;
            }
        }
        int pleft = this.mPaddingLeft;
        int pright = this.mPaddingRight;
        int ptop = this.mPaddingTop;
        int pbottom = this.mPaddingBottom;
        if (resizeWidth || resizeHeight) {
            float actualAspect;
            widthSize = this.resolveAdjustedSize(w + pleft + pright, this.mMaxWidth, widthMeasureSpec);
            heightSize = this.resolveAdjustedSize(h + ptop + pbottom, this.mMaxHeight, heightMeasureSpec);
            if (desiredAspect != 0.0f && (double)Math.abs((actualAspect = (float)(widthSize - pleft - pright) / (float)(heightSize - ptop - pbottom)) - desiredAspect) > 1.0E-7) {
                int newHeight;
                int newWidth;
                boolean done = false;
                if (resizeWidth && (newWidth = (int)(desiredAspect * (float)(heightSize - ptop - pbottom)) + pleft + pright) <= widthSize) {
                    widthSize = newWidth;
                    done = true;
                }
                if (!done && resizeHeight && (newHeight = (int)((float)(widthSize - pleft - pright) / desiredAspect) + ptop + pbottom) <= heightSize) {
                    heightSize = newHeight;
                }
            }
        } else {
            w += pleft + pright;
            h += ptop + pbottom;
            w = Math.max(w, this.getSuggestedMinimumWidth());
            h = Math.max(h, this.getSuggestedMinimumHeight());
            widthSize = ImageView.resolveSize(w, widthMeasureSpec);
            heightSize = ImageView.resolveSize(h, heightMeasureSpec);
        }
        this.setMeasuredDimension(widthSize, heightSize);
    }

    public int resolveAdjustedSize(int desiredSize, int maxSize, int measureSpec) {
        int result = desiredSize;
        int specMode = View.MeasureSpec.getMode(measureSpec);
        int specSize = View.MeasureSpec.getSize(measureSpec);
        switch (specMode) {
            case 0: {
                result = Math.min(desiredSize, maxSize);
                break;
            }
            case -2147483648: {
                result = Math.min(Math.min(desiredSize, specSize), maxSize);
                break;
            }
            case 0x40000000: {
                result = specSize;
            }
        }
        return result;
    }

    public boolean setFrame(int l, int t, int r, int b) {
        boolean changed = super.setFrame(l, t, r, b);
        this.mHaveFrame = true;
        this.configureBounds();
        return changed;
    }

    public void configureBounds() {
        boolean fits;
        if (this.mDrawable == null || !this.mHaveFrame) {
            return;
        }
        int dwidth = this.mDrawableWidth;
        int dheight = this.mDrawableHeight;
        int vwidth = this.getWidth() - this.mPaddingLeft - this.mPaddingRight;
        int vheight = this.getHeight() - this.mPaddingTop - this.mPaddingBottom;
        boolean bl = fits = !(dwidth >= 0 && vwidth != dwidth || dheight >= 0 && vheight != dheight);
        if (dwidth <= 0 || dheight <= 0 || ScaleType.FIT_XY == this.mScaleType) {
            this.mDrawable.setBounds(0, 0, vwidth, vheight);
            this.mDrawMatrix = null;
        } else {
            this.mDrawable.setBounds(0, 0, dwidth, dheight);
            if (ScaleType.MATRIX == this.mScaleType) {
                this.mDrawMatrix = this.mMatrix.isIdentity() ? null : this.mMatrix;
            } else if (fits) {
                this.mDrawMatrix = null;
            } else if (ScaleType.CENTER == this.mScaleType) {
                this.mDrawMatrix = this.mMatrix;
                this.mDrawMatrix.setTranslate((float)(vwidth - dwidth) * 0.5f, (float)(vheight - dheight) * 0.5f);
            } else if (ScaleType.CENTER_CROP == this.mScaleType) {
                float scale;
                this.mDrawMatrix = this.mMatrix;
                float dx = 0.0f;
                float dy = 0.0f;
                if (dwidth * vheight > vwidth * dheight) {
                    scale = (float)vheight / (float)dheight;
                    dx = ((float)vwidth - (float)dwidth * scale) * 0.5f;
                } else {
                    scale = (float)vwidth / (float)dwidth;
                    dy = ((float)vheight - (float)dheight * scale) * 0.5f;
                }
                this.mDrawMatrix.setScale(scale, scale);
                this.mDrawMatrix.postTranslate(dx, dy);
            } else if (ScaleType.CENTER_INSIDE == this.mScaleType) {
                this.mDrawMatrix = this.mMatrix;
                float scale = dwidth <= vwidth && dheight <= vheight ? 1.0f : Math.min((float)vwidth / (float)dwidth, (float)vheight / (float)dheight);
                float dx = ((float)vwidth - (float)dwidth * scale) * 0.5f;
                float dy = ((float)vheight - (float)dheight * scale) * 0.5f;
                this.mDrawMatrix.setScale(scale, scale);
                this.mDrawMatrix.postTranslate(dx, dy);
            } else {
                this.mTempSrc.set(0.0f, 0.0f, dwidth, dheight);
                this.mTempDst.set(0.0f, 0.0f, vwidth, vheight);
                this.mDrawMatrix = this.mMatrix;
                this.mDrawMatrix.setRectToRect(this.mTempSrc, this.mTempDst, ImageView.scaleTypeToScaleToFit(this.mScaleType));
            }
        }
    }

    public void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable d = this.mDrawable;
        if (d != null && d.isStateful()) {
            d.setState(this.getDrawableState());
        }
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDrawable == null) {
            return;
        }
        if (this.mDrawableWidth == 0 || this.mDrawableHeight == 0) {
            return;
        }
        if (this.mDrawMatrix == null && this.mPaddingTop == 0 && this.mPaddingLeft == 0) {
            this.mDrawable.draw(canvas);
        } else {
            int saveCount = canvas.getSaveCount();
            canvas.save();
            if (this.mCropToPadding) {
                int scrollX = this.mScrollX;
                int scrollY = this.mScrollY;
                canvas.clipRect(scrollX + this.mPaddingLeft, scrollY + this.mPaddingTop, scrollX + this.mRight - this.mLeft - this.mPaddingRight, scrollY + this.mBottom - this.mTop - this.mPaddingBottom);
            }
            canvas.translate(this.mPaddingLeft, this.mPaddingTop);
            if (this.mDrawMatrix != null) {
                canvas.concat(this.mDrawMatrix);
            }
            this.mDrawable.draw(canvas);
            canvas.restoreToCount(saveCount);
        }
    }

    public int getBaseline() {
        return this.mBaselineAligned ? this.getMeasuredHeight() : -1;
    }

    public void setColorFilter(int color2, PorterDuff.Mode mode) {
        this.setColorFilter(new PorterDuffColorFilter(color2, mode));
    }

    public void clearColorFilter() {
        this.setColorFilter(null);
    }

    public void setColorFilter(ColorFilter cf) {
        if (this.mColorFilter != cf) {
            this.mColorFilter = cf;
            this.applyColorMod();
            this.invalidate();
        }
    }

    public void setAlpha(int alpha) {
        if (this.mAlpha != (alpha &= 0xFF)) {
            this.mAlpha = alpha;
            this.applyColorMod();
            this.invalidate();
        }
    }

    public void applyColorMod() {
        if (this.mDrawable != null) {
            this.mDrawable.setColorFilter(this.mColorFilter);
            this.mDrawable.setAlpha(this.mAlpha * this.mViewAlphaScale >> 8);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScaleType {
        MATRIX(0),
        FIT_XY(1),
        FIT_START(2),
        FIT_CENTER(3),
        FIT_END(4),
        CENTER(5),
        CENTER_CROP(6),
        CENTER_INSIDE(7);

        public final int nativeInt;

        public ScaleType(int ni) {
            this.nativeInt = ni;
        }
    }
}

