/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.android.internal.R;

public class TabWidget
extends LinearLayout
implements View.OnFocusChangeListener {
    public OnTabSelectionChanged mSelectionChangedListener;
    public int mSelectedTab = 0;
    public Drawable mBottomLeftStrip;
    public Drawable mBottomRightStrip;
    public boolean mStripMoved;
    public Drawable mDividerDrawable;
    public boolean mDrawBottomStrips = true;

    public TabWidget(Context context) {
        this(context, null);
    }

    public TabWidget(Context context, AttributeSet attrs) {
        this(context, attrs, 16842883);
    }

    public TabWidget(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs);
        this.initTabWidget();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TabWidget, defStyle, 0);
        a.recycle();
    }

    public void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mStripMoved = true;
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public void initTabWidget() {
        this.setOrientation(0);
        this.mBottomLeftStrip = this.mContext.getResources().getDrawable(17302173);
        this.mBottomRightStrip = this.mContext.getResources().getDrawable(17302174);
        this.setFocusable(true);
        this.setOnFocusChangeListener(this);
    }

    public View getChildTabViewAt(int index) {
        if (this.mDividerDrawable != null) {
            index *= 2;
        }
        return this.getChildAt(index);
    }

    public int getTabCount() {
        int children = this.getChildCount();
        if (this.mDividerDrawable != null) {
            children = (children + 1) / 2;
        }
        return children;
    }

    public void setDividerDrawable(Drawable drawable2) {
        this.mDividerDrawable = drawable2;
    }

    public void setDividerDrawable(int resId) {
        this.mDividerDrawable = this.mContext.getResources().getDrawable(resId);
    }

    public void setDrawBottomStrips(boolean drawBottomStrips) {
        this.mDrawBottomStrips = drawBottomStrips;
    }

    public void childDrawableStateChanged(View child) {
        if (child == this.getChildTabViewAt(this.mSelectedTab)) {
            this.invalidate();
        }
        super.childDrawableStateChanged(child);
    }

    public void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (!this.mDrawBottomStrips) {
            return;
        }
        View selectedChild = this.getChildTabViewAt(this.mSelectedTab);
        this.mBottomLeftStrip.setState(selectedChild.getDrawableState());
        this.mBottomRightStrip.setState(selectedChild.getDrawableState());
        if (this.mStripMoved) {
            Rect selBounds = new Rect();
            selBounds.left = selectedChild.getLeft();
            selBounds.right = selectedChild.getRight();
            int myHeight = this.getHeight();
            this.mBottomLeftStrip.setBounds(Math.min(0, selBounds.left - this.mBottomLeftStrip.getIntrinsicWidth()), myHeight - this.mBottomLeftStrip.getIntrinsicHeight(), selBounds.left, this.getHeight());
            this.mBottomRightStrip.setBounds(selBounds.right, myHeight - this.mBottomRightStrip.getIntrinsicHeight(), Math.max(this.getWidth(), selBounds.right + this.mBottomRightStrip.getIntrinsicWidth()), myHeight);
            this.mStripMoved = false;
        }
        this.mBottomLeftStrip.draw(canvas);
        this.mBottomRightStrip.draw(canvas);
    }

    public void setCurrentTab(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            return;
        }
        this.getChildTabViewAt(this.mSelectedTab).setSelected(false);
        this.mSelectedTab = index;
        this.getChildTabViewAt(this.mSelectedTab).setSelected(true);
        this.mStripMoved = true;
    }

    public void focusCurrentTab(int index) {
        int oldTab = this.mSelectedTab;
        this.setCurrentTab(index);
        if (oldTab != index) {
            this.getChildTabViewAt(index).requestFocus();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int count = this.getTabCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildTabViewAt(i);
            child.setEnabled(enabled);
        }
    }

    public void addView(View child) {
        if (child.getLayoutParams() == null) {
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(0, -1, 1.0f);
            lp.setMargins(0, 0, 0, 0);
            child.setLayoutParams(lp);
        }
        child.setFocusable(true);
        child.setClickable(true);
        if (this.mDividerDrawable != null && this.getTabCount() > 0) {
            ImageView divider = new ImageView(this.mContext);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(this.mDividerDrawable.getIntrinsicWidth(), -1);
            lp.setMargins(0, 0, 0, 0);
            divider.setLayoutParams(lp);
            divider.setBackgroundDrawable(this.mDividerDrawable);
            super.addView(divider);
        }
        super.addView(child);
        child.setOnClickListener(new TabClickListener(this.getTabCount() - 1, null));
        child.setOnFocusChangeListener(this);
    }

    public void setTabSelectionListener(OnTabSelectionChanged listener) {
        this.mSelectionChangedListener = listener;
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (v == this && hasFocus) {
            this.getChildTabViewAt(this.mSelectedTab).requestFocus();
            return;
        }
        if (hasFocus) {
            int numTabs = this.getTabCount();
            for (int i = 0; i < numTabs; ++i) {
                if (this.getChildTabViewAt(i) != v) continue;
                this.setCurrentTab(i);
                this.mSelectionChangedListener.onTabSelectionChanged(i, false);
                break;
            }
        }
    }

    public static class 1 {
    }

    public static interface OnTabSelectionChanged {
        public void onTabSelectionChanged(int var1, boolean var2);
    }

    public class TabClickListener
    implements View.OnClickListener {
        public final int mTabIndex;

        public TabClickListener(int tabIndex) {
            this.mTabIndex = tabIndex;
        }

        public void onClick(View v) {
            TabWidget.this.mSelectionChangedListener.onTabSelectionChanged(this.mTabIndex, true);
        }

        public /* synthetic */ TabClickListener(int x1, 1 x2) {
            this(x1);
        }
    }
}

