/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.PhoneNumberUtils;
import android.util.Log;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.IccUtils;

public class AdnRecord
implements Parcelable {
    public static final String LOG_TAG = "GSM";
    public String alphaTag = "";
    public String number = "";
    public int extRecord = 255;
    public int efid;
    public int recordNumber;
    public static final int FOOTER_SIZE_BYTES = 14;
    public static final int MAX_NUMBER_SIZE_BYTES = 11;
    public static final int EXT_RECORD_LENGTH_BYTES = 13;
    public static final int EXT_RECORD_TYPE_ADDITIONAL_DATA = 2;
    public static final int EXT_RECORD_TYPE_MASK = 3;
    public static final int MAX_EXT_CALLED_PARTY_LENGTH = 10;
    public static final int ADN_BCD_NUMBER_LENGTH = 0;
    public static final int ADN_TON_AND_NPI = 1;
    public static final int ADN_DAILING_NUMBER_START = 2;
    public static final int ADN_DAILING_NUMBER_END = 11;
    public static final int ADN_CAPABILITY_ID = 12;
    public static final int ADN_EXTENSION_ID = 13;
    public static final Parcelable.Creator<AdnRecord> CREATOR = new Parcelable.Creator<AdnRecord>(){

        @Override
        public AdnRecord createFromParcel(Parcel source) {
            int efid = source.readInt();
            int recordNumber = source.readInt();
            String alphaTag = source.readString();
            String number = source.readString();
            return new AdnRecord(efid, recordNumber, alphaTag, number);
        }

        public AdnRecord[] newArray(int size) {
            return new AdnRecord[size];
        }
    };

    public AdnRecord(byte[] record) {
        this(0, 0, record);
    }

    public AdnRecord(int efid, int recordNumber, byte[] record) {
        this.efid = efid;
        this.recordNumber = recordNumber;
        this.parseRecord(record);
    }

    public AdnRecord(String alphaTag, String number) {
        this(0, 0, alphaTag, number);
    }

    public AdnRecord(int efid, int recordNumber, String alphaTag, String number) {
        this.efid = efid;
        this.recordNumber = recordNumber;
        this.alphaTag = alphaTag;
        this.number = number;
    }

    public String getAlphaTag() {
        return this.alphaTag;
    }

    public String getNumber() {
        return this.number;
    }

    public String toString() {
        return "ADN Record '" + this.alphaTag + "' '" + this.number + "'";
    }

    public boolean isEmpty() {
        return this.alphaTag.equals("") && this.number.equals("");
    }

    public boolean hasExtendedRecord() {
        return this.extRecord != 0 && this.extRecord != 255;
    }

    public boolean isEqual(AdnRecord adn) {
        return this.alphaTag.equals(adn.getAlphaTag()) && this.number.equals(adn.getNumber());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.efid);
        dest.writeInt(this.recordNumber);
        dest.writeString(this.alphaTag);
        dest.writeString(this.number);
    }

    public byte[] buildAdnString(int recordSize) {
        byte[] adnString = null;
        int footerOffset = recordSize - 14;
        if (this.number == null || this.number.equals("") || this.alphaTag == null || this.alphaTag.equals("")) {
            Log.w(LOG_TAG, "[buildAdnString] Empty alpha tag or number");
            adnString = new byte[recordSize];
            for (int i = 0; i < recordSize; ++i) {
                adnString[i] = -1;
            }
        } else if (this.number.length() > 20) {
            Log.w(LOG_TAG, "[buildAdnString] Max length of dailing number is 20");
        } else if (this.alphaTag.length() > footerOffset) {
            Log.w(LOG_TAG, "[buildAdnString] Max length of tag is " + footerOffset);
        } else {
            adnString = new byte[recordSize];
            for (int i = 0; i < recordSize; ++i) {
                adnString[i] = -1;
            }
            byte[] bcdNumber = PhoneNumberUtils.numberToCalledPartyBCD(this.number);
            System.arraycopy(bcdNumber, 0, adnString, footerOffset + 1, bcdNumber.length);
            adnString[footerOffset + 0] = (byte)bcdNumber.length;
            adnString[footerOffset + 12] = -1;
            adnString[footerOffset + 13] = -1;
            byte[] byteTag = GsmAlphabet.stringToGsm8BitPacked(this.alphaTag);
            System.arraycopy(byteTag, 0, adnString, 0, byteTag.length);
        }
        return adnString;
    }

    public void appendExtRecord(byte[] extRecord) {
        try {
            if (extRecord.length != 13) {
                return;
            }
            if ((extRecord[0] & 3) != 2) {
                return;
            }
            if ((0xFF & extRecord[1]) > 10) {
                return;
            }
            this.number = this.number + PhoneNumberUtils.calledPartyBCDFragmentToString(extRecord, 2, 0xFF & extRecord[1]);
        }
        catch (RuntimeException ex) {
            Log.w(LOG_TAG, "Error parsing AdnRecord ext record", ex);
        }
    }

    public void parseRecord(byte[] record) {
        try {
            this.alphaTag = IccUtils.adnStringFieldToString(record, 0, record.length - 14);
            int footerOffset = record.length - 14;
            int numberLength = 0xFF & record[footerOffset];
            if (numberLength > 11) {
                this.number = "";
                return;
            }
            this.number = PhoneNumberUtils.calledPartyBCDToString(record, footerOffset + 1, numberLength);
            this.extRecord = 0xFF & record[record.length - 1];
        }
        catch (RuntimeException ex) {
            Log.w(LOG_TAG, "Error parsing AdnRecord", ex);
            this.number = "";
            this.alphaTag = "";
        }
    }
}

