/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.provider.Contacts;
import android.telephony.PhoneNumberUtils;
import android.telephony.TelephonyManager;
import android.text.TextUtils;

public class CallerInfo {
    public static final String TAG = "CallerInfo";
    public static final String UNKNOWN_NUMBER = "-1";
    public static final String PRIVATE_NUMBER = "-2";
    public static final String PAYPHONE_NUMBER = "-3";
    public String name;
    public String phoneNumber;
    public String cnapName;
    public int numberPresentation;
    public int namePresentation;
    public boolean contactExists;
    public String phoneLabel;
    public int numberType;
    public String numberLabel;
    public int photoResource;
    public long person_id;
    public boolean needUpdate;
    public Uri contactRefUri;
    public Uri contactRingtoneUri;
    public boolean shouldSendToVoicemail;
    public Drawable cachedPhoto;
    public boolean isCachedPhotoCurrent;
    public static boolean sSkipVmCheck = false;

    public static CallerInfo getCallerInfo(Context context, Uri contactRef, Cursor cursor) {
        CallerInfo info = new CallerInfo();
        info.photoResource = 0;
        info.phoneLabel = null;
        info.numberType = 0;
        info.numberLabel = null;
        info.cachedPhoto = null;
        info.isCachedPhotoCurrent = false;
        info.contactExists = false;
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                int typeColumnIndex;
                int columnIndex = cursor.getColumnIndex("name");
                if (columnIndex != -1) {
                    info.name = cursor.getString(columnIndex);
                }
                if ((columnIndex = cursor.getColumnIndex("number")) != -1) {
                    info.phoneNumber = cursor.getString(columnIndex);
                }
                if ((columnIndex = cursor.getColumnIndex("label")) != -1 && (typeColumnIndex = cursor.getColumnIndex("type")) != -1) {
                    info.numberType = cursor.getInt(typeColumnIndex);
                    info.numberLabel = cursor.getString(columnIndex);
                    info.phoneLabel = ((Object)Contacts.Phones.getDisplayLabel(context, info.numberType, info.numberLabel)).toString();
                }
                if ((columnIndex = cursor.getColumnIndex("person")) != -1) {
                    info.person_id = cursor.getLong(columnIndex);
                } else {
                    columnIndex = cursor.getColumnIndex("_id");
                    if (columnIndex != -1) {
                        info.person_id = cursor.getLong(columnIndex);
                    }
                }
                columnIndex = cursor.getColumnIndex("custom_ringtone");
                info.contactRingtoneUri = columnIndex != -1 && cursor.getString(columnIndex) != null ? Uri.parse(cursor.getString(columnIndex)) : null;
                columnIndex = cursor.getColumnIndex("send_to_voicemail");
                info.shouldSendToVoicemail = columnIndex != -1 && cursor.getInt(columnIndex) == 1;
                info.contactExists = true;
            }
            cursor.close();
        }
        info.needUpdate = false;
        info.name = CallerInfo.normalize(info.name);
        info.contactRefUri = contactRef;
        return info;
    }

    public static CallerInfo getCallerInfo(Context context, Uri contactRef) {
        return CallerInfo.getCallerInfo(context, contactRef, context.getContentResolver().query(contactRef, null, null, null, null));
    }

    public static CallerInfo getCallerInfo(Context context, String number) {
        if (TextUtils.isEmpty(number)) {
            return null;
        }
        if (PhoneNumberUtils.isEmergencyNumber(number)) {
            CallerInfo ci = new CallerInfo();
            ci.phoneNumber = context.getString(17039873);
            return ci;
        }
        try {
            if (!sSkipVmCheck && PhoneNumberUtils.compare(number, TelephonyManager.getDefault().getVoiceMailNumber())) {
                CallerInfo ci = new CallerInfo();
                ci.phoneNumber = TelephonyManager.getDefault().getVoiceMailAlphaTag();
                return ci;
            }
        }
        catch (SecurityException ex) {
            sSkipVmCheck = true;
        }
        Uri contactUri = Uri.withAppendedPath(Contacts.Phones.CONTENT_FILTER_URL, Uri.encode(number));
        CallerInfo info = CallerInfo.getCallerInfo(context, contactUri);
        if (TextUtils.isEmpty(info.phoneNumber)) {
            info.phoneNumber = number;
        }
        return info;
    }

    public static String getCallerId(Context context, String number) {
        CallerInfo info = CallerInfo.getCallerInfo(context, number);
        String callerID = null;
        if (info != null) {
            String name = info.name;
            callerID = !TextUtils.isEmpty(name) ? name : number;
        }
        return callerID;
    }

    public static String normalize(String s) {
        if (s == null || s.length() > 0) {
            return s;
        }
        return null;
    }
}

