/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.PendingIntent;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.INetStatService;
import android.os.Message;
import android.provider.Settings;
import android.util.Log;
import com.android.internal.telephony.PhoneBase;

public abstract class DataConnectionTracker
extends Handler {
    public static final boolean DBG = true;
    public static final int EVENT_DATA_SETUP_COMPLETE = 1;
    public static final int EVENT_RADIO_AVAILABLE = 3;
    public static final int EVENT_RECORDS_LOADED = 4;
    public static final int EVENT_TRY_SETUP_DATA = 5;
    public static final int EVENT_DATA_STATE_CHANGED = 6;
    public static final int EVENT_POLL_PDP = 7;
    public static final int EVENT_GET_PDP_LIST_COMPLETE = 11;
    public static final int EVENT_RADIO_OFF_OR_NOT_AVAILABLE = 12;
    public static final int EVENT_VOICE_CALL_STARTED = 14;
    public static final int EVENT_VOICE_CALL_ENDED = 15;
    public static final int EVENT_GPRS_DETACHED = 19;
    public static final int EVENT_LINK_STATE_CHANGED = 20;
    public static final int EVENT_ROAMING_ON = 21;
    public static final int EVENT_ROAMING_OFF = 22;
    public static final int EVENT_ENABLE_NEW_APN = 23;
    public static final int EVENT_RESTORE_DEFAULT_APN = 24;
    public static final int EVENT_DISCONNECT_DONE = 25;
    public static final int EVENT_GPRS_ATTACHED = 26;
    public static final int EVENT_START_NETSTAT_POLL = 27;
    public static final int EVENT_START_RECOVERY = 28;
    public static final int EVENT_APN_CHANGED = 29;
    public static final int EVENT_CDMA_DATA_DETACHED = 30;
    public static final int EVENT_NV_READY = 31;
    public static final int EVENT_PS_RESTRICT_ENABLED = 32;
    public static final int EVENT_PS_RESTRICT_DISABLED = 33;
    public static final int EVENT_CLEAN_UP_CONNECTION = 34;
    public static final int RECONNECT_DELAY_INITIAL_MILLIS = 5000;
    public static final int RECONNECT_DELAY_MAX_MILLIS = 1800000;
    public static final int POLL_NETSTAT_SLOW_MILLIS = 5000;
    public static final int DEFAULT_PING_DEADLINE = 5;
    public static final int DEFAULT_MAX_PDP_RESET_FAIL = 3;
    public static final int NO_RECV_POLL_LIMIT = 24;
    public static final int POLL_NETSTAT_MILLIS = 1000;
    public static final int POLL_NETSTAT_SCREEN_OFF_MILLIS = 600000;
    public static final int POLL_LONGEST_RTT = 120000;
    public static final int NUMBER_SENT_PACKETS_OF_HANG = 10;
    public static final int RESTORE_DEFAULT_APN_DELAY = 60000;
    public static final String APN_RESTORE_DELAY_PROP_NAME = "android.telephony.apn-restore";
    public static final String NULL_IP = "0.0.0.0";
    public PhoneBase phone;
    public Activity activity = Activity.NONE;
    public State state = State.IDLE;
    public Handler mDataConnectionTracker = null;
    public INetStatService netstat;
    public long txPkts;
    public long rxPkts;
    public long sentSinceLastRecv;
    public int netStatPollPeriod;
    public int mNoRecvPollCount = 0;
    public boolean netStatPollEnabled = false;
    public boolean mIsWifiConnected = false;
    public PendingIntent mReconnectIntent = null;
    public int cidActive;

    public DataConnectionTracker(PhoneBase phone) {
        this.phone = phone;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public State getState() {
        return this.state;
    }

    public String getStateInString() {
        switch (this.state) {
            case IDLE: {
                return "IDLE";
            }
            case INITING: {
                return "INIT";
            }
            case CONNECTING: {
                return "CING";
            }
            case SCANNING: {
                return "SCAN";
            }
            case CONNECTED: {
                return "CNTD";
            }
            case DISCONNECTING: {
                return "DING";
            }
            case FAILED: {
                return "FAIL";
            }
        }
        return "ERRO";
    }

    public abstract boolean isDataConnectionAsDesired();

    public void setDataOnRoamingEnabled(boolean enabled) {
        if (this.getDataOnRoamingEnabled() != enabled) {
            Settings.Secure.putInt(this.phone.getContext().getContentResolver(), "data_roaming", enabled ? 1 : 0);
        }
        Message roamingMsg = this.phone.getServiceState().getRoaming() ? this.obtainMessage(21) : this.obtainMessage(22);
        this.sendMessage(roamingMsg);
    }

    public boolean getDataOnRoamingEnabled() {
        try {
            return Settings.Secure.getInt(this.phone.getContext().getContentResolver(), "data_roaming") > 0;
        }
        catch (Settings.SettingNotFoundException snfe) {
            return false;
        }
    }

    public abstract void onTrySetupData(String var1);

    public abstract void onRoamingOff();

    public abstract void onRoamingOn();

    public abstract void onRadioAvailable();

    public abstract void onRadioOffOrNotAvailable();

    public abstract void onDataSetupComplete(AsyncResult var1);

    public abstract void onDisconnectDone(AsyncResult var1);

    public abstract void onVoiceCallStarted();

    public abstract void onVoiceCallEnded();

    public abstract void onCleanUpConnection(boolean var1, String var2);

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 5: {
                String reason = null;
                if (msg.obj instanceof String) {
                    reason = (String)msg.obj;
                }
                this.onTrySetupData(reason);
                break;
            }
            case 22: {
                this.onRoamingOff();
                break;
            }
            case 21: {
                this.onRoamingOn();
                break;
            }
            case 3: {
                this.onRadioAvailable();
                break;
            }
            case 12: {
                this.onRadioOffOrNotAvailable();
                break;
            }
            case 1: {
                this.cidActive = msg.arg1;
                this.onDataSetupComplete((AsyncResult)msg.obj);
                break;
            }
            case 25: {
                this.onDisconnectDone((AsyncResult)msg.obj);
                break;
            }
            case 14: {
                this.onVoiceCallStarted();
                break;
            }
            case 15: {
                this.onVoiceCallEnded();
                break;
            }
            case 34: {
                boolean tearDown = msg.arg1 != 0;
                this.onCleanUpConnection(tearDown, (String)msg.obj);
                break;
            }
            default: {
                Log.e("DATA", "Unidentified event = " + msg.what);
            }
        }
    }

    public abstract boolean getDataEnabled();

    public abstract boolean getAnyDataEnabled();

    public abstract boolean setDataEnabled(boolean var1);

    public abstract void startNetStatPoll();

    public abstract void stopNetStatPoll();

    public abstract void restartRadio();

    public abstract void log(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Activity {
        NONE,
        DATAIN,
        DATAOUT,
        DATAINANDOUT,
        DORMANT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        IDLE,
        INITING,
        CONNECTING,
        SCANNING,
        CONNECTED,
        DISCONNECTING,
        FAILED;

    }
}

