/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.telephony.ServiceState;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.gsm.PdpConnection;
import com.android.internal.telephony.test.SimulatedRadioControl;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PhoneBase
implements Phone {
    public static final String LOG_TAG = "PHONE";
    public static final boolean LOCAL_DEBUG = true;
    public static final String NETWORK_SELECTION_KEY = "network_selection_key";
    public static final String DATA_DISABLED_ON_BOOT_KEY = "disabled_on_boot_key";
    public static final int EVENT_RADIO_AVAILABLE = 1;
    public static final int EVENT_SSN = 2;
    public static final int EVENT_SIM_RECORDS_LOADED = 3;
    public static final int EVENT_MMI_DONE = 4;
    public static final int EVENT_RADIO_ON = 5;
    public static final int EVENT_GET_BASEBAND_VERSION_DONE = 6;
    public static final int EVENT_USSD = 7;
    public static final int EVENT_RADIO_OFF_OR_NOT_AVAILABLE = 8;
    public static final int EVENT_GET_IMEI_DONE = 9;
    public static final int EVENT_GET_IMEISV_DONE = 10;
    public static final int EVENT_GET_SIM_STATUS_DONE = 11;
    public static final int EVENT_SET_CALL_FORWARD_DONE = 12;
    public static final int EVENT_GET_CALL_FORWARD_DONE = 13;
    public static final int EVENT_CALL_RING = 14;
    public static final int EVENT_SET_NETWORK_MANUAL_COMPLETE = 15;
    public static final int EVENT_SET_NETWORK_AUTOMATIC_COMPLETE = 16;
    public static final int EVENT_SET_CLIR_COMPLETE = 17;
    public static final int EVENT_REGISTERED_TO_NETWORK = 18;
    public static final int EVENT_SET_VM_NUMBER_DONE = 19;
    public static final int EVENT_GET_DEVICE_IDENTITY_DONE = 20;
    public static final int EVENT_RUIM_RECORDS_LOADED = 21;
    public static final int EVENT_NV_READY = 22;
    public static final int EVENT_SET_ENHANCED_VP = 23;
    public static final int EVENT_EMERGENCY_CALLBACK_MODE_ENTER = 24;
    public static final int EVENT_EXIT_EMERGENCY_CALLBACK_RESPONSE = 25;
    public static final String CLIR_KEY = "clir_key";
    public static final String DNS_SERVER_CHECK_DISABLED_KEY = "dns_server_check_disabled_key";
    public CommandsInterface mCM;
    public IccFileHandler mIccFileHandler;
    public boolean mDnsCheckDisabled = false;
    public final RegistrantList mPhoneStateRegistrants = new RegistrantList();
    public final RegistrantList mNewRingingConnectionRegistrants = new RegistrantList();
    public final RegistrantList mIncomingRingRegistrants = new RegistrantList();
    public final RegistrantList mDisconnectRegistrants = new RegistrantList();
    public final RegistrantList mServiceStateRegistrants = new RegistrantList();
    public final RegistrantList mMmiCompleteRegistrants = new RegistrantList();
    public final RegistrantList mMmiRegistrants = new RegistrantList();
    public final RegistrantList mUnknownConnectionRegistrants = new RegistrantList();
    public final RegistrantList mSuppServiceFailedRegistrants = new RegistrantList();
    public Looper mLooper;
    public Context mContext;
    public PhoneNotifier mNotifier;
    public SimulatedRadioControl mSimulatedRadioControl;
    public boolean mUnitTestMode;

    public void setSystemProperty(String property, String value) {
        if (this.getUnitTestMode()) {
            return;
        }
        SystemProperties.set(property, value);
    }

    public PhoneBase(PhoneNotifier notifier, Context context) {
        this(notifier, context, false);
    }

    public PhoneBase(PhoneNotifier notifier, Context context, boolean unitTestMode) {
        this.mNotifier = notifier;
        this.mContext = context;
        this.mLooper = Looper.myLooper();
        this.setLocaleByCarrier();
        this.setUnitTestMode(unitTestMode);
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(context);
        this.mDnsCheckDisabled = sp.getBoolean(DNS_SERVER_CHECK_DISABLED_KEY, false);
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public void disableDnsCheck(boolean b) {
        this.mDnsCheckDisabled = b;
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        editor.putBoolean(DNS_SERVER_CHECK_DISABLED_KEY, b);
        editor.commit();
    }

    @Override
    public boolean isDnsCheckDisabled() {
        return this.mDnsCheckDisabled;
    }

    @Override
    public void registerForPhoneStateChanged(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mPhoneStateRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForPhoneStateChanged(Handler h) {
        this.mPhoneStateRegistrants.remove(h);
    }

    public void notifyCallStateChangedP() {
        AsyncResult ar = new AsyncResult(null, this, null);
        this.mPhoneStateRegistrants.notifyRegistrants(ar);
    }

    @Override
    public void registerForUnknownConnection(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mUnknownConnectionRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForUnknownConnection(Handler h) {
        this.mUnknownConnectionRegistrants.remove(h);
    }

    @Override
    public void registerForNewRingingConnection(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mNewRingingConnectionRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForNewRingingConnection(Handler h) {
        this.mNewRingingConnectionRegistrants.remove(h);
    }

    @Override
    public void registerForInCallVoicePrivacyOn(Handler h, int what, Object obj) {
        this.mCM.registerForInCallVoicePrivacyOn(h, what, obj);
    }

    @Override
    public void unregisterForInCallVoicePrivacyOn(Handler h) {
        this.mCM.unregisterForInCallVoicePrivacyOn(h);
    }

    @Override
    public void registerForInCallVoicePrivacyOff(Handler h, int what, Object obj) {
        this.mCM.registerForInCallVoicePrivacyOff(h, what, obj);
    }

    @Override
    public void unregisterForInCallVoicePrivacyOff(Handler h) {
        this.mCM.unregisterForInCallVoicePrivacyOff(h);
    }

    public void notifyNewRingingConnectionP(Connection cn) {
        AsyncResult ar = new AsyncResult(null, cn, null);
        this.mNewRingingConnectionRegistrants.notifyRegistrants(ar);
    }

    @Override
    public void registerForIncomingRing(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mIncomingRingRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForIncomingRing(Handler h) {
        this.mIncomingRingRegistrants.remove(h);
    }

    @Override
    public void registerForDisconnect(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mDisconnectRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForDisconnect(Handler h) {
        this.mDisconnectRegistrants.remove(h);
    }

    @Override
    public void registerForSuppServiceFailed(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mSuppServiceFailedRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForSuppServiceFailed(Handler h) {
        this.mSuppServiceFailedRegistrants.remove(h);
    }

    @Override
    public void registerForMmiInitiate(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mMmiRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForMmiInitiate(Handler h) {
        this.mMmiRegistrants.remove(h);
    }

    @Override
    public void registerForMmiComplete(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mMmiCompleteRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForMmiComplete(Handler h) {
        this.checkCorrectThread(h);
        this.mMmiCompleteRegistrants.remove(h);
    }

    public String getSavedNetworkSelection() {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        return sp.getString(NETWORK_SELECTION_KEY, "");
    }

    public void restoreSavedNetworkSelection(Message response) {
        String networkSelection = this.getSavedNetworkSelection();
        if (TextUtils.isEmpty(networkSelection)) {
            this.mCM.setNetworkSelectionModeAutomatic(response);
        } else {
            this.mCM.setNetworkSelectionModeManual(networkSelection, response);
        }
    }

    @Override
    public void setUnitTestMode(boolean f) {
        this.mUnitTestMode = f;
    }

    @Override
    public boolean getUnitTestMode() {
        return this.mUnitTestMode;
    }

    public void notifyDisconnectP(Connection cn) {
        AsyncResult ar = new AsyncResult(null, cn, null);
        this.mDisconnectRegistrants.notifyRegistrants(ar);
    }

    @Override
    public void registerForServiceStateChanged(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mServiceStateRegistrants.add(h, what, obj);
    }

    @Override
    public void unregisterForServiceStateChanged(Handler h) {
        this.mServiceStateRegistrants.remove(h);
    }

    public void notifyServiceStateChangedP(ServiceState ss) {
        AsyncResult ar = new AsyncResult(null, ss, null);
        this.mServiceStateRegistrants.notifyRegistrants(ar);
        this.mNotifier.notifyServiceState(this);
    }

    @Override
    public SimulatedRadioControl getSimulatedRadioControl() {
        return this.mSimulatedRadioControl;
    }

    public void checkCorrectThread(Handler h) {
        if (h.getLooper() != this.mLooper) {
            throw new RuntimeException("com.android.internal.telephony.Phone must be used from within one thread");
        }
    }

    public void setLocaleByCarrier() {
        String carrier = SystemProperties.get("ro.carrier");
        if (null == carrier || 0 == carrier.length()) {
            return;
        }
        CharSequence[] carrierLocales = this.mContext.getResources().getTextArray(17235980);
        for (int i = 0; i < carrierLocales.length - 1; i += 2) {
            String c = ((Object)carrierLocales[i]).toString();
            String l = ((Object)carrierLocales[i + 1]).toString();
            if (!carrier.equals(c)) continue;
            String language = l.substring(0, 2);
            String country = "";
            if (l.length() >= 5) {
                country = l.substring(3, 5);
            }
            this.setSystemLocale(language, country);
            return;
        }
    }

    public void setSystemLocale(String language, String country) {
        String l = SystemProperties.get("persist.sys.language");
        String c = SystemProperties.get("persist.sys.country");
        if (null == language) {
            return;
        }
        language = language.toLowerCase();
        if (null == country) {
            country = "";
        }
        country = country.toUpperCase();
        if (!(null != l && 0 != l.length() || null != c && 0 != c.length())) {
            try {
                String[] locales = this.mContext.getAssets().getLocales();
                int N = locales.length;
                String bestMatch = null;
                for (int i = 0; i < N; ++i) {
                    if (locales[i] == null || locales[i].length() < 5 || !locales[i].substring(0, 2).equals(language)) continue;
                    if (locales[i].substring(3, 5).equals(country)) {
                        bestMatch = locales[i];
                        break;
                    }
                    if (null != bestMatch) continue;
                    bestMatch = locales[i];
                }
                if (null != bestMatch) {
                    IActivityManager am = ActivityManagerNative.getDefault();
                    Configuration config = am.getConfiguration();
                    config.locale = new Locale(bestMatch.substring(0, 2), bestMatch.substring(3, 5));
                    config.userSetLocale = true;
                    am.updateConfiguration(config);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public abstract Handler getHandler();

    public abstract IccFileHandler getIccFileHandler();

    @Override
    public void queryCdmaRoamingPreference(Message response) {
        this.mCM.queryCdmaRoamingPreference(response);
    }

    @Override
    public void setCdmaRoamingPreference(int cdmaRoamingType, Message response) {
        this.mCM.setCdmaRoamingPreference(cdmaRoamingType, response);
    }

    @Override
    public void setCdmaSubscription(int cdmaSubscriptionType, Message response) {
        this.mCM.setCdmaSubscription(cdmaSubscriptionType, response);
    }

    @Override
    public void setPreferredNetworkType(int networkType, Message response) {
        this.mCM.setPreferredNetworkType(networkType, response);
    }

    @Override
    public void getPreferredNetworkType(Message response) {
        this.mCM.getPreferredNetworkType(response);
    }

    @Override
    public void getSmscAddress(Message result) {
        this.mCM.getSmscAddress(result);
    }

    @Override
    public void setSmscAddress(String address, Message result) {
        this.mCM.setSmscAddress(address, result);
    }

    @Override
    public void setTTYMode(int ttyMode, Message onComplete) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public void queryTTYMode(Message onComplete) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public List<PdpConnection> getCurrentPdpList() {
        return null;
    }

    @Override
    public void enableEnhancedVoicePrivacy(boolean enable, Message onComplete) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public void getEnhancedVoicePrivacy(Message onComplete) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public void setBandMode(int bandMode, Message response) {
        this.mCM.setBandMode(bandMode, response);
    }

    @Override
    public void queryAvailableBandMode(Message response) {
        this.mCM.queryAvailableBandMode(response);
    }

    @Override
    public void invokeOemRilRequestRaw(byte[] data, Message response) {
        this.mCM.invokeOemRilRequestRaw(data, response);
    }

    @Override
    public void invokeOemRilRequestStrings(String[] strings, Message response) {
        this.mCM.invokeOemRilRequestStrings(strings, response);
    }

    @Override
    public void notifyDataActivity() {
        this.mNotifier.notifyDataActivity(this);
    }

    public void notifyMessageWaitingIndicator() {
        this.mNotifier.notifyMessageWaitingChanged(this);
    }

    public void notifyDataConnection(String reason) {
        this.mNotifier.notifyDataConnection(this, reason);
    }

    @Override
    public abstract String getPhoneName();

    @Override
    public int getVoiceMessageCount() {
        return 0;
    }

    @Override
    public int getCdmaEriIconIndex() {
        Log.e(LOG_TAG, "Error! getCdmaEriIconIndex should never be executed in GSM mode");
        return -1;
    }

    @Override
    public int getCdmaEriIconMode() {
        Log.e(LOG_TAG, "Error! getCdmaEriIconMode should never be executed in GSM mode");
        return -1;
    }

    @Override
    public String getCdmaEriText() {
        Log.e(LOG_TAG, "Error! getCdmaEriText should never be executed in GSM mode");
        return "GSM nw, no ERI";
    }

    @Override
    public String getCdmaMin() {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
        return null;
    }

    @Override
    public String getCdmaPrlVersion() {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
        return null;
    }

    @Override
    public void sendBurstDtmf(String dtmfString, int on, int off, Message onComplete) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public void exitEmergencyCallbackMode() {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public void registerForCdmaOtaStatusChange(Handler h, int what, Object obj) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public void unregisterForCdmaOtaStatusChange(Handler h) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public boolean isOtaSpNumber(String dialStr) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
        return false;
    }

    @Override
    public void registerForCallWaiting(Handler h, int what, Object obj) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public void unregisterForCallWaiting(Handler h) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public void registerForSignalInfo(Handler h, int what, Object obj) {
        this.mCM.registerForSignalInfo(h, what, obj);
    }

    @Override
    public void unregisterForSignalInfo(Handler h) {
        this.mCM.unregisterForSignalInfo(h);
    }

    @Override
    public void registerForDisplayInfo(Handler h, int what, Object obj) {
        this.mCM.registerForDisplayInfo(h, what, obj);
    }

    @Override
    public void unregisterForDisplayInfo(Handler h) {
        this.mCM.unregisterForDisplayInfo(h);
    }

    @Override
    public void registerForNumberInfo(Handler h, int what, Object obj) {
        this.mCM.registerForNumberInfo(h, what, obj);
    }

    @Override
    public void unregisterForNumberInfo(Handler h) {
        this.mCM.unregisterForNumberInfo(h);
    }

    @Override
    public void registerForRedirectedNumberInfo(Handler h, int what, Object obj) {
        this.mCM.registerForRedirectedNumberInfo(h, what, obj);
    }

    @Override
    public void unregisterForRedirectedNumberInfo(Handler h) {
        this.mCM.unregisterForRedirectedNumberInfo(h);
    }

    @Override
    public void registerForLineControlInfo(Handler h, int what, Object obj) {
        this.mCM.registerForLineControlInfo(h, what, obj);
    }

    @Override
    public void unregisterForLineControlInfo(Handler h) {
        this.mCM.unregisterForLineControlInfo(h);
    }

    @Override
    public void registerFoT53ClirlInfo(Handler h, int what, Object obj) {
        this.mCM.registerFoT53ClirlInfo(h, what, obj);
    }

    @Override
    public void unregisterForT53ClirInfo(Handler h) {
        this.mCM.unregisterForT53ClirInfo(h);
    }

    @Override
    public void registerForT53AudioControlInfo(Handler h, int what, Object obj) {
        this.mCM.registerForT53AudioControlInfo(h, what, obj);
    }

    @Override
    public void unregisterForT53AudioControlInfo(Handler h) {
        this.mCM.unregisterForT53AudioControlInfo(h);
    }

    @Override
    public void setOnEcbModeExitResponse(Handler h, int what, Object obj) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    @Override
    public void unsetOnEcbModeExitResponse(Handler h) {
        Log.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }
}

