/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.ActivityManagerNative;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.telephony.CellLocation;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccPhoneBookInterfaceManager;
import com.android.internal.telephony.IccPhoneBookInterfaceManagerProxy;
import com.android.internal.telephony.IccSmsInterfaceManager;
import com.android.internal.telephony.IccSmsInterfaceManagerProxy;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.PhoneSubInfo;
import com.android.internal.telephony.PhoneSubInfoProxy;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.NetworkInfo;
import com.android.internal.telephony.gsm.PdpConnection;
import com.android.internal.telephony.test.SimulatedRadioControl;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhoneProxy
extends Handler
implements Phone {
    public static final Object lockForRadioTechnologyChange = new Object();
    public Phone mActivePhone;
    public String mOutgoingPhone;
    public CommandsInterface mCommandsInterface;
    public IccSmsInterfaceManagerProxy mIccSmsInterfaceManagerProxy;
    public IccPhoneBookInterfaceManagerProxy mIccPhoneBookInterfaceManagerProxy;
    public PhoneSubInfoProxy mPhoneSubInfoProxy;
    public static final int EVENT_RADIO_TECHNOLOGY_CHANGED = 1;
    public static final String LOG_TAG = "PHONE";

    public PhoneProxy(Phone phone) {
        this.mActivePhone = phone;
        this.mIccSmsInterfaceManagerProxy = new IccSmsInterfaceManagerProxy(phone.getIccSmsInterfaceManager());
        this.mIccPhoneBookInterfaceManagerProxy = new IccPhoneBookInterfaceManagerProxy(phone.getIccPhoneBookInterfaceManager());
        this.mPhoneSubInfoProxy = new PhoneSubInfoProxy(phone.getPhoneSubInfo());
        this.mCommandsInterface = ((PhoneBase)this.mActivePhone).mCM;
        this.mCommandsInterface.registerForRadioTechnologyChanged(this, 1, null);
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                Phone oldPhone;
                this.mOutgoingPhone = ((PhoneBase)this.mActivePhone).getPhoneName();
                this.logd("Switching phone from " + this.mOutgoingPhone + "Phone to " + (this.mOutgoingPhone.equals("GSM") ? "CDMAPhone" : "GSMPhone"));
                boolean oldPowerState = false;
                if (this.mCommandsInterface.getRadioState().isOn()) {
                    oldPowerState = true;
                    this.logd("Setting Radio Power to Off");
                    this.mCommandsInterface.setRadioPower(false, null);
                }
                if (this.mOutgoingPhone.equals("GSM")) {
                    this.logd("Make a new CDMAPhone and destroy the old GSMPhone.");
                    ((GSMPhone)this.mActivePhone).dispose();
                    oldPhone = this.mActivePhone;
                    this.mActivePhone = PhoneFactory.getCdmaPhone();
                    this.logd("Resetting Radio");
                    this.mCommandsInterface.setRadioPower(oldPowerState, null);
                    ((GSMPhone)oldPhone).removeReferences();
                    oldPhone = null;
                } else {
                    this.logd("Make a new GSMPhone and destroy the old CDMAPhone.");
                    ((CDMAPhone)this.mActivePhone).dispose();
                    oldPhone = this.mActivePhone;
                    this.mActivePhone = PhoneFactory.getGsmPhone();
                    this.logd("Resetting Radio:");
                    this.mCommandsInterface.setRadioPower(oldPowerState, null);
                    ((CDMAPhone)oldPhone).removeReferences();
                    oldPhone = null;
                }
                this.mIccSmsInterfaceManagerProxy.setmIccSmsInterfaceManager(this.mActivePhone.getIccSmsInterfaceManager());
                this.mIccPhoneBookInterfaceManagerProxy.setmIccPhoneBookInterfaceManager(this.mActivePhone.getIccPhoneBookInterfaceManager());
                this.mPhoneSubInfoProxy.setmPhoneSubInfo(this.mActivePhone.getPhoneSubInfo());
                this.mCommandsInterface = ((PhoneBase)this.mActivePhone).mCM;
                Intent intent = new Intent("android.intent.action.RADIO_TECHNOLOGY");
                intent.putExtra("phoneName", this.mActivePhone.getPhoneName());
                ActivityManagerNative.broadcastStickyIntent(intent, null);
                break;
            }
            default: {
                Log.e(LOG_TAG, "Error! This handler was not registered for this message type. Message: " + msg.what);
            }
        }
        super.handleMessage(msg);
    }

    public void logv(String msg) {
        Log.v(LOG_TAG, "[PhoneProxy] " + msg);
    }

    public void logd(String msg) {
        Log.d(LOG_TAG, "[PhoneProxy] " + msg);
    }

    public void logw(String msg) {
        Log.w(LOG_TAG, "[PhoneProxy] " + msg);
    }

    public void loge(String msg) {
        Log.e(LOG_TAG, "[PhoneProxy] " + msg);
    }

    @Override
    public ServiceState getServiceState() {
        return this.mActivePhone.getServiceState();
    }

    @Override
    public CellLocation getCellLocation() {
        return this.mActivePhone.getCellLocation();
    }

    @Override
    public Phone.DataState getDataConnectionState() {
        return this.mActivePhone.getDataConnectionState();
    }

    @Override
    public Phone.DataActivityState getDataActivityState() {
        return this.mActivePhone.getDataActivityState();
    }

    @Override
    public Context getContext() {
        return this.mActivePhone.getContext();
    }

    @Override
    public void disableDnsCheck(boolean b) {
        this.mActivePhone.disableDnsCheck(b);
    }

    @Override
    public boolean isDnsCheckDisabled() {
        return this.mActivePhone.isDnsCheckDisabled();
    }

    @Override
    public Phone.State getState() {
        return this.mActivePhone.getState();
    }

    @Override
    public String getPhoneName() {
        return this.mActivePhone.getPhoneName();
    }

    @Override
    public String[] getActiveApnTypes() {
        return this.mActivePhone.getActiveApnTypes();
    }

    @Override
    public String getActiveApn() {
        return this.mActivePhone.getActiveApn();
    }

    @Override
    public SignalStrength getSignalStrength() {
        return this.mActivePhone.getSignalStrength();
    }

    @Override
    public void registerForUnknownConnection(Handler h, int what, Object obj) {
        this.mActivePhone.registerForUnknownConnection(h, what, obj);
    }

    @Override
    public void unregisterForUnknownConnection(Handler h) {
        this.mActivePhone.unregisterForUnknownConnection(h);
    }

    @Override
    public void registerForPhoneStateChanged(Handler h, int what, Object obj) {
        this.mActivePhone.registerForPhoneStateChanged(h, what, obj);
    }

    @Override
    public void unregisterForPhoneStateChanged(Handler h) {
        this.mActivePhone.unregisterForPhoneStateChanged(h);
    }

    @Override
    public void registerForNewRingingConnection(Handler h, int what, Object obj) {
        this.mActivePhone.registerForNewRingingConnection(h, what, obj);
    }

    @Override
    public void unregisterForNewRingingConnection(Handler h) {
        this.mActivePhone.unregisterForNewRingingConnection(h);
    }

    @Override
    public void registerForIncomingRing(Handler h, int what, Object obj) {
        this.mActivePhone.registerForIncomingRing(h, what, obj);
    }

    @Override
    public void unregisterForIncomingRing(Handler h) {
        this.mActivePhone.unregisterForIncomingRing(h);
    }

    @Override
    public void registerForDisconnect(Handler h, int what, Object obj) {
        this.mActivePhone.registerForDisconnect(h, what, obj);
    }

    @Override
    public void unregisterForDisconnect(Handler h) {
        this.mActivePhone.unregisterForDisconnect(h);
    }

    @Override
    public void registerForMmiInitiate(Handler h, int what, Object obj) {
        this.mActivePhone.registerForMmiInitiate(h, what, obj);
    }

    @Override
    public void unregisterForMmiInitiate(Handler h) {
        this.mActivePhone.unregisterForMmiInitiate(h);
    }

    @Override
    public void registerForMmiComplete(Handler h, int what, Object obj) {
        this.mActivePhone.registerForMmiComplete(h, what, obj);
    }

    @Override
    public void unregisterForMmiComplete(Handler h) {
        this.mActivePhone.unregisterForMmiComplete(h);
    }

    @Override
    public List<? extends MmiCode> getPendingMmiCodes() {
        return this.mActivePhone.getPendingMmiCodes();
    }

    @Override
    public void sendUssdResponse(String ussdMessge) {
        this.mActivePhone.sendUssdResponse(ussdMessge);
    }

    @Override
    public void registerForServiceStateChanged(Handler h, int what, Object obj) {
        this.mActivePhone.registerForServiceStateChanged(h, what, obj);
    }

    @Override
    public void unregisterForServiceStateChanged(Handler h) {
        this.mActivePhone.unregisterForServiceStateChanged(h);
    }

    @Override
    public void registerForSuppServiceNotification(Handler h, int what, Object obj) {
        this.mActivePhone.registerForSuppServiceNotification(h, what, obj);
    }

    @Override
    public void unregisterForSuppServiceNotification(Handler h) {
        this.mActivePhone.unregisterForSuppServiceNotification(h);
    }

    @Override
    public void registerForSuppServiceFailed(Handler h, int what, Object obj) {
        this.mActivePhone.registerForSuppServiceFailed(h, what, obj);
    }

    @Override
    public void unregisterForSuppServiceFailed(Handler h) {
        this.mActivePhone.unregisterForSuppServiceFailed(h);
    }

    @Override
    public void registerForInCallVoicePrivacyOn(Handler h, int what, Object obj) {
        this.mActivePhone.registerForInCallVoicePrivacyOn(h, what, obj);
    }

    @Override
    public void unregisterForInCallVoicePrivacyOn(Handler h) {
        this.mActivePhone.unregisterForInCallVoicePrivacyOn(h);
    }

    @Override
    public void registerForInCallVoicePrivacyOff(Handler h, int what, Object obj) {
        this.mActivePhone.registerForInCallVoicePrivacyOff(h, what, obj);
    }

    @Override
    public void unregisterForInCallVoicePrivacyOff(Handler h) {
        this.mActivePhone.unregisterForInCallVoicePrivacyOff(h);
    }

    @Override
    public void registerForCdmaOtaStatusChange(Handler h, int what, Object obj) {
        this.mActivePhone.registerForCdmaOtaStatusChange(h, what, obj);
    }

    @Override
    public void unregisterForCdmaOtaStatusChange(Handler h) {
        this.mActivePhone.unregisterForCdmaOtaStatusChange(h);
    }

    @Override
    public boolean getIccRecordsLoaded() {
        return this.mActivePhone.getIccRecordsLoaded();
    }

    @Override
    public IccCard getIccCard() {
        return this.mActivePhone.getIccCard();
    }

    @Override
    public void acceptCall() throws CallStateException {
        this.mActivePhone.acceptCall();
    }

    @Override
    public void rejectCall() throws CallStateException {
        this.mActivePhone.rejectCall();
    }

    @Override
    public void switchHoldingAndActive() throws CallStateException {
        this.mActivePhone.switchHoldingAndActive();
    }

    @Override
    public boolean canConference() {
        return this.mActivePhone.canConference();
    }

    @Override
    public void conference() throws CallStateException {
        this.mActivePhone.conference();
    }

    @Override
    public void enableEnhancedVoicePrivacy(boolean enable, Message onComplete) {
        this.mActivePhone.enableEnhancedVoicePrivacy(enable, onComplete);
    }

    @Override
    public void getEnhancedVoicePrivacy(Message onComplete) {
        this.mActivePhone.getEnhancedVoicePrivacy(onComplete);
    }

    @Override
    public boolean canTransfer() {
        return this.mActivePhone.canTransfer();
    }

    @Override
    public void explicitCallTransfer() throws CallStateException {
        this.mActivePhone.explicitCallTransfer();
    }

    @Override
    public void clearDisconnected() {
        this.mActivePhone.clearDisconnected();
    }

    @Override
    public Call getForegroundCall() {
        return this.mActivePhone.getForegroundCall();
    }

    @Override
    public Call getBackgroundCall() {
        return this.mActivePhone.getBackgroundCall();
    }

    @Override
    public Call getRingingCall() {
        return this.mActivePhone.getRingingCall();
    }

    @Override
    public Connection dial(String dialString) throws CallStateException {
        return this.mActivePhone.dial(dialString);
    }

    @Override
    public boolean handlePinMmi(String dialString) {
        return this.mActivePhone.handlePinMmi(dialString);
    }

    @Override
    public boolean handleInCallMmiCommands(String command) throws CallStateException {
        return this.mActivePhone.handleInCallMmiCommands(command);
    }

    @Override
    public void sendDtmf(char c) {
        this.mActivePhone.sendDtmf(c);
    }

    @Override
    public void startDtmf(char c) {
        this.mActivePhone.startDtmf(c);
    }

    @Override
    public void stopDtmf() {
        this.mActivePhone.stopDtmf();
    }

    @Override
    public void setRadioPower(boolean power) {
        this.mActivePhone.setRadioPower(power);
    }

    @Override
    public boolean getMessageWaitingIndicator() {
        return this.mActivePhone.getMessageWaitingIndicator();
    }

    @Override
    public boolean getCallForwardingIndicator() {
        return this.mActivePhone.getCallForwardingIndicator();
    }

    @Override
    public String getLine1Number() {
        return this.mActivePhone.getLine1Number();
    }

    @Override
    public String getCdmaMin() {
        return this.mActivePhone.getCdmaMin();
    }

    @Override
    public String getCdmaPrlVersion() {
        return this.mActivePhone.getCdmaPrlVersion();
    }

    @Override
    public String getLine1AlphaTag() {
        return this.mActivePhone.getLine1AlphaTag();
    }

    @Override
    public void setLine1Number(String alphaTag, String number, Message onComplete) {
        this.mActivePhone.setLine1Number(alphaTag, number, onComplete);
    }

    @Override
    public String getVoiceMailNumber() {
        return this.mActivePhone.getVoiceMailNumber();
    }

    @Override
    public int getVoiceMessageCount() {
        return this.mActivePhone.getVoiceMessageCount();
    }

    @Override
    public String getVoiceMailAlphaTag() {
        return this.mActivePhone.getVoiceMailAlphaTag();
    }

    @Override
    public void setVoiceMailNumber(String alphaTag, String voiceMailNumber, Message onComplete) {
        this.mActivePhone.setVoiceMailNumber(alphaTag, voiceMailNumber, onComplete);
    }

    @Override
    public void getCallForwardingOption(int commandInterfaceCFReason, Message onComplete) {
        this.mActivePhone.getCallForwardingOption(commandInterfaceCFReason, onComplete);
    }

    @Override
    public void setCallForwardingOption(int commandInterfaceCFReason, int commandInterfaceCFAction, String dialingNumber, int timerSeconds, Message onComplete) {
        this.mActivePhone.setCallForwardingOption(commandInterfaceCFReason, commandInterfaceCFAction, dialingNumber, timerSeconds, onComplete);
    }

    @Override
    public void getOutgoingCallerIdDisplay(Message onComplete) {
        this.mActivePhone.getOutgoingCallerIdDisplay(onComplete);
    }

    @Override
    public void setOutgoingCallerIdDisplay(int commandInterfaceCLIRMode, Message onComplete) {
        this.mActivePhone.setOutgoingCallerIdDisplay(commandInterfaceCLIRMode, onComplete);
    }

    @Override
    public void getCallWaiting(Message onComplete) {
        this.mActivePhone.getCallWaiting(onComplete);
    }

    @Override
    public void setCallWaiting(boolean enable, Message onComplete) {
        this.mActivePhone.setCallWaiting(enable, onComplete);
    }

    @Override
    public void getAvailableNetworks(Message response) {
        this.mActivePhone.getAvailableNetworks(response);
    }

    @Override
    public void setNetworkSelectionModeAutomatic(Message response) {
        this.mActivePhone.setNetworkSelectionModeAutomatic(response);
    }

    @Override
    public void selectNetworkManually(NetworkInfo network, Message response) {
        this.mActivePhone.selectNetworkManually(network, response);
    }

    @Override
    public void setPreferredNetworkType(int networkType, Message response) {
        this.mActivePhone.setPreferredNetworkType(networkType, response);
    }

    @Override
    public void getPreferredNetworkType(Message response) {
        this.mActivePhone.getPreferredNetworkType(response);
    }

    @Override
    public void getNeighboringCids(Message response) {
        this.mActivePhone.getNeighboringCids(response);
    }

    @Override
    public void setOnPostDialCharacter(Handler h, int what, Object obj) {
        this.mActivePhone.setOnPostDialCharacter(h, what, obj);
    }

    @Override
    public void setMute(boolean muted) {
        this.mActivePhone.setMute(muted);
    }

    @Override
    public boolean getMute() {
        return this.mActivePhone.getMute();
    }

    @Override
    public void invokeOemRilRequestRaw(byte[] data, Message response) {
        this.mActivePhone.invokeOemRilRequestRaw(data, response);
    }

    @Override
    public void invokeOemRilRequestStrings(String[] strings, Message response) {
        this.mActivePhone.invokeOemRilRequestStrings(strings, response);
    }

    @Override
    public void getPdpContextList(Message response) {
        this.mActivePhone.getPdpContextList(response);
    }

    @Override
    public void getDataCallList(Message response) {
        this.mActivePhone.getDataCallList(response);
    }

    @Override
    public List<PdpConnection> getCurrentPdpList() {
        return this.mActivePhone.getCurrentPdpList();
    }

    @Override
    public List<DataConnection> getCurrentDataConnectionList() {
        return this.mActivePhone.getCurrentDataConnectionList();
    }

    @Override
    public void updateServiceLocation(Message response) {
        this.mActivePhone.updateServiceLocation(response);
    }

    @Override
    public void enableLocationUpdates() {
        this.mActivePhone.enableLocationUpdates();
    }

    @Override
    public void disableLocationUpdates() {
        this.mActivePhone.disableLocationUpdates();
    }

    @Override
    public void setUnitTestMode(boolean f) {
        this.mActivePhone.setUnitTestMode(f);
    }

    @Override
    public boolean getUnitTestMode() {
        return this.mActivePhone.getUnitTestMode();
    }

    @Override
    public void setBandMode(int bandMode, Message response) {
        this.mActivePhone.setBandMode(bandMode, response);
    }

    @Override
    public void queryAvailableBandMode(Message response) {
        this.mActivePhone.queryAvailableBandMode(response);
    }

    @Override
    public boolean getDataRoamingEnabled() {
        return this.mActivePhone.getDataRoamingEnabled();
    }

    @Override
    public void setDataRoamingEnabled(boolean enable) {
        this.mActivePhone.setDataRoamingEnabled(enable);
    }

    @Override
    public void queryCdmaRoamingPreference(Message response) {
        this.mActivePhone.queryCdmaRoamingPreference(response);
    }

    @Override
    public void setCdmaRoamingPreference(int cdmaRoamingType, Message response) {
        this.mActivePhone.setCdmaRoamingPreference(cdmaRoamingType, response);
    }

    @Override
    public void setCdmaSubscription(int cdmaSubscriptionType, Message response) {
        this.mActivePhone.setCdmaSubscription(cdmaSubscriptionType, response);
    }

    @Override
    public SimulatedRadioControl getSimulatedRadioControl() {
        return this.mActivePhone.getSimulatedRadioControl();
    }

    @Override
    public boolean enableDataConnectivity() {
        return this.mActivePhone.enableDataConnectivity();
    }

    @Override
    public boolean disableDataConnectivity() {
        return this.mActivePhone.disableDataConnectivity();
    }

    @Override
    public int enableApnType(String type) {
        return this.mActivePhone.enableApnType(type);
    }

    @Override
    public int disableApnType(String type) {
        return this.mActivePhone.disableApnType(type);
    }

    @Override
    public boolean isDataConnectivityPossible() {
        return this.mActivePhone.isDataConnectivityPossible();
    }

    @Override
    public String getInterfaceName(String apnType) {
        return this.mActivePhone.getInterfaceName(apnType);
    }

    @Override
    public String getIpAddress(String apnType) {
        return this.mActivePhone.getIpAddress(apnType);
    }

    @Override
    public String getGateway(String apnType) {
        return this.mActivePhone.getGateway(apnType);
    }

    @Override
    public String[] getDnsServers(String apnType) {
        return this.mActivePhone.getDnsServers(apnType);
    }

    @Override
    public String getDeviceId() {
        return this.mActivePhone.getDeviceId();
    }

    @Override
    public String getDeviceSvn() {
        return this.mActivePhone.getDeviceSvn();
    }

    @Override
    public String getSubscriberId() {
        return this.mActivePhone.getSubscriberId();
    }

    @Override
    public String getIccSerialNumber() {
        return this.mActivePhone.getIccSerialNumber();
    }

    @Override
    public String getEsn() {
        return this.mActivePhone.getEsn();
    }

    @Override
    public String getMeid() {
        return this.mActivePhone.getMeid();
    }

    @Override
    public PhoneSubInfo getPhoneSubInfo() {
        return this.mActivePhone.getPhoneSubInfo();
    }

    @Override
    public IccSmsInterfaceManager getIccSmsInterfaceManager() {
        return this.mActivePhone.getIccSmsInterfaceManager();
    }

    @Override
    public IccPhoneBookInterfaceManager getIccPhoneBookInterfaceManager() {
        return this.mActivePhone.getIccPhoneBookInterfaceManager();
    }

    @Override
    public void setTTYMode(int ttyMode, Message onComplete) {
        this.mActivePhone.setTTYMode(ttyMode, onComplete);
    }

    @Override
    public void queryTTYMode(Message onComplete) {
        this.mActivePhone.queryTTYMode(onComplete);
    }

    @Override
    public void activateCellBroadcastSms(int activate, Message response) {
        this.mActivePhone.activateCellBroadcastSms(activate, response);
    }

    @Override
    public void getCellBroadcastSmsConfig(Message response) {
        this.mActivePhone.getCellBroadcastSmsConfig(response);
    }

    @Override
    public void setCellBroadcastSmsConfig(int[] configValuesArray, Message response) {
        this.mActivePhone.setCellBroadcastSmsConfig(configValuesArray, response);
    }

    @Override
    public void notifyDataActivity() {
        this.mActivePhone.notifyDataActivity();
    }

    @Override
    public void getSmscAddress(Message result) {
        this.mActivePhone.getSmscAddress(result);
    }

    @Override
    public void setSmscAddress(String address, Message result) {
        this.mActivePhone.setSmscAddress(address, result);
    }

    @Override
    public int getCdmaEriIconIndex() {
        return this.mActivePhone.getCdmaEriIconIndex();
    }

    @Override
    public String getCdmaEriText() {
        return this.mActivePhone.getCdmaEriText();
    }

    @Override
    public int getCdmaEriIconMode() {
        return this.mActivePhone.getCdmaEriIconMode();
    }

    @Override
    public void sendBurstDtmf(String dtmfString, int on, int off, Message onComplete) {
        this.mActivePhone.sendBurstDtmf(dtmfString, on, off, onComplete);
    }

    @Override
    public void exitEmergencyCallbackMode() {
        this.mActivePhone.exitEmergencyCallbackMode();
    }

    @Override
    public boolean isOtaSpNumber(String dialStr) {
        return this.mActivePhone.isOtaSpNumber(dialStr);
    }

    @Override
    public void registerForCallWaiting(Handler h, int what, Object obj) {
        this.mActivePhone.registerForCallWaiting(h, what, obj);
    }

    @Override
    public void unregisterForCallWaiting(Handler h) {
        this.mActivePhone.unregisterForCallWaiting(h);
    }

    @Override
    public void registerForSignalInfo(Handler h, int what, Object obj) {
        this.mActivePhone.registerForSignalInfo(h, what, obj);
    }

    @Override
    public void unregisterForSignalInfo(Handler h) {
        this.mActivePhone.unregisterForSignalInfo(h);
    }

    @Override
    public void registerForDisplayInfo(Handler h, int what, Object obj) {
        this.mActivePhone.registerForDisplayInfo(h, what, obj);
    }

    @Override
    public void unregisterForDisplayInfo(Handler h) {
        this.mActivePhone.unregisterForDisplayInfo(h);
    }

    @Override
    public void registerForNumberInfo(Handler h, int what, Object obj) {
        this.mActivePhone.registerForNumberInfo(h, what, obj);
    }

    @Override
    public void unregisterForNumberInfo(Handler h) {
        this.mActivePhone.unregisterForNumberInfo(h);
    }

    @Override
    public void registerForRedirectedNumberInfo(Handler h, int what, Object obj) {
        this.mActivePhone.registerForRedirectedNumberInfo(h, what, obj);
    }

    @Override
    public void unregisterForRedirectedNumberInfo(Handler h) {
        this.mActivePhone.unregisterForRedirectedNumberInfo(h);
    }

    @Override
    public void registerForLineControlInfo(Handler h, int what, Object obj) {
        this.mActivePhone.registerForLineControlInfo(h, what, obj);
    }

    @Override
    public void unregisterForLineControlInfo(Handler h) {
        this.mActivePhone.unregisterForLineControlInfo(h);
    }

    @Override
    public void registerFoT53ClirlInfo(Handler h, int what, Object obj) {
        this.mActivePhone.registerFoT53ClirlInfo(h, what, obj);
    }

    @Override
    public void unregisterForT53ClirInfo(Handler h) {
        this.mActivePhone.unregisterForT53ClirInfo(h);
    }

    @Override
    public void registerForT53AudioControlInfo(Handler h, int what, Object obj) {
        this.mActivePhone.registerForT53AudioControlInfo(h, what, obj);
    }

    @Override
    public void unregisterForT53AudioControlInfo(Handler h) {
        this.mActivePhone.unregisterForT53AudioControlInfo(h);
    }

    @Override
    public void setOnEcbModeExitResponse(Handler h, int what, Object obj) {
        this.mActivePhone.setOnEcbModeExitResponse(h, what, obj);
    }

    @Override
    public void unsetOnEcbModeExitResponse(Handler h) {
        this.mActivePhone.unsetOnEcbModeExitResponse(h);
    }
}

