/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AlertDialog;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.database.Cursor;
import android.database.SQLException;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.provider.Settings;
import android.provider.Telephony;
import android.telephony.SmsMessage;
import android.util.Log;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.SmsResponse;
import com.android.internal.telephony.WapPushOverSms;
import com.android.internal.util.HexDump;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SMSDispatcher
extends Handler {
    public static final String TAG = "SMS";
    public static final int DEFAULT_SMS_CHECK_PERIOD = 3600000;
    public static final int DEFAULT_SMS_MAX_COUNT = 100;
    public static final int DEFAULT_SMS_TIMOUEOUT = 6000;
    public static final String[] RAW_PROJECTION = new String[]{"pdu", "sequence", "destination_port"};
    public static final int MAIL_SEND_SMS = 1;
    public static final int EVENT_NEW_SMS = 1;
    public static final int EVENT_SEND_SMS_COMPLETE = 2;
    public static final int EVENT_SEND_RETRY = 3;
    public static final int EVENT_NEW_SMS_STATUS_REPORT = 5;
    public static final int EVENT_ICC_FULL = 6;
    public static final int EVENT_POST_ALERT = 7;
    public static final int EVENT_SEND_CONFIRMED_SMS = 8;
    public static final int EVENT_ALERT_TIMEOUT = 9;
    public Phone mPhone;
    public Context mContext;
    public ContentResolver mResolver;
    public CommandsInterface mCm;
    public final WapPushOverSms mWapPush;
    public final Uri mRawUri = Uri.withAppendedPath(Telephony.Sms.CONTENT_URI, "raw");
    public static final int MAX_SEND_RETRIES = 3;
    public static final int SEND_RETRY_DELAY = 2000;
    public static final int SINGLE_PART_SMS = 1;
    public static int sConcatenatedRef;
    public SmsCounter mCounter;
    public SmsTracker mSTracker;
    public PowerManager.WakeLock mWakeLock;
    public final int WAKE_LOCK_TIMEOUT = 5000;
    public static SmsMessage mSmsMessage;
    public static SmsMessageBase mSmsMessageBase;
    public SmsMessageBase.SubmitPduBase mSubmitPduBase;
    public boolean mStorageAvailable = true;
    public final ArrayList<SmsTracker> deliveryPendingList = new ArrayList();
    public DialogInterface.OnClickListener mListener = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int which) {
            if (which == -1) {
                Log.d(SMSDispatcher.TAG, "click YES to send out sms");
                SMSDispatcher.this.sendMessage(SMSDispatcher.this.obtainMessage(8));
            }
        }
    };
    public BroadcastReceiver mResultReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.DEVICE_STORAGE_LOW")) {
                SMSDispatcher.this.mStorageAvailable = false;
                SMSDispatcher.this.mCm.reportSmsMemoryStatus(false, null);
            } else if (intent.getAction().equals("android.intent.action.DEVICE_STORAGE_OK")) {
                SMSDispatcher.this.mStorageAvailable = true;
                SMSDispatcher.this.mCm.reportSmsMemoryStatus(true, null);
            } else {
                int rc = this.getResultCode();
                boolean success = rc == -1 || rc == 1;
                SMSDispatcher.this.acknowledgeLastIncomingSms(success, rc, null);
            }
        }
    };

    public static int getNextConcatenatedRef() {
        return ++sConcatenatedRef;
    }

    public SMSDispatcher(PhoneBase phone) {
        this.mPhone = phone;
        this.mWapPush = new WapPushOverSms(phone, this);
        this.mContext = phone.getContext();
        this.mResolver = this.mContext.getContentResolver();
        this.mCm = phone.mCM;
        this.mSTracker = null;
        this.createWakelock();
        int check_period = Settings.Gservices.getInt(this.mResolver, "sms_outgoing_check_interval_ms", 3600000);
        int max_count = Settings.Gservices.getInt(this.mResolver, "sms_outgoing_check_max_count", 100);
        this.mCounter = new SmsCounter(max_count, check_period);
        this.mCm.setOnNewSMS(this, 1, null);
        this.mCm.setOnSmsStatus(this, 5, null);
        this.mCm.setOnIccSmsFull(this, 6, null);
        sConcatenatedRef = new Random().nextInt(256);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.DEVICE_STORAGE_LOW");
        filter.addAction("android.intent.action.DEVICE_STORAGE_OK");
        this.mContext.registerReceiver(this.mResultReceiver, filter);
    }

    public void dispose() {
        this.mCm.unSetOnNewSMS(this);
        this.mCm.unSetOnSmsStatus(this);
        this.mCm.unSetOnIccSmsFull(this);
    }

    public void finalize() {
        Log.d(TAG, "SMSDispatcher finalized");
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                Log.d(TAG, "New SMS Message Received");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) {
                    Log.e(TAG, "Exception processing incoming SMS. Exception:" + ar.exception);
                    return;
                }
                SmsMessage sms = (SmsMessage)ar.result;
                try {
                    if (this.mStorageAvailable) {
                        int result = this.dispatchMessage(sms.mWrappedSmsMessage);
                        if (result == -1) break;
                        boolean handled = result == 1;
                        this.acknowledgeLastIncomingSms(handled, result, null);
                        break;
                    }
                    this.acknowledgeLastIncomingSms(false, 3, null);
                }
                catch (RuntimeException ex) {
                    this.acknowledgeLastIncomingSms(false, 2, null);
                }
                break;
            }
            case 2: {
                this.handleSendComplete((AsyncResult)msg.obj);
                break;
            }
            case 3: {
                this.sendSms((SmsTracker)msg.obj);
                break;
            }
            case 5: {
                this.handleStatusReport((AsyncResult)msg.obj);
                break;
            }
            case 6: {
                this.handleIccFull();
                break;
            }
            case 7: {
                this.handleReachSentLimit((SmsTracker)msg.obj);
                break;
            }
            case 9: {
                ((AlertDialog)msg.obj).dismiss();
                msg.obj = null;
                this.mSTracker = null;
                break;
            }
            case 8: {
                if (this.mSTracker == null) break;
                if (this.isMultipartTracker(this.mSTracker)) {
                    this.sendMultipartSms(this.mSTracker);
                } else {
                    this.sendSms(this.mSTracker);
                }
                this.mSTracker = null;
            }
        }
    }

    public void createWakelock() {
        PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, "SMSDispatcher");
        this.mWakeLock.setReferenceCounted(true);
    }

    public void dispatch(Intent intent, String permission2) {
        this.mWakeLock.acquire(5000L);
        this.mContext.sendOrderedBroadcast(intent, permission2, this.mResultReceiver, this, -1, null, null);
    }

    public void handleIccFull() {
        Intent intent = new Intent("android.provider.Telephony.SIM_FULL");
        this.mWakeLock.acquire(5000L);
        this.mContext.sendBroadcast(intent, "android.permission.RECEIVE_SMS");
    }

    public abstract void handleStatusReport(AsyncResult var1);

    public void handleSendComplete(AsyncResult ar) {
        SmsTracker tracker = (SmsTracker)ar.userObj;
        PendingIntent sentIntent = tracker.mSentIntent;
        if (ar.exception == null) {
            Log.d(TAG, "SMS send complete. Broadcasting intent: " + sentIntent);
            if (tracker.mDeliveryIntent != null) {
                int messageRef;
                tracker.mMessageRef = messageRef = ((SmsResponse)ar.result).messageRef;
                this.deliveryPendingList.add(tracker);
            }
            if (sentIntent != null) {
                try {
                    sentIntent.send(-1);
                }
                catch (PendingIntent.CanceledException ex) {}
            }
        } else {
            Log.d(TAG, "SMS send failed");
            int ss = this.mPhone.getServiceState().getState();
            if (ss != 0) {
                this.handleNotInService(ss, tracker);
            } else if (((CommandException)ar.exception).getCommandError() == CommandException.Error.SMS_FAIL_RETRY && tracker.mRetryCount < 3) {
                ++tracker.mRetryCount;
                Message retryMsg = this.obtainMessage(3, tracker);
                this.sendMessageDelayed(retryMsg, 2000L);
            } else if (tracker.mSentIntent != null) {
                try {
                    tracker.mSentIntent.send(1);
                }
                catch (PendingIntent.CanceledException ex) {
                    // empty catch block
                }
            }
        }
    }

    public void handleNotInService(int ss, SmsTracker tracker) {
        if (tracker.mSentIntent != null) {
            try {
                if (ss == 3) {
                    tracker.mSentIntent.send(2);
                } else {
                    tracker.mSentIntent.send(4);
                }
            }
            catch (PendingIntent.CanceledException canceledException) {
                // empty catch block
            }
        }
    }

    public abstract int dispatchMessage(SmsMessageBase var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processMessagePart(SmsMessageBase sms, SmsHeader.ConcatRef concatRef, SmsHeader.PortAddrs portAddrs) {
        int cursorCount;
        Cursor cursor;
        Object pdus;
        String[] whereArgs;
        StringBuilder where;
        block14: {
            int n;
            block15: {
                where = new StringBuilder("reference_number =");
                where.append(concatRef.refNumber);
                where.append(" AND address = ?");
                whereArgs = new String[]{sms.getOriginatingAddress()};
                pdus = null;
                cursor = null;
                cursor = this.mResolver.query(this.mRawUri, RAW_PROJECTION, where.toString(), whereArgs, null);
                cursorCount = cursor.getCount();
                if (cursorCount == concatRef.msgCount - 1) break block14;
                ContentValues values = new ContentValues();
                values.put("date", new Long(sms.getTimestampMillis()));
                values.put("pdu", HexDump.toHexString(sms.getPdu()));
                values.put("address", sms.getOriginatingAddress());
                values.put("reference_number", concatRef.refNumber);
                values.put("count", concatRef.msgCount);
                values.put("sequence", concatRef.seqNumber);
                if (portAddrs != null) {
                    values.put("destination_port", portAddrs.destPort);
                }
                this.mResolver.insert(this.mRawUri, values);
                n = 1;
                Object var14_17 = null;
                if (cursor == null) break block15;
                cursor.close();
            }
            return n;
        }
        try {
            try {
                int pduColumn = cursor.getColumnIndex("pdu");
                int sequenceColumn = cursor.getColumnIndex("sequence");
                pdus = new byte[concatRef.msgCount][];
                for (int i = 0; i < cursorCount; ++i) {
                    cursor.moveToNext();
                    int cursorSequence = (int)cursor.getLong(sequenceColumn);
                    pdus[cursorSequence - 1] = HexDump.hexStringToByteArray(cursor.getString(pduColumn));
                }
                pdus[concatRef.seqNumber - 1] = sms.getPdu();
                this.mResolver.delete(this.mRawUri, where.toString(), whereArgs);
            }
            catch (SQLException e) {
                Log.e(TAG, "Can't access multipart SMS database", e);
                int pduColumn = 2;
                Object var14_19 = null;
                if (cursor != null) {
                    cursor.close();
                }
                return pduColumn;
            }
            Object var14_18 = null;
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (Throwable throwable) {
            Object var14_20 = null;
            if (cursor != null) {
                cursor.close();
            }
            throw throwable;
        }
        if (portAddrs != null) {
            if (portAddrs.destPort == 2948) {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                for (int i = 0; i < concatRef.msgCount; ++i) {
                    SmsMessage msg = SmsMessage.createFromPdu(pdus[i]);
                    byte[] data = msg.getUserData();
                    output.write(data, 0, data.length);
                }
                return this.mWapPush.dispatchWapPdu(output.toByteArray());
            }
            this.dispatchPortAddressedPdus((byte[][])pdus, portAddrs.destPort);
        } else {
            this.dispatchPdus((byte[][])pdus);
        }
        return -1;
    }

    public void dispatchPdus(byte[][] pdus) {
        Intent intent = new Intent("android.provider.Telephony.SMS_RECEIVED");
        intent.putExtra("pdus", (Serializable)pdus);
        this.dispatch(intent, "android.permission.RECEIVE_SMS");
    }

    public void dispatchPortAddressedPdus(byte[][] pdus, int port) {
        Uri uri = Uri.parse("sms://localhost:" + port);
        Intent intent = new Intent("android.intent.action.DATA_SMS_RECEIVED", uri);
        intent.putExtra("pdus", (Serializable)pdus);
        this.dispatch(intent, "android.permission.RECEIVE_SMS");
    }

    public abstract void sendMultipartText(String var1, String var2, ArrayList<String> var3, ArrayList<PendingIntent> var4, ArrayList<PendingIntent> var5);

    public void sendRawPdu(byte[] smsc, byte[] pdu, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        if (pdu == null) {
            if (sentIntent != null) {
                try {
                    sentIntent.send(3);
                }
                catch (PendingIntent.CanceledException ex) {
                    // empty catch block
                }
            }
            return;
        }
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        map.put("smsc", smsc);
        map.put("pdu", pdu);
        SmsTracker tracker = new SmsTracker(map, sentIntent, deliveryIntent);
        int ss = this.mPhone.getServiceState().getState();
        if (ss != 0) {
            this.handleNotInService(ss, tracker);
        } else {
            String appName = this.getAppNameByIntent(sentIntent);
            if (this.mCounter.check(appName, 1)) {
                this.sendSms(tracker);
            } else {
                this.sendMessage(this.obtainMessage(7, tracker));
            }
        }
    }

    public void handleReachSentLimit(SmsTracker tracker) {
        Resources r = Resources.getSystem();
        String appName = this.getAppNameByIntent(tracker.mSentIntent);
        AlertDialog d = new AlertDialog.Builder(this.mContext).setTitle(r.getString(17040012)).setMessage(appName + " " + r.getString(17040013)).setPositiveButton(r.getString(17040014), this.mListener).setNegativeButton(r.getString(17040015), null).create();
        d.getWindow().setType(2003);
        d.show();
        this.mSTracker = tracker;
        this.sendMessageDelayed(this.obtainMessage(9, d), 6000L);
    }

    public String getAppNameByIntent(PendingIntent intent) {
        Resources r = Resources.getSystem();
        return intent != null ? intent.getTargetPackage() : r.getString(17040011);
    }

    public abstract void sendSms(SmsTracker var1);

    public abstract void sendMultipartSms(SmsTracker var1);

    public abstract void activateCellBroadcastSms(int var1, Message var2);

    public abstract void getCellBroadcastSmsConfig(Message var1);

    public abstract void setCellBroadcastConfig(int[] var1, Message var2);

    public abstract void acknowledgeLastIncomingSms(boolean var1, int var2, Message var3);

    public boolean isMultipartTracker(SmsTracker tracker) {
        HashMap map = tracker.mData;
        return map.get("parts") != null;
    }

    public SmsTracker SmsTrackerFactory(HashMap data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        return new SmsTracker(data, sentIntent, deliveryIntent);
    }

    public static class SmsTracker {
        public HashMap mData;
        public int mRetryCount;
        public int mMessageRef;
        public PendingIntent mSentIntent;
        public PendingIntent mDeliveryIntent;

        public SmsTracker(HashMap data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
            this.mData = data;
            this.mSentIntent = sentIntent;
            this.mDeliveryIntent = deliveryIntent;
            this.mRetryCount = 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SmsCounter {
        public int mCheckPeriod;
        public int mMaxAllowed;
        public HashMap<String, ArrayList<Long>> mSmsStamp;

        public SmsCounter(int mMax, int mPeriod) {
            this.mMaxAllowed = mMax;
            this.mCheckPeriod = mPeriod;
            this.mSmsStamp = new HashMap();
        }

        public boolean check(String appName, int smsWaiting) {
            if (!this.mSmsStamp.containsKey(appName)) {
                this.mSmsStamp.put(appName, new ArrayList());
            }
            return this.isUnderLimit(this.mSmsStamp.get(appName), smsWaiting);
        }

        public boolean isUnderLimit(ArrayList<Long> sent, int smsWaiting) {
            Long ct = System.currentTimeMillis();
            Log.d(SMSDispatcher.TAG, "SMS send size=" + sent.size() + "time=" + ct);
            while (sent.size() > 0 && ct - sent.get(0) > (long)this.mCheckPeriod) {
                sent.remove(0);
            }
            if (sent.size() + smsWaiting <= this.mMaxAllowed) {
                for (int i = 0; i < smsWaiting; ++i) {
                    sent.add(ct);
                }
                return true;
            }
            return false;
        }
    }
}

