/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import com.android.internal.telephony.CommandsInterface;

public abstract class ServiceStateTracker
extends Handler {
    public static final int DATA_ACCESS_UNKNOWN = 0;
    public static final int DATA_ACCESS_GPRS = 1;
    public static final int DATA_ACCESS_EDGE = 2;
    public static final int DATA_ACCESS_UMTS = 3;
    public static final int DATA_ACCESS_CDMA_IS95A = 4;
    public static final int DATA_ACCESS_CDMA_IS95B = 5;
    public static final int DATA_ACCESS_CDMA_1xRTT = 6;
    public static final int DATA_ACCESS_CDMA_EvDo_0 = 7;
    public static final int DATA_ACCESS_CDMA_EvDo_A = 8;
    public CommandsInterface cm;
    public ServiceState ss;
    public ServiceState newSS;
    public SignalStrength mSignalStrength;
    public int[] pollingContext;
    public boolean mDesiredPowerState;
    public boolean dontPollSignalStrength = false;
    public RegistrantList networkAttachedRegistrants = new RegistrantList();
    public RegistrantList roamingOnRegistrants = new RegistrantList();
    public RegistrantList roamingOffRegistrants = new RegistrantList();
    public static final boolean DBG = true;
    public static final int POLL_PERIOD_MILLIS = 20000;
    public static final int DEFAULT_GPRS_CHECK_PERIOD_MILLIS = 60000;
    public static final int MAX_NUM_DATA_STATE_READS = 15;
    public static final int DATA_STATE_POLL_SLEEP_MS = 100;
    public static final int EVENT_RADIO_STATE_CHANGED = 1;
    public static final int EVENT_NETWORK_STATE_CHANGED = 2;
    public static final int EVENT_GET_SIGNAL_STRENGTH = 3;
    public static final int EVENT_POLL_STATE_REGISTRATION = 4;
    public static final int EVENT_POLL_STATE_GPRS = 5;
    public static final int EVENT_POLL_STATE_OPERATOR = 6;
    public static final int EVENT_POLL_SIGNAL_STRENGTH = 10;
    public static final int EVENT_NITZ_TIME = 11;
    public static final int EVENT_SIGNAL_STRENGTH_UPDATE = 12;
    public static final int EVENT_RADIO_AVAILABLE = 13;
    public static final int EVENT_POLL_STATE_NETWORK_SELECTION_MODE = 14;
    public static final int EVENT_GET_LOC_DONE = 15;
    public static final int EVENT_SIM_RECORDS_LOADED = 16;
    public static final int EVENT_SIM_READY = 17;
    public static final int EVENT_LOCATION_UPDATES_ENABLED = 18;
    public static final int EVENT_GET_PREFERRED_NETWORK_TYPE = 19;
    public static final int EVENT_SET_PREFERRED_NETWORK_TYPE = 20;
    public static final int EVENT_RESET_PREFERRED_NETWORK_TYPE = 21;
    public static final int EVENT_CHECK_REPORT_GPRS = 22;
    public static final int EVENT_RESTRICTED_STATE_CHANGED = 23;
    public static final int EVENT_POLL_STATE_REGISTRATION_CDMA = 24;
    public static final int EVENT_POLL_STATE_OPERATOR_CDMA = 25;
    public static final int EVENT_RUIM_READY = 26;
    public static final int EVENT_RUIM_RECORDS_LOADED = 27;
    public static final int EVENT_POLL_SIGNAL_STRENGTH_CDMA = 28;
    public static final int EVENT_GET_SIGNAL_STRENGTH_CDMA = 29;
    public static final int EVENT_NETWORK_STATE_CHANGED_CDMA = 30;
    public static final int EVENT_GET_LOC_DONE_CDMA = 31;
    public static final int EVENT_SIGNAL_STRENGTH_UPDATE_CDMA = 32;
    public static final int EVENT_NV_LOADED = 33;
    public static final int EVENT_POLL_STATE_CDMA_SUBSCRIPTION = 34;
    public static final int EVENT_NV_READY = 35;
    public static final int EVENT_ERI_FILE_LOADED = 36;
    public static final String TIMEZONE_PROPERTY = "persist.sys.timezone";
    public static final String[] GMT_COUNTRY_CODES = new String[]{"bf", "ci", "eh", "fo", "gh", "gm", "gn", "gw", "ie", "lr", "is", "ma", "ml", "mr", "pt", "sl", "sn", "st", "tg", "uk"};
    public static final String REGISTRATION_DENIED_GEN = "General";
    public static final String REGISTRATION_DENIED_AUTH = "Authentication Failure";

    public boolean getDesiredPowerState() {
        return this.mDesiredPowerState;
    }

    public void registerForRoamingOn(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.roamingOnRegistrants.add(r);
        if (this.ss.getRoaming()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForRoamingOn(Handler h) {
        this.roamingOnRegistrants.remove(h);
    }

    public void registerForRoamingOff(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.roamingOffRegistrants.add(r);
        if (!this.ss.getRoaming()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForRoamingOff(Handler h) {
        this.roamingOffRegistrants.remove(h);
    }

    public void reRegisterNetwork(Message onComplete) {
        this.cm.getPreferredNetworkType(this.obtainMessage(19, onComplete));
    }

    public void setRadioPower(boolean power) {
        this.mDesiredPowerState = power;
        this.setPowerStateToDesired();
    }

    public void enableLocationUpdates() {
        this.cm.setLocationUpdates(true, this.obtainMessage(18));
    }

    public void disableLocationUpdates() {
        this.cm.setLocationUpdates(false, null);
    }

    public abstract void handleMessage(Message var1);

    public abstract void handlePollStateResult(int var1, AsyncResult var2);

    public abstract void updateSpnDisplay();

    public abstract void setPowerStateToDesired();

    public void cancelPollState() {
        this.pollingContext = new int[1];
    }
}

