/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.cdma.CdmaCall;
import com.android.internal.telephony.cdma.CdmaCallWaitingNotification;
import com.android.internal.telephony.cdma.CdmaConnection;
import java.util.ArrayList;
import java.util.List;

public class CdmaCallTracker
extends CallTracker {
    public static final String LOG_TAG = "CDMA";
    public static final boolean REPEAT_POLLING = false;
    public static final boolean DBG_POLL = false;
    public static final int MAX_CONNECTIONS = 1;
    public static final int MAX_CONNECTIONS_PER_CALL = 1;
    public CdmaConnection[] connections = new CdmaConnection[1];
    public RegistrantList voiceCallEndedRegistrants = new RegistrantList();
    public RegistrantList voiceCallStartedRegistrants = new RegistrantList();
    public RegistrantList callWaitingRegistrants = new RegistrantList();
    public ArrayList<CdmaConnection> droppedDuringPoll = new ArrayList(1);
    public CdmaCall ringingCall = new CdmaCall(this);
    public CdmaCall foregroundCall = new CdmaCall(this);
    public CdmaCall backgroundCall = new CdmaCall(this);
    public CdmaConnection pendingMO;
    public boolean hangupPendingMO;
    public boolean pendingCallInECM = false;
    public CDMAPhone phone;
    public boolean desiredMute = false;
    public int pendingCallClirMode;
    public Phone.State state = Phone.State.IDLE;

    public CdmaCallTracker(CDMAPhone phone) {
        this.phone = phone;
        this.cm = phone.mCM;
        this.cm.registerForCallStateChanged(this, 2, null);
        this.cm.registerForOn(this, 9, null);
        this.cm.registerForNotAvailable(this, 10, null);
        this.cm.registerForCallWaitingInfo(this, 15, null);
        this.foregroundCall.setGeneric(false);
    }

    public void dispose() {
        this.cm.unregisterForCallStateChanged(this);
        this.cm.unregisterForOn(this);
        this.cm.unregisterForNotAvailable(this);
        this.cm.unregisterForCallWaitingInfo(this);
        for (CdmaConnection c : this.connections) {
            try {
                if (c == null) continue;
                this.hangup(c);
            }
            catch (CallStateException ex) {
                Log.e(LOG_TAG, "unexpected error on hangup during dispose");
            }
        }
        try {
            if (this.pendingMO != null) {
                this.hangup(this.pendingMO);
            }
        }
        catch (CallStateException ex) {
            Log.e(LOG_TAG, "unexpected error on hangup during dispose");
        }
        this.clearDisconnected();
    }

    public void finalize() {
        Log.d(LOG_TAG, "CdmaCallTracker finalized");
    }

    public void registerForVoiceCallStarted(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.voiceCallStartedRegistrants.add(r);
    }

    public void unregisterForVoiceCallStarted(Handler h) {
        this.voiceCallStartedRegistrants.remove(h);
    }

    public void registerForVoiceCallEnded(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.voiceCallEndedRegistrants.add(r);
    }

    public void unregisterForVoiceCallEnded(Handler h) {
        this.voiceCallEndedRegistrants.remove(h);
    }

    public void registerForCallWaiting(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.callWaitingRegistrants.add(r);
    }

    public void unregisterForCallWaiting(Handler h) {
        this.callWaitingRegistrants.remove(h);
    }

    public void fakeHoldForegroundBeforeDial() {
        List connCopy = (List)this.foregroundCall.connections.clone();
        int s = connCopy.size();
        for (int i = 0; i < s; ++i) {
            CdmaConnection conn = (CdmaConnection)connCopy.get(i);
            conn.fakeHoldBeforeDial();
        }
    }

    public Connection dial(String dialString, int clirMode) throws CallStateException {
        this.clearDisconnected();
        if (!this.canDial()) {
            throw new CallStateException("cannot dial in current state");
        }
        this.foregroundCall.setGeneric(false);
        if (this.foregroundCall.getState() == Call.State.ACTIVE) {
            return this.dialThreeWay(dialString);
        }
        this.pendingMO = new CdmaConnection(this.phone.getContext(), dialString, this, this.foregroundCall);
        this.hangupPendingMO = false;
        if (this.pendingMO.address == null || this.pendingMO.address.length() == 0 || this.pendingMO.address.indexOf(78) >= 0) {
            this.pendingMO.cause = Connection.DisconnectCause.INVALID_NUMBER;
            this.pollCallsWhenSafe();
        } else {
            this.setMute(false);
            String inEcm = SystemProperties.get("ril.cdma.inecmmode", "false");
            if (inEcm.equals("false")) {
                this.cm.dial(this.pendingMO.address, clirMode, this.obtainCompleteMessage());
            } else {
                this.phone.exitEmergencyCallbackMode();
                this.phone.setOnEcbModeExitResponse(this, 14, null);
                this.pendingCallClirMode = clirMode;
                this.pendingCallInECM = true;
            }
        }
        this.updatePhoneState();
        this.phone.notifyCallStateChanged();
        return this.pendingMO;
    }

    public Connection dial(String dialString) throws CallStateException {
        return this.dial(dialString, 0);
    }

    public Connection dialThreeWay(String dialString) {
        if (!this.foregroundCall.isIdle()) {
            this.pendingMO = new CdmaConnection(this.phone.getContext(), dialString, this, this.foregroundCall);
            this.cm.sendCDMAFeatureCode(this.pendingMO.address, this.obtainMessage(16));
            return this.pendingMO;
        }
        return null;
    }

    public void acceptCall() throws CallStateException {
        if (this.ringingCall.getState() == Call.State.INCOMING) {
            Log.i("phone", "acceptCall: incoming...");
            this.setMute(false);
            this.cm.acceptCall(this.obtainCompleteMessage());
        } else if (this.ringingCall.getState() == Call.State.WAITING) {
            CdmaConnection cwConn = (CdmaConnection)this.ringingCall.getLatestConnection();
            cwConn.updateParent(this.ringingCall, this.foregroundCall);
            cwConn.onConnectedInOrOut();
            this.switchWaitingOrHoldingAndActive();
        } else {
            throw new CallStateException("phone not ringing");
        }
    }

    public void rejectCall() throws CallStateException {
        if (!this.ringingCall.getState().isRinging()) {
            throw new CallStateException("phone not ringing");
        }
        this.cm.rejectCall(this.obtainCompleteMessage());
    }

    public void switchWaitingOrHoldingAndActive() throws CallStateException {
        if (this.ringingCall.getState() == Call.State.INCOMING) {
            throw new CallStateException("cannot be in the incoming state");
        }
        this.flashAndSetGenericTrue();
    }

    public void conference() throws CallStateException {
        this.flashAndSetGenericTrue();
    }

    public void explicitCallTransfer() throws CallStateException {
        this.cm.explicitCallTransfer(this.obtainCompleteMessage(13));
    }

    public void clearDisconnected() {
        this.internalClearDisconnected();
        this.updatePhoneState();
        this.phone.notifyCallStateChanged();
    }

    public boolean canConference() {
        return this.foregroundCall.getState() == Call.State.ACTIVE && this.backgroundCall.getState() == Call.State.HOLDING && !this.backgroundCall.isFull() && !this.foregroundCall.isFull();
    }

    public boolean canDial() {
        int serviceState = this.phone.getServiceState().getState();
        boolean ret = serviceState != 3 && this.pendingMO == null && !this.ringingCall.isRinging() && (!this.foregroundCall.getState().isAlive() || this.foregroundCall.getState() == Call.State.ACTIVE || !this.backgroundCall.getState().isAlive());
        return ret;
    }

    public boolean canTransfer() {
        Log.e(LOG_TAG, "canTransfer: not possible in CDMA");
        return false;
    }

    public void internalClearDisconnected() {
        this.ringingCall.clearDisconnected();
        this.foregroundCall.clearDisconnected();
        this.backgroundCall.clearDisconnected();
    }

    public Message obtainCompleteMessage() {
        return this.obtainCompleteMessage(4);
    }

    public Message obtainCompleteMessage(int what) {
        ++this.pendingOperations;
        this.lastRelevantPoll = null;
        this.needsPoll = true;
        return this.obtainMessage(what);
    }

    public void operationComplete() {
        --this.pendingOperations;
        if (this.pendingOperations == 0 && this.needsPoll) {
            this.lastRelevantPoll = this.obtainMessage(1);
            this.cm.getCurrentCalls(this.lastRelevantPoll);
        } else if (this.pendingOperations < 0) {
            Log.e(LOG_TAG, "CdmaCallTracker.pendingOperations < 0");
            this.pendingOperations = 0;
        }
    }

    public void updatePhoneState() {
        Phone.State oldState = this.state;
        this.state = this.ringingCall.isRinging() ? Phone.State.RINGING : (this.pendingMO != null || !this.foregroundCall.isIdle() || !this.backgroundCall.isIdle() ? Phone.State.OFFHOOK : Phone.State.IDLE);
        if (this.state == Phone.State.IDLE && oldState != this.state) {
            this.voiceCallEndedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        } else if (oldState == Phone.State.IDLE && oldState != this.state) {
            this.voiceCallStartedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        }
        if (this.state != oldState) {
            this.phone.notifyPhoneStateChanged();
        }
    }

    public void handlePollCalls(AsyncResult ar) {
        int i;
        ArrayList polledCalls;
        if (ar.exception == null) {
            polledCalls = (ArrayList)ar.result;
        } else if (this.isCommandExceptionRadioNotAvailable(ar.exception)) {
            polledCalls = new ArrayList();
        } else {
            this.pollCallsAfterDelay();
            return;
        }
        CdmaConnection newRinging = null;
        boolean hasNonHangupStateChanged = false;
        boolean needsPollDelay = false;
        boolean unknownConnectionAppeared = false;
        int curDC = 0;
        int dcSize = polledCalls.size();
        for (i = 0; i < this.connections.length; ++i) {
            CdmaConnection conn = this.connections[i];
            DriverCall dc = null;
            if (curDC < dcSize) {
                dc = (DriverCall)polledCalls.get(curDC);
                if (dc.index == i + 1) {
                    ++curDC;
                } else {
                    dc = null;
                }
            }
            if (conn == null && dc != null) {
                if (this.pendingMO != null && this.pendingMO.compareTo(dc)) {
                    this.connections[i] = this.pendingMO;
                    this.pendingMO.index = i;
                    this.pendingMO.update(dc);
                    this.pendingMO = null;
                    if (this.hangupPendingMO) {
                        this.hangupPendingMO = false;
                        try {
                            this.log("poll: hangupPendingMO, hangup conn " + i);
                            this.hangup(this.connections[i]);
                        }
                        catch (CallStateException ex) {
                            Log.e(LOG_TAG, "unexpected error on hangup");
                        }
                        return;
                    }
                } else {
                    this.connections[i] = new CdmaConnection(this.phone.getContext(), dc, this, i);
                    if (this.connections[i].getCall() == this.ringingCall) {
                        newRinging = this.connections[i];
                    } else {
                        Log.i(LOG_TAG, "Phantom call appeared " + dc);
                        if (dc.state != DriverCall.State.ALERTING && dc.state != DriverCall.State.DIALING) {
                            this.connections[i].connectTime = System.currentTimeMillis();
                        }
                        unknownConnectionAppeared = true;
                    }
                }
                hasNonHangupStateChanged = true;
                continue;
            }
            if (conn != null && dc == null) {
                int count = this.foregroundCall.connections.size();
                if (count == 0) {
                    this.droppedDuringPoll.add(conn);
                } else {
                    for (int n = 0; n < count; ++n) {
                        CdmaConnection cn = (CdmaConnection)this.foregroundCall.connections.get(n);
                        this.droppedDuringPoll.add(cn);
                    }
                }
                this.foregroundCall.setGeneric(false);
                this.connections[i] = null;
                continue;
            }
            if (conn != null && dc != null && !conn.compareTo(dc)) {
                this.droppedDuringPoll.add(conn);
                this.connections[i] = new CdmaConnection(this.phone.getContext(), dc, this, i);
                if (this.connections[i].getCall() == this.ringingCall) {
                    newRinging = this.connections[i];
                }
                hasNonHangupStateChanged = true;
                continue;
            }
            if (conn == null || dc == null) continue;
            boolean changed = conn.update(dc);
            hasNonHangupStateChanged = hasNonHangupStateChanged || changed;
        }
        if (this.pendingMO != null) {
            Log.d(LOG_TAG, "Pending MO dropped before poll fg state:" + (Object)((Object)this.foregroundCall.getState()));
            this.droppedDuringPoll.add(this.pendingMO);
            this.pendingMO = null;
            this.hangupPendingMO = false;
            if (this.pendingCallInECM) {
                this.pendingCallInECM = false;
            }
        }
        if (newRinging != null) {
            this.phone.notifyNewRingingConnection(newRinging);
        }
        for (i = this.droppedDuringPoll.size() - 1; i >= 0; --i) {
            CdmaConnection conn = this.droppedDuringPoll.get(i);
            if (conn.isIncoming() && conn.getConnectTime() == 0L) {
                Connection.DisconnectCause cause = conn.cause == Connection.DisconnectCause.LOCAL ? Connection.DisconnectCause.INCOMING_REJECTED : Connection.DisconnectCause.INCOMING_MISSED;
                this.log("missed/rejected call, conn.cause=" + (Object)((Object)conn.cause));
                this.log("setting cause to " + (Object)((Object)cause));
                this.droppedDuringPoll.remove(i);
                conn.onDisconnect(cause);
                continue;
            }
            if (conn.cause == Connection.DisconnectCause.LOCAL) {
                this.droppedDuringPoll.remove(i);
                conn.onDisconnect(Connection.DisconnectCause.LOCAL);
                continue;
            }
            if (conn.cause != Connection.DisconnectCause.INVALID_NUMBER) continue;
            this.droppedDuringPoll.remove(i);
            conn.onDisconnect(Connection.DisconnectCause.INVALID_NUMBER);
        }
        if (this.droppedDuringPoll.size() > 0) {
            this.cm.getLastCallFailCause(this.obtainNoPollCompleteMessage(5));
        }
        if (needsPollDelay) {
            this.pollCallsAfterDelay();
        }
        if (newRinging != null || hasNonHangupStateChanged) {
            this.internalClearDisconnected();
        }
        this.updatePhoneState();
        if (unknownConnectionAppeared) {
            this.phone.notifyUnknownConnection();
        }
        if (hasNonHangupStateChanged || newRinging != null) {
            this.phone.notifyCallStateChanged();
        }
    }

    public void hangup(CdmaConnection conn) throws CallStateException {
        if (conn.owner != this) {
            throw new CallStateException("CdmaConnection " + conn + "does not belong to CdmaCallTracker " + this);
        }
        if (conn == this.pendingMO) {
            this.log("hangup: set hangupPendingMO to true");
            this.hangupPendingMO = true;
        } else {
            if (conn.getCall() == this.ringingCall && this.ringingCall.getState() == Call.State.WAITING) {
                conn.onLocalDisconnect();
                this.phone.notifyCallStateChanged();
                return;
            }
            try {
                this.cm.hangupConnection(conn.getCDMAIndex(), this.obtainCompleteMessage());
            }
            catch (CallStateException ex) {
                Log.w(LOG_TAG, "CdmaCallTracker WARN: hangup() on absent connection " + conn);
            }
        }
        conn.onHangupLocal();
    }

    public void separate(CdmaConnection conn) throws CallStateException {
        if (conn.owner != this) {
            throw new CallStateException("CdmaConnection " + conn + "does not belong to CdmaCallTracker " + this);
        }
        try {
            this.cm.separateConnection(conn.getCDMAIndex(), this.obtainCompleteMessage(12));
        }
        catch (CallStateException ex) {
            Log.w(LOG_TAG, "CdmaCallTracker WARN: separate() on absent connection " + conn);
        }
    }

    public void setMute(boolean mute) {
        this.desiredMute = mute;
        this.cm.setMute(this.desiredMute, null);
    }

    public boolean getMute() {
        return this.desiredMute;
    }

    public void hangup(CdmaCall call) throws CallStateException {
        if (call.getConnections().size() == 0) {
            throw new CallStateException("no connections in call");
        }
        if (call == this.ringingCall) {
            this.log("(ringing) hangup waiting or background");
            this.cm.hangupWaitingOrBackground(this.obtainCompleteMessage());
        } else if (call == this.foregroundCall) {
            if (call.isDialingOrAlerting()) {
                this.log("(foregnd) hangup dialing or alerting...");
                this.hangup((CdmaConnection)call.getConnections().get(0));
            } else {
                this.hangupForegroundResumeBackground();
            }
        } else if (call == this.backgroundCall) {
            if (this.ringingCall.isRinging()) {
                this.log("hangup all conns in background call");
                this.hangupAllConnections(call);
            } else {
                this.hangupWaitingOrBackground();
            }
        } else {
            throw new RuntimeException("CdmaCall " + call + "does not belong to CdmaCallTracker " + this);
        }
        call.onHangupLocal();
    }

    public void hangupWaitingOrBackground() {
        this.log("hangupWaitingOrBackground");
        this.cm.hangupWaitingOrBackground(this.obtainCompleteMessage());
    }

    public void hangupForegroundResumeBackground() {
        this.log("hangupForegroundResumeBackground");
        this.cm.hangupForegroundResumeBackground(this.obtainCompleteMessage());
    }

    public void hangupConnectionByIndex(CdmaCall call, int index) throws CallStateException {
        int count = call.connections.size();
        for (int i = 0; i < count; ++i) {
            CdmaConnection cn = (CdmaConnection)call.connections.get(i);
            if (cn.getCDMAIndex() != index) continue;
            this.cm.hangupConnection(index, this.obtainCompleteMessage());
            return;
        }
        throw new CallStateException("no gsm index found");
    }

    public void hangupAllConnections(CdmaCall call) throws CallStateException {
        try {
            int count = call.connections.size();
            for (int i = 0; i < count; ++i) {
                CdmaConnection cn = (CdmaConnection)call.connections.get(i);
                this.cm.hangupConnection(cn.getCDMAIndex(), this.obtainCompleteMessage());
            }
        }
        catch (CallStateException ex) {
            Log.e(LOG_TAG, "hangupConnectionByIndex caught " + ex);
        }
    }

    public CdmaConnection getConnectionByIndex(CdmaCall call, int index) throws CallStateException {
        int count = call.connections.size();
        for (int i = 0; i < count; ++i) {
            CdmaConnection cn = (CdmaConnection)call.connections.get(i);
            if (cn.getCDMAIndex() != index) continue;
            return cn;
        }
        return null;
    }

    public void flashAndSetGenericTrue() throws CallStateException {
        this.cm.sendCDMAFeatureCode("", this.obtainMessage(8));
        this.foregroundCall.setGeneric(true);
        this.phone.notifyCallStateChanged();
    }

    public Phone.SuppService getFailedService(int what) {
        switch (what) {
            case 8: {
                return Phone.SuppService.SWITCH;
            }
            case 11: {
                return Phone.SuppService.CONFERENCE;
            }
            case 12: {
                return Phone.SuppService.SEPARATE;
            }
            case 13: {
                return Phone.SuppService.TRANSFER;
            }
        }
        return Phone.SuppService.UNKNOWN;
    }

    public void handleRadioNotAvailable() {
        this.pollCallsWhenSafe();
    }

    public void notifyCallWaitingInfo(CdmaCallWaitingNotification obj) {
        if (this.callWaitingRegistrants != null) {
            this.callWaitingRegistrants.notifyRegistrants(new AsyncResult(null, obj, null));
        }
    }

    public void handleCallWaitingInfo(CdmaCallWaitingNotification cw) {
        if (this.foregroundCall.connections.size() > 1) {
            this.foregroundCall.setGeneric(true);
        }
        this.ringingCall.setGeneric(false);
        new CdmaConnection(this.phone.getContext(), cw, this, this.ringingCall);
        this.notifyCallWaitingInfo(cw);
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                Log.d(LOG_TAG, "Event EVENT_POLL_CALLS_RESULT Received");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (msg != this.lastRelevantPoll) break;
                this.needsPoll = false;
                this.lastRelevantPoll = null;
                this.handlePollCalls((AsyncResult)msg.obj);
                break;
            }
            case 4: {
                this.operationComplete();
                break;
            }
            case 8: {
                break;
            }
            case 5: {
                int causeCode;
                AsyncResult ar = (AsyncResult)msg.obj;
                this.operationComplete();
                if (ar.exception != null) {
                    causeCode = 16;
                    Log.i(LOG_TAG, "Exception during getLastCallFailCause, assuming normal disconnect");
                } else {
                    causeCode = ((int[])ar.result)[0];
                }
                int s = this.droppedDuringPoll.size();
                for (int i = 0; i < s; ++i) {
                    CdmaConnection conn = this.droppedDuringPoll.get(i);
                    conn.onRemoteDisconnect(causeCode);
                }
                this.updatePhoneState();
                this.phone.notifyCallStateChanged();
                this.droppedDuringPoll.clear();
                break;
            }
            case 2: 
            case 3: {
                this.pollCallsWhenSafe();
                break;
            }
            case 9: {
                this.handleRadioAvailable();
                break;
            }
            case 10: {
                this.handleRadioNotAvailable();
                break;
            }
            case 14: {
                if (this.pendingCallInECM) {
                    this.cm.dial(this.pendingMO.address, this.pendingCallClirMode, this.obtainCompleteMessage());
                    this.pendingCallInECM = false;
                }
                this.phone.unsetOnEcbModeExitResponse(this);
                break;
            }
            case 15: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.handleCallWaitingInfo((CdmaCallWaitingNotification)ar.result);
                Log.d(LOG_TAG, "Event EVENT_CALL_WAITING_INFO_CDMA Received");
                break;
            }
            case 16: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.pendingMO.onConnectedInOrOut();
                break;
            }
            default: {
                throw new RuntimeException("unexpected event not handled");
            }
        }
    }

    public void log(String msg) {
        Log.d(LOG_TAG, "[CdmaCallTracker] " + msg);
    }
}

