/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemProperties;
import android.util.EventLog;
import android.util.Log;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.DataLinkInterface;
import com.android.internal.telephony.cdma.CDMAPhone;

public class CdmaDataConnection
extends DataConnection {
    public static final String LOG_TAG = "CDMA";
    public static final boolean DBG = true;
    public static final int PS_NET_DOWN_REASON_OPERATOR_DETERMINED_BARRING = 8;
    public static final int PS_NET_DOWN_REASON_UNKNOWN_APN = 27;
    public static final int PS_NET_DOWN_REASON_AUTH_FAILED = 29;
    public static final int PS_NET_DOWN_REASON_OPTION_NOT_SUPPORTED = 32;
    public static final int PS_NET_DOWN_REASON_OPTION_UNSUBSCRIBED = 33;
    public static final int PS_NET_DOWN_REASON_NOT_SPECIFIED = 0;
    public static final int PS_NET_DOWN_REASON_CLOSE_IN_PROGRESS = 1;
    public static final int PS_NET_DOWN_REASON_NW_INITIATED_TERMINATION = 2;
    public static final int PS_NET_DOWN_REASON_APP_PREEMPTED = 3;
    public static final int PS_NET_DOWN_REASON_LLC_SNDCP_FAILURE = 25;
    public static final int PS_NET_DOWN_REASON_INSUFFICIENT_RESOURCES = 26;
    public static final int PS_NET_DOWN_REASON_UNKNOWN_PDP = 28;
    public static final int PS_NET_DOWN_REASON_GGSN_REJECT = 30;
    public static final int PS_NET_DOWN_REASON_ACTIVATION_REJECT = 31;
    public static final int PS_NET_DOWN_REASON_OPTION_TEMP_OOO = 34;
    public static final int PS_NET_DOWN_REASON_NSAPI_ALREADY_USED = 35;
    public static final int PS_NET_DOWN_REASON_REGULAR_DEACTIVATION = 36;
    public static final int PS_NET_DOWN_REASON_QOS_NOT_ACCEPTED = 37;
    public static final int PS_NET_DOWN_REASON_NETWORK_FAILURE = 38;
    public static final int PS_NET_DOWN_REASON_UMTS_REATTACH_REQ = 39;
    public static final int PS_NET_DOWN_REASON_TFT_SEMANTIC_ERROR = 41;
    public static final int PS_NET_DOWN_REASON_TFT_SYNTAX_ERROR = 42;
    public static final int PS_NET_DOWN_REASON_UNKNOWN_PDP_CONTEXT = 43;
    public static final int PS_NET_DOWN_REASON_FILTER_SEMANTIC_ERROR = 44;
    public static final int PS_NET_DOWN_REASON_FILTER_SYNTAX_ERROR = 45;
    public static final int PS_NET_DOWN_REASON_PDP_WITHOUT_ACTIVE_TFT = 46;
    public static final int PS_NET_DOWN_REASON_INVALID_TRANSACTION_ID = 81;
    public static final int PS_NET_DOWN_REASON_MESSAGE_INCORRECT_SEMANTIC = 95;
    public static final int PS_NET_DOWN_REASON_INVALID_MANDATORY_INFO = 96;
    public static final int PS_NET_DOWN_REASON_MESSAGE_TYPE_UNSUPPORTED = 97;
    public static final int PS_NET_DOWN_REASON_MSG_TYPE_NONCOMPATIBLE_STATE = 98;
    public static final int PS_NET_DOWN_REASON_UNKNOWN_INFO_ELEMENT = 99;
    public static final int PS_NET_DOWN_REASON_CONDITIONAL_IE_ERROR = 100;
    public static final int PS_NET_DOWN_REASON_MSG_AND_PROTOCOL_STATE_UNCOMPATIBLE = 101;
    public static final int PS_NET_DOWN_REASON_PROTOCOL_ERROR = 111;
    public static final int PS_NET_DOWN_REASON_APN_TYPE_CONFLICT = 112;
    public static final int PS_NET_DOWN_REASON_UNKNOWN_CAUSE_CODE = 113;
    public static final int PS_NET_DOWN_REASON_INTERNAL_MIN = 200;
    public static final int PS_NET_DOWN_REASON_INTERNAL_ERROR = 201;
    public static final int PS_NET_DOWN_REASON_INTERNAL_CALL_ENDED = 202;
    public static final int PS_NET_DOWN_REASON_INTERNAL_UNKNOWN_CAUSE_CODE = 203;
    public static final int PS_NET_DOWN_REASON_INTERNAL_MAX = 204;
    public static final int PS_NET_DOWN_REASON_CDMA_LOCK = 500;
    public static final int PS_NET_DOWN_REASON_INTERCEPT = 501;
    public static final int PS_NET_DOWN_REASON_REORDER = 502;
    public static final int PS_NET_DOWN_REASON_REL_SO_REJ = 503;
    public static final int PS_NET_DOWN_REASON_INCOM_CALL = 504;
    public static final int PS_NET_DOWN_REASON_ALERT_STOP = 505;
    public static final int PS_NET_DOWN_REASON_ACTIVATION = 506;
    public static final int PS_NET_DOWN_REASON_MAX_ACCESS_PROBE = 507;
    public static final int PS_NET_DOWN_REASON_CCS_NOT_SUPPORTED_BY_BS = 508;
    public static final int PS_NET_DOWN_REASON_NO_RESPONSE_FROM_BS = 509;
    public static final int PS_NET_DOWN_REASON_REJECTED_BY_BS = 510;
    public static final int PS_NET_DOWN_REASON_INCOMPATIBLE = 511;
    public static final int PS_NET_DOWN_REASON_ALREADY_IN_TC = 512;
    public static final int PS_NET_DOWN_REASON_USER_CALL_ORIG_DURING_GPS = 513;
    public static final int PS_NET_DOWN_REASON_USER_CALL_ORIG_DURING_SMS = 514;
    public static final int PS_NET_DOWN_REASON_NO_CDMA_SRV = 515;
    public static final int PS_NET_DOWN_REASON_CONF_FAILED = 1000;
    public static final int PS_NET_DOWN_REASON_INCOM_REJ = 1001;
    public static final int PS_NET_DOWN_REASON_NO_GW_SRV = 1002;
    public static final int PS_NET_DOWN_REASON_CD_GEN_OR_BUSY = 1500;
    public static final int PS_NET_DOWN_REASON_CD_BILL_OR_AUTH = 1501;
    public static final int PS_NET_DOWN_REASON_CHG_HDR = 1502;
    public static final int PS_NET_DOWN_REASON_EXIT_HDR = 1503;
    public static final int PS_NET_DOWN_REASON_HDR_NO_SESSION = 1504;
    public static final int PS_NET_DOWN_REASON_HDR_ORIG_DURING_GPS_FIX = 1505;
    public static final int PS_NET_DOWN_REASON_HDR_CS_TIMEOUT = 1506;
    public static final int PS_NET_DOWN_REASON_HDR_RELEASED_BY_CM = 1507;
    public static final int PS_NET_DOWN_REASON_CLIENT_END = 2000;
    public static final int PS_NET_DOWN_REASON_NO_SRV = 2001;
    public static final int PS_NET_DOWN_REASON_FADE = 2002;
    public static final int PS_NET_DOWN_REASON_REL_NORMAL = 2003;
    public static final int PS_NET_DOWN_REASON_ACC_IN_PROG = 2004;
    public static final int PS_NET_DOWN_REASON_ACC_FAIL = 2005;
    public static final int PS_NET_DOWN_REASON_REDIR_OR_HANDOFF = 2006;

    public CdmaDataConnection(CDMAPhone phone) {
        super(phone);
        this.log("CdmaDataConnection <constructor>");
    }

    public void connect(Message onCompleted) {
        this.log("CdmaDataConnection Connecting...");
        this.state = DataConnection.State.ACTIVATING;
        this.onConnectCompleted = onCompleted;
        this.createTime = -1L;
        this.lastFailTime = -1L;
        this.lastFailCause = DataConnection.FailCause.NONE;
        this.receivedDisconnectReq = false;
        this.phone.mCM.setupDataCall(Integer.toString(2), Integer.toString(0), null, null, null, this.obtainMessage(1));
    }

    public void tearDownData(Message msg) {
        if (this.phone.mCM.getRadioState().isOn()) {
            this.phone.mCM.deactivateDataCall(this.cid, this.obtainMessage(4, msg));
        }
    }

    public void disconnect(Message msg) {
        this.onDisconnect = msg;
        if (this.state == DataConnection.State.ACTIVE) {
            this.tearDownData(msg);
        } else if (this.state == DataConnection.State.ACTIVATING) {
            this.receivedDisconnectReq = true;
        } else {
            this.notifyDisconnect(msg);
        }
    }

    public String toString() {
        return "State=" + (Object)((Object)this.state) + " create=" + this.createTime + " lastFail=" + this.lastFailTime + " lastFailCause=" + (Object)((Object)this.lastFailCause);
    }

    public void notifyFail(DataConnection.FailCause cause, Message onCompleted) {
        if (onCompleted == null) {
            return;
        }
        this.state = DataConnection.State.INACTIVE;
        this.lastFailCause = cause;
        this.lastFailTime = System.currentTimeMillis();
        this.onConnectCompleted = null;
        this.log("Notify data connection fail at " + this.lastFailTime + " due to " + (Object)((Object)this.lastFailCause));
        AsyncResult.forMessage(onCompleted, (Object)cause, new Exception());
        onCompleted.sendToTarget();
    }

    public void notifySuccess(Message onCompleted) {
        if (onCompleted == null) {
            return;
        }
        this.state = DataConnection.State.ACTIVE;
        this.createTime = System.currentTimeMillis();
        this.onConnectCompleted = null;
        onCompleted.arg1 = this.cid;
        this.log("Notify data connection success at " + this.createTime);
        AsyncResult.forMessage(onCompleted);
        onCompleted.sendToTarget();
    }

    public void notifyDisconnect(Message msg) {
        this.log("Notify data connection disconnect");
        if (msg != null) {
            AsyncResult.forMessage(msg);
            msg.sendToTarget();
        }
        this.clearSettings();
    }

    public void onLinkStateChanged(DataLinkInterface.LinkState linkState) {
        switch (linkState) {
            case LINK_UP: {
                this.notifySuccess(this.onConnectCompleted);
                break;
            }
            case LINK_DOWN: 
            case LINK_EXITED: {
                this.phone.mCM.getLastDataCallFailCause(this.obtainMessage(2));
            }
        }
    }

    public DataConnection.FailCause getFailCauseFromRequest(int rilCause) {
        DataConnection.FailCause cause;
        switch (rilCause) {
            case 8: {
                cause = DataConnection.FailCause.OPERATOR_BARRED;
                break;
            }
            case 29: {
                cause = DataConnection.FailCause.USER_AUTHENTICATION;
                break;
            }
            case 32: {
                cause = DataConnection.FailCause.SERVICE_OPTION_NOT_SUPPORTED;
                break;
            }
            case 33: {
                cause = DataConnection.FailCause.SERVICE_OPTION_NOT_SUBSCRIBED;
                break;
            }
            default: {
                cause = DataConnection.FailCause.UNKNOWN;
            }
        }
        return cause;
    }

    public void log(String s) {
        Log.d(LOG_TAG, "[CdmaDataConnection] " + s);
    }

    public void onDeactivated(AsyncResult ar) {
        this.notifyDisconnect((Message)ar.userObj);
        this.log("CDMA Connection Deactivated");
    }

    public void onSetupConnectionCompleted(AsyncResult ar) {
        if (ar.exception != null) {
            Log.e(LOG_TAG, "CdmaDataConnection Init failed " + ar.exception);
            if (this.receivedDisconnectReq) {
                this.notifyDisconnect(this.onDisconnect);
            } else if (ar.exception instanceof CommandException && ((CommandException)ar.exception).getCommandError() == CommandException.Error.RADIO_NOT_AVAILABLE) {
                this.notifyFail(DataConnection.FailCause.RADIO_NOT_AVAILABLE, this.onConnectCompleted);
            } else {
                this.phone.mCM.getLastDataCallFailCause(this.obtainMessage(2));
            }
        } else if (this.receivedDisconnectReq) {
            this.tearDownData(this.onDisconnect);
        } else {
            String[] response = (String[])ar.result;
            this.cid = Integer.parseInt(response[0]);
            if (response.length > 2) {
                this.interfaceName = response[1];
                this.ipAddress = response[2];
                String prefix = "net." + this.interfaceName + ".";
                this.gatewayAddress = SystemProperties.get(prefix + "gw");
                this.dnsServers[0] = SystemProperties.get(prefix + "dns1");
                this.dnsServers[1] = SystemProperties.get(prefix + "dns2");
                this.log("interface=" + this.interfaceName + " ipAddress=" + this.ipAddress + " gateway=" + this.gatewayAddress + " DNS1=" + this.dnsServers[0] + " DNS2=" + this.dnsServers[1]);
                if ("0.0.0.0".equals(this.dnsServers[0]) && "0.0.0.0".equals(this.dnsServers[1]) && !((CDMAPhone)this.phone).isDnsCheckDisabled()) {
                    EventLog.writeEvent(50100, this.dnsServers[0]);
                    this.phone.mCM.deactivateDataCall(this.cid, this.obtainMessage(5));
                    return;
                }
            }
            this.onLinkStateChanged(DataLinkInterface.LinkState.LINK_UP);
            this.log("CdmaDataConnection setup on cid = " + this.cid);
        }
    }
}

