/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.util.Log;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.cdma.EriInfo;
import com.android.internal.util.XmlUtils;
import java.util.HashMap;

public class EriManager {
    public static final String LOG_TAG = "CDMA";
    public static final int ERI_FROM_XML = 0;
    public static final int ERI_FROM_FILE_SYSTEM = 1;
    public static final int ERI_FROM_MODEM = 2;
    public PhoneBase mPhone;
    public Context mContext;
    public int mEriFileSource = 0;
    public boolean isEriFileLoaded;
    public EriFile mEriFile;

    public EriManager(PhoneBase phone, Context context, int eriFileSource) {
        this.mPhone = phone;
        this.mContext = context;
        this.mEriFileSource = eriFileSource;
        this.mEriFile = new EriFile();
    }

    public void dispose() {
        this.mEriFile = new EriFile();
        this.isEriFileLoaded = false;
    }

    public void loadEriFile() {
        switch (this.mEriFileSource) {
            case 2: {
                this.loadEriFileFromModem();
                break;
            }
            case 1: {
                this.loadEriFileFromFileSystem();
                break;
            }
            default: {
                this.loadEriFileFromXml();
            }
        }
    }

    public void loadEriFileFromModem() {
    }

    public void loadEriFileFromFileSystem() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadEriFileFromXml() {
        Resources r = this.mContext.getResources();
        XmlResourceParser parser = r.getXml(17498114);
        try {
            try {
                XmlUtils.beginDocument(parser, "EriFile");
                this.mEriFile.mVersionNumber = Integer.parseInt(parser.getAttributeValue(null, "VersionNumber"));
                this.mEriFile.mNumberOfEriEntries = Integer.parseInt(parser.getAttributeValue(null, "NumberOfEriEntries"));
                this.mEriFile.mEriFileType = Integer.parseInt(parser.getAttributeValue(null, "EriFileType"));
                int parsedEriEntries = 0;
                while (true) {
                    XmlUtils.nextElement(parser);
                    String name = parser.getName();
                    if (name == null) {
                        if (parsedEriEntries == this.mEriFile.mNumberOfEriEntries) break;
                        Log.e(LOG_TAG, "Error Parsing ERI file: " + this.mEriFile.mNumberOfEriEntries + " defined, " + parsedEriEntries + " parsed!");
                        break;
                    }
                    if (name.equals("CallPromptId")) {
                        int id2 = Integer.parseInt(parser.getAttributeValue(null, "Id"));
                        String text = parser.getAttributeValue(null, "CallPromptText");
                        if (id2 >= 0 && id2 <= 2) {
                            this.mEriFile.mCallPromptId[id2] = text;
                            continue;
                        }
                        Log.e(LOG_TAG, "Error Parsing ERI file: found" + id2 + " CallPromptId");
                        continue;
                    }
                    if (!name.equals("EriInfo")) continue;
                    int roamingIndicator = Integer.parseInt(parser.getAttributeValue(null, "RoamingIndicator"));
                    int iconIndex = Integer.parseInt(parser.getAttributeValue(null, "IconIndex"));
                    int iconMode = Integer.parseInt(parser.getAttributeValue(null, "IconMode"));
                    String eriText = parser.getAttributeValue(null, "EriText");
                    int callPromptId = Integer.parseInt(parser.getAttributeValue(null, "CallPromptId"));
                    int alertId = Integer.parseInt(parser.getAttributeValue(null, "AlertId"));
                    ++parsedEriEntries;
                    this.mEriFile.mRoamIndTable.put(roamingIndicator, new EriInfo(roamingIndicator, iconIndex, iconMode, eriText, callPromptId, alertId));
                }
                this.isEriFileLoaded = true;
            }
            catch (Exception e) {
                Log.e(LOG_TAG, "Got exception while loading ERI file.", e);
                Object var12_14 = null;
                parser.close();
            }
            Object var12_13 = null;
            parser.close();
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            parser.close();
            throw throwable;
        }
    }

    public int getEriFileVersion() {
        return this.mEriFile.mVersionNumber;
    }

    public int getEriNumberOfEntries() {
        return this.mEriFile.mNumberOfEriEntries;
    }

    public int getEriFileType() {
        return this.mEriFile.mEriFileType;
    }

    public boolean isEriFileLoaded() {
        return this.isEriFileLoaded;
    }

    public EriInfo getEriInfo(int roamingIndicator) {
        if (this.mEriFile.mRoamIndTable.containsKey(roamingIndicator)) {
            return this.mEriFile.mRoamIndTable.get(roamingIndicator);
        }
        return null;
    }

    public EriDisplayInformation getEriDisplayInformation(int roamInd, int defRoamInd) {
        EriDisplayInformation ret;
        block0 : switch (roamInd) {
            case 0: {
                ret = new EriDisplayInformation(0, 0, ((Object)this.mContext.getText(17039571)).toString());
                break;
            }
            case 1: {
                ret = new EriDisplayInformation(1, 0, ((Object)this.mContext.getText(17039572)).toString());
                break;
            }
            case 2: {
                ret = new EriDisplayInformation(2, 1, ((Object)this.mContext.getText(17039573)).toString());
                break;
            }
            case 3: {
                ret = new EriDisplayInformation(roamInd, 0, ((Object)this.mContext.getText(17039574)).toString());
                break;
            }
            case 4: {
                ret = new EriDisplayInformation(roamInd, 0, ((Object)this.mContext.getText(17039575)).toString());
                break;
            }
            case 5: {
                ret = new EriDisplayInformation(roamInd, 0, ((Object)this.mContext.getText(17039576)).toString());
                break;
            }
            case 6: {
                ret = new EriDisplayInformation(roamInd, 0, ((Object)this.mContext.getText(17039577)).toString());
                break;
            }
            case 7: {
                ret = new EriDisplayInformation(roamInd, 0, ((Object)this.mContext.getText(17039578)).toString());
                break;
            }
            case 8: {
                ret = new EriDisplayInformation(roamInd, 0, ((Object)this.mContext.getText(17039579)).toString());
                break;
            }
            case 9: {
                ret = new EriDisplayInformation(roamInd, 0, ((Object)this.mContext.getText(17039580)).toString());
                break;
            }
            case 10: {
                ret = new EriDisplayInformation(roamInd, 0, ((Object)this.mContext.getText(17039581)).toString());
                break;
            }
            case 11: {
                ret = new EriDisplayInformation(roamInd, 0, ((Object)this.mContext.getText(17039582)).toString());
                break;
            }
            case 12: {
                ret = new EriDisplayInformation(roamInd, 0, ((Object)this.mContext.getText(17039583)).toString());
                break;
            }
            default: {
                if (!this.isEriFileLoaded) {
                    Log.d(LOG_TAG, "ERI File not loaded");
                    if (defRoamInd > 2) {
                        Log.d(LOG_TAG, "ERI defRoamInd > 2 ...flashing");
                        ret = new EriDisplayInformation(2, 1, ((Object)this.mContext.getText(17039573)).toString());
                        break;
                    }
                    Log.d(LOG_TAG, "ERI defRoamInd <= 2");
                    switch (defRoamInd) {
                        case 0: {
                            ret = new EriDisplayInformation(0, 0, ((Object)this.mContext.getText(17039571)).toString());
                            break block0;
                        }
                        case 1: {
                            ret = new EriDisplayInformation(1, 0, ((Object)this.mContext.getText(17039572)).toString());
                            break block0;
                        }
                        case 2: {
                            ret = new EriDisplayInformation(2, 1, ((Object)this.mContext.getText(17039573)).toString());
                            break block0;
                        }
                    }
                    ret = new EriDisplayInformation(-1, -1, "ERI text");
                    break;
                }
                Log.d(LOG_TAG, "ERI File loaded");
                EriInfo eriInfo = this.getEriInfo(roamInd);
                EriInfo defEriInfo = this.getEriInfo(defRoamInd);
                if (eriInfo == null) {
                    Log.d(LOG_TAG, "ERI roamInd " + roamInd + " not found in ERI file ...using defRoamInd " + defRoamInd);
                    if (defEriInfo == null) {
                        Log.e(LOG_TAG, "ERI defRoamInd " + defRoamInd + " not found in ERI file ...on");
                        ret = new EriDisplayInformation(0, 0, ((Object)this.mContext.getText(17039571)).toString());
                        break;
                    }
                    Log.d(LOG_TAG, "ERI defRoamInd " + defRoamInd + " found in ERI file");
                    ret = new EriDisplayInformation(defEriInfo.mIconIndex, defEriInfo.mIconMode, defEriInfo.mEriText);
                    break;
                }
                Log.d(LOG_TAG, "ERI roamInd " + roamInd + " found in ERI file");
                ret = new EriDisplayInformation(eriInfo.mIconIndex, eriInfo.mIconMode, eriInfo.mEriText);
            }
        }
        Log.d(LOG_TAG, "Displaying ERI " + ret.toString());
        return ret;
    }

    public int getCdmaEriIconIndex(int roamInd, int defRoamInd) {
        return this.getEriDisplayInformation((int)roamInd, (int)defRoamInd).mEriIconIndex;
    }

    public int getCdmaEriIconMode(int roamInd, int defRoamInd) {
        return this.getEriDisplayInformation((int)roamInd, (int)defRoamInd).mEriIconMode;
    }

    public String getCdmaEriText(int roamInd, int defRoamInd) {
        return this.getEriDisplayInformation((int)roamInd, (int)defRoamInd).mEriIconText;
    }

    public class EriDisplayInformation {
        public int mEriIconIndex;
        public int mEriIconMode;
        public String mEriIconText;

        public EriDisplayInformation(int eriIconIndex, int eriIconMode, String eriIconText) {
            this.mEriIconIndex = eriIconIndex;
            this.mEriIconMode = eriIconMode;
            this.mEriIconText = eriIconText;
        }

        public String toString() {
            return "EriDisplayInformation: { IconIndex: " + this.mEriIconIndex + " EriIconMode: " + this.mEriIconMode + " EriIconText: " + this.mEriIconText + " }";
        }
    }

    public class EriFile {
        public int mVersionNumber = -1;
        public int mNumberOfEriEntries = 0;
        public int mEriFileType = -1;
        public String[] mCallPromptId = new String[]{"", "", ""};
        public HashMap<Integer, EriInfo> mRoamIndTable = new HashMap();
    }
}

