/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm.stk;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.telephony.gsm.stk.Item;
import com.android.internal.telephony.gsm.stk.PresentationType;
import com.android.internal.telephony.gsm.stk.TextAttribute;
import java.util.ArrayList;
import java.util.List;

public class Menu
implements Parcelable {
    public List<Item> items;
    public List<TextAttribute> titleAttrs;
    public PresentationType presentationType;
    public String title;
    public Bitmap titleIcon;
    public int defaultItem;
    public boolean softKeyPreferred;
    public boolean helpAvailable;
    public boolean titleIconSelfExplanatory;
    public boolean itemsIconSelfExplanatory;
    public static final Parcelable.Creator<Menu> CREATOR = new Parcelable.Creator<Menu>(){

        @Override
        public Menu createFromParcel(Parcel in) {
            return new Menu(in, null);
        }

        public Menu[] newArray(int size) {
            return new Menu[size];
        }
    };

    public Menu() {
        this.items = new ArrayList<Item>();
        this.title = null;
        this.titleAttrs = null;
        this.defaultItem = 0;
        this.softKeyPreferred = false;
        this.helpAvailable = false;
        this.titleIconSelfExplanatory = false;
        this.itemsIconSelfExplanatory = false;
        this.titleIcon = null;
        this.presentationType = PresentationType.NAVIGATION_OPTIONS;
    }

    public Menu(Parcel in) {
        this.title = in.readString();
        this.titleIcon = (Bitmap)in.readParcelable(null);
        this.items = new ArrayList<Item>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Item item = (Item)in.readParcelable(null);
            this.items.add(item);
        }
        this.defaultItem = in.readInt();
        this.softKeyPreferred = in.readInt() == 1;
        this.helpAvailable = in.readInt() == 1;
        this.titleIconSelfExplanatory = in.readInt() == 1;
        this.itemsIconSelfExplanatory = in.readInt() == 1;
        this.presentationType = PresentationType.values()[in.readInt()];
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.title);
        dest.writeParcelable(this.titleIcon, flags);
        int size = this.items.size();
        dest.writeInt(size);
        for (int i = 0; i < size; ++i) {
            dest.writeParcelable(this.items.get(i), flags);
        }
        dest.writeInt(this.defaultItem);
        dest.writeInt(this.softKeyPreferred ? 1 : 0);
        dest.writeInt(this.helpAvailable ? 1 : 0);
        dest.writeInt(this.titleIconSelfExplanatory ? 1 : 0);
        dest.writeInt(this.itemsIconSelfExplanatory ? 1 : 0);
        dest.writeInt(this.presentationType.ordinal());
    }

    public /* synthetic */ Menu(Parcel x0, 1 x1) {
        this(x0);
    }
}

