/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuView;
import com.android.internal.view.menu.SubMenuBuilder;
import java.lang.ref.WeakReference;

public class MenuItemImpl
implements MenuItem {
    public final int mId;
    public final int mGroup;
    public final int mCategoryOrder;
    public final int mOrdering;
    public CharSequence mTitle;
    public CharSequence mTitleCondensed;
    public Intent mIntent;
    public char mShortcutNumericChar;
    public char mShortcutAlphabeticChar;
    public Drawable mIconDrawable;
    public int mIconResId = 0;
    public WeakReference<MenuView.ItemView>[] mItemViews;
    public MenuBuilder mMenu;
    public SubMenuBuilder mSubMenu;
    public Runnable mItemCallback;
    public MenuItem.OnMenuItemClickListener mClickListener;
    public int mFlags = 16;
    public static final int CHECKABLE = 1;
    public static final int CHECKED = 2;
    public static final int EXCLUSIVE = 4;
    public static final int HIDDEN = 8;
    public static final int ENABLED = 16;
    public static final int NO_ICON = 0;
    public ContextMenu.ContextMenuInfo mMenuInfo;
    public static String sPrependShortcutLabel;
    public static String sEnterShortcutLabel;
    public static String sDeleteShortcutLabel;
    public static String sSpaceShortcutLabel;

    public MenuItemImpl(MenuBuilder menu, int group, int id2, int categoryOrder, int ordering, CharSequence title) {
        if (sPrependShortcutLabel == null) {
            sPrependShortcutLabel = menu.getContext().getResources().getString(17039935);
            sEnterShortcutLabel = menu.getContext().getResources().getString(17039937);
            sDeleteShortcutLabel = menu.getContext().getResources().getString(17039938);
            sSpaceShortcutLabel = menu.getContext().getResources().getString(17039936);
        }
        this.mItemViews = new WeakReference[3];
        this.mMenu = menu;
        this.mId = id2;
        this.mGroup = group;
        this.mCategoryOrder = categoryOrder;
        this.mOrdering = ordering;
        this.mTitle = title;
    }

    public boolean invoke() {
        if (this.mClickListener != null && this.mClickListener.onMenuItemClick(this)) {
            return true;
        }
        MenuBuilder.Callback callback = this.mMenu.getCallback();
        if (callback != null && callback.onMenuItemSelected(this.mMenu.getRootMenu(), this)) {
            return true;
        }
        if (this.mItemCallback != null) {
            this.mItemCallback.run();
            return true;
        }
        if (this.mIntent != null) {
            this.mMenu.getContext().startActivity(this.mIntent);
            return true;
        }
        return false;
    }

    public boolean hasItemView(int menuType) {
        return this.mItemViews[menuType] != null && this.mItemViews[menuType].get() != null;
    }

    public boolean isEnabled() {
        return (this.mFlags & 0x10) != 0;
    }

    public MenuItem setEnabled(boolean enabled) {
        this.mFlags = enabled ? (this.mFlags |= 0x10) : (this.mFlags &= 0xFFFFFFEF);
        for (int i = 2; i >= 0; --i) {
            if (!this.hasItemView(i)) continue;
            ((MenuView.ItemView)this.mItemViews[i].get()).setEnabled(enabled);
        }
        return this;
    }

    public int getGroupId() {
        return this.mGroup;
    }

    @ViewDebug.CapturedViewProperty
    public int getItemId() {
        return this.mId;
    }

    public int getOrder() {
        return this.mCategoryOrder;
    }

    public int getOrdering() {
        return this.mOrdering;
    }

    public Intent getIntent() {
        return this.mIntent;
    }

    public MenuItem setIntent(Intent intent) {
        this.mIntent = intent;
        return this;
    }

    public Runnable getCallback() {
        return this.mItemCallback;
    }

    public MenuItem setCallback(Runnable callback) {
        this.mItemCallback = callback;
        return this;
    }

    public char getAlphabeticShortcut() {
        return this.mShortcutAlphabeticChar;
    }

    public MenuItem setAlphabeticShortcut(char alphaChar) {
        if (this.mShortcutAlphabeticChar == alphaChar) {
            return this;
        }
        this.mShortcutAlphabeticChar = Character.toLowerCase(alphaChar);
        this.refreshShortcutOnItemViews();
        return this;
    }

    public char getNumericShortcut() {
        return this.mShortcutNumericChar;
    }

    public MenuItem setNumericShortcut(char numericChar) {
        if (this.mShortcutNumericChar == numericChar) {
            return this;
        }
        this.mShortcutNumericChar = numericChar;
        this.refreshShortcutOnItemViews();
        return this;
    }

    public MenuItem setShortcut(char numericChar, char alphaChar) {
        this.mShortcutNumericChar = numericChar;
        this.mShortcutAlphabeticChar = Character.toLowerCase(alphaChar);
        this.refreshShortcutOnItemViews();
        return this;
    }

    public char getShortcut() {
        return this.mMenu.isQwertyMode() ? this.mShortcutAlphabeticChar : this.mShortcutNumericChar;
    }

    public String getShortcutLabel() {
        char shortcut = this.getShortcut();
        if (shortcut == '\u0000') {
            return "";
        }
        StringBuilder sb = new StringBuilder(sPrependShortcutLabel);
        switch (shortcut) {
            case '\n': {
                sb.append(sEnterShortcutLabel);
                break;
            }
            case '\b': {
                sb.append(sDeleteShortcutLabel);
                break;
            }
            case ' ': {
                sb.append(sSpaceShortcutLabel);
                break;
            }
            default: {
                sb.append(shortcut);
            }
        }
        return sb.toString();
    }

    public boolean shouldShowShortcut() {
        return this.mMenu.isShortcutsVisible() && this.getShortcut() != '\u0000';
    }

    public void refreshShortcutOnItemViews() {
        this.refreshShortcutOnItemViews(this.mMenu.isShortcutsVisible(), this.mMenu.isQwertyMode());
    }

    public void refreshShortcutOnItemViews(boolean menuShortcutShown, boolean isQwertyMode) {
        char shortcutKey = isQwertyMode ? this.mShortcutAlphabeticChar : this.mShortcutNumericChar;
        boolean showShortcut = menuShortcutShown && shortcutKey != '\u0000';
        for (int i = 2; i >= 0; --i) {
            if (!this.hasItemView(i)) continue;
            ((MenuView.ItemView)this.mItemViews[i].get()).setShortcut(showShortcut, shortcutKey);
        }
    }

    public SubMenu getSubMenu() {
        return this.mSubMenu;
    }

    public boolean hasSubMenu() {
        return this.mSubMenu != null;
    }

    public void setSubMenu(SubMenuBuilder subMenu) {
        if (this.mMenu != null && this.mMenu instanceof SubMenu) {
            throw new UnsupportedOperationException("Attempt to add a sub-menu to a sub-menu.");
        }
        this.mSubMenu = subMenu;
        subMenu.setHeaderTitle(this.getTitle());
    }

    @ViewDebug.CapturedViewProperty
    public CharSequence getTitle() {
        return this.mTitle;
    }

    public CharSequence getTitleForItemView(MenuView.ItemView itemView) {
        return itemView != null && itemView.prefersCondensedTitle() ? this.getTitleCondensed() : this.getTitle();
    }

    public MenuItem setTitle(CharSequence title) {
        this.mTitle = title;
        for (int i = 2; i >= 0; --i) {
            MenuView.ItemView itemView;
            if (!this.hasItemView(i) || (itemView = (MenuView.ItemView)this.mItemViews[i].get()).prefersCondensedTitle() && this.mTitleCondensed != null) continue;
            itemView.setTitle(title);
        }
        if (this.mSubMenu != null) {
            this.mSubMenu.setHeaderTitle(title);
        }
        return this;
    }

    public MenuItem setTitle(int title) {
        return this.setTitle(this.mMenu.getContext().getString(title));
    }

    public CharSequence getTitleCondensed() {
        return this.mTitleCondensed != null ? this.mTitleCondensed : this.mTitle;
    }

    public MenuItem setTitleCondensed(CharSequence title) {
        this.mTitleCondensed = title;
        if (title == null) {
            title = this.mTitle;
        }
        for (int i = 2; i >= 0; --i) {
            if (!this.hasItemView(i) || !((MenuView.ItemView)this.mItemViews[i].get()).prefersCondensedTitle()) continue;
            ((MenuView.ItemView)this.mItemViews[i].get()).setTitle(title);
        }
        return this;
    }

    public Drawable getIcon() {
        if (this.mIconDrawable != null) {
            return this.mIconDrawable;
        }
        if (this.mIconResId != 0) {
            return this.mMenu.getResources().getDrawable(this.mIconResId);
        }
        return null;
    }

    public MenuItem setIcon(Drawable icon) {
        this.mIconResId = 0;
        this.mIconDrawable = icon;
        this.setIconOnViews(icon);
        return this;
    }

    public MenuItem setIcon(int iconResId) {
        this.mIconDrawable = null;
        this.mIconResId = iconResId;
        if (this.haveAnyOpenedIconCapableItemViews()) {
            Drawable drawable2 = iconResId != 0 ? this.mMenu.getResources().getDrawable(iconResId) : null;
            this.setIconOnViews(drawable2);
        }
        return this;
    }

    public void setIconOnViews(Drawable icon) {
        for (int i = 2; i >= 0; --i) {
            if (!this.hasItemView(i) || !((MenuView.ItemView)this.mItemViews[i].get()).showsIcon()) continue;
            ((MenuView.ItemView)this.mItemViews[i].get()).setIcon(icon);
        }
    }

    public boolean haveAnyOpenedIconCapableItemViews() {
        for (int i = 2; i >= 0; --i) {
            if (!this.hasItemView(i) || !((MenuView.ItemView)this.mItemViews[i].get()).showsIcon()) continue;
            return true;
        }
        return false;
    }

    public boolean isCheckable() {
        return (this.mFlags & 1) == 1;
    }

    public MenuItem setCheckable(boolean checkable) {
        int oldFlags = this.mFlags;
        this.mFlags = this.mFlags & 0xFFFFFFFE | (checkable ? 1 : 0);
        if (oldFlags != this.mFlags) {
            for (int i = 2; i >= 0; --i) {
                if (!this.hasItemView(i)) continue;
                ((MenuView.ItemView)this.mItemViews[i].get()).setCheckable(checkable);
            }
        }
        return this;
    }

    public void setExclusiveCheckable(boolean exclusive) {
        this.mFlags = this.mFlags & 0xFFFFFFFB | (exclusive ? 4 : 0);
    }

    public boolean isExclusiveCheckable() {
        return (this.mFlags & 4) != 0;
    }

    public boolean isChecked() {
        return (this.mFlags & 2) == 2;
    }

    public MenuItem setChecked(boolean checked) {
        if ((this.mFlags & 4) != 0) {
            this.mMenu.setExclusiveItemChecked(this);
        } else {
            this.setCheckedInt(checked);
        }
        return this;
    }

    public void setCheckedInt(boolean checked) {
        int oldFlags = this.mFlags;
        this.mFlags = this.mFlags & 0xFFFFFFFD | (checked ? 2 : 0);
        if (oldFlags != this.mFlags) {
            for (int i = 2; i >= 0; --i) {
                if (!this.hasItemView(i)) continue;
                ((MenuView.ItemView)this.mItemViews[i].get()).setChecked(checked);
            }
        }
    }

    public boolean isVisible() {
        return (this.mFlags & 8) == 0;
    }

    public boolean setVisibleInt(boolean shown) {
        int oldFlags = this.mFlags;
        this.mFlags = this.mFlags & 0xFFFFFFF7 | (shown ? 0 : 8);
        return oldFlags != this.mFlags;
    }

    public MenuItem setVisible(boolean shown) {
        if (this.setVisibleInt(shown)) {
            this.mMenu.onItemVisibleChanged(this);
        }
        return this;
    }

    public MenuItem setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener clickListener) {
        this.mClickListener = clickListener;
        return this;
    }

    public View getItemView(int menuType, ViewGroup parent) {
        if (!this.hasItemView(menuType)) {
            this.mItemViews[menuType] = new WeakReference<MenuView.ItemView>(this.createItemView(menuType, parent));
        }
        return (View)this.mItemViews[menuType].get();
    }

    public MenuView.ItemView createItemView(int menuType, ViewGroup parent) {
        MenuView.ItemView itemView = (MenuView.ItemView)((Object)this.getLayoutInflater(menuType).inflate(MenuBuilder.ITEM_LAYOUT_RES_FOR_TYPE[menuType], parent, false));
        itemView.initialize(this, menuType);
        return itemView;
    }

    public void clearItemViews() {
        for (int i = this.mItemViews.length - 1; i >= 0; --i) {
            this.mItemViews[i] = null;
        }
    }

    public String toString() {
        return ((Object)this.mTitle).toString();
    }

    public void setMenuInfo(ContextMenu.ContextMenuInfo menuInfo) {
        this.mMenuInfo = menuInfo;
    }

    public ContextMenu.ContextMenuInfo getMenuInfo() {
        return this.mMenuInfo;
    }

    public LayoutInflater getLayoutInflater(int menuType) {
        return this.mMenu.getMenuType(menuType).getInflater();
    }

    public boolean shouldShowIcon(int menuType) {
        return menuType == 0 || this.mMenu.getOptionalIconsVisible();
    }
}

